/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Dipoles;
import org.jmol.viewer.Draw;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.MeshCollection;
import org.jmol.viewer.Model;
import org.jmol.viewer.Polyhedra;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Viewer;

class ModelManager {
    final Viewer viewer;
    Frame frame;
    String fullPathName;
    String fileName;
    String modelSetName;
    boolean haveFile;
    int[] shapeSizes = new int[30];
    static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};

    ModelManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.modelSetName = null;
        this.fileName = null;
        this.fullPathName = null;
        this.haveFile = false;
        this.clearFrame();
    }

    void clearFrame() {
        this.frame = null;
        System.gc();
    }

    void zap() {
        this.clear();
        this.modelSetName = "zapped";
        this.fileName = "zapped";
        this.fullPathName = "zapped";
        this.frame = new Frame(this.viewer, "empty");
    }

    void setClientFile(String fullPathName, String fileName, JmolAdapter adapter, Object clientFile) {
        if (clientFile == null) {
            this.clear();
            return;
        }
        this.fullPathName = fullPathName;
        this.fileName = fileName;
        this.modelSetName = adapter.getAtomSetCollectionName(clientFile);
        if (this.modelSetName != null) {
            this.modelSetName = this.modelSetName.trim();
            if (this.modelSetName.length() == 0) {
                this.modelSetName = null;
            }
        }
        if (this.modelSetName == null) {
            this.modelSetName = this.reduceFilename(fileName);
        }
        this.clearFrame();
        this.frame = new Frame(this.viewer, adapter, clientFile);
        this.haveFile = true;
        if (this.frame.atomCount == 0) {
            this.zap();
        }
    }

    String reduceFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        int ichDot = fileName.indexOf(46);
        if (ichDot > 0) {
            fileName = fileName.substring(0, ichDot);
        }
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 20) + " ...";
        }
        return fileName;
    }

    Frame getFrame() {
        return this.frame;
    }

    JmolAdapter getExportJmolAdapter() {
        return this.frame.getExportJmolAdapter();
    }

    String getModelSetName() {
        return this.modelSetName;
    }

    String getModelSetFileName() {
        return this.fileName;
    }

    String getModelSetPathName() {
        return this.fullPathName;
    }

    Properties getModelSetProperties() {
        return this.frame.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.frame.getModelSetProperty(propertyName);
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.frame.getModelSetAuxiliaryInfo();
    }

    Object getModelSetAuxiliaryInfo(String keyName) {
        return this.frame.getModelSetAuxiliaryInfo(keyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.frame.modelSetHasVibrationVectors();
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        return this.frame.modelHasVibrationVectors(modelIndex);
    }

    String getModelSetTypeName() {
        return this.frame.getModelSetTypeName();
    }

    boolean isPDB() {
        return this.frame.isPDB;
    }

    boolean isPDB(int modelIndex) {
        return this.frame.mmset.getModel((int)modelIndex).isPDB;
    }

    int getModelCount() {
        return this.frame.getModelCount();
    }

    String getModelInfoAsString() {
        int modelCount = this.getModelCount();
        String str = "model count = " + modelCount + "\nmodelSetHasVibrationVectors:" + this.modelSetHasVibrationVectors();
        Properties props = this.getModelSetProperties();
        str = str.concat(this.listProperties(props));
        for (int i = 0; i < modelCount; ++i) {
            str = str.concat("\n" + i + ":" + this.getModelNumber(i) + ":" + this.getModelName(i) + "\nmodelHasVibrationVectors:" + this.modelHasVibrationVectors(i));
        }
        return str;
    }

    String getSymmetryInfoAsString() {
        int modelCount = this.getModelCount();
        String str = "Symmetry Information:";
        for (int i = 0; i < modelCount; ++i) {
            str = str + "\nmodel #" + this.getModelNumber(i) + "; name=" + this.getModelName(i) + "\n" + this.frame.getSymmetryInfoAsString(i);
        }
        return str;
    }

    String getModelName(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelName(modelIndex);
    }

    int getModelNumber(int modelIndex) {
        return this.frame.getModelNumber(modelIndex);
    }

    Properties getModelProperties(int modelIndex) {
        return this.frame.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.frame.getModelProperty(modelIndex, propertyName);
    }

    Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.frame.getModelAuxiliaryInfo(modelIndex);
    }

    Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.frame.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.frame.getModelNumberIndex(modelNumber);
    }

    Point3f getSpinCenter(String axisID, int modelIndex) {
        Draw draw = (Draw)this.frame.shapes[29];
        if (draw == null) {
            return null;
        }
        int meshIndex = draw.getIndexFromName(axisID);
        if (meshIndex < 0) {
            return null;
        }
        return draw.getSpinCenter(meshIndex, modelIndex);
    }

    Vector3f getSpinAxis(String axisID, int modelIndex) {
        Draw draw = (Draw)this.frame.shapes[29];
        if (draw == null) {
            return null;
        }
        int meshIndex = draw.getIndexFromName(axisID);
        if (meshIndex < 0) {
            return null;
        }
        return draw.getSpinAxis(meshIndex, modelIndex);
    }

    float calcRotationRadius(Point3f center) {
        return this.frame.calcRotationRadius(center);
    }

    Point3f getBoundBoxCenter() {
        return this.frame.getBoundBoxCenter();
    }

    Point3f getAverageAtomPoint() {
        return this.frame.getAverageAtomPoint();
    }

    Vector3f getBoundBoxCornerVector() {
        return this.frame.getBoundBoxCornerVector();
    }

    Point3f getAtomSetCenter(BitSet bs) {
        return this.frame.getAtomSetCenter(bs);
    }

    int firstAtomOf(BitSet bs) {
        return this.frame.firstAtomOf(bs);
    }

    BitSet getAtomBits(String setType) {
        return this.frame.getAtomBits(setType);
    }

    BitSet getAtomBits(String setType, String specInfo) {
        return this.frame.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int specInfo) {
        return this.frame.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        return this.frame.getAtomBits(setType, specInfo);
    }

    int getAtomCount() {
        return this.frame.getAtomCount();
    }

    int getAtomCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.getAtomCount() : this.frame.getAtomCountInModel(modelIndex);
    }

    int getBondCount() {
        return this.frame.getBondCount();
    }

    int getBondCountInModel(int modelIndex) {
        return this.frame.getBondCountInModel(modelIndex);
    }

    int getGroupCount() {
        return this.frame.getGroupCount();
    }

    int getGroupCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.getGroupCount() : this.frame.getGroupCountInModel(modelIndex);
    }

    int getChainCount() {
        return this.frame.getChainCount();
    }

    int getChainCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.getChainCount() : this.frame.getChainCountInModel(modelIndex);
    }

    int getPolymerCount() {
        return this.frame.getPolymerCount();
    }

    int getPolymerCountInModel(int modelIndex) {
        return modelIndex < 0 ? this.getPolymerCount() : this.frame.getPolymerCountInModel(modelIndex);
    }

    int getMoleuleCount() {
        return this.frame.getMoleculeCount();
    }

    int makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB) {
        return this.frame.makeConnections(minDistance, maxDistance, order, connectOperation, bsA, bsB);
    }

    void rebond() {
        this.frame.rebond();
    }

    boolean frankClicked(int x, int y) {
        return this.getShapeSize(20) != 0 && this.frame.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        if (this.frame == null) {
            return -1;
        }
        return this.frame.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubber) {
        return this.frame.findAtomsInRectangle(rectRubber);
    }

    void loadShape(int shapeID) {
        this.frame.loadShape(shapeID);
    }

    void setShapeSize(int shapeType, int size, BitSet bsSelected) {
        this.shapeSizes[shapeType] = size;
        this.frame.setShapeSize(shapeType, size, bsSelected);
    }

    int getShapeSize(int shapeType) {
        return this.shapeSizes[shapeType];
    }

    void setShapeProperty(int shapeType, String propertyName, Object value, BitSet bsSelected) {
        this.frame.setShapeProperty(shapeType, propertyName.intern(), value, bsSelected);
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.frame.getShapeProperty(shapeType, propertyName, index);
    }

    int getShapeIdFromObjectName(String objectName) {
        int i;
        for (i = 25; i < 30; ++i) {
            MeshCollection shape = (MeshCollection)this.frame.shapes[i];
            if (shape == null || shape.getIndexFromName(objectName) < 0) continue;
            return i;
        }
        i = 24;
        Dipoles dipoles = (Dipoles)this.frame.shapes[i];
        if (dipoles != null && dipoles.getIndexFromName(objectName) >= 0) {
            return i;
        }
        return -1;
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.frame.getAtomIndexFromAtomNumber(atomNumber);
    }

    BitSet getElementsPresentBitSet() {
        return this.frame.getElementsPresentBitSet();
    }

    public Hashtable getHeteroList(int modelIndex) {
        return this.frame.mmset.getHeteroList(modelIndex);
    }

    BitSet getVisibleSet() {
        return this.frame.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.frame.getClickableSet();
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        return this.frame.getModelAtomBitSet(modelIndex);
    }

    BitSet getModelBitSet(BitSet atomList) {
        return this.frame.getModelBitSet(atomList);
    }

    BitSet getMoleculeBitSet(int modelIndex) {
        return this.frame.getMoleculeBitSet(modelIndex);
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.frame.calcSelectedGroupsCount(bsSelected);
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        this.frame.calcSelectedMonomersCount(bsSelected);
    }

    void calcSelectedMoleculesCount(BitSet bsSelected) {
        this.frame.calcSelectedGroupsCount(bsSelected);
    }

    String getAtomInfo(int i) {
        return this.frame.getAtomAt(i).getInfo();
    }

    String getAtomInfoXYZ(int i) {
        return this.frame.getAtomAt(i).getInfoXYZ();
    }

    String getElementSymbol(int i) {
        return this.frame.getAtomAt(i).getElementSymbol();
    }

    int getElementNumber(int i) {
        return this.frame.getAtomAt(i).getElementNumber();
    }

    String getElementName(int i) {
        return JmolConstants.elementNameFromNumber(this.frame.getAtomAt(i).getAtomicAndIsotopeNumber());
    }

    String getAtomName(int i) {
        return this.frame.getAtomAt(i).getAtomName();
    }

    boolean getAtomVisibility(int i) {
        return this.frame.getAtomAt(i).isVisible();
    }

    int getAtomNumber(int i) {
        return this.frame.getAtomAt(i).getAtomNumber();
    }

    float getAtomX(int i) {
        return this.frame.getAtomAt((int)i).x;
    }

    float getAtomY(int i) {
        return this.frame.getAtomAt((int)i).y;
    }

    float getAtomZ(int i) {
        return this.frame.getAtomAt((int)i).z;
    }

    Point3f getAtomPoint3f(int i) {
        return this.frame.getAtomAt(i);
    }

    float getAtomRadius(int i) {
        return this.frame.getAtomAt(i).getRadius();
    }

    short getAtomColix(int i) {
        return this.frame.getAtomAt(i).getColix();
    }

    String getAtomChain(int i) {
        return "" + this.frame.getAtomAt(i).getChainID();
    }

    String getAtomSequenceCode(int i) {
        return this.frame.getAtomAt(i).getSeqcodeString();
    }

    int getAtomModelIndex(int i) {
        return this.frame.getAtomAt(i).getModelIndex();
    }

    Point3f getBondPoint3f1(int i) {
        return this.frame.getBondAt(i).getAtom1();
    }

    Point3f getBondPoint3f2(int i) {
        return this.frame.getBondAt(i).getAtom2();
    }

    float getBondRadius(int i) {
        return this.frame.getBondAt(i).getRadius();
    }

    short getBondOrder(int i) {
        return this.frame.getBondAt(i).getOrder();
    }

    float getBondLength(int i) {
        return this.getBondAtom1(i).distance(this.getBondAtom2(i));
    }

    Atom getBondAtom1(int i) {
        return this.frame.getBondAt(i).getAtom1();
    }

    Atom getBondAtom2(int i) {
        return this.frame.getBondAt(i).getAtom2();
    }

    short getBondColix1(int i) {
        return this.frame.getBondAt(i).getColix1();
    }

    short getBondColix2(int i) {
        return this.frame.getBondAt(i).getColix2();
    }

    int getBondModelIndex(int i) {
        Atom atom = this.frame.getBondAt(i).getAtom1();
        if (atom != null) {
            return atom.getModelIndex();
        }
        atom = this.frame.getBondAt(i).getAtom2();
        if (atom != null) {
            return atom.getModelIndex();
        }
        return 0;
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        Polymer polymer = this.frame.getPolymerAt(modelIndex, polymerIndex);
        return polymer.getLeadMidpoints();
    }

    BitSet getAtomsWithin(String withinWhat, String specInfo, BitSet bs) {
        if (withinWhat.equals("sequence")) {
            return this.withinSequence(specInfo, bs);
        }
        return null;
    }

    BitSet getAtomsWithin(String withinWhat, BitSet bs) {
        if (withinWhat.equals("group")) {
            return this.withinGroup(bs);
        }
        if (withinWhat.equals("chain")) {
            return this.withinChain(bs);
        }
        if (withinWhat.equals("molecule")) {
            return this.withinMolecule(bs);
        }
        if (withinWhat.equals("model")) {
            return this.withinModel(bs);
        }
        if (withinWhat.equals("element")) {
            return this.withinElement(bs);
        }
        if (withinWhat.equals("site")) {
            return this.withinSite(bs);
        }
        return null;
    }

    BitSet withinGroup(BitSet bs) {
        Group groupLast = null;
        BitSet bsResult = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Group group;
            if (!bs.get(i) || (group = (atom = this.frame.getAtomAt(i)).getGroup()) == groupLast) continue;
            group.selectAtoms(bsResult);
            groupLast = group;
        }
        return bsResult;
    }

    BitSet withinChain(BitSet bs) {
        Chain chainLast = null;
        BitSet bsResult = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Chain chain;
            if (!bs.get(i) || (chain = (atom = this.frame.getAtomAt(i)).getChain()) == chainLast) continue;
            chain.selectAtoms(bsResult);
            chainLast = chain;
        }
        return bsResult;
    }

    BitSet withinMolecule(BitSet bs) {
        return this.frame.getMoleculeBitSet(bs);
    }

    BitSet withinModel(BitSet bs) {
        BitSet bsResult = new BitSet();
        BitSet bsThis = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            bsThis.set(this.frame.getAtomAt((int)i).modelIndex);
        }
        i = this.getAtomCount();
        while (--i >= 0) {
            if (!bsThis.get(this.frame.getAtomAt((int)i).modelIndex)) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    BitSet withinSite(BitSet bs) {
        BitSet bsResult = new BitSet();
        BitSet bsThis = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            bsThis.set(this.frame.getAtomAt((int)i).atomSite);
        }
        i = this.getAtomCount();
        while (--i >= 0) {
            if (!bsThis.get(this.frame.getAtomAt((int)i).atomSite)) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    BitSet withinElement(BitSet bs) {
        BitSet bsResult = new BitSet();
        BitSet bsThis = new BitSet();
        int i = this.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            bsThis.set(this.getElementNumber(i));
        }
        i = this.getAtomCount();
        while (--i >= 0) {
            if (!bsThis.get(this.getElementNumber(i))) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    BitSet withinSequence(String specInfo, BitSet bs) {
        String sequence = "";
        int lenInfo = specInfo.length();
        BitSet bsResult = new BitSet();
        if (lenInfo == 0) {
            return bsResult;
        }
        int modelCount = this.viewer.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            int polymerCount = this.getPolymerCountInModel(i);
            block1: for (int ip = 0; ip < polymerCount; ++ip) {
                sequence = this.getPolymerSequence(i, ip);
                int j = -1;
                while (true) {
                    ++j;
                    if ((j = sequence.indexOf(specInfo, j)) < 0) continue block1;
                    this.getPolymerSequenceAtoms(i, ip, j, lenInfo, bs, bsResult);
                }
            }
        }
        return bsResult;
    }

    void selectModelIndexAtoms(int modelIndex, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (frame.getAtomAt(i).getModelIndex() != modelIndex) continue;
            bsResult.set(i);
        }
    }

    BitSet getAtomsWithin(float distance, BitSet bs) {
        BitSet bsResult = new BitSet();
        int i = this.frame.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            Atom atom = this.frame.getAtomAt(i);
            AtomIterator iterWithin = this.frame.getWithinModelIterator(atom, distance);
            while (iterWithin.hasNext()) {
                bsResult.set(iterWithin.next().getAtomIndex());
            }
        }
        return bsResult;
    }

    BitSet getAtomsWithin(float distance, Point3f coord) {
        BitSet bsResult = new BitSet();
        int i = this.frame.getAtomCount();
        while (--i >= 0) {
            Atom atom = this.frame.getAtomAt(i);
            if (!(atom.distance(coord) <= distance)) continue;
            bsResult.set(atom.atomIndex);
        }
        return bsResult;
    }

    BitSet getAtomsConnected(float min, float max, BitSet bs) {
        BitSet bsResult = new BitSet();
        int atomCount = this.getAtomCount();
        int[] nBonded = new int[atomCount];
        int bondCount = this.getBondCount();
        for (int ibond = 0; ibond < bondCount; ++ibond) {
            Bond bond = this.frame.bonds[ibond];
            if (bond.order <= 0) continue;
            if (bs.get(bond.atom1.atomIndex)) {
                int n = bond.atom2.atomIndex;
                nBonded[n] = nBonded[n] + 1;
            }
            if (!bs.get(bond.atom2.atomIndex)) continue;
            int n = bond.atom1.atomIndex;
            nBonded[n] = nBonded[n] + 1;
        }
        int i = atomCount;
        while (--i >= 0) {
            if (!((float)nBonded[i] >= min) || !((float)nBonded[i] <= max)) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    String getModelExtract(BitSet bs) {
        int i;
        int atomCount = this.getAtomCount();
        int bondCount = this.getBondCount();
        int nAtoms = 0;
        int nBonds = 0;
        int[] atomMap = new int[atomCount];
        StringBuffer mol = new StringBuffer();
        StringBuffer s = new StringBuffer();
        for (i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            atomMap[i] = ++nAtoms;
            this.getAtomRecordMOL(s, i);
        }
        for (i = 0; i < bondCount; ++i) {
            short order;
            if (!bs.get(this.frame.getBondAt((int)i).getAtom1().atomIndex) || !bs.get(this.frame.getBondAt((int)i).getAtom2().atomIndex) || (order = this.getBondOrder(i)) < 1 || order >= 3) continue;
            this.getBondRecordMOL(s, i, atomMap);
            ++nBonds;
        }
        if (nAtoms > 999 || nBonds > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        this.rFill(mol, "   ", "" + nAtoms);
        this.rFill(mol, "   ", "" + nBonds);
        mol.append("  0  0  0\n");
        mol.append(s);
        return mol.toString();
    }

    void getAtomRecordMOL(StringBuffer s, int i) {
        this.rFill(s, "          ", this.safeTruncate(this.getAtomX(i), 9));
        this.rFill(s, "          ", this.safeTruncate(this.getAtomY(i), 9));
        this.rFill(s, "          ", this.safeTruncate(this.getAtomZ(i), 9));
        s.append(" " + (this.getElementSymbol(i) + "  ").substring(0, 2) + "\n");
    }

    void getBondRecordMOL(StringBuffer s, int i, int[] atomMap) {
        Bond b = this.frame.getBondAt(i);
        this.rFill(s, "   ", "" + atomMap[b.getAtom1().atomIndex]);
        this.rFill(s, "   ", "" + atomMap[b.getAtom2().atomIndex]);
        s.append("  " + this.getBondOrder(i) + "\n");
    }

    private void rFill(StringBuffer s, String s1, String s2) {
        s.append(s1.substring(0, s1.length() - s2.length()));
        s.append(s2);
    }

    private String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    String getFileHeader() {
        if (this.frame.isPDB) {
            return this.getFullPDBHeader();
        }
        String info = this.getModelSetProperty("fileHeader");
        if (info == null) {
            info = this.getModelSetName();
        }
        if (info != null) {
            return info;
        }
        return "no header information found";
    }

    String getPDBHeader() {
        return this.frame.isPDB ? this.getFullPDBHeader() : "!Not a pdb file!\n" + this.getFileHeader();
    }

    /*
     * WARNING - void declaration
     */
    String getFullPDBHeader() {
        String info = this.viewer.getCurrentFileAsString();
        int ichMin = info.length();
        int i = pdbRecords.length;
        block4: while (--i >= 0) {
            void var4_4;
            String strRecord = pdbRecords[i];
            int ichFound = info.startsWith(strRecord) ? 0 : info.indexOf("\n" + strRecord);
            switch (ichFound) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    return "";
                }
            }
            if (var4_4 >= ichMin) continue;
            ichMin = ++var4_4;
        }
        return info.substring(0, ichMin);
    }

    Hashtable getModelInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        int modelCount = this.viewer.getModelCount();
        info.put("modelSetName", this.getModelSetName());
        info.put("modelCount", new Integer(modelCount));
        info.put("modelSetHasVibrationVectors", new Boolean(this.modelSetHasVibrationVectors()));
        Properties props = this.viewer.getModelSetProperties();
        if (props != null) {
            info.put("modelSetProperties", props);
        }
        Vector models = new Vector();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Object> model = new Hashtable<String, Object>();
            model.put("_ipt", new Integer(i));
            model.put("num", new Integer(this.viewer.getModelNumber(i)));
            model.put("name", this.viewer.getModelName(i));
            model.put("vibrationVectors", new Boolean(this.modelHasVibrationVectors(i)));
            model.put("atomCount", new Integer(this.getAtomCountInModel(i)));
            model.put("bondCount", new Integer(this.getBondCountInModel(i)));
            model.put("groupCount", new Integer(this.getGroupCountInModel(i)));
            model.put("polymerCount", new Integer(this.getPolymerCountInModel(i)));
            model.put("chainCount", new Integer(this.getChainCountInModel(i)));
            props = this.viewer.getModelProperties(i);
            if (props != null) {
                model.put("modelProperties", props);
            }
            models.add(model);
        }
        info.put("models", models);
        return info;
    }

    Hashtable getAuxiliaryInfo() {
        Hashtable info = new Hashtable();
        info = this.getModelSetAuxiliaryInfo();
        if (info == null) {
            return info;
        }
        Vector<Hashtable> models = new Vector<Hashtable>();
        int modelCount = this.viewer.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable modelinfo = this.getModelAuxiliaryInfo(i);
            models.add(modelinfo);
        }
        info.put("models", models);
        return info;
    }

    Vector getAllAtomInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        int atomCount = this.viewer.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            V.add(this.getAtomInfoLong(i));
        }
        return V;
    }

    Vector getMoleculeInfo(BitSet bsAtoms) {
        return this.frame.getMoleculeInfo(bsAtoms);
    }

    void getAtomIdentityInfo(int i, Hashtable info) {
        info.put("_ipt", new Integer(i));
        info.put("atomno", new Integer(this.getAtomNumber(i)));
        info.put("info", this.getAtomInfo(i));
        info.put("sym", this.getElementSymbol(i));
    }

    Hashtable getAtomInfoLong(int i) {
        Atom atom = this.frame.getAtomAt(i);
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(i, info);
        info.put("element", this.getElementName(i));
        info.put("elemno", new Integer(this.getElementNumber(i)));
        info.put("x", new Float(this.getAtomX(i)));
        info.put("y", new Float(this.getAtomY(i)));
        info.put("z", new Float(this.getAtomZ(i)));
        if (this.frame.vibrationVectors != null && this.frame.vibrationVectors[i] != null) {
            info.put("vibVector", new Vector3f(this.frame.vibrationVectors[i]));
        }
        info.put("bondCount", new Integer(atom.getCovalentBondCount()));
        info.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        info.put("model", new Integer(atom.getModelTagNumber()));
        info.put("visible", new Boolean(this.getAtomVisibility(i)));
        info.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        info.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        info.put("spacefill", new Integer(atom.madAtom >> 3));
        String strColor = this.viewer.getHexColorFromIndex(atom.colixAtom);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(atom.colixAtom));
        boolean isTranslucent = atom.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", new Boolean(isTranslucent));
        }
        info.put("formalCharge", new Integer(atom.getFormalCharge()));
        info.put("partialCharge", new Float(atom.getPartialCharge()));
        float d = (float)atom.getSurfaceDistance100() / 100.0f;
        if (d >= 0.0f) {
            info.put("surfaceDistance", new Float(d));
        }
        if (this.isPDB(atom.modelIndex)) {
            info.put("resname", atom.getGroup3());
            int seqNum = atom.getSeqNumber();
            char insCode = atom.getInsertionCode();
            if (seqNum > 0) {
                info.put("resno", new Integer(seqNum));
            }
            if (insCode != '\u0000') {
                info.put("insertionCode", "" + insCode);
            }
            char chainID = atom.getChainID();
            info.put("name", this.getAtomName(i));
            info.put("chain", chainID == '\u0000' ? "" : "" + chainID);
            info.put("atomID", new Integer(atom.getSpecialAtomID()));
            info.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != 0) {
                info.put("altLocation", new String("" + atom.alternateLocationID));
            }
            info.put("structure", new Integer(atom.getProteinStructureType()));
            info.put("polymerLength", new Integer(atom.getPolymerLength()));
            info.put("occupancy", new Integer(atom.getOccupancy()));
            int temp = atom.getBfactor100();
            info.put("temp", new Integer(temp < 0 ? 0 : temp / 100));
        }
        return info;
    }

    Vector getAllBondInfo(BitSet bs) {
        Vector<Hashtable> V = new Vector<Hashtable>();
        int bondCount = this.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            if (!bs.get(this.frame.getBondAt((int)i).getAtom1().atomIndex) || !bs.get(this.frame.getBondAt((int)i).getAtom2().atomIndex)) continue;
            V.add(this.getBondInfo(i));
        }
        return V;
    }

    Hashtable getBondInfo(int i) {
        Bond bond = this.frame.getBondAt(i);
        Atom atom1 = this.getBondAtom1(i);
        Atom atom2 = this.getBondAtom2(i);
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("_bpt", new Integer(i));
        Hashtable infoA = new Hashtable();
        this.getAtomIdentityInfo(atom1.atomIndex, infoA);
        Hashtable infoB = new Hashtable();
        this.getAtomIdentityInfo(atom2.atomIndex, infoB);
        info.put("atom1", infoA);
        info.put("atom2", infoB);
        info.put("order", new Integer(this.getBondOrder(i)));
        info.put("radius", new Float((double)bond.mad / 2000.0));
        info.put("length_Ang", new Float(this.getBondLength(i)));
        info.put("visible", new Boolean(bond.shapeVisibilityFlags != 0));
        String strColor = this.viewer.getHexColorFromIndex(bond.colix);
        if (strColor != null) {
            info.put("color", strColor);
        }
        info.put("colix", new Integer(bond.colix));
        boolean isTranslucent = bond.isTranslucent();
        if (isTranslucent) {
            info.put("translucent", new Boolean(isTranslucent));
        }
        return info;
    }

    String listProperties(Properties props) {
        String str = "";
        if (props == null) {
            str = str.concat("\nProperties: null");
        } else {
            Enumeration<?> e = props.propertyNames();
            str = str.concat("\nProperties:");
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                str = str.concat("\n " + propertyName + "=" + props.getProperty(propertyName));
            }
        }
        return str;
    }

    Hashtable listPropertiesAsObject(Properties props) {
        Hashtable<String, String> info = new Hashtable<String, String>();
        if (props == null) {
            return info;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            info.put(propertyName, props.getProperty(propertyName));
        }
        return info;
    }

    Hashtable getAllChainInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        int modelCount = this.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector info = this.getChainInfo(i, bs);
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("chains", info);
            modelVector.add(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    Vector getChainInfo(int modelIndex, BitSet bs) {
        Model model = this.frame.mmset.getModel(modelIndex);
        int nChains = model.getChainCount();
        Vector infoChains = new Vector();
        for (int i = 0; i < nChains; ++i) {
            Chain chain = model.getChain(i);
            Vector infoChain = new Vector();
            int nGroups = chain.getGroupCount();
            Hashtable arrayName = new Hashtable();
            for (int igroup = 0; igroup < nGroups; ++igroup) {
                Group group = chain.getGroup(igroup);
                if (!bs.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> infoGroup = new Hashtable<String, Object>();
                infoGroup.put("groupIndex", new Integer(igroup));
                infoGroup.put("groupID", new Short(group.getGroupID()));
                infoGroup.put("seqCode", group.getSeqcodeString());
                infoGroup.put("_apt1", new Integer(group.firstAtomIndex));
                infoGroup.put("_apt2", new Integer(group.lastAtomIndex));
                infoGroup.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex));
                infoGroup.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex));
                infoGroup.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                infoChain.add(infoGroup);
            }
            if (infoChain.isEmpty()) continue;
            arrayName.put("residues", infoChain);
            infoChains.add(arrayName);
        }
        return infoChains;
    }

    Hashtable getAllPolymerInfo(BitSet bs) {
        Hashtable finalInfo = new Hashtable();
        Vector modelVector = new Vector();
        int modelCount = this.getModelCount();
        for (int i = 0; i < modelCount; ++i) {
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Vector<Hashtable> info = new Vector<Hashtable>();
            int polymerCount = this.getPolymerCountInModel(i);
            for (int ip = 0; ip < polymerCount; ++ip) {
                Hashtable polyInfo = this.getPolymerInfo(i, ip, bs);
                if (polyInfo.isEmpty()) continue;
                info.add(polyInfo);
            }
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", new Integer(i));
            modelInfo.put("polymers", info);
            modelVector.add(modelInfo);
        }
        finalInfo.put("models", modelVector);
        return finalInfo;
    }

    String getPolymerSequence(int iModel, int iPolymer) {
        String sequence = "";
        Polymer polymer = this.frame.mmset.getModel(iModel).getPolymer(iPolymer);
        int monomerCount = polymer.monomerCount;
        for (int i = 0; i < monomerCount; ++i) {
            sequence = sequence + polymer.monomers[i].getGroup1();
        }
        return sequence;
    }

    void getPolymerSequenceAtoms(int iModel, int iPolymer, int group1, int nGroups, BitSet bsInclude, BitSet bsResult) {
        Polymer polymer = this.frame.mmset.getModel(iModel).getPolymer(iPolymer);
        int monomerCount = polymer.monomerCount;
        int max = group1 + nGroups;
        for (int i = group1; i < monomerCount && i < max; ++i) {
            int jfirst = polymer.monomers[i].firstAtomIndex;
            int jlast = polymer.monomers[i].lastAtomIndex;
            for (int j = jfirst; j <= jlast; ++j) {
                if (!bsInclude.get(j)) continue;
                bsResult.set(j);
            }
        }
    }

    Hashtable getPolymerInfo(int iModel, int iPolymer, BitSet bs) {
        Hashtable<String, Object> returnInfo = new Hashtable<String, Object>();
        Vector<Hashtable> info = new Vector<Hashtable>();
        Polymer polymer = this.frame.mmset.getModel(iModel).getPolymer(iPolymer);
        int monomerCount = polymer.monomerCount;
        String sequence = "";
        for (int i = 0; i < monomerCount; ++i) {
            if (!bs.get(polymer.monomers[i].getLeadAtomIndex())) continue;
            Hashtable monomerInfo = polymer.monomers[i].getMyInfo();
            monomerInfo.put("monomerIndex", new Integer(i));
            info.add(monomerInfo);
            sequence = sequence + polymer.monomers[i].getGroup1();
        }
        if (info.size() > 0) {
            returnInfo.put("sequence", sequence);
            returnInfo.put("monomers", info);
        }
        return returnInfo;
    }

    void addStateScript(String script) {
        this.frame.addStateScript(script);
    }

    String getState() {
        return this.frame.getState();
    }

    Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> info = new Hashtable<String, Tuple3f>();
        info.put("center", this.getBoundBoxCenter());
        info.put("edge", this.getBoundBoxCornerVector());
        return info;
    }

    void setModelVisibility() {
        if (this.frame == null) {
            return;
        }
        BitSet bs = this.viewer.getVisibleFramesBitSet();
        for (int i = 24; i < 30; ++i) {
            if (this.frame.shapes[i] == null) continue;
            this.frame.shapes[i].setVisibilityFlags(bs);
        }
        Polyhedra p = (Polyhedra)this.frame.shapes[23];
        if (p != null) {
            p.setVisibilityFlags(bs);
        }
        if (this.frame.shapes[16] != null) {
            this.frame.shapes[16].setVisibilityFlags(bs);
        }
        this.frame.shapes[0].setVisibilityFlags(bs);
        for (int i = 0; i < 30; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    void checkObjectClicked(int x, int y, int modifiers) {
        for (int i = 0; i < 30; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            shape.checkObjectClicked(x, y, modifiers);
        }
    }

    void checkObjectDragged(int prevX, int prevY, int deltaX, int deltaY, int modifiers) {
        for (int i = 0; i < 30; ++i) {
            Shape shape = this.frame.shapes[i];
            if (shape == null) continue;
            shape.checkObjectDragged(prevX, prevY, deltaX, deltaY, modifiers);
        }
    }

    Hashtable getShapeInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        StringBuffer commands = new StringBuffer();
        for (int i = 0; i < 30; ++i) {
            String shapeType;
            Shape shape = this.frame.shapes[i];
            if (shape == null || "Draw,Dipoles,Isosurface,LcaoOrbital,MolecularOrbital".indexOf(shapeType = JmolConstants.shapeClassBases[i]) < 0) continue;
            Hashtable<String, Vector> shapeinfo = new Hashtable<String, Vector>();
            shapeinfo.put("obj", shape.getShapeDetail());
            info.put(shapeType, shapeinfo);
        }
        if (commands.length() > 0) {
            info.put("shapeCommands", commands.toString());
        }
        return info;
    }

    Point3f getAveragePosition(int atomIndex1, int atomIndex2) {
        return this.frame.getAveragePosition(atomIndex1, atomIndex2);
    }

    Vector3f getAtomVector(int atomIndex1, int atomIndex2) {
        return this.frame.getAtomVector(atomIndex1, atomIndex2);
    }

    Vector3f getModelDipole() {
        return this.frame.getModelDipole();
    }

    void getBondDipoles() {
        this.frame.getBondDipoles();
    }

    boolean modelsHaveSymmetry() {
        return this.frame.someModelsHaveSymmetry;
    }

    BitSet setConformation(int modelIndex, BitSet bsConformation) {
        this.frame.setConformation(modelIndex, bsConformation);
        return bsConformation;
    }

    BitSet setConformation(int modelIndex, int conformationIndex) {
        return this.frame.setConformation(modelIndex, conformationIndex);
    }

    String getAltLocListInModel(int modelIndex) {
        if (modelIndex < 0) {
            return "";
        }
        return this.frame.getAltLocListInModel(modelIndex);
    }

    void autoHbond(BitSet bsFrom, BitSet bsTo) {
        this.frame.autoHbond(bsFrom, bsTo);
    }

    boolean hbondsAreVisible(int modelIndex) {
        int bondCount = this.getBondCount();
        Bond[] bonds = this.frame.bonds;
        int i = bondCount;
        while (--i >= 0) {
            if (modelIndex >= 0 && modelIndex != bonds[i].atom1.modelIndex || !bonds[i].isHydrogen() || bonds[i].mad <= 0) continue;
            return true;
        }
        return false;
    }

    void convertFractionalCoordinates(int modelIndex, Point3f pt) {
        this.frame.convertFractionalCoordinates(modelIndex, pt);
    }

    void clearBfactorRange() {
        this.frame.clearBfactorRange();
    }

    void setZeroBased() {
        this.frame.setZeroBased();
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        this.frame.setAtomCoord(atomIndex, x, y, z);
    }

    void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        this.frame.setAtomCoordRelative(atomIndex, x, y, z);
    }

    void setAtomCoordRelative(Point3f offset, BitSet bs) {
        this.frame.setAtomCoordRelative(bs, offset.x, offset.y, offset.z);
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoType, boolean hybridizationCompatible) {
        return this.frame.getPrincipalAxes(atomIndex, z, x, lcaoType, hybridizationCompatible);
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        return this.frame.getAdditionalHydrogens(atomSet);
    }

    String getUnitCellInfoText() {
        int modelIndex = this.viewer.getCurrentModelIndex();
        if (modelIndex < 0) {
            return "no single current model";
        }
        if (this.frame.cellInfos == null) {
            return "not applicable";
        }
        return this.frame.cellInfos[modelIndex].getUnitCellInfo();
    }

    String getSpaceGroupInfoText(String spaceGroup) {
        SpaceGroup sg;
        String strOperations = "";
        int modelIndex = this.viewer.getCurrentModelIndex();
        if (spaceGroup == null) {
            if (modelIndex < 0) {
                return "no single current model";
            }
            if (this.frame.cellInfos == null) {
                return "not applicable";
            }
            Frame.CellInfo cellInfo = this.frame.cellInfos[modelIndex];
            spaceGroup = cellInfo.spaceGroup;
            if (spaceGroup.indexOf("[") >= 0) {
                spaceGroup = spaceGroup.substring(0, spaceGroup.indexOf("[")).trim();
            }
            if (spaceGroup == "spacegroup unspecified") {
                return "no space group identified in file";
            }
            sg = SpaceGroup.determineSpaceGroup(spaceGroup, cellInfo.getNotionalUnitCell());
            strOperations = "\nSymmetry operations employed:" + this.frame.getModelSymmetryList(modelIndex);
        } else {
            if (spaceGroup.equalsIgnoreCase("ALL")) {
                return SpaceGroup.dumpAll();
            }
            sg = SpaceGroup.determineSpaceGroup(spaceGroup);
            if (sg == null) {
                sg = SpaceGroup.createSpaceGroup(spaceGroup);
            }
        }
        if (sg == null) {
            return "could not identify space group from name: " + spaceGroup;
        }
        return sg.dumpInfo() + strOperations;
    }

    public int getSpaceGroupIndexFromName(String spaceGroup) {
        return SpaceGroup.determineSpaceGroupIndex(spaceGroup);
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        this.frame.setSelectionHaloEnabled(selectionHaloEnabled);
    }

    boolean getSelectionHaloEnabled() {
        return this.frame.getSelectionHaloEnabled();
    }

    void calculateStructures() {
        this.frame.calculateStructures(true);
    }

    boolean getEchoStateActive() {
        return this.frame.getEchoStateActive();
    }

    void setEchoStateActive(boolean TF) {
        this.frame.setEchoStateActive(TF);
    }

    boolean havePartialCharges() {
        return this.frame.partialCharges != null;
    }

    void setFormalCharges(BitSet bs, int formalCharge) {
        this.frame.setFormalCharges(bs, formalCharge);
    }

    UnitCell getUnitCell(int modelIndex) {
        if (modelIndex < 0) {
            return null;
        }
        return this.frame.cellInfos == null ? null : this.frame.cellInfos[modelIndex].unitCell;
    }

    Point3f getUnitCellOffset(int modelIndex) {
        UnitCell unitCell = this.getUnitCell(modelIndex);
        if (unitCell == null) {
            return null;
        }
        return unitCell.getCartesianOffset();
    }

    boolean setUnitCellOffset(int modelIndex, Point3f pt) {
        UnitCell unitCell = this.getUnitCell(modelIndex);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(pt);
        return true;
    }

    boolean setUnitCellOffset(int modelIndex, int nnn) {
        UnitCell unitCell = this.getUnitCell(modelIndex);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(nnn);
        return true;
    }
}

