/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.AtomShape;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Shape;
import org.jmol.viewer.StateManager;

class Polyhedra
extends AtomShape {
    static final float DEFAULT_DISTANCE_FACTOR = 1.85f;
    static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    static final int EDGES_NONE = 0;
    static final int EDGES_ALL = 1;
    static final int EDGES_FRONT = 2;
    static final int MAX_VERTICES = 90;
    static final int FACE_COUNT_MAX = 87;
    Atom[] otherAtoms = new Atom[90];
    int polyhedronCount;
    Polyhedron[] polyhedrons = new Polyhedron[32];
    float radius;
    int nVertices;
    float faceCenterOffset;
    float distanceFactor;
    int drawEdges;
    boolean isCollapsed;
    boolean iHaveCenterBitSet;
    boolean iHaveVertexBitSet;
    boolean bondedOnly;
    boolean haveBitSetVertices;
    BitSet centers;
    BitSet bsVertices;
    BitSet bsVertexCount;
    short[] normixesT = new short[90];
    byte[] planesT = new byte[270];
    static final Point3f randomPoint = new Point3f(3141.0f, 2718.0f, 1414.0f);
    Vector3f align1 = new Vector3f();
    Vector3f align2 = new Vector3f();
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    static float minDistanceForPlanarity = 0.1f;

    Polyhedra() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("polyhedra: " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.faceCenterOffset = 0.25f;
            this.distanceFactor = 1.85f;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.bsVertices = null;
            this.centers = null;
            this.bsVertexCount = new BitSet();
            this.iHaveVertexBitSet = false;
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.drawEdges = 0;
            this.haveBitSetVertices = false;
        }
        if ("generate" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == propertyName) {
            this.isCollapsed = (Boolean)value;
            return;
        }
        if ("nVertices" == propertyName) {
            this.nVertices = (Integer)value;
            this.bsVertexCount.set(this.nVertices);
            return;
        }
        if ("centers" == propertyName) {
            this.centers = (BitSet)value;
            this.iHaveCenterBitSet = true;
        }
        if ("to" == propertyName) {
            this.bsVertices = (BitSet)value;
        }
        if ("toBitSet" == propertyName) {
            this.bsVertices = (BitSet)value;
            this.haveBitSetVertices = true;
        }
        if ("faceCenterOffset" == propertyName) {
            this.faceCenterOffset = ((Float)value).floatValue();
            return;
        }
        if ("distanceFactor" == propertyName) {
            this.distanceFactor = ((Float)value).floatValue();
            return;
        }
        if ("bonds" == propertyName) {
            this.bondedOnly = true;
            return;
        }
        if ("delete" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == propertyName) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == propertyName) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == propertyName) {
            this.drawEdges = 2;
            return;
        }
        if (propertyName.indexOf("color") == 0) {
            if ("colorThis" == propertyName && this.iHaveCenterBitSet) {
                bs = this.centers;
            }
            super.setProperty("color", value, bs);
            return;
        }
        if (propertyName.indexOf("translucency") == 0) {
            if ("translucencyThis" == propertyName && this.iHaveCenterBitSet) {
                bs = this.centers;
            }
            super.setProperty("translucency", value, bs);
            return;
        }
        if ("radius" == propertyName) {
            this.radius = ((Float)value).floatValue();
            return;
        }
    }

    void deletePolyhedra() {
        int i;
        int newCount = 0;
        for (i = 0; i < this.polyhedronCount; ++i) {
            Polyhedron p = this.polyhedrons[i];
            if (this.centers.get(p.centralAtom.atomIndex)) continue;
            this.polyhedrons[newCount++] = p;
        }
        for (i = newCount; i < this.polyhedronCount; ++i) {
            this.polyhedrons[i] = null;
        }
        this.polyhedronCount = newCount;
    }

    void setVisible(boolean visible) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !this.centers.get(p.centralAtom.atomIndex)) continue;
            p.visible = visible;
        }
    }

    void savePolyhedron(Polyhedron p) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])ArrayUtil.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = p;
    }

    void buildPolyhedra() {
        boolean useBondAlgorithm = this.radius == 0.0f || this.bondedOnly;
        int i = this.atomCount;
        while (--i >= 0) {
            Polyhedron p;
            if (!this.centers.get(i)) continue;
            Polyhedron polyhedron = this.haveBitSetVertices ? this.constructBitSetPolyhedron(i) : (p = useBondAlgorithm ? this.constructBondsPolyhedron(i) : this.constructRadiusPolyhedron(i));
            if (p != null) {
                this.savePolyhedron(p);
            }
            if (!this.haveBitSetVertices) continue;
            return;
        }
    }

    Polyhedron constructBondsPolyhedron(int atomIndex) {
        Atom atom = this.atoms[atomIndex];
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return null;
        }
        int bondCount = 0;
        int i = bonds.length;
        while (--i >= 0) {
            Atom otherAtom;
            Bond bond = bonds[i];
            Atom atom2 = otherAtom = bond.atom1 == atom ? bond.atom2 : bond.atom1;
            if (this.bsVertices != null && !this.bsVertices.get(otherAtom.atomIndex) || this.radius > 0.0f && bond.atom1.distance(bond.atom2) > this.radius) continue;
            this.otherAtoms[bondCount++] = otherAtom;
            if (bondCount != 90) continue;
            break;
        }
        if (bondCount < 3 || this.nVertices > 0 && !this.bsVertexCount.get(bondCount)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, bondCount, this.otherAtoms);
    }

    Polyhedron constructBitSetPolyhedron(int atomIndex) {
        int otherAtomCount = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.bsVertices.get(i)) continue;
            this.otherAtoms[otherAtomCount++] = this.atoms[i];
        }
        return this.validatePolyhedronNew(this.atoms[atomIndex], otherAtomCount, this.otherAtoms);
    }

    Polyhedron constructRadiusPolyhedron(int atomIndex) {
        Atom atom = this.atoms[atomIndex];
        int otherAtomCount = 0;
        AtomIterator withinIterator = this.frame.getWithinModelIterator(atom, this.radius);
        while (withinIterator.hasNext()) {
            Atom other = withinIterator.next();
            if (other == atom || this.bsVertices != null && !this.bsVertices.get(other.atomIndex) || other.alternateLocationID != atom.alternateLocationID && other.alternateLocationID != 0 && atom.alternateLocationID != 0) continue;
            if (otherAtomCount == 90) break;
            this.otherAtoms[otherAtomCount++] = other;
        }
        if (otherAtomCount < 3 || this.nVertices > 0 && !this.bsVertexCount.get(otherAtomCount)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, otherAtomCount, this.otherAtoms);
    }

    Polyhedron validatePolyhedronNew(Atom centralAtom, int vertexCount, Atom[] otherAtoms) {
        boolean isOK;
        Vector3f normal = new Vector3f();
        int planeCount = 0;
        int ipt = 0;
        int ptCenter = vertexCount;
        int nPoints = ptCenter + 1;
        float distMax = 0.0f;
        float dAverage = 0.0f;
        Point3f[] points = new Point3f[270];
        points[ptCenter] = centralAtom;
        otherAtoms[ptCenter] = centralAtom;
        for (int i = 0; i < ptCenter; ++i) {
            points[i] = otherAtoms[i];
            dAverage += points[ptCenter].distance(points[i]);
        }
        float factor = this.distanceFactor;
        BitSet bs = new BitSet(ptCenter);
        boolean bl = isOK = (dAverage /= (float)ptCenter) == 0.0f;
        block1: while (!isOK) {
            int i;
            distMax = dAverage * factor;
            for (i = 0; i < ptCenter; ++i) {
                bs.set(i);
            }
            for (i = 0; i < ptCenter - 2; ++i) {
                for (int j = i + 1; j < ptCenter - 1; ++j) {
                    if (points[i].distance(points[j]) > distMax) continue;
                    for (int k = j + 1; k < ptCenter; ++k) {
                        if (points[i].distance(points[k]) > distMax || points[j].distance(points[k]) > distMax) continue;
                        bs.clear(i);
                        bs.clear(j);
                        bs.clear(k);
                    }
                }
            }
            isOK = true;
            for (i = 0; i < ptCenter; ++i) {
                if (!bs.get(i)) continue;
                isOK = false;
                Logger.debug("Polyhedra distanceFactor for " + ptCenter + " atoms increased to " + (factor *= 1.05f) + " in order to include " + otherAtoms[i].getIdentity());
                continue block1;
            }
        }
        String faceCatalog = "";
        String facetCatalog = "";
        for (int i = 0; i < ptCenter - 2; ++i) {
            for (int j = i + 1; j < ptCenter - 1; ++j) {
                for (int k = j + 1; k < ptCenter; ++k) {
                    if (!this.isPlanar(points[i], points[j], points[k], points[ptCenter])) continue;
                    faceCatalog = faceCatalog + this.faceId(i, j, k);
                }
            }
        }
        for (int j = 0; j < ptCenter - 1; ++j) {
            for (int k = j + 1; k < ptCenter; ++k) {
                if (!this.isAligned(points[j], points[k], points[ptCenter])) continue;
                facetCatalog = facetCatalog + this.faceId(j, k, -1);
            }
        }
        Point3f ptRef = new Point3f();
        for (int i = 0; i < ptCenter - 2; ++i) {
            for (int j = i + 1; j < ptCenter - 1; ++j) {
                if (points[i].distance(points[j]) > distMax) continue;
                for (int k = j + 1; k < ptCenter; ++k) {
                    boolean isFaceCentered;
                    if (points[i].distance(points[k]) > distMax || points[j].distance(points[k]) > distMax) continue;
                    if (planeCount >= 87) {
                        Logger.error("Polyhedron error: maximum face(87) -- reduce RADIUS ");
                        return null;
                    }
                    if (nPoints >= 90) {
                        Logger.error("Polyhedron error: maximum vertex count(90) -- reduce RADIUS ");
                        return null;
                    }
                    boolean bl2 = isFaceCentered = faceCatalog.indexOf(this.faceId(i, j, k)) >= 0;
                    if (isFaceCentered) {
                        Graphics3D.getNormalFromCenter(randomPoint, points[i], points[j], points[k], false, normal);
                    } else {
                        Graphics3D.getNormalFromCenter(points[ptCenter], points[i], points[j], points[k], true, normal);
                    }
                    normal.scale(this.isCollapsed && !isFaceCentered ? this.faceCenterOffset : 0.001f);
                    int nRef = nPoints;
                    if (this.isCollapsed && !isFaceCentered) {
                        points[nPoints] = new Point3f(points[ptCenter]);
                        points[nPoints].add(normal);
                        otherAtoms[nPoints] = new Atom(points[nPoints]);
                    } else if (isFaceCentered) {
                        ptRef.set(points[ptCenter]);
                        ptRef.sub(normal);
                        nRef = ptCenter;
                    }
                    String facet = this.faceId(i, j, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)i;
                        this.planesT[ipt++] = (byte)j;
                        this.planesT[ipt++] = (byte)nRef;
                        Graphics3D.getNormalFromCenter(points[k], points[i], points[j], ptRef, false, normal);
                        this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    facet = this.faceId(i, k, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)i;
                        this.planesT[ipt++] = (byte)nRef;
                        this.planesT[ipt++] = (byte)k;
                        Graphics3D.getNormalFromCenter(points[j], points[i], ptRef, points[k], false, normal);
                        this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    facet = this.faceId(j, k, -1);
                    if (this.isCollapsed || isFaceCentered && facetCatalog.indexOf(facet) < 0) {
                        facetCatalog = facetCatalog + facet;
                        this.planesT[ipt++] = (byte)nRef;
                        this.planesT[ipt++] = (byte)j;
                        this.planesT[ipt++] = (byte)k;
                        Graphics3D.getNormalFromCenter(points[i], ptRef, points[j], points[k], false, normal);
                        short s = this.normixesT[planeCount++] = isFaceCentered ? this.g3d.get2SidedNormix(normal) : this.g3d.getNormix(normal);
                    }
                    if (isFaceCentered) continue;
                    if (this.isCollapsed) {
                        ++nPoints;
                        continue;
                    }
                    this.planesT[ipt++] = (byte)i;
                    this.planesT[ipt++] = (byte)j;
                    this.planesT[ipt++] = (byte)k;
                    this.normixesT[planeCount++] = this.g3d.getNormix(normal);
                }
            }
        }
        return new Polyhedron(centralAtom, ptCenter, nPoints, planeCount, otherAtoms, this.normixesT, this.planesT);
    }

    String faceId(int i, int j, int k) {
        return "" + new Point3i(i, j, k);
    }

    boolean isAligned(Point3f pt1, Point3f pt2, Point3f pt3) {
        this.align1.sub(pt1, pt3);
        this.align2.sub(pt2, pt3);
        float angle = this.align1.angle(this.align2);
        return angle < 0.01f || angle > 3.13f;
    }

    boolean isPlanar(Point3f pt1, Point3f pt2, Point3f pt3, Point3f ptX) {
        Vector3f plane = new Vector3f();
        float w = Graphics3D.getPlaneThroughPoints(pt1, pt2, pt3, plane, this.vAB, this.vAC);
        float distanceToPlane = Math.abs(plane.x * ptX.x + plane.y * ptX.y + plane.z * ptX.z + w) / (float)Math.sqrt(plane.x * plane.x + plane.y * plane.y + plane.z * plane.z);
        boolean isPlanar = distanceToPlane < minDistanceForPlanarity;
        return isPlanar;
    }

    void setVisibilityFlags(BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            p.visibilityFlags = p.visible && bs.get(p.centralAtom.modelIndex) && !this.frame.bsHidden.get(p.centralAtom.atomIndex) ? this.myVisibilityFlag : 0;
        }
    }

    String getShapeState() {
        Hashtable temp = new Hashtable();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            s.append(this.polyhedrons[i].getState(temp));
        }
        if (this.drawEdges == 2) {
            Shape.appendCmd(s, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Shape.appendCmd(s, "polyhedra edges");
        }
        s.append(super.getShapeState());
        return s.toString();
    }

    class Polyhedron {
        final Atom centralAtom;
        final Atom[] vertices;
        int ptCenter;
        int nPoints;
        boolean visible;
        final short[] normixes;
        byte[] planes;
        int planeCount;
        int visibilityFlags = 0;
        boolean collapsed = false;
        float myFaceCenterOffset;
        float myDistanceFactor;

        Polyhedron(Atom centralAtom, int ptCenter, int nPoints, int planeCount, Atom[] otherAtoms, short[] normixes, byte[] planes) {
            this.collapsed = Polyhedra.this.isCollapsed;
            this.centralAtom = centralAtom;
            this.ptCenter = ptCenter;
            this.nPoints = nPoints;
            this.vertices = new Atom[nPoints];
            this.visible = true;
            this.normixes = new short[planeCount];
            this.planeCount = planeCount;
            this.planes = new byte[planeCount * 3];
            this.myFaceCenterOffset = Polyhedra.this.faceCenterOffset;
            this.myDistanceFactor = Polyhedra.this.distanceFactor;
            int i = nPoints;
            while (--i >= 0) {
                this.vertices[i] = otherAtoms[i];
            }
            i = planeCount;
            while (--i >= 0) {
                this.normixes[i] = normixes[i];
            }
            i = planeCount * 3;
            while (--i >= 0) {
                this.planes[i] = planes[i];
            }
        }

        String getState(Hashtable temp) {
            BitSet bs = new BitSet();
            for (int i = 0; i < this.ptCenter; ++i) {
                bs.set(this.vertices[i].atomIndex);
            }
            String s = "select ({" + this.centralAtom.atomIndex + "});polyhedra " + this.ptCenter + (this.myDistanceFactor == 1.85f ? "" : " distanceFactor " + this.myDistanceFactor) + (this.myFaceCenterOffset == 0.25f ? "" : " faceCenterOffset " + this.myFaceCenterOffset) + " to " + StateManager.escape(bs) + (this.collapsed ? " collapsed" : "") + ";" + (this.visible ? "" : "polyhedra off;") + "\n";
            return s;
        }
    }
}

