/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Vectors;

class VectorsRenderer
extends ShapeRenderer {
    final Point3f pointVectorEnd = new Point3f();
    final Point3f pointArrowHead = new Point3f();
    final Point3i screenVectorEnd = new Point3i();
    final Point3i screenArrowHead = new Point3i();
    final Vector3f headOffsetVector = new Vector3f();
    int diameter;
    float headWidthAngstroms;
    int headWidthPixels;
    float vectorScale;
    float headScale;
    boolean doShaft;
    static final float arrowHeadOffset = -0.2f;

    VectorsRenderer() {
    }

    void render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return;
        }
        short[] mads = vectors.mads;
        if (mads == null) {
            return;
        }
        Atom[] atoms = vectors.atoms;
        short[] colixes = vectors.colixes;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Vector3f vibrationVector;
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & 1) == 0 || (atom.shapeVisibilityFlags & vectors.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i) || (vibrationVector = atom.getVibrationVector()) == null) continue;
            this.vectorScale = vectors.scale;
            if (Float.isNaN(this.vectorScale)) {
                this.vectorScale = vectors.scale = this.viewer.getDefaultVectorScale();
            }
            if (!this.transform(mads[i], atom, vibrationVector)) continue;
            this.renderVector(colixes == null ? (short)0 : colixes[i], atom);
        }
    }

    boolean transform(short mad, Atom atom, Vector3f vibrationVector) {
        if (atom.madAtom == Short.MIN_VALUE) {
            return false;
        }
        float len = vibrationVector.length();
        if ((double)Math.abs(len * this.vectorScale) < 0.01) {
            return false;
        }
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        this.doShaft = 0.1 + (double)Math.abs(this.headScale / len) < (double)Math.abs(this.vectorScale);
        this.headOffsetVector.set(vibrationVector);
        this.headOffsetVector.scale(this.headScale / len);
        this.pointVectorEnd.scaleAdd(this.vectorScale, vibrationVector, atom);
        this.pointArrowHead.set(this.pointVectorEnd);
        this.pointArrowHead.add(this.headOffsetVector);
        this.viewer.transformPoint(this.pointArrowHead, vibrationVector, this.screenArrowHead);
        this.viewer.transformPoint(this.pointVectorEnd, vibrationVector, this.screenVectorEnd);
        this.diameter = mad < 5 ? 5 : (mad <= 20 ? (int)mad : (int)this.viewer.scaleToScreen(this.screenVectorEnd.z, mad));
        this.headWidthPixels = (int)((float)this.diameter * 1.5f);
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    void renderVector(short colix, Atom atom) {
        colix = Graphics3D.getColixInherited(colix, atom.colixAtom);
        if (this.doShaft) {
            this.g3d.fillCylinder(colix, (byte)1, this.diameter, atom.screenX, atom.screenY, atom.screenZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        }
        this.g3d.fillCone(colix, (byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd);
    }
}

