/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.IClientAppdata;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.simpleclient.IdFactory;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.SimpleClientAppdata;
import uk.ac.vamsas.client.simpleclient.SimpleClientConfig;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasSession;
import uk.ac.vamsas.objects.core.AppData;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.AppDataReference;

public class ClientDocument
extends uk.ac.vamsas.client.ClientDocument
implements IClientDocument {
    private static Log log = LogFactory.getLog((Class)ClientDocument.class);
    private VamsasDocument doc;
    protected SimpleClient sclient;
    protected VamsasArchive iohandler = null;
    private boolean isModified = false;
    private VAMSAS[] _VamsasRoots = null;
    private boolean invalidModification = false;
    SimpleClientAppdata scappd = null;

    public boolean isModified() {
        return this.isModified;
    }

    protected ClientDocument(VamsasDocument doc, VamsasArchive docHandler, IdFactory Factory, SimpleClient sclient) {
        super(Factory.getVorbaIdHash(), Factory);
        this.sclient = sclient;
        this.iohandler = docHandler;
        this.doc = doc;
        this._VamsasRoots = doc.getVAMSAS();
    }

    public Vobject getObject(VorbaId id) {
        if (this.vamsasObjects == null) {
            log.debug((Object)"getObject called on null objrefs list.");
            return null;
        }
        if (this.vamsasObjects.containsKey(id)) {
            return (Vobject)this.vamsasObjects.get(id);
        }
        log.debug((Object)("Returning null Vobject reference for id " + id.getId()));
        return null;
    }

    public Vobject[] getObjects(VorbaId[] ids) {
        if (this.vamsasObjects == null) {
            log.debug((Object)"getObject[]  called on null vamsasObjects list.");
            return null;
        }
        Vobject[] vo = new Vobject[ids.length];
        int j = ids.length;
        for (int i = 0; i < j; ++i) {
            if (this.vamsasObjects.containsKey(ids[i])) {
                vo[i] = (Vobject)this.vamsasObjects.get(ids[i]);
                continue;
            }
            log.debug((Object)("Returning null Vobject reference for id " + ids[i].getId()));
        }
        return vo;
    }

    protected void updateDocumentRoots() {
        if (this.doc == null) {
            log.error((Object)"updateDocumentRoots called on null document. Probably an implementation error.");
            return;
        }
        if (this.isModified && this._VamsasRoots != null) {
            this.doc.setVAMSAS(this._VamsasRoots);
            this._VamsasRoots = null;
        }
    }

    public VAMSAS[] getVamsasRoots() {
        if (this.doc == null) {
            log.debug((Object)"Null document for getVamsasRoots(), returning null");
            return null;
        }
        if (this.iohandler == null) {
            log.warn((Object)"getVamsasRoots() called on possibly read-only document.");
        }
        if (this._VamsasRoots != null) {
            return this._VamsasRoots;
        }
        VAMSAS[] roots = this.doc.getVAMSAS();
        if (roots == null) {
            this._VamsasRoots = new VAMSAS[]{new VAMSAS()};
            this.registerObject(this._VamsasRoots[0]);
            this.doc.getProvenance().addEntry(this.sclient.getProvenanceEntry("Created new document root [id=" + this._VamsasRoots[0].getId() + "]"));
            this.doc.addVAMSAS(this._VamsasRoots[0]);
        } else {
            this._VamsasRoots = new VAMSAS[roots.length];
            for (int r = 0; r < roots.length; ++r) {
                this._VamsasRoots[r] = roots[r];
            }
        }
        return this._VamsasRoots;
    }

    private int _contains(VAMSAS root, VAMSAS[] docRoots) {
        if (root == null) {
            return -1;
        }
        if (docRoots == null || docRoots.length == 0) {
            return -1;
        }
        VorbaId d_id = null;
        VorbaId r_id = root.getVorbaId();
        int j = docRoots.length;
        for (int i = 0; i < j; ++i) {
            if (docRoots[i] != root && (docRoots[i] == null || (d_id = docRoots[i].getVorbaId()) == null || !d_id.equals(r_id))) continue;
            return i;
        }
        return -1;
    }

    private boolean isValidUpdate(VAMSAS newVersion, VAMSAS oldVersion, ClientDocument modflag) {
        if (oldVersion == newVersion) {
            if (!newVersion.isRegistered()) {
                this._registerObject(newVersion);
                modflag.isModified = true;
            }
            if (oldVersion.is__stored_in_document()) {
                if (oldVersion.get__last_hash() != (long)oldVersion.hashCode()) {
                    log.debug((Object)("Modified hashcode for vamsas root " + oldVersion.getVorbaId()));
                    modflag.isModified = true;
                } else {
                    log.debug((Object)("Unmodified vamsas root " + oldVersion.getVorbaId()));
                }
            }
            try {
                if (this.getSimpleClientConfig().validateUpdatedRoots()) {
                    newVersion.validate();
                }
                return true;
            }
            catch (Exception e) {
                log.error((Object)("Validation Exception for new vamsas root :" + newVersion.getVorbaId()), (Throwable)e);
                modflag.invalidModification = true;
                return false;
            }
        }
        if (!newVersion.isRegistered()) {
            this._registerObject(newVersion);
            modflag.isModified = true;
        }
        try {
            if (this.getSimpleClientConfig().validateMergedRoots()) {
                newVersion.validate();
            }
            modflag.isModified = true;
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Validation Exception for new vamsas root :" + newVersion.getVorbaId()), (Throwable)e);
            return false;
        }
    }

    private SimpleClientConfig getSimpleClientConfig() {
        return this.sclient.getSimpleClientConfig();
    }

    private VAMSAS[] _combineRoots(VAMSAS[] newr, VAMSAS[] original, ClientDocument modflag) {
        int i;
        Vector<VAMSAS> rts = new Vector<VAMSAS>();
        int j = original.length;
        for (i = 0; i < j; ++i) {
            int k = this._contains(original[i], newr);
            if (k > -1) {
                if (this.isValidUpdate(newr[k], original[i], modflag)) {
                    rts.add(newr[k]);
                    newr[k] = null;
                    continue;
                }
                log.warn((Object)("Couldn't merge new VAMSAS root " + newr[k].getId()));
                newr[k] = null;
                continue;
            }
            rts.add(original[i]);
        }
        j = newr.length;
        for (i = 0; i < j; ++i) {
            if (newr[i] == null) continue;
            rts.add(newr[i]);
            modflag.isModified = true;
        }
        newr = new VAMSAS[rts.size()];
        j = rts.size();
        for (i = 0; i < j; ++i) {
            newr[i] = (VAMSAS)rts.get(i);
        }
        return newr;
    }

    public void setVamsasRoots(VAMSAS[] newroots) {
        VAMSAS[] newr;
        if (this.doc == null) {
            log.debug((Object)"setVamsasRoots called on null document.");
            return;
        }
        if (newroots == null) {
            log.debug((Object)"setVamsasRoots(null) - do nothing.");
            return;
        }
        if (this._VamsasRoots != newroots) {
            newr = new VAMSAS[newroots.length];
            for (int i = 0; i < newr.length; ++i) {
                newr[i] = newroots[i];
            }
            newr = this._combineRoots(newr, this._VamsasRoots, this);
        } else {
            newr = new VAMSAS[this._VamsasRoots.length];
            for (int i = 0; i < newr.length; ++i) {
                newr[i] = this._VamsasRoots[i];
            }
        }
        this._VamsasRoots = this._combineRoots(newr, this.doc.getVAMSAS(), this);
    }

    public void addVamsasRoot(VAMSAS newroot) {
        if (this.doc == null) {
            log.debug((Object)"addVamsasRoots called on null document.");
            return;
        }
        VAMSAS[] newroots = this._combineRoots(new VAMSAS[]{newroot}, this.getVamsasRoots(), this);
        this._VamsasRoots = newroots;
    }

    public VorbaId[] registerObjects(Vobject[] unregistered) {
        if (this.doc == null) {
            log.warn((Object)"registerObjects[] called on null document.");
            return null;
        }
        if (this.vamsasObjects == null) {
            log.warn((Object)"registerObjects[] called for null vamsasObjects hasharray.");
            return null;
        }
        if (unregistered != null) {
            VorbaId[] ids = new VorbaId[unregistered.length];
            int k = unregistered.length;
            for (int i = 0; i < k; ++i) {
                if (unregistered[i] != null) {
                    log.warn((Object)("Null Vobject passed to registerObject[] at position " + i));
                    return null;
                }
                ids[i] = this.registerObject(unregistered[i]);
            }
            log.debug((Object)("Registered " + unregistered.length + " objects - total of " + this.vamsasObjects.size() + " ids."));
            return ids;
        }
        return null;
    }

    public VorbaId registerObject(Vobject unregistered) {
        if (this.doc == null) {
            log.warn((Object)"registerObjects called on null document.");
            return null;
        }
        if (this.vamsasObjects == null) {
            log.warn((Object)"registerObjects called for null vamsasObjects hasharray.");
            return null;
        }
        if (this.iohandler == null) {
            log.warn((Object)"registerObjects called for read only document.");
            return null;
        }
        if (unregistered != null) {
            VorbaId id = this._registerObject(unregistered);
            log.debug((Object)("Registered object - total of " + this.vamsasObjects.size() + " ids."));
            return id;
        }
        log.warn((Object)"Null Vobject passed to registerObject.");
        return null;
    }

    public IClientAppdata getClientAppdata() {
        log.error((Object)"TODO: TEST Client Appdata access methods");
        if (this.doc == null) {
            log.warn((Object)"getClientAppdata called on null document.");
            return null;
        }
        if (this.scappd == null) {
            log.debug((Object)("Creating new SimpleClientAppdata instance for " + this.sclient.getSessionHandle()));
            this.scappd = new SimpleClientAppdata(this);
            if (this.scappd == null) {
                log.warn((Object)("Null appdata object for " + this.sclient.getSessionHandle()));
            } else {
                log.debug((Object)"Created SimpleClientAppdata successfully.");
            }
        } else {
            log.debug((Object)"Returning existing SimpleClientAppdata reference.");
        }
        return this.scappd;
    }

    protected VamsasDocument getVamsasDocument() {
        return this.doc;
    }

    protected VamsasArchiveReader getVamsasArchiveReader() {
        if (this.iohandler == null) {
            log.error((Object)"Near fatal. Null VamsasArchive iohandler so can't get VamsasArchiveReader");
            return null;
        }
        try {
            log.info((Object)"TODO: test getVamsasArchiveReader");
            return this.iohandler.getOriginalArchiveReader();
        }
        catch (Exception e) {
            log.warn((Object)"Unable to create OriginalArchiveReader!", (Throwable)e);
            return null;
        }
    }

    protected boolean updateSessionDocument() throws IOException {
        boolean docupdate = true;
        if (this.doc == null) {
            log.warn((Object)"updateSessionDocument called on null document.");
            throw new IOException("Document is closed.");
        }
        if (this.iohandler == null) {
            log.warn((Object)"updateSessionDocument called on null document iohandler handler.");
            throw new IOException("Document is closed.");
        }
        if (!this.isModified() && !this.scappd.isModified()) {
            log.debug((Object)"Document update not necessary. returning false.");
            return false;
        }
        VamsasSession session = this.sclient._session;
        log.debug((Object)("updating Session Document in " + session.sessionDir));
        log.debug((Object)("Attempting to update session " + this.sclient.session.getSessionUrn()));
        if (this.scappd != null && this.scappd.isModified()) {
            AppData appd;
            ClientHandle client = this.sclient.client;
            UserHandle user = this.sclient.user;
            this.scappd.closeForWriting();
            if (this.scappd.appsGlobal == null) {
                log.debug((Object)"Creating new appData entry for this application...");
                this.scappd.appsGlobal = new ApplicationData();
                appd = this.scappd.appsGlobal;
                ((ApplicationData)appd).setName(client.getClientName());
                ((ApplicationData)appd).setVersion(client.getVersion());
                this.doc.addApplicationData((ApplicationData)appd);
                appd.setDataReference(AppDataReference.uniqueAppDataReference(this.doc, this.sclient.client.getClientUrn()));
                log.debug((Object)"... created.");
            }
            if (this.scappd.newAppData != null && this.scappd.newAppData.sessionFile.exists()) {
                log.debug((Object)"Beginning update for new Global Appdata...");
                if (this.scappd.appsGlobal.getData() != null) {
                    this.scappd.appsGlobal.setData(null);
                    this.scappd.appsGlobal.setDataReference(AppDataReference.uniqueAppDataReference(this.doc, this.sclient.client.getClientUrn()));
                }
                this.scappd.updateAnAppdataEntry(this.iohandler, this.scappd.appsGlobal, this.scappd.newAppData);
                log.debug((Object)"...Successfully updated Global Appdata Entry.");
            }
            if (this.scappd.newUserData != null && this.scappd.newUserData.sessionFile.exists()) {
                log.debug((Object)"Beginning to update Users Appdata entry....");
                if (this.scappd.usersData == null) {
                    this.scappd.usersData = new User();
                    this.scappd.usersData.setFullname(user.getFullName());
                    this.scappd.usersData.setOrganization(user.getOrganization());
                    this.scappd.appsGlobal.addUser(this.scappd.usersData);
                }
                if ((appd = this.scappd.usersData).getData() != null || appd.getDataReference() == null) {
                    appd.setData(null);
                    String safe_username = user.getFullName();
                    int t = safe_username.indexOf(" ");
                    if (t != -1) {
                        safe_username = safe_username.substring(t);
                    }
                    appd.setDataReference(AppDataReference.uniqueAppDataReference(this.doc, this.sclient.client.getClientUrn() + safe_username));
                }
                this.scappd.updateAnAppdataEntry(this.iohandler, this.scappd.usersData, this.scappd.newUserData);
                log.debug((Object)"...Successfully updated user AppData entry.");
            }
        }
        try {
            if (this.iohandler.transferRemainingAppDatas()) {
                log.debug((Object)"Remaining appdatas were transferred.");
            } else {
                log.debug((Object)"No remaining appdatas were transferred. (Correct?)");
            }
        }
        catch (Exception e) {
            log.error((Object)"While transferring remaining AppDatas", (Throwable)e);
        }
        log.debug((Object)"Updating Document...");
        this.updateDocumentRoots();
        try {
            this.iohandler.putVamsasDocument(this.doc);
            log.debug((Object)"Successfully written document entry.");
        }
        catch (Exception e) {
            log.error((Object)"Marshalling error for vamsas document.", (Throwable)e);
            docupdate = false;
        }
        this.iohandler.closeArchive();
        this.iohandler = null;
        log.debug((Object)"...successully finished and closed.");
        return docupdate;
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"Garbage collecting on ClientDocument instance.");
        if (this.scappd != null) {
            this.scappd.finalize();
            this.scappd = null;
        }
        if (this.doc != null) {
            this.doc = null;
        }
        if (this.sclient != null && this.sclient.cdocument == this) {
            this.sclient.cdocument = null;
        }
        this.sclient = null;
        super.finalize();
    }

    public Vector getUpdatedObjects() {
        return null;
    }

    public boolean isInvalidModification() {
        return this.invalidModification;
    }

    public void setInvalidModification(boolean invalidModification) {
        this.invalidModification = invalidModification;
    }
}

