/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.simpleclient.ListFile;
import uk.ac.vamsas.client.simpleclient.Lock;

public class SessionsFile
extends ListFile {
    private static Log log = LogFactory.getLog((Class)SessionsFile.class);
    boolean backup = false;
    private int syncnum = 1;

    public SessionsFile(File file) throws IOException {
        super(file);
    }

    private SessionHandle[] retrieveSessionHandles() {
        if (this.lockFile()) {
            try {
                ObjectInputStream is;
                Object o;
                SessionHandle[] sessions = null;
                if (this.fileLock.length() > 0L && (o = (is = new ObjectInputStream(this.fileLock.getBufferedInputStream(true))).readObject()) != null) {
                    try {
                        sessions = (SessionHandle[])o;
                    }
                    catch (Exception e) {
                        log.error((Object)("Garbage in the clientHandle list " + this.sessionFile), (Throwable)e);
                    }
                }
                return sessions;
            }
            catch (FileNotFoundException e) {
                log.error((Object)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public SessionHandle[] retrieveSessionsList() {
        if (this.lockFile()) {
            SessionHandle[] clients = this.retrieveSessionHandles();
            this.unlockFile();
            return clients;
        }
        return null;
    }

    public SessionHandle[] retrieveSessionsList(Lock extantlock) {
        if (this.lockFile(extantlock)) {
            SessionHandle[] sessions = this.retrieveSessionHandles();
            this.unlockFile();
            return sessions;
        }
        return null;
    }

    public int addSession(SessionHandle newSession, Lock extantLock) {
        return this.addSession(newSession, true, extantLock);
    }

    public int addSession(SessionHandle newSession, boolean disambig, Lock extantLock) {
        if (this.lockFile(extantLock)) {
            this.syncnum = this.addSession(newSession, disambig);
            this.unlockFile();
            return this.syncnum;
        }
        return 0;
    }

    public void removeSession(SessionHandle session, Lock sessionlock) {
        int mynum = -1;
        if (this.lockFile(sessionlock)) {
            SessionHandle[] sessions = this.retrieveSessionHandles();
            if (sessions != null) {
                if (this.syncnum <= 0 || this.syncnum > sessions.length || !sessions[this.syncnum - 1].equals(session)) {
                    int j = sessions.length;
                    for (int i = 0; i < j; ++i) {
                        if (!sessions[i].equals(session)) continue;
                        mynum = i;
                        break;
                    }
                } else {
                    mynum = this.syncnum - 1;
                }
                if (mynum > -1) {
                    SessionHandle[] newlist = new SessionHandle[sessions.length - 1];
                    int k = 0;
                    int j = sessions.length;
                    for (int i = 0; i < j; ++i) {
                        if (i == mynum) continue;
                        newlist[k++] = sessions[i];
                    }
                    if (!this.putSessionsList(newlist)) {
                        throw new Error("Failed to write new sessionsList!");
                    }
                }
            }
        } else {
            throw new Error("Couldn't get lock for " + (this.sessionFile == null ? "Unitialised sessionFile in SessionsFile" : this.sessionFile.getAbsolutePath()));
        }
        this.unlockFile();
    }

    protected int addSession(SessionHandle session, boolean disambiguate) {
        int newsession = 0;
        int tries = 5;
        while (tries-- > 0 && !this.lockFile()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {}
        }
        if (this.lockFile()) {
            SessionHandle[] sessions = this.retrieveSessionHandles();
            if (sessions == null) {
                sessions = new SessionHandle[]{session};
                newsession = 1;
            } else {
                int i;
                boolean k = false;
                int j = sessions.length;
                for (i = 0; i < j; ++i) {
                    if (!sessions[i].equals(session)) continue;
                    if (disambiguate) {
                        while (sessions[i].equals(session)) {
                        }
                        continue;
                    }
                    return -1 - i;
                }
                SessionHandle[] newlist = new SessionHandle[sessions.length + 1];
                j = sessions.length;
                for (i = 0; i < j; ++i) {
                    newlist[i] = sessions[i];
                }
                newlist[j] = session;
                sessions = newlist;
                newsession = j + 1;
            }
            if (!this.putSessionsList(sessions)) {
                return 0;
            }
        }
        return newsession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean putSessionsList(SessionHandle[] clients) {
        if (!this.lockFile()) throw new Error("Could not lock the clientList: " + (this.sessionFile == null ? "Unitialized ClientsFile" : " failed to get lock on " + this.sessionFile.getAbsolutePath()));
        File templist = null;
        if (this.backup && (templist = this.backupSessionFile()) == null) throw new Error("Couldn't create backup of the clientList before writing to it!");
        int retries = 3;
        while (retries-- > 0) {
            try {
                ObjectOutputStream os = new ObjectOutputStream(this.fileLock.getBufferedOutputStream(true));
                log.debug((Object)("About to write " + clients.length + " sessionHandles to output stream."));
                os.writeObject(clients);
                os.close();
                if (this.backup) {
                    templist.delete();
                }
                templist = null;
                retries = -1;
            }
            catch (Exception e) {
                log.error((Object)"Serious - problems writing to sessionFile.", (Throwable)e);
                if (retries > 0 && templist != null) {
                    log.error((Object)("Recovering from Backup in " + templist.getAbsolutePath()));
                    templist.renameTo(this.fileLock.target);
                }
                log.error((Object)e);
            }
        }
        if (retries <= -2) return true;
        log.error((Object)"Serious - problems writing to sessionFile. Giving Up.");
        return false;
    }

    public void clearList() {
        if (this.lockFile()) {
            try {
                FileOutputStream fout = this.fileLock.getFileOutputStream(true);
                fout.flush();
                fout.close();
            }
            catch (Exception e) {
                throw new Error("Problems trying to clear clientlist!", e);
            }
        }
    }
}

