/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.IOException;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.SessionsFile;

public class SimpleSessionManager {
    private SessionsFile sessionFile = null;

    protected SimpleSessionManager(File sessionsFile) throws IOException {
        this.initManagerObjects(sessionsFile);
    }

    private void initManagerObjects(File sessionsFile) throws IOException {
        if (this.sessionFile != null) {
            throw new IOException("initFactoryObjects called for initialised ClientFactory object.");
        }
        this.sessionFile = new SessionsFile(sessionsFile);
    }

    public FileWatcher getSessionsWatcher() {
        return new FileWatcher(this.getSessionFile().sessionFile);
    }

    public String[] getCurrentSessions() {
        SessionHandle[] sessionHandles;
        String[] sessions = null;
        if (this.sessionFile != null && (sessionHandles = this.sessionFile.retrieveSessionsList()) != null) {
            sessions = new String[sessionHandles.length];
            for (int i = sessionHandles.length - 1; i > -1; --i) {
                SessionHandle sessionHandle = sessionHandles[i];
                sessions[i] = sessionHandle.getSessionUrn();
            }
        }
        return sessions;
    }

    public int addSession(SessionHandle newSession) {
        return this.sessionFile.addSession(newSession, false, this.getSessionsWatcher().getChangedState());
    }

    private SessionsFile getSessionFile() {
        return this.sessionFile;
    }

    protected void removeSession(SessionHandle session) {
        this.getSessionFile().removeSession(session, this.getSessionsWatcher().getChangedState());
    }
}

