/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.EventGeneratorThread;
import uk.ac.vamsas.client.simpleclient.WatcherElement;

public class VamsasFileWatcherThread
extends Thread {
    private Log log = LogFactory.getLog((Class)VamsasFileWatcherThread.class);
    EventGeneratorThread client = null;
    private Vector elements = null;
    boolean running = false;
    boolean watching = false;
    public int WATCH_SLEEP = 30;

    public VamsasFileWatcherThread(EventGeneratorThread client) {
        this.client = client;
        this.elements = new Vector();
    }

    public void addElement(WatcherElement welement) {
        this.elements.addElement(welement);
    }

    public void removeElemenet(WatcherElement welement) {
        this.elements.removeElement(welement);
    }

    public void clearElements() {
        this.elements.clear();
    }

    public void haltWatchers() {
        if (!this.watching) {
            return;
        }
        this.watching = false;
        try {
            this.interrupt();
            long time = System.currentTimeMillis() + (long)this.WATCH_SLEEP;
            while (this.running && time > System.currentTimeMillis()) {
                Thread.sleep(1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.running) {
            this.log.warn((Object)"haltWatchers returning whilst thread is still running.");
        }
    }

    public void run() {
        this.running = true;
        this.watching = true;
        this.log.debug((Object)"Starting WatcherThread poll loop");
        while (this.watching) {
            boolean wait = true;
            Iterator watchers = this.elements.iterator();
            while (this.watching && watchers.hasNext()) {
                WatcherElement watch = (WatcherElement)watchers.next();
                if (!watch.doWatch()) continue;
                wait = false;
                this.log.debug((Object)("Event generated for watcher on " + watch.getWatcher().getSubject()));
            }
            if (!this.watching || !wait) continue;
            try {
                Thread.sleep(this.WATCH_SLEEP);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.debug((Object)"Finishing WatcherThread poll loop");
        this.running = false;
    }

    public void interrupt() {
    }
}

