/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.castor.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.Glyph;

public class AnnotationElement
extends Vobject
implements Serializable {
    private long _position;
    private boolean _has_position;
    private boolean _after = false;
    private boolean _has_after;
    private String _id;
    private String _description;
    private Vector _glyphList = new Vector();
    private Vector _valueList = new Vector();

    public void addGlyph(Glyph vGlyph) throws IndexOutOfBoundsException {
        this._glyphList.addElement(vGlyph);
    }

    public void addGlyph(int index, Glyph vGlyph) throws IndexOutOfBoundsException {
        this._glyphList.add(index, vGlyph);
    }

    public void addValue(float vValue) throws IndexOutOfBoundsException {
        this._valueList.addElement(new Float(vValue));
    }

    public void addValue(int index, float vValue) throws IndexOutOfBoundsException {
        this._valueList.add(index, new Float(vValue));
    }

    public void deleteAfter() {
        this._has_after = false;
    }

    public void deletePosition() {
        this._has_position = false;
    }

    public Enumeration enumerateGlyph() {
        return this._glyphList.elements();
    }

    public Enumeration enumerateValue() {
        return this._valueList.elements();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AnnotationElement) {
            boolean tmcycle;
            boolean thcycle;
            AnnotationElement temp = (AnnotationElement)obj;
            if (this._position != temp._position) {
                return false;
            }
            if (this._has_position != temp._has_position) {
                return false;
            }
            if (this._after != temp._after) {
                return false;
            }
            if (this._has_after != temp._has_after) {
                return false;
            }
            if (this._id != null) {
                if (temp._id == null) {
                    return false;
                }
                if (this._id != temp._id) {
                    thcycle = CycleBreaker.startingToCycle((Object)this._id);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle((Object)temp._id))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle((Object)this._id);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle((Object)temp._id);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this._id.equals(temp._id)) {
                            CycleBreaker.releaseCycleHandle((Object)this._id);
                            CycleBreaker.releaseCycleHandle((Object)temp._id);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle((Object)this._id);
                        CycleBreaker.releaseCycleHandle((Object)temp._id);
                    }
                }
            } else if (temp._id != null) {
                return false;
            }
            if (this._description != null) {
                if (temp._description == null) {
                    return false;
                }
                if (this._description != temp._description) {
                    thcycle = CycleBreaker.startingToCycle((Object)this._description);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle((Object)temp._description))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle((Object)this._description);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle((Object)temp._description);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this._description.equals(temp._description)) {
                            CycleBreaker.releaseCycleHandle((Object)this._description);
                            CycleBreaker.releaseCycleHandle((Object)temp._description);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle((Object)this._description);
                        CycleBreaker.releaseCycleHandle((Object)temp._description);
                    }
                }
            } else if (temp._description != null) {
                return false;
            }
            if (this._glyphList != null) {
                if (temp._glyphList == null) {
                    return false;
                }
                if (this._glyphList != temp._glyphList) {
                    thcycle = CycleBreaker.startingToCycle((Object)this._glyphList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle((Object)temp._glyphList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle((Object)this._glyphList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle((Object)temp._glyphList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this._glyphList.equals(temp._glyphList)) {
                            CycleBreaker.releaseCycleHandle((Object)this._glyphList);
                            CycleBreaker.releaseCycleHandle((Object)temp._glyphList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle((Object)this._glyphList);
                        CycleBreaker.releaseCycleHandle((Object)temp._glyphList);
                    }
                }
            } else if (temp._glyphList != null) {
                return false;
            }
            if (this._valueList != null) {
                if (temp._valueList == null) {
                    return false;
                }
                if (this._valueList != temp._valueList) {
                    thcycle = CycleBreaker.startingToCycle((Object)this._valueList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle((Object)temp._valueList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle((Object)this._valueList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle((Object)temp._valueList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this._valueList.equals(temp._valueList)) {
                            CycleBreaker.releaseCycleHandle((Object)this._valueList);
                            CycleBreaker.releaseCycleHandle((Object)temp._valueList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle((Object)this._valueList);
                        CycleBreaker.releaseCycleHandle((Object)temp._valueList);
                    }
                }
            } else if (temp._valueList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean getAfter() {
        return this._after;
    }

    public String getDescription() {
        return this._description;
    }

    public Glyph getGlyph(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._glyphList.size()) {
            throw new IndexOutOfBoundsException("getGlyph: Index value '" + index + "' not in range [0.." + (this._glyphList.size() - 1) + "]");
        }
        return (Glyph)this._glyphList.get(index);
    }

    public Glyph[] getGlyph() {
        Glyph[] array = new Glyph[]{};
        return this._glyphList.toArray(array);
    }

    public Vector getGlyphAsReference() {
        return this._glyphList;
    }

    public int getGlyphCount() {
        return this._glyphList.size();
    }

    public String getId() {
        return this._id;
    }

    public long getPosition() {
        return this._position;
    }

    public float getValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._valueList.size()) {
            throw new IndexOutOfBoundsException("getValue: Index value '" + index + "' not in range [0.." + (this._valueList.size() - 1) + "]");
        }
        return ((Float)this._valueList.get(index)).floatValue();
    }

    public float[] getValue() {
        int size = this._valueList.size();
        float[] array = new float[size];
        Iterator iter = this._valueList.iterator();
        for (int index = 0; index < size; ++index) {
            array[index] = ((Float)iter.next()).floatValue();
        }
        return array;
    }

    public Vector getValueAsReference() {
        return this._valueList;
    }

    public int getValueCount() {
        return this._valueList.size();
    }

    public boolean hasAfter() {
        return this._has_after;
    }

    public boolean hasPosition() {
        return this._has_position;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (int)(this._position ^ this._position >>> 32);
        result = 37 * result + (this._after ? 0 : 1);
        if (this._id != null && !CycleBreaker.startingToCycle((Object)this._id)) {
            result = 37 * result + this._id.hashCode();
            CycleBreaker.releaseCycleHandle((Object)this._id);
        }
        if (this._description != null && !CycleBreaker.startingToCycle((Object)this._description)) {
            result = 37 * result + this._description.hashCode();
            CycleBreaker.releaseCycleHandle((Object)this._description);
        }
        if (this._glyphList != null && !CycleBreaker.startingToCycle((Object)this._glyphList)) {
            result = 37 * result + this._glyphList.hashCode();
            CycleBreaker.releaseCycleHandle((Object)this._glyphList);
        }
        if (this._valueList != null && !CycleBreaker.startingToCycle((Object)this._valueList)) {
            result = 37 * result + this._valueList.hashCode();
            CycleBreaker.releaseCycleHandle((Object)this._valueList);
        }
        return result;
    }

    public boolean isAfter() {
        return this._after;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllGlyph() {
        this._glyphList.clear();
    }

    public void removeAllValue() {
        this._valueList.clear();
    }

    public boolean removeGlyph(Glyph vGlyph) {
        boolean removed = this._glyphList.remove(vGlyph);
        return removed;
    }

    public Glyph removeGlyphAt(int index) {
        Object obj = this._glyphList.remove(index);
        return (Glyph)obj;
    }

    public boolean removeValue(float vValue) {
        boolean removed = this._valueList.remove(new Float(vValue));
        return removed;
    }

    public float removeValueAt(int index) {
        Object obj = this._valueList.remove(index);
        return ((Float)obj).floatValue();
    }

    public void setAfter(boolean after) {
        this._after = after;
        this._has_after = true;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGlyph(int index, Glyph vGlyph) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._glyphList.size()) {
            throw new IndexOutOfBoundsException("setGlyph: Index value '" + index + "' not in range [0.." + (this._glyphList.size() - 1) + "]");
        }
        this._glyphList.set(index, vGlyph);
    }

    public void setGlyph(Glyph[] vGlyphArray) {
        this._glyphList.clear();
        for (int i = 0; i < vGlyphArray.length; ++i) {
            this._glyphList.add(vGlyphArray[i]);
        }
    }

    public void setGlyph(Vector vGlyphList) {
        this._glyphList.clear();
        this._glyphList.addAll(vGlyphList);
    }

    public void setGlyphAsReference(Vector glyphVector) {
        this._glyphList = glyphVector;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setPosition(long position) {
        this._position = position;
        this._has_position = true;
    }

    public void setValue(int index, float vValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._valueList.size()) {
            throw new IndexOutOfBoundsException("setValue: Index value '" + index + "' not in range [0.." + (this._valueList.size() - 1) + "]");
        }
        this._valueList.set(index, new Float(vValue));
    }

    public void setValue(float[] vValueArray) {
        this._valueList.clear();
        for (int i = 0; i < vValueArray.length; ++i) {
            this._valueList.add(new Float(vValueArray[i]));
        }
    }

    public void setValue(Vector vValueList) {
        this._valueList.clear();
        this._valueList.addAll(vValueList);
    }

    public void setValueAsReference(Vector valueVector) {
        this._valueList = valueVector;
    }

    public static AnnotationElement unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (AnnotationElement)Unmarshaller.unmarshal((Class)AnnotationElement.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

