/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.objects.core.Local;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Mapped;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.utils.MapList;

public class Range {
    static Log log;

    public static int[] getSegRange(Seg visSeg, boolean ensureDirection) {
        boolean incl = visSeg.getInclusive();
        int pol = visSeg.getStart() <= visSeg.getEnd() ? 1 : -1;
        int start = visSeg.getStart() + (incl ? 0 : pol);
        int end = visSeg.getEnd() + (incl ? 0 : -pol);
        if (ensureDirection && pol == -1) {
            int t = end;
            end = start;
            start = t;
        }
        return new int[]{start, end, pol < 0 ? 1 : 0};
    }

    public static int[] getBounds(RangeType dseta) {
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error("Invalid vamsas RangeType - cannot resolve both lists of Pos and Seg from choice!");
            }
            if (dseta.getSegCount() > 0) {
                se = Range.getSegRange(dseta.getSeg(0), true);
                int sSize = dseta.getSegCount();
                for (int s = 1; s < sSize; ++s) {
                    int[] nse = Range.getSegRange(dseta.getSeg(s), true);
                    if (se[0] > nse[0]) {
                        se[0] = nse[0];
                    }
                    if (se[1] >= nse[1]) continue;
                    se[1] = nse[1];
                }
            }
            if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                se = new int[]{pos, pos};
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    if (se[0] > pos) {
                        se[0] = pos;
                    }
                    if (se[1] >= pos) continue;
                    se[1] = pos;
                }
            }
            return se;
        }
        return null;
    }

    public static int[] getMapping(RangeType dseta) {
        Vector<Integer> posList = new Vector<Integer>();
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error("Invalid vamsas RangeType - cannot resolve both lists of Pos and Seg from choice!");
            }
            if (dseta.getSegCount() > 0) {
                int sSize = dseta.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = Range.getSegRange(dseta.getSeg(s), false);
                    int se_end = se[1 - se[2]] + (se[2] == 0 ? 1 : -1);
                    for (int p = se[se[2]]; p != se_end; p += se[2] == 0 ? 1 : -1) {
                        posList.add(new Integer(p));
                    }
                }
            } else if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    posList.add(new Integer(pos));
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            int[] range = new int[posList.size()];
            for (int i = 0; i < range.length; ++i) {
                range[i] = (Integer)posList.elementAt(i);
            }
            posList.clear();
            return range;
        }
        return null;
    }

    public static int[] getIntervals(RangeType range) {
        int[] intervals = null;
        Vector<Integer> posList = new Vector<Integer>();
        if (range != null) {
            int[] se = null;
            if (range.getSegCount() > 0 && range.getPosCount() > 0) {
                throw new Error("Invalid vamsas RangeType - cannot resolve both lists of Pos and Seg from choice!");
            }
            if (range.getSegCount() > 0) {
                int sSize = range.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = Range.getSegRange(range.getSeg(s), false);
                    posList.addElement(new Integer(se[0]));
                    posList.addElement(new Integer(se[1]));
                }
            } else if (range.getPosCount() > 0) {
                int pos = range.getPos(0).getI();
                int pSize = range.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = range.getPos(p).getI();
                    posList.add(new Integer(pos));
                    posList.add(new Integer(pos));
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            intervals = new int[posList.size()];
            Enumeration e = posList.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                intervals[i++] = (Integer)e.nextElement();
            }
        }
        return intervals;
    }

    public static void initRangeType(RangeType mrt, int[] range) {
        for (int i = 0; i < range.length; i += 2) {
            Seg vSeg = new Seg();
            vSeg.setStart(range[i]);
            vSeg.setEnd(range[i + 1]);
            vSeg.setInclusive(true);
            mrt.addSeg(vSeg);
        }
    }

    public static MapList parsemapType(MapType maprange, int localu, int mappedu) {
        MapList ml = null;
        int[] localRange = Range.getIntervals(maprange.getLocal());
        int[] mappedRange = Range.getIntervals(maprange.getMapped());
        long lu = maprange.getLocal().hasUnit() ? maprange.getLocal().getUnit() : (long)localu;
        long mu = maprange.getMapped().hasUnit() ? maprange.getMapped().getUnit() : (long)mappedu;
        ml = new MapList(localRange, mappedRange, (int)lu, (int)mu);
        return ml;
    }

    public static MapList parsemapType(MapType map) {
        if (!(map.getLocal().hasUnit() && map.getMapped().hasUnit() || !log.isDebugEnabled())) {
            log.debug((Object)("using default mapping length of 1:1 for map " + (map.isRegistered() ? map.getVorbaId().toString() : "<no Id registered> " + map.toString())));
        }
        return Range.parsemapType(map, 1, 1);
    }

    public static void initMapType(MapType maprange, MapList ml, boolean setUnits) {
        Range.initMapType(maprange, ml, setUnits, false);
    }

    public static void initMapType(MapType maprange, MapList ml, boolean setUnits, boolean reverse) {
        maprange.setLocal(new Local());
        maprange.setMapped(new Mapped());
        if (!reverse) {
            Range.initRangeType(maprange.getLocal(), ml.getFromRanges());
            Range.initRangeType(maprange.getMapped(), ml.getToRanges());
        } else {
            Range.initRangeType(maprange.getLocal(), ml.getToRanges());
            Range.initRangeType(maprange.getMapped(), ml.getFromRanges());
        }
        if (setUnits) {
            if (!reverse) {
                maprange.getLocal().setUnit(ml.getFromRatio());
                maprange.getMapped().setUnit(ml.getToRatio());
            } else {
                maprange.getLocal().setUnit(ml.getToRatio());
                maprange.getMapped().setUnit(ml.getFromRatio());
            }
        }
    }

    static {
        LogFactory.getFactory();
        log = LogFactory.getLog((Class)Range.class);
    }
}

