/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Pattern;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.SequenceType;

public class Seq {
    public static void write_PirSeq(OutputStream os, SequenceType seq, int wid) throws IOException {
        BufferedWriter pir_out = new BufferedWriter(new OutputStreamWriter(os));
        pir_out.write(">P1;" + seq.getName() + "\n");
        int width = wid < 1 ? 80 : wid;
        int k = seq.getSequence().length();
        for (int j = 0; j < k; j += width) {
            if (j + width < k) {
                pir_out.write(seq.getSequence().substring(j, j + width) + "\n");
                continue;
            }
            pir_out.write(seq.getSequence().substring(j) + "\n");
        }
        pir_out.flush();
    }

    public static void write_FastaSeq(OutputStream os, SequenceType seq) throws IOException {
        BufferedWriter fasta_out = new BufferedWriter(new OutputStreamWriter(os));
        fasta_out.write(">" + seq.getName() + "\n");
        fasta_out.write(seq.getSequence() + "\n");
        fasta_out.flush();
    }

    public static void write_FastaSeq(OutputStream os, SequenceType seq, int wid) throws IOException {
        BufferedWriter fasta_out = new BufferedWriter(new OutputStreamWriter(os));
        fasta_out.write(">" + seq.getName() + "\n");
        int width = wid < 1 ? 80 : wid;
        int k = seq.getSequence().length();
        for (int j = 0; j < k; j += width) {
            if (j + width < k) {
                fasta_out.write(seq.getSequence().substring(j, j + width) + "\n");
                continue;
            }
            fasta_out.write(seq.getSequence().substring(j) + "\n");
        }
        fasta_out.flush();
    }

    private static boolean valid_aadictionary_string(String s, String dict) {
        if (s == null) {
            return false;
        }
        Pattern aa_repl = Pattern.compile("[ARNDCQEGHILKMFPSTWYVUX]+", 2);
        String remnants = aa_repl.matcher(s).replaceAll("");
        return !remnants.matches("//S+");
    }

    public static Sequence newSequence(String Name, String Sequence2, String Dictionary2, int start, int end) {
        Sequence seq = new Sequence();
        seq.setDictionary(Dictionary2);
        seq.setName(Name);
        seq.setSequence(Sequence2);
        seq.setStart(start);
        if (start <= end) {
            if (end - start != Sequence2.length()) {
                seq.setEnd(start + Sequence2.length());
            }
        } else if (start - end != Sequence2.length()) {
            seq.setEnd(end + Sequence2.length());
        }
        return seq;
    }

    public static AlignmentSequence newAlignmentSequence(String name, String alSequence, Sequence refseq, long start, long end) {
        if (refseq != null) {
            AlignmentSequence asq = new AlignmentSequence();
            asq.setName(name);
            asq.setSequence(alSequence);
            asq.setRefid(refseq);
            if (end > refseq.getEnd() || end < start || end == -1L) {
                end = refseq.getEnd();
            }
            asq.setEnd(end);
            if (start < refseq.getStart()) {
                start = refseq.getStart();
            }
            asq.setStart(start);
            return asq;
        }
        return null;
    }

    public static boolean is_valid_aa_seq(SequenceType s) {
        Object w;
        boolean validref = false;
        if (s instanceof Sequence) {
            Sequence q = (Sequence)s;
            if (q.getDictionary() != null && q.getDictionary().length() > 0 || !q.getDictionary().equals("info:iubmb.org/aminoacids")) {
                return false;
            }
            return Seq.valid_aadictionary_string(q.getSequence(), "info:iubmb.org/aminoacids");
        }
        if (s instanceof AlignmentSequence && (w = ((AlignmentSequence)s).getRefid()) != null && w != s && w instanceof SequenceType) {
            return Seq.is_valid_aa_seq((SequenceType)w) && Seq.valid_aadictionary_string(((AlignmentSequence)s).getSequence(), "info:iubmb.org/aminoacids");
        }
        return false;
    }
}

