/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.File;
import java.util.Vector;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.simpleclient.ClientsFile;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.test.simpleclient.CommandProcessor;

public class ClientsFileTest {
    private static CommandProcessor cproc = new CommandProcessor();
    private static Vector commands = new Vector();

    private static void complainArgs(int argl, int argpos, String cmd, int argneed, String msg) {
        if (argl - argpos < argneed) {
            throw new Error(cmd + " needs " + argneed + " arguments : " + msg);
        }
    }

    public static void main(String[] args) {
        ClientsFile cfhand;
        File cf = new File(args[0]);
        System.out.println("Connecting to clientFile " + args[0]);
        try {
            cfhand = new ClientsFile(cf);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
        int argc = 1;
        while (argc < args.length) {
            int com = cproc.getCommand(args, argc);
            ++argc;
            block2 : switch (com) {
                case 0: {
                    ClientHandle ch = new ClientHandle(args[argc], args[argc + 1]);
                    int pos = cfhand.addClient(ch);
                    argc += 2;
                    if (pos != 0) {
                        System.out.println("Client added at " + pos + " as urn:" + ch.getClientUrn());
                        break;
                    }
                    System.out.println("Client was not added.");
                    break;
                }
                case 1: {
                    ClientHandle ch = new ClientHandle(args[argc], args[argc + 1]);
                    ch.setClientUrn(args[argc + 2]);
                    argc += 3;
                    cfhand.removeClient(ch, null);
                    System.out.println("Client removed (apparently)");
                    break;
                }
                case 2: {
                    ClientHandle[] chlist = cfhand.retrieveClientList();
                    if (chlist != null) {
                        int che = chlist.length;
                        for (int chi = 0; chi < che; ++chi) {
                            System.out.println("Client " + chi + " (" + chlist[chi].getClientName() + " " + chlist[chi].getVersion() + " " + chlist[chi].getClientUrn() + ")");
                        }
                        break;
                    }
                    System.out.println("Client list is empty.");
                    break;
                }
                case 3: {
                    try {
                        cfhand.clearList();
                    }
                    catch (Exception e) {
                        System.err.println("Failed on new empty clientfile creation!");
                        e.printStackTrace(System.err);
                    }
                    break;
                }
                case 4: {
                    FileWatcher w = new FileWatcher(cf);
                    while (cf.exists()) {
                        Lock chlock = w.getChangedState();
                        if (chlock == null) continue;
                        ClientHandle[] cl = cfhand.retrieveClientList(chlock);
                        System.out.println("-- Watching " + cf.getName());
                        if (cl != null) {
                            int che = cl.length;
                            for (int chi = 0; chi < che; ++chi) {
                                System.out.println("Client " + chi + " (" + cl[chi].getClientName() + " " + cl[chi].getVersion() + " " + cl[chi].getClientUrn() + ")");
                            }
                            continue;
                        }
                        System.out.println("Client list is empty.");
                    }
                    break;
                }
                case 5: {
                    ClientHandle ch = new ClientHandle(args[argc], args[argc + 1]);
                    int clpos = cfhand.addClient(ch);
                    argc += 2;
                    if (clpos == 0) {
                        System.err.println("Monitor Client was not added.");
                        break;
                    }
                    System.out.println("Monitor Client added at " + clpos + " as urn:" + ch.getClientUrn());
                    FileWatcher mon = new FileWatcher(cf);
                    while (cf.exists()) {
                        Lock chlock = mon.getChangedState();
                        if (chlock == null) continue;
                        ClientHandle[] cl = cfhand.retrieveClientList(chlock);
                        System.out.println("-- Monitor " + cf.getName());
                        int newpos = -1;
                        if (cl != null) {
                            int che = cl.length;
                            for (int chi = 0; chi < che; ++chi) {
                                if (!ch.equals(cl[chi])) continue;
                                newpos = chi + 1;
                            }
                        }
                        if (newpos == -1) {
                            newpos = cfhand.addClient(ch);
                            mon.setState();
                            if (newpos == 0) {
                                System.err.println("Monitor client could not be re-added to list.");
                                break block2;
                            }
                        }
                        if (newpos == clpos) continue;
                        System.out.println("Monitor client moved from " + clpos + " to " + newpos);
                        clpos = newpos;
                    }
                    break;
                }
                default: {
                    if (com == -1) {
                        System.err.println("Unknown command : " + args[argc++] + "*Ignored!*");
                        break;
                    }
                    System.err.println("Command " + args[argc++] + " *Ignored!* - its not implemented.");
                }
            }
            for (int j = 0; j < 900000; ++j) {
                Integer i;
                Integer q = i = Integer.getInteger("1");
            }
        }
    }

    static {
        commands.add(new String("add"));
        cproc.addCommand("add", 2, "for the Client's 'Name' and 'Version'");
        commands.add(new String("remove"));
        cproc.addCommand("remove", 3, "for the Client's 'Name', Version and URN");
        commands.add(new String("list"));
        cproc.addCommand("list", 0, "no args needed");
        commands.add(new String("clear"));
        cproc.addCommand("clear", 0, "no args needed");
        commands.add(new String("watch"));
        cproc.addCommand("watch", 0, "no args needed");
        commands.add(new String("monitor"));
        cproc.addCommand("monitor", 2, "for the Client's 'Name' and 'Version'");
    }
}

