/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.main;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import org.biolegato.core.menu.GDEMakeMenus;
import org.biolegato.core.menu.GDEMenu;
import org.biolegato.core.pcdmenu.PCDMenu;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BLMain {
    public static final String NAME = "BioLegato";
    public static final String PROGRAM_DIR = new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).isDirectory() ? BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath() : new File(new File(BLMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent()).getPath();
    public static final String CURRENT_DIR = System.getProperty("user.dir");
    public static final String VERSION = "0.7.3";
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    public static final String HOME_DIR = System.getProperty("user.home");
    public static final int DOUBLE_CLICK_TIME = 300;
    public static final OS CURRENT_OS = OS.detectOS();
    public static final ARCH CURRENT_ARCH = ARCH.detectARCH();
    public static final long serialVersionUID = 7526472295622776147L;
    public static final JMenuItem ABOUT_MENUITEM = new JMenuItem(new AbstractAction("About..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent evt) {
            BLMain.aboutPopup();
        }
    });
    public static final JMenuItem EXIT_MENUITEM = new JMenuItem(new AbstractAction("Exit"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(88));
        }

        public void actionPerformed(ActionEvent evt) {
            window.dispose();
        }
    });
    private static JFrame window = null;
    private static BLProperties properties = null;
    private static JTabbedPane canvasPane = null;
    private static JMenuBar menu = null;
    private static File currentPWD = new File(CURRENT_DIR);
    private static Hashtable<String, JMenu> menuHeadings = new Hashtable();
    private static PluginLoader plugins = null;
    public static boolean debug = false;

    public static void main(String[] args) {
        String value = "";
        String argument = null;
        LinkedList<File> dataAdd = new LinkedList<File>();
        properties = new BLProperties();
        plugins = new PluginLoader(BLMain.envreplace(BLMain.getProperty("plugins")));
        if (args != null) {
            for (String rawarg : args) {
                if (rawarg == null) continue;
                File fileIn = null;
                fileIn = new File(rawarg);
                if (fileIn != null && fileIn.exists() && fileIn.isFile() && fileIn.canRead()) {
                    dataAdd.add(fileIn);
                    continue;
                }
                if (!rawarg.startsWith("/") && !rawarg.startsWith("-")) continue;
                argument = rawarg;
                if (argument.startsWith("--") && argument.length() > 2) {
                    argument = argument.substring(2);
                } else if ((argument.startsWith("/") || argument.startsWith("-")) && argument.length() > 1) {
                    argument = argument.substring(1);
                }
                if (argument.indexOf(61) > 0) {
                    value = argument.substring(argument.indexOf(61) + 1);
                    argument = argument.substring(0, argument.indexOf(61));
                }
                if ("help".equals(argument = argument.toLowerCase().trim()) || "h".equals(argument) || "?".equals(argument)) {
                    System.out.println("Usage: biolegato [options] [files]\nUse --optionlist  to see a detailed list of options\nUse --manpage     to see BioLegato's manpage");
                    System.exit(0);
                    continue;
                }
                if ("optionlist".equals(argument)) {
                    System.out.println("+-------------+------------------------------------------------------+\n| Option      | Description                                          |\n+-------------+------------------------------------------------------+\n| help,?      | Displays usage information for BioLegato             |\n| manpage,man | Displays the manpage entry for BioLegato             |\n| optionlist  | Displays the list of options for using BioLegato     |\n| version,v   | Displays the version information for BioLegato       |\n| debug       | Enables BioLegato's debug mode                       |\n| plugins     | Displays a list of loaded plugins                    |\n| properties  | Displays a list of BioLegato's properties            |\n+-------------+------------------------------------------------------+\n");
                    System.exit(0);
                    continue;
                }
                if ("manpage".equals(argument) || "man".equals(argument)) {
                    System.out.println("NAME\n    Bio Legato - A customizable GUI for running programs\n\nVERSION\n    Version 0.7.3\n\nSYNOPSIS\n    biolegato [options] [files]\n\nDESCRIPTION\n    BioLegato is a customizable GUI for running programs.\n    Its initial intent is to be a replacement for GDE; however\n    with its large plugin API, it may be customized to run more\n    than just CLI programs.\n\n    With the versitility of BioLegato's plugin interface, it\n    supports a wide range of file formats which may be added to\n    at any time through addition of plugins.\n\nOPTIONS\n  NOTE: All command line parameters are case insensitive\n        and may optionally begin with -, --, or / to prevent\n        confusion with filenames\n\n    help,h,?\n        Displays usage information for BioLegato\n    manpage,man\n        Displays the manpage entry for BioLegato (this screen)\n    optionlist\n        Displays the list of options for using BioLegato\n    version,v\n        Displays the version information for BioLegato\n    debug\n        Enables BioLegato's debug mode\n    plugins\n        Displays a list of loaded plugins\n    properties\n        Displays a list of BioLegato's properties\n\nUSAGE EXAMPLES\n    biolegato\n\n    biolegato insequence.gb\n\n    biolegato --debug\n    biolegato /debug\n    biolegato -debug\n\n    biolegato --plugins --properties --debug\n\n    biolegato --plugins /properties -debug insequence.gb\n\nENVIRONMENT VARIABLES\n    BioLegato searches for the following environment variables.  If they don't exist BioLegato sets them to defaults.\n\n      BL_HOME\n        Default: the path of the current working directory\n        Description: the path to reference BioLegato from\n\n      BL_MASKS\n        Default: uses .blproperties value\n        Description: the directory to populate the default colourmask\n                     list\n\n      BL_PROPERTIES\n        Default: $BL_HOME/properties\n        Description: the locations to load the BioLegato properties file from\n\n      GDE_HELP_DIR\n        Default: null\n        Description: specifies a path to search for the main .GDEmenus file\n                     (NOTE: this is GDE_Menus.jar plugin specific)\n\n      GDE_MAKEMENUS_DIR\n        Default: null\n        Description: specifies a path to use as the root for parsing GDE\n                     format menus in the same way as BIRCH's makemenus.py\n\n      BL_DEBUG\n        Default: uses .blproperties value OR command switch --debug\n        Description: set to \"true\" to enable debug mode\n\n      NOTE: in properties files, BL_DIR points to the directory where\n            BioLegato is stored\n\nPROPERTIES\n    BioLegato supports the followind properties:\n\n      Property             Description\n        debug                determines whether or not to display debug information\n        plugins              sets the plugin directory\n        temp                 sets the temporary files directory\n        font.size            determines the default font size for objects in BioLegato\n        font.type            determines the default font type for objects in BioLegato\n        shell.name           determines the shell to execute\n        shell.parameter      determines the parameter for directing the shell to execute a command\n        pwd.properties       determines whether or not to read the properties file located in the current working directory\n        user.properties      determines whether or not to read the user's propery files (located in the user's home directory\n        user.plugins         determines whether or not to read the user's plugin files (located in the user's home directory\n        default.canvas       determines the default canvas to show on startup\n        default.fileformat   determines the default file format for open/save dialogs\n        GDE.menu             determines whether or not to read the GDE menu files (backwards compatibility mode)\n        GDE.help.viewer      determines which file to feed the help file to\n        GDE.help.path        the location to search for the help files\n        undo                 whether or not to enable undo support\n        undo.size            whether or not to enable undo support\n\n    This properties class will read properties files from the directory containing BioLegato, the user directory and finally\n    the directory BioLegato was launched from.  Please note that you can disable reading of properties files\n    from the user directory via. \"user.properties\"; likewise you can disable reading properties files in the directory BioLegato\n    was launched from via. \"pwd.properties\"\n    NOTE: for path properties BioLegato will replace all $'s with the appropriate environment variables if set.\n\nSUPPORTED PLUGINS\n    Currently BioLegato supports the following main types of Plugins:\n\n        Canvases\n           extends the class: org.biolegato.core.plugintypes.DataCanvas\n        File formats\n           extends the class: org.biolegato.core.plugintypes.DataFormat\n        Menu types\n           extends the class: org.biolegato.core.plugintypes.MenuType\n\n    For more information about plugins, please consult the BioLegato API\n\nFILES\n    biolegato\n        Script to run BioLegato\n    biolegato.jar\n        BioLegato's core java code\n    changelog.txt\n        BioLegato's revision history\n    plugins/GDE.jar        Provides a GDE style multiple alignment canvas and related support\n    plugins/tables.jar        Provides tabulated data support\n\nFILE FORMATS\n    All file formats in BioLegato are supported through plugins.\n    Below is a list of file formats supported by a default\n    installation of BioLegato (with all standard plugins):\n\n        BioLegato flatfiles\n        FastA files\n        GDE flatfiles\n        GDE format files\n        GenBank files (2008 standard compliant)\n\nBUGS\n    There are currently no known bugs in this version of BioLegato\n\n    Please report all bugs to: Graham Alvare <alvare@cc.umanitoba.ca>\nAUTHORS\n    Dr. Brian Fristensky\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: frist@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~frist\n\n    Graham Alvare\n    Department of Plant Science\n    University of Manitoba\n    Winnipeg, MB  Canada R3T 2N2\n\n    Email: alvare@cc.umanitoba.ca\n    Web: http://home.cc.umanitoba.ca/~alvare\n");
                    System.exit(0);
                    continue;
                }
                if ("version".equals(argument) || "v".equals(argument)) {
                    System.out.println("BioLegato v0.7.3");
                    System.exit(0);
                    continue;
                }
                if ("debug".equals(argument)) {
                    debug = true;
                    continue;
                }
                if ("plugins".equals(argument)) {
                    String[] pluginList;
                    System.out.println("(Current plugins path: " + BLMain.getProperty("plugins") + ")");
                    System.out.println("-- listing plugins loaded --");
                    for (String pluginName : pluginList = plugins.getPluginHash().keySet().toArray(new String[0])) {
                        System.out.println("Plugin: " + pluginName);
                    }
                    System.out.println("-- end of plugin list --");
                    continue;
                }
                if ("properties".equals(argument)) {
                    System.out.println("**********");
                    System.out.println("PROPERTIES");
                    System.out.println("**********");
                    properties.list(System.out);
                    continue;
                }
                BLMain.error("Unknown argument: " + rawarg, "processArgs");
            }
        }
        if (debug) {
            BLMain.message("Command line arguments read successfully", "processArgs");
        }
        if ("true".equalsIgnoreCase(BLMain.getProperty("debug")) || System.getenv("BL_DEBUG") != null && !"".equals(System.getenv("BL_DEBUG").trim()) && !"false".equalsIgnoreCase(System.getenv("debug"))) {
            debug = true;
        }
        canvasPane = new JTabbedPane();
        window = new JFrame(NAME);
        menu = new JMenuBar();
        Box displayBox = new Box(3);
        window.setJMenuBar(menu);
        window.add(canvasPane);
        BLMain.addMenuHeading("File");
        PCDMenu.loadMenu();
        GDEMenu.loadMenu();
        GDEMakeMenus.loadMenu();
        BLMain.addMenuItem("Help", ABOUT_MENUITEM);
        BLMain.addMenuItem("File", EXIT_MENUITEM);
        for (PluginWrapper plugin : BLMain.getPlugins(DataCanvas.class)) {
            try {
                if (!plugin.isA(Component.class)) continue;
                DataCanvas currentCanvas = null;
                currentCanvas = (DataCanvas)plugin.create();
                if (currentCanvas != null) {
                    canvasPane.add(currentCanvas.getTabName(), (Component)((Object)currentCanvas));
                    if (currentCanvas.getTabName() != null && currentCanvas.getTabName().equalsIgnoreCase(BLMain.getProperty("default.canvas"))) {
                        canvasPane.setSelectedComponent((Component)((Object)currentCanvas));
                    }
                }
                for (File file : dataAdd) {
                    currentCanvas.readFile("", file);
                }
            }
            catch (Throwable th) {
                BLMain.error("error loading the plugin: " + plugin.getName(), "BLMain");
                th.printStackTrace();
            }
        }
        window.pack();
        window.setVisible(true);
        window.setLocationRelativeTo(null);
        window.setDefaultCloseOperation(2);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static String getProperty(String property) {
        return properties.getProperty(property);
    }

    public static DataCanvas getCanvas() throws BadLocationException {
        return (DataCanvas)((Object)canvasPane.getSelectedComponent());
    }

    public static JFrame getJFrame() {
        return window;
    }

    public static BLProperties getProperties() {
        return properties;
    }

    public static JMenu addMenuHeading(String name) {
        JMenu heading = menuHeadings.get(name);
        if (heading == null) {
            heading = new JMenu(name);
            if (name != null && name.length() >= 1 && (name.charAt(0) >= 'a' && name.charAt(0) <= 'z' || name.charAt(0) >= 'A' && name.charAt(0) <= 'Z')) {
                heading.setMnemonic(name.charAt(0));
            }
            menuHeadings.put(name, heading);
            menu.add(heading);
        }
        return heading;
    }

    public static JMenu addMenuHeading(int order, String name) {
        JMenu heading = BLMain.addMenuHeading(name);
        if (menu.getComponentIndex(heading) != order) {
            menu.remove(heading);
            menu.add((Component)heading, order);
        }
        return heading;
    }

    public static void addMenuItem(int location, String headingName, JMenuItem menuItem) {
        BLMain.addMenuHeading(headingName).insert(menuItem, location);
    }

    public static void addMenuItem(String headingName, JMenuItem menuItem) {
        BLMain.addMenuHeading(headingName).add(menuItem);
    }

    public static void aboutPopup() {
        JOptionPane.showMessageDialog(window, "BioLegato version 0.7.3\nby Graham Alvare and Brian Fristensky\nUniveristy of Manitoba 2008-2010", "About BioLegato", 3);
    }

    public static void addPropertiesListener(String key, PropertiesListener listener) {
        properties.addPropertiesListener(key, listener);
    }

    public static Process safeExecute(String cmd) {
        Process result = null;
        StringBuffer message = new StringBuffer();
        String[] execute = new String[]{cmd};
        if (properties.getProperty("shell.name") != null) {
            execute = properties.getProperty("shell.parameter") != null ? new String[]{properties.getProperty("shell.name"), properties.getProperty("shell.parameter"), cmd} : new String[]{properties.getProperty("shell.name"), cmd};
        }
        if (debug) {
            for (String parameter : execute) {
                message.append(parameter + " ");
            }
            BLMain.message(message.toString(), "safeExecute");
        }
        try {
            result = Runtime.getRuntime().exec(execute);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void shellCommand(String cmd, String data) {
        int result = -65535;
        final Process process = BLMain.safeExecute(cmd);
        if (process != null) {
            try {
                if (data != null) {
                    new OutputStreamWriter(process.getOutputStream()).write(data);
                }
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    public void run() {
                        String line = "";
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            while ((line = reader.readLine()) != null) {
                                System.err.println(line);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                if (debug) {
                    BLMain.message("BioLegato: Command executed successfully, returned: " + process.waitFor(), "shellCommand");
                } else {
                    process.waitFor();
                }
            }
            catch (Throwable e) {
                BLMain.error("BioLegato: error executing command: " + cmd, "shellCommand");
                e.printStackTrace();
            }
        }
    }

    public static void error(String message) {
        BLMain.error(message, null);
    }

    public static void error(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": ERROR --- " + message);
    }

    public static void warning(String message) {
        BLMain.warning(message, null);
    }

    public static void warning(String message, String location) {
        System.err.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": WARNING --- " + message);
    }

    public static void message(String message) {
        BLMain.message(message, null);
    }

    public static void message(String message, String location) {
        System.out.println(NAME + (location != null && !"".equals(location.trim()) ? " (" + location + ")" : "") + ": " + message);
    }

    public static String readStream(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer result = new StringBuffer();
        while (line != null) {
            result.append(line).append("\n");
            line = reader.readLine();
        }
        return result.toString();
    }

    public static boolean testNumber(char[] test) {
        boolean result = false;
        if (test != null && test.length > 0) {
            result = true;
            for (int count = 0; result && count < test.length; result &= Character.isDigit(test[count]), ++count) {
            }
        }
        return result;
    }

    public static String envreplace(String change) {
        int start = 0;
        int end = -1;
        String replace = null;
        String variable = "";
        if (change != null) {
            while ((start = change.indexOf(36, start)) >= start && start > -1) {
                for (end = start + 1; end < change.length() && (change.charAt(end) == '_' || Character.isLetter(change.charAt(end))); ++end) {
                }
                variable = change.substring(start + 1, end);
                replace = System.getenv(variable);
                if (variable.equalsIgnoreCase("BL_DIR")) {
                    replace = PROGRAM_DIR;
                }
                if (variable.equalsIgnoreCase("BL_HOME")) {
                    replace = replace == null || "".equals(replace.trim()) || !new File(replace).exists() ? CURRENT_DIR : new File(replace).getAbsolutePath();
                }
                if (replace != null) {
                    change = change.substring(0, start) + replace + change.substring(end);
                    continue;
                }
                ++start;
            }
        }
        return change;
    }

    public static final boolean notDigit(char test) {
        return !(test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z');
    }

    public static final boolean isDigit(char test) {
        return test >= '0' && test <= '9' || test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z';
    }

    public static File getCurrentPWD() {
        return currentPWD;
    }

    public static void setCurrentPWD(File newPWD) {
        currentPWD = newPWD;
    }

    public static Collection<PluginWrapper> getPlugins(Class<?> type) {
        return plugins.getPlugins(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ARCH {
        X86,
        AMD64,
        ALPHA,
        ARM,
        MIPS,
        SPARC,
        PPC,
        PPC64,
        UNKNOWN;


        public static ARCH detectARCH() {
            ARCH result = UNKNOWN;
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osArch.equals("sparc")) {
                result = SPARC;
            } else if (osArch.equals("arm")) {
                result = ARM;
            } else if (osArch.equals("alpha")) {
                result = ALPHA;
            } else if (osArch.equals("mips")) {
                result = MIPS;
            } else if (osArch.equals("amd64") || osArch.equals("x86_64")) {
                result = AMD64;
            } else if (osArch.equals("x86") || osArch.startsWith("i") && osArch.endsWith("86")) {
                result = X86;
            } else if (osArch.equals("ppc") || osArch.startsWith("power")) {
                result = !osArch.endsWith("64") ? PPC : PPC64;
            } else {
                BLMain.warning("Did not detect your system archetecture: " + System.getProperty("os.arch"));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        BSD,
        LINUX,
        HP_UX,
        MACOS,
        OSX,
        SOLARIS,
        WINDOWS_9X,
        WINDOWS_NT,
        UNIX;


        public boolean isWindows() {
            return this == WINDOWS_9X || this == WINDOWS_NT;
        }

        public boolean isUNIX() {
            return this != WINDOWS_9X && this != WINDOWS_NT;
        }

        public static OS detectOS() {
            OS result = UNIX;
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                result = WINDOWS_NT;
                if (osName.startsWith("windows 9") || osName.equals("windows me")) {
                    result = WINDOWS_9X;
                }
            } else if (osName.startsWith("solaris") || osName.startsWith("sunos")) {
                result = SOLARIS;
            } else if (osName.startsWith("linux")) {
                result = LINUX;
            } else if (osName.endsWith("bsd")) {
                result = BSD;
            } else if (osName.startsWith("hp-ux")) {
                result = HP_UX;
            } else if (osName.startsWith("mac os")) {
                result = MACOS;
            } else if (osName.startsWith("mac os x")) {
                result = OSX;
            } else {
                BLMain.warning("Did not detect your OS!  Defaulting to UNIX: " + System.getProperty("os.name") + "   version: " + System.getProperty("os.version"));
            }
            return result;
        }
    }
}

