/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.menu;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.menu.variables.EZChoiceList;
import org.biolegato.core.menu.variables.EZChooser;
import org.biolegato.core.menu.variables.EZComboBox;
import org.biolegato.core.menu.variables.EZCommandButton;
import org.biolegato.core.menu.variables.EZFileChooser;
import org.biolegato.core.menu.variables.EZSlider;
import org.biolegato.core.menu.variables.EZTempFile;
import org.biolegato.core.menu.variables.EZTextField;
import org.biolegato.core.menu.variables.EZVariable;
import org.biolegato.core.menu.variables.EZWidgetVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EZRunWindow {
    protected Map<String, Object> variableMapList;
    protected JDialog runWindow = null;
    protected HashMap<String, EZVariable> variableHash = new HashMap();
    private static final long serialVersionUID = 7526472295622777007L;

    public EZRunWindow(Map<String, Object> programData) {
        this.variableMapList = programData;
        int widgetCount = 0;
        int buttonCount = 0;
        boolean isDisplayWindow = false;
        String name = "";
        String type = null;
        EZVariable variable = null;
        EZCommandButton execute = null;
        Box variablePane = new Box(3);
        Box buttonPane = new Box(2);
        if (programData.containsKey("name")) {
            name = (String)programData.get("name");
        }
        for (Map.Entry<String, Object> e : this.variableMapList.entrySet()) {
            if (!(e.getValue() instanceof Map)) continue;
            Map data = (Map)e.getValue();
            if (data.containsKey("type")) {
                type = data.get("type").toString().trim().toLowerCase();
                if ("button".equals(type)) {
                    variable = execute = new EZCommandButton(this, data);
                    buttonPane.add(new JButton(execute));
                    ++buttonCount;
                } else {
                    if ("tempfile".equals(type)) {
                        variable = new EZTempFile(data);
                    } else {
                        if ("slider".equals(type)) {
                            variable = new EZSlider(data);
                        } else if ("choice_menu".equals(type)) {
                            variable = new EZComboBox(data);
                        } else if ("choice_list".equals(type)) {
                            BLMain.warning("Using deprecated menu widget \"choice_list\"");
                            variable = new EZChoiceList(data);
                        } else if ("chooser".equals(type)) {
                            variable = new EZChooser((Map<String, Object>)data);
                        } else if ("text".equals(type)) {
                            variable = new EZTextField(data);
                        } else if ("file_chooser".equals(type)) {
                            variable = new EZFileChooser(data);
                        }
                        variablePane.add((EZWidgetVariable)variable);
                        ++widgetCount;
                    }
                    this.variableHash.put(e.getKey().toLowerCase(), variable);
                }
            }
            if (variable != null) continue;
            BLMain.error("Invalid variable: " + type + " (check your plugin directory, properties file, and menu files for possible errors)", "EZRunWindow.createVariable");
        }
        if (widgetCount <= 0 && buttonCount <= 1 && execute != null) {
            new Thread(execute).start();
        } else {
            this.runWindow = new JDialog(BLMain.getJFrame(), "BioLegato: " + name, true);
            Object panel = null;
            Box windowPane = new Box(3);
            this.runWindow.setContentPane(new JScrollPane(windowPane));
            windowPane.add(variablePane);
            windowPane.add(buttonPane);
            this.runWindow.setMinimumSize(new Dimension(50, 50));
            this.runWindow.setSize(new Dimension(100, 100));
            this.runWindow.setLocationRelativeTo(BLMain.getJFrame());
            this.runWindow.setVisible(false);
            this.runWindow.pack();
            this.runWindow.setDefaultCloseOperation(2);
            this.runWindow.setVisible(true);
        }
    }

    public synchronized void closeWindow() {
        String search = "";
        Map current = null;
        if (this.runWindow != null) {
            this.runWindow.setVisible(false);
        }
        try {
            for (Map.Entry<String, EZVariable> key : this.variableHash.entrySet()) {
                if (key == null || !(key.getValue() instanceof EZWidgetVariable) || !this.variableMapList.containsKey(key.getKey()) || !(this.variableMapList.get(key.getKey()) instanceof Map)) continue;
                current = (Map)this.variableMapList.get(key.getKey());
                current.put("default", ((EZWidgetVariable)key.getValue()).getNewDefault());
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        if (this.runWindow != null) {
            this.runWindow.dispose();
        }
        this.runWindow = null;
    }

    public final EZVariable createVariable(Map data) {
        String type = null;
        EZVariable result = null;
        if (data.containsKey("type")) {
            type = data.get("type").toString().trim().toLowerCase();
            if ("slider".equals(type)) {
                result = new EZSlider(data);
            } else if ("choice_menu".equals(type)) {
                result = new EZComboBox(data);
            } else if ("choice_list".equals(type)) {
                BLMain.warning("Using deprecated menu widget \"choice_list\"");
                result = new EZChoiceList(data);
            } else if ("chooser".equals(type)) {
                result = new EZChooser((Map<String, Object>)data);
            } else if ("text".equals(type)) {
                result = new EZTextField(data);
            } else if ("tempfile".equals(type)) {
                result = new EZTempFile(data);
            } else if ("file_chooser".equals(type)) {
                result = new EZFileChooser(data);
            } else if ("button".equals(type)) {
                result = new EZCommandButton(this, data);
            }
        }
        if (result == null) {
            BLMain.error("Invalid variable type: " + type + " (check your plugin directory, properties file, and menu files for possible errors)", "EZRunWindow.createVariable");
        }
        return result;
    }

    public Map<String, EZVariable> getVariableHash() {
        return this.variableHash;
    }
}

