/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.menu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.main.OrderedHash;
import org.biolegato.core.menu.GDEMenuParser;

public class GDEMakeMenus {
    public static void loadMenu() {
        File menufile = null;
        String dirname = "";
        String basedir = "";
        File menulist = null;
        LinkedList<String> menulistArray = new LinkedList<String>();
        OrderedHash menu = new OrderedHash();
        BufferedReader reader = null;
        BufferedReader localreader = null;
        if (System.getenv("GDE_MAKEMENUS_DIR") != null) {
            String line;
            basedir = System.getenv("GDE_MAKEMENUS_DIR");
            menulistArray.add(basedir + File.separator + "menus");
            File localmenudirfile = new File(basedir + File.separator + "ldir.param");
            if (localmenudirfile.exists() && localmenudirfile.canRead() && localmenudirfile.isFile()) {
                try {
                    localreader = new BufferedReader(new FileReader(localmenudirfile));
                    while ((line = localreader.readLine()) != null) {
                        menulistArray.add(line);
                    }
                    localreader.close();
                    localreader = null;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (String string : menulistArray) {
                menulist = new File(string + File.separator + "menulist");
                if (!menulist.exists() || !menulist.canRead() || !menulist.isFile()) continue;
                try {
                    reader = new BufferedReader(new FileReader(menulist));
                    while ((line = reader.readLine()) != null) {
                        boolean possible = true;
                        if (line.length() <= 0 || line.trim().equals("") || line.startsWith("#")) continue;
                        if (Character.isWhitespace(line.charAt(0))) {
                            if ((line = line.trim()).indexOf(9) >= 0) {
                                char[] system = line.substring(line.indexOf(9) + 1).trim().toCharArray();
                                line = line.substring(0, line.indexOf(9));
                                if (system.length >= 0) {
                                    possible = false;
                                    for (char av : system) {
                                        if (!("solaris-sparc".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 'S' || "solaris-amd64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 's' || "linux-intel".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) && av == 'L') && (!"linux-x86_64".equalsIgnoreCase(System.getenv("BIRCH_PLATFORM")) || av != 'l')) continue;
                                        possible = true;
                                    }
                                    if (BLMain.debug) {
                                        BLMain.message("BIRCH Makemenus: " + line + "    " + new String(system) + "    " + System.getenv("BIRCH_PLATFORM") + "    " + (possible ? "loaded" : "NOT loaded"));
                                    }
                                }
                            }
                            if (!possible) continue;
                            menufile = new File(string + File.separatorChar + dirname + File.separatorChar + line + ".item");
                            if (menufile.exists() && menufile.isFile() && menufile.canRead()) {
                                ((OrderedHash)menu.get(dirname)).put(line, menufile);
                                continue;
                            }
                            BLMain.error("Cannot read menu item: " + menufile.getAbsolutePath() + "   " + menufile.exists() + "   " + menufile.isFile() + "   " + menufile.canRead(), "GDEMakeMenus plugin");
                            continue;
                        }
                        dirname = line;
                        if (menu.containsKey(dirname)) continue;
                        menu.put(dirname, new OrderedHash());
                    }
                    reader.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            for (Map.Entry entry : menu.entrySet()) {
                for (File file : ((OrderedHash)entry.getValue()).values()) {
                    GDEMenuParser.readGDEMenuFile((String)entry.getKey(), file);
                }
            }
        } else {
            BLMain.warning("GDE_MAKEMENUS_DIR not set!", "GDE Makemenus plugin");
        }
    }
}

