/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu;

import java.awt.Component;
import java.io.File;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.pcdmenu.widgets.Widget;

public class TempFile
implements Widget {
    String source = null;
    String dest = null;
    private File currentFile = null;
    private boolean input = false;
    private boolean output = false;
    private boolean save = false;
    private boolean overwrite = false;
    private String format = null;

    public TempFile(boolean input, boolean output, boolean save, boolean overwrite, String format) {
        this.input = input;
        this.output = output;
        this.save = save;
        this.overwrite = overwrite;
        this.format = format;
    }

    public Object getValue() {
        String result = "";
        String data = "";
        File location = new File(BLMain.envreplace(BLMain.getProperty("temp")));
        if (this.currentFile == null) {
            try {
                if (!location.exists() && !location.isDirectory()) {
                    location = new File(BLMain.CURRENT_DIR);
                }
                this.currentFile = File.createTempFile("bio", null, location);
                if (!this.save) {
                    this.currentFile.deleteOnExit();
                }
                if (this.input && this.format != null) {
                    BLMain.getCanvas().writeFile(this.format, this.currentFile);
                } else if (this.format == null) {
                    BLMain.error("Invalid file format", "GDETempFile");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (this.currentFile != null) {
            result = this.currentFile.getName();
        }
        return result != null && !"".equals(result.trim()) ? result : "nullfile";
    }

    public void close() {
        if (this.currentFile != null && this.currentFile.exists()) {
            if (this.output) {
                if (this.format != null) {
                    try {
                        BLMain.getCanvas().readFile(this.format, this.currentFile);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else {
                    BLMain.error("Invalid file format", "GDETempFile");
                }
            }
            if (!this.save) {
                this.currentFile.delete();
            }
        }
        this.currentFile = null;
    }

    public static String getType() {
        return "tempfile";
    }

    public Component display() {
        return null;
    }
}

