/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.midas.Constant;
import org.tigr.midas.display.AcknowlegementDialog;
import org.tigr.midas.display.AlertDialogPane;
import org.tigr.midas.display.FlowImagePane;
import org.tigr.midas.display.IconBar;
import org.tigr.midas.display.InformationPane;
import org.tigr.midas.display.MenuBar;
import org.tigr.midas.display.MessagePane;
import org.tigr.midas.display.Midas;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.display.ProfaceProjector;
import org.tigr.midas.display.ToolPane;
import org.tigr.midas.engine.Conductor;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.engine.ProjOpener;
import org.tigr.midas.engine.ProjRecorder;
import org.tigr.midas.engine.Project;
import org.tigr.midas.report.PdfFormatOptions;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.GBA;
import org.tigr.midas.util.MemObserver;
import org.tigr.midas.util.MidasProjFileFilter;
import org.tigr.midas.util.StringSplitter;

public class ActionManager {
    protected FlowImagePane flowImagePane;
    protected ParameterPane paramPane;
    protected MessagePane messgePane;
    private Vector paramPageVec;
    private Vector flowImageVec;
    private Vector flowVec;
    private Conductor conductor;
    private Project proj;
    private int procID = 0;
    private boolean ifBuildPdfReport;
    private boolean ifBuildTxtReport = true;
    EventListener eventListener = new EventListener();

    public ActionManager() {
        this.flowImagePane = new FlowImagePane();
        this.flowImageVec = new Vector();
        this.paramPane = new ParameterPane();
        this.paramPageVec = new Vector();
    }

    public void respondTo(JComponent component) {
        if (component instanceof IconBar) {
            IconBar iconBar = (IconBar)component;
            IconBar.blankButton.addActionListener(this.eventListener);
            IconBar.openProjButton.addActionListener(this.eventListener);
            IconBar.saveProjButton.addActionListener(this.eventListener);
            IconBar.stopButton.addActionListener(this.eventListener);
            IconBar.readFileButton.addActionListener(this.eventListener);
            IconBar.readPairButton.addActionListener(this.eventListener);
            IconBar.readFolderButton.addActionListener(this.eventListener);
            IconBar.totintButton.addActionListener(this.eventListener);
            IconBar.locfitButton.addActionListener(this.eventListener);
            IconBar.iterLinRegButton.addActionListener(this.eventListener);
            IconBar.iterLogMeanButton.addActionListener(this.eventListener);
            IconBar.ratioStatsButton.addActionListener(this.eventListener);
            IconBar.sdRegButton.addActionListener(this.eventListener);
            IconBar.filterButton.addActionListener(this.eventListener);
            IconBar.sliceAnalysisButton.addActionListener(this.eventListener);
            IconBar.inSlideReplicaButton.addActionListener(this.eventListener);
            IconBar.crossSlideReplicaButton.addActionListener(this.eventListener);
            IconBar.crossSlideTtestButton.addActionListener(this.eventListener);
            IconBar.crossSlideSAMButton.addActionListener(this.eventListener);
            IconBar.flipDyeButton.addActionListener(this.eventListener);
            IconBar.maanovaButton.addActionListener(this.eventListener);
            IconBar.writeButton.addActionListener(this.eventListener);
            IconBar.exeButton.addActionListener(this.eventListener);
        } else if (component instanceof MenuBar) {
            MenuBar menuBar = (MenuBar)component;
            MenuBar.newProjItem.addActionListener(this.eventListener);
            MenuBar.openProjItem.addActionListener(this.eventListener);
            MenuBar.saveProjItem.addActionListener(this.eventListener);
            MenuBar.stopProjItem.addActionListener(this.eventListener);
            MenuBar.exitItem.addActionListener(this.eventListener);
            MenuBar.readFileItem.addActionListener(this.eventListener);
            MenuBar.readPairItem.addActionListener(this.eventListener);
            MenuBar.readFolderItem.addActionListener(this.eventListener);
            MenuBar.totIntItem.addActionListener(this.eventListener);
            MenuBar.locFitItem.addActionListener(this.eventListener);
            MenuBar.iterLinRegItem.addActionListener(this.eventListener);
            MenuBar.iterLogMeanItem.addActionListener(this.eventListener);
            MenuBar.ratioStatsItem.addActionListener(this.eventListener);
            MenuBar.sdRegItem.addActionListener(this.eventListener);
            MenuBar.intFilterItem.addActionListener(this.eventListener);
            MenuBar.saItem.addActionListener(this.eventListener);
            MenuBar.inSlideRAItem.addActionListener(this.eventListener);
            MenuBar.crossSlideRAItem.addActionListener(this.eventListener);
            MenuBar.crossSlideTtestItem.addActionListener(this.eventListener);
            MenuBar.crossSlideSAMItem.addActionListener(this.eventListener);
            MenuBar.flipDyeItem.addActionListener(this.eventListener);
            MenuBar.maanovaItem.addActionListener(this.eventListener);
            MenuBar.writeItem.addActionListener(this.eventListener);
            MenuBar.setAllParamItem.addActionListener(this.eventListener);
            MenuBar.txtReportItem.addItemListener(this.eventListener);
            MenuBar.pdfReportItem.addItemListener(this.eventListener);
            MenuBar.aboutItem.addActionListener(this.eventListener);
            MenuBar.sysInfoItem.addActionListener(this.eventListener);
            MenuBar.acknowlegeItem.addActionListener(this.eventListener);
        }
    }

    private void blankButtonAction() {
        this.procID = 0;
        this.flowImagePane = new FlowImagePane();
        Parameter param = new Parameter();
        this.paramPane = new ParameterPane();
        this.paramPageVec = new Vector();
        this.changePage();
        this.buttonEnabler(0, true);
        this.buttonEnabler(1, true);
        this.buttonEnabler(2, true);
        this.buttonEnabler(12, false);
        this.buttonEnabler(11, false);
        this.buttonEnabler(15, false);
        this.buttonEnabler(14, false);
        this.buttonEnabler(16, false);
        this.buttonEnabler(13, false);
        this.buttonEnabler(10, false);
        this.buttonEnabler(20, false);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, false);
        this.buttonEnabler(8888, true);
        System.gc();
        MemObserver.mem("Work Flow just renewed");
    }

    private void saveButtonAction() {
        int returnVal;
        this.proj = new Project();
        this.proj.setFlow(this.flowImagePane.getFlowStr());
        JFileChooser saveChooser = new JFileChooser();
        saveChooser.setDialogTitle("Save MIDAS project");
        saveChooser.setFileFilter(new MidasProjFileFilter());
        if (this.proj.getProjFile() != null) {
            saveChooser.setCurrentDirectory(this.proj.getProjFile());
        }
        if ((returnVal = saveChooser.showSaveDialog(this.flowImagePane.getParent())) == 0) {
            this.proj.setProjFile(saveChooser.getSelectedFile());
            System.out.println("<==== Project file name: " + this.proj.getProjName() + " ====>");
            ProjRecorder projRecorder = new ProjRecorder(this.proj);
        }
    }

    private void openButtonAction() {
        block4: {
            int returnVal;
            this.flowImagePane = new FlowImagePane();
            JFileChooser openChooser = new JFileChooser();
            openChooser.setDialogTitle("Open MIDAS project");
            openChooser.setFileFilter(new MidasProjFileFilter());
            if (this.proj != null) {
                openChooser.setCurrentDirectory(new File(this.proj.getProjName()));
            }
            if ((returnVal = openChooser.showOpenDialog(this.flowImagePane.getParent())) != 0) break block4;
            File file = openChooser.getSelectedFile();
            this.proj = new Project();
            this.proj.setProjFile(file);
            this.proj.setFlow(this.flowImagePane.getFlowStr());
            try {
                System.out.println("Openning " + file.getAbsolutePath());
                ProjOpener projOpener = new ProjOpener(file);
                this.flowImagePane = projOpener.flowImagePane;
                this.paramPageVec = projOpener.getParamPageVec();
                this.procID = this.paramPageVec.size();
                this.loadPage(this.flowImagePane);
                this.buttonEnabler(0, false);
                this.buttonEnabler(1, false);
                this.buttonEnabler(2, false);
                this.buttonEnabler(12, false);
                this.buttonEnabler(11, false);
                this.buttonEnabler(15, false);
                this.buttonEnabler(14, false);
                this.buttonEnabler(16, false);
                this.buttonEnabler(13, false);
                this.buttonEnabler(10, false);
                this.buttonEnabler(20, false);
                this.buttonEnabler(30, false);
                this.buttonEnabler(31, false);
                this.buttonEnabler(32, false);
                this.buttonEnabler(33, false);
                this.buttonEnabler(40, false);
                this.buttonEnabler(41, false);
                this.buttonEnabler(100, false);
                this.buttonEnabler(8888, true);
            }
            catch (FileNotFoundException fnex) {
                AlertDialogPane aPane = new AlertDialogPane(1, "The project file you specified does not exisit ");
                fnex.printStackTrace();
            }
            catch (Exception ex) {
                AlertDialogPane aPane = new AlertDialogPane(1, "The project file that you are trying to open is either corrupted or created by \na different version of MIDAS, thus might not be loaded correctly ");
                ex.printStackTrace();
            }
        }
    }

    private void readFileButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.readFileImage), this.procID);
        this.paramPane = new ParameterPane(0);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, true);
        this.buttonEnabler(11, true);
        this.buttonEnabler(15, true);
        this.buttonEnabler(14, true);
        this.buttonEnabler(16, true);
        this.buttonEnabler(13, true);
        this.buttonEnabler(10, true);
        this.buttonEnabler(20, true);
        this.buttonEnabler(30, true);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void readPairButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.readPairImage), this.procID);
        this.paramPane = new ParameterPane(1);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, true);
        this.buttonEnabler(11, true);
        this.buttonEnabler(15, true);
        this.buttonEnabler(14, true);
        this.buttonEnabler(16, true);
        this.buttonEnabler(13, true);
        this.buttonEnabler(10, true);
        this.buttonEnabler(20, true);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, true);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, false);
        ++this.procID;
    }

    private void readFolderButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.readFolderImage), this.procID);
        this.paramPane = new ParameterPane(2);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, true);
        this.buttonEnabler(11, true);
        this.buttonEnabler(15, true);
        this.buttonEnabler(14, true);
        this.buttonEnabler(16, true);
        this.buttonEnabler(13, true);
        this.buttonEnabler(10, true);
        this.buttonEnabler(20, true);
        this.buttonEnabler(30, true);
        this.buttonEnabler(31, true);
        this.buttonEnabler(32, true);
        this.buttonEnabler(33, true);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, true);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void totintButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.totintImage), this.procID);
        this.paramPane = new ParameterPane(12);
        this.changePage();
        this.buttonEnabler(12, false);
        ++this.procID;
    }

    private void locfitButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.locfitImage), this.procID);
        this.paramPane = new ParameterPane(11);
        this.changePage();
        this.buttonEnabler(11, false);
        ++this.procID;
    }

    private void iterLinRegButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLinRegImage), this.procID);
        this.paramPane = new ParameterPane(15);
        this.changePage();
        this.buttonEnabler(15, false);
        this.buttonEnabler(41, false);
        ++this.procID;
    }

    private void iterLogMeanButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.iterLogMeanImage), this.procID);
        this.paramPane = new ParameterPane(14);
        this.changePage();
        this.buttonEnabler(14, false);
        ++this.procID;
    }

    private void ratioStatsButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.ratioStatsImage), this.procID);
        this.paramPane = new ParameterPane(16);
        this.changePage();
        this.buttonEnabler(16, false);
        ++this.procID;
    }

    private void sdRegButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.sdRegImage), this.procID);
        this.paramPane = new ParameterPane(13);
        this.changePage();
        this.buttonEnabler(13, false);
        ++this.procID;
    }

    private void filterButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.filterImage), this.procID);
        this.paramPane = new ParameterPane(10);
        this.changePage();
        this.buttonEnabler(10, false);
        ++this.procID;
    }

    private void sliceAnalysisButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.sliceAnalysisImage), this.procID);
        this.paramPane = new ParameterPane(20);
        this.changePage();
        this.buttonEnabler(20, false);
        this.buttonEnabler(41, false);
        ++this.procID;
    }

    private void inSlideRAButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.inSlideReplicaImage), this.procID);
        this.paramPane = new ParameterPane(30);
        this.changePage();
        this.buttonEnabler(30, false);
        this.buttonEnabler(41, false);
        ++this.procID;
    }

    private void crossSlideRAButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.crossSlideReplicaImage), this.procID);
        this.paramPane = new ParameterPane(31);
        this.changePage();
        this.buttonEnabler(31, false);
        this.buttonEnabler(41, false);
        ++this.procID;
    }

    private void crossSlideTtestButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.crossSlideTtestImage), this.procID);
        this.paramPane = new ParameterPane(32);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, false);
        this.buttonEnabler(11, false);
        this.buttonEnabler(15, false);
        this.buttonEnabler(14, false);
        this.buttonEnabler(16, false);
        this.buttonEnabler(13, false);
        this.buttonEnabler(10, true);
        this.buttonEnabler(20, true);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void crossSlideSAMButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.crossSlideSAMImage), this.procID);
        this.paramPane = new ParameterPane(33);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, false);
        this.buttonEnabler(11, false);
        this.buttonEnabler(15, false);
        this.buttonEnabler(14, false);
        this.buttonEnabler(16, false);
        this.buttonEnabler(13, false);
        this.buttonEnabler(10, true);
        this.buttonEnabler(20, true);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void flipDyeButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.flipDyeImage), this.procID);
        this.paramPane = new ParameterPane(40);
        this.changePage();
        this.buttonEnabler(40, false);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void maanovaButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.maanovaImage), this.procID);
        this.paramPane = new ParameterPane(41);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, false);
        this.buttonEnabler(11, false);
        this.buttonEnabler(15, false);
        this.buttonEnabler(14, false);
        this.buttonEnabler(16, false);
        this.buttonEnabler(13, false);
        this.buttonEnabler(10, false);
        this.buttonEnabler(20, false);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(41, false);
        this.buttonEnabler(100, true);
        ++this.procID;
    }

    private void writeButtonAction() {
        this.flowImagePane.addImage(new ImageIcon(IconBar.writeImage), this.procID);
        this.paramPane = new ParameterPane(100);
        this.changePage();
        this.buttonEnabler(0, false);
        this.buttonEnabler(1, false);
        this.buttonEnabler(2, false);
        this.buttonEnabler(12, false);
        this.buttonEnabler(11, false);
        this.buttonEnabler(15, false);
        this.buttonEnabler(14, false);
        this.buttonEnabler(16, false);
        this.buttonEnabler(13, false);
        this.buttonEnabler(10, false);
        this.buttonEnabler(20, false);
        this.buttonEnabler(30, false);
        this.buttonEnabler(31, false);
        this.buttonEnabler(32, false);
        this.buttonEnabler(33, false);
        this.buttonEnabler(40, false);
        this.buttonEnabler(100, false);
        this.buttonEnabler(8888, true);
        ++this.procID;
    }

    private void exeButtonAction() {
        if (this.proj == null) {
            this.proj = new Project();
        }
        this.proj.setFlow(this.flowImagePane.getFlowStr());
        this.proj.setPdfReportOption(this.ifBuildPdfReport);
        this.proj.setTxtReportOption(this.ifBuildTxtReport);
        if (this.paramCheck()) {
            int returnVal;
            if (this.ifBuildPdfReport) {
                PdfFormatOptions format = new PdfFormatOptions(this.proj);
            }
            JFileChooser saveChooser = new JFileChooser();
            saveChooser.setFileFilter(new MidasProjFileFilter());
            saveChooser.setDialogTitle("Save MIDAS project");
            if (this.proj != null) {
                saveChooser.setCurrentDirectory(this.proj.getProjFile());
            }
            if ((returnVal = saveChooser.showSaveDialog(this.flowImagePane.getParent())) == 0) {
                this.proj.setProjFile(saveChooser.getSelectedFile());
                ProjRecorder projRecorder = new ProjRecorder(this.proj);
                String finalLocationMsg = "MIDAS will store all the processed data, graph data, and reports \nunder your project folder -- " + this.proj.getProjPath();
                AlertDialogPane aPane = new AlertDialogPane(0, finalLocationMsg);
                this.conductor = new Conductor(this.proj);
                this.conductor.conduct();
            }
        }
    }

    private void stopButtonAction() {
    }

    private void setParamButtonAction() {
        StringSplitter st = new StringSplitter(this.flowImagePane.getFlowStr(), '>');
        Vector<String> flowVec = new Vector<String>();
        while (st.hasMoreTokens()) {
            flowVec.add(st.nextToken());
        }
        if (flowVec.size() > 0) {
            GBA gba = new GBA();
            JDialog allParamPane = new JDialog();
            allParamPane.setModal(true);
            allParamPane.setTitle("Set All Parameters");
            allParamPane.getContentPane().setLayout(new GridBagLayout());
            int i = 0;
            while (i < flowVec.size()) {
                JPanel titledParamPane = new JPanel();
                titledParamPane.setLayout(new GridBagLayout());
                JLabel paramTitleLabel = new JLabel();
                int currentCall = Integer.parseInt(flowVec.elementAt(i).toString());
                if (currentCall == 0) {
                    paramTitleLabel.setText("Read single file                  ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 1) {
                    paramTitleLabel.setText("Read file pair(s)                 ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 2) {
                    paramTitleLabel.setText("Read directory                   ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 12) {
                    paramTitleLabel.setText("Total intensity normalization    ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 11) {
                    paramTitleLabel.setText("Lowess(Locfit) normalization      ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 15) {
                    paramTitleLabel.setText("Iterative Linear Regression       ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 14) {
                    paramTitleLabel.setText("Iterative Log Mean Centering      ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 16) {
                    paramTitleLabel.setText("Ratio Statistics                  ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 13) {
                    paramTitleLabel.setText("Standard Deviation Regularization ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 10) {
                    paramTitleLabel.setText("Low intensity filter              ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 20) {
                    paramTitleLabel.setText("Z-score filtering (Slice Analysis)");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 30) {
                    paramTitleLabel.setText("In-slide replicates analysis      ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 31) {
                    paramTitleLabel.setText("Cross-slide replicates analysis   ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 32) {
                    paramTitleLabel.setText("Cross-slide replicates ttest      ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 33) {
                    paramTitleLabel.setText("Cross-slide one class SAM      ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 40) {
                    paramTitleLabel.setText("Flip dye consistency checking     ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 41) {
                    paramTitleLabel.setText("MAANOVA                           ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                } else if (currentCall == 100) {
                    paramTitleLabel.setText("Write outputs                     ");
                    gba.add(titledParamPane, paramTitleLabel, 1, 0, 1, 1, 0, 0, 0, 17, 0, 0, 0, 0);
                    gba.add(titledParamPane, (ParameterPane)this.paramPageVec.elementAt(i), 1, 1, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
                }
                gba.add(allParamPane.getContentPane(), titledParamPane, i, 0, 1, 1, 1, 1, 1, 10, 1, 1, 1, 1);
                ++i;
            }
            allParamPane.pack();
            allParamPane.setVisible(true);
        } else {
            AlertDialogPane alertDialogPane = new AlertDialogPane(0, "No analysis module has been specified yet ");
        }
    }

    private void buttonEnabler(int whichButn, boolean b) {
        switch (whichButn) {
            case 0: {
                IconBar.readFileButton.setEnabled(b);
                MenuBar.readFileItem.setEnabled(b);
                break;
            }
            case 1: {
                IconBar.readPairButton.setEnabled(b);
                MenuBar.readPairItem.setEnabled(b);
                break;
            }
            case 2: {
                IconBar.readFolderButton.setEnabled(b);
                MenuBar.readFolderItem.setEnabled(b);
                break;
            }
            case 12: {
                IconBar.totintButton.setEnabled(b);
                MenuBar.totIntItem.setEnabled(b);
                break;
            }
            case 11: {
                IconBar.locfitButton.setEnabled(b);
                MenuBar.locFitItem.setEnabled(b);
                break;
            }
            case 15: {
                IconBar.iterLinRegButton.setEnabled(b);
                MenuBar.iterLinRegItem.setEnabled(b);
                break;
            }
            case 14: {
                IconBar.iterLogMeanButton.setEnabled(b);
                MenuBar.iterLogMeanItem.setEnabled(b);
                break;
            }
            case 13: {
                IconBar.sdRegButton.setEnabled(b);
                MenuBar.sdRegItem.setEnabled(b);
                break;
            }
            case 16: {
                IconBar.ratioStatsButton.setEnabled(b);
                MenuBar.ratioStatsItem.setEnabled(b);
                break;
            }
            case 10: {
                IconBar.filterButton.setEnabled(b);
                MenuBar.intFilterItem.setEnabled(b);
                break;
            }
            case 20: {
                IconBar.sliceAnalysisButton.setEnabled(b);
                MenuBar.saItem.setEnabled(b);
                break;
            }
            case 30: {
                IconBar.inSlideReplicaButton.setEnabled(b);
                MenuBar.inSlideRAItem.setEnabled(b);
                break;
            }
            case 31: {
                IconBar.crossSlideReplicaButton.setEnabled(b);
                MenuBar.crossSlideRAItem.setEnabled(b);
                break;
            }
            case 32: {
                IconBar.crossSlideTtestButton.setEnabled(b);
                MenuBar.crossSlideTtestItem.setEnabled(b);
                break;
            }
            case 33: {
                IconBar.crossSlideSAMButton.setEnabled(b);
                MenuBar.crossSlideSAMItem.setEnabled(b);
                break;
            }
            case 40: {
                IconBar.flipDyeButton.setEnabled(b);
                MenuBar.flipDyeItem.setEnabled(b);
                break;
            }
            case 41: {
                IconBar.maanovaButton.setEnabled(b);
                MenuBar.maanovaItem.setEnabled(b);
                break;
            }
            case 100: {
                IconBar.writeButton.setEnabled(b);
                MenuBar.writeItem.setEnabled(b);
                IconBar.exeButton.setEnabled(b);
                break;
            }
            case 8888: {
                IconBar.exeButton.setEnabled(b);
            }
        }
    }

    public void changePage() {
        Midas.flowImageHolderPane.pasteImagePane(this.flowImagePane);
        Midas.paramHolderPane.pasteParameterPane(this.paramPane);
        this.flowImageVec = this.flowImagePane.getAddedButtonVec();
        this.paramPageVec.add(this.procID, this.paramPane);
        int flowImageNdx = 0;
        while (flowImageNdx < this.flowImagePane.getAddedButtonVec().size()) {
            this.flowImagePane.getAddedButtonAt(flowImageNdx).addActionListener(this.eventListener);
            ++flowImageNdx;
        }
    }

    public void loadPage(FlowImagePane target) {
        Midas.flowImageHolderPane.pasteImagePane(target);
        this.flowImageVec = target.getAddedButtonVec();
        this.procID = this.paramPageVec.size();
        int flowImageNdx = 0;
        while (flowImageNdx < this.flowImagePane.getAddedButtonVec().size()) {
            this.flowImagePane.getAddedButtonAt(flowImageNdx).addActionListener(this.eventListener);
            ++flowImageNdx;
        }
    }

    private boolean paramCheck() {
        StringSplitter st = new StringSplitter(this.flowImagePane.getFlowStr(), '>');
        this.flowVec = new Vector();
        while (st.hasMoreTokens()) {
            this.flowVec.add(st.nextToken());
        }
        boolean b = true;
        int step = 0;
        block1: while (step < this.flowVec.size()) {
            int currentCall = Integer.parseInt(this.flowVec.elementAt(step).toString());
            if (currentCall == 0) {
                if (Parameter.pSingleFileStr.startsWith("Please specify")) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "No input data file(s) specified yet ");
                    b = false;
                    break;
                }
                if (Parameter.pCh1BkgdOpt ^ Parameter.pCh2BkgdOpt) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 ");
                    b = false;
                    break;
                }
            } else if (currentCall == 1) {
                if (Parameter.pFilePairVec.size() == 0) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "No input data file(s) specified yet ");
                    b = false;
                    break;
                }
                if (Parameter.pCh1BkgdOpt ^ Parameter.pCh2BkgdOpt) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 ");
                    b = false;
                    break;
                }
            } else if (currentCall == 2) {
                if (Parameter.pFolderStr.startsWith("Please specify") || Parameter.pFolderFilesVec.size() == 0) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "No input data file(s) specified yet ");
                    b = false;
                    break;
                }
                if (Parameter.pCh1BkgdOpt ^ Parameter.pCh2BkgdOpt) {
                    AlertDialogPane aPane = new AlertDialogPane(1, "Please specify background columns for both Cy3 and Cy5 ");
                    b = false;
                    break;
                }
            } else if (currentCall != 12) {
                if (currentCall == 11) {
                    if ((double)Parameter.pSmoothParaVal > 1.0) {
                        AlertDialogPane aPane = new AlertDialogPane(1, "Lowess smooth parameter must be less than or equal to 1.0 ");
                        b = false;
                        break;
                    }
                } else if (currentCall != 15 && currentCall != 14) {
                    if (currentCall == 16) {
                        if (Parameter.pRatioStatsCIChkOpt && Parameter.pRatioStatsCIVal < 0) {
                            AlertDialogPane aPane = new AlertDialogPane(1, "Please specify Ratio Confidence Interval range ");
                            b = false;
                            break;
                        }
                    } else if (currentCall != 13 && currentCall != 10) {
                        if (currentCall == 20) {
                            if ((double)Parameter.pSliceDataRangeGtVal == -1.0 && (double)Parameter.pSliceDataRangeLtVal == -1.0) {
                                AlertDialogPane aPane = new AlertDialogPane(1, "Neither \"Data Keep Range >\" nor \"Data Keep Range <\" in Slice Analysis has been set ");
                                b = false;
                                break;
                            }
                            if (Parameter.pSliceDataRangeLtVal >= 0.0f && Parameter.pSliceDataRangeGtVal >= 0.0f && Parameter.pSliceDataRangeLtVal < Parameter.pSliceDataRangeGtVal) {
                                AlertDialogPane aPane = new AlertDialogPane(1, "\"Data Keep range <\" cannot be less than \"Data Keep range >\" ");
                                b = false;
                                break;
                            }
                            if (Parameter.pSliceDataRangeLtVal == Parameter.pSliceDataRangeGtVal) {
                                AlertDialogPane aPane = new AlertDialogPane(1, "\"Data Keep range <\" cannot be equal to \"Data Keep range >\" ");
                                b = false;
                                break;
                            }
                        } else if (currentCall != 30 && currentCall != 31) {
                            if (currentCall == 32) {
                                if (Parameter.pTtestPValBase == 320 && Parameter.pGroupFilesVec.size() > 29) {
                                    AlertDialogPane aPane = new AlertDialogPane(1, "All possible unique permutation number is too high. \nTry to compute p-value based on T-statistics \n or specify a permutation number ");
                                    b = false;
                                    break;
                                }
                            } else if (currentCall != 33 && currentCall != 40) {
                                if (currentCall == 41) {
                                    int selectNdx = 0;
                                    while (selectNdx < MaAnovaParameter.elistSize) {
                                        String s = MaAnovaParameter.GetFile(selectNdx);
                                        s = s.substring(0, s.lastIndexOf(46));
                                        boolean not_found = true;
                                        int fileNdx = 0;
                                        while (fileNdx < Parameter.pFolderFilesVec.size()) {
                                            String ss = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                                            if ((ss = ss.substring(ss.lastIndexOf(FileBrowser.fsep) + 1, ss.lastIndexOf(46))).equalsIgnoreCase(s)) {
                                                not_found = false;
                                                break;
                                            }
                                            ++fileNdx;
                                        }
                                        if (not_found) {
                                            AlertDialogPane aPane = new AlertDialogPane(1, "Files selected in MAANOVA must also be selected as input files ");
                                            b = false;
                                            break block1;
                                        }
                                        ++selectNdx;
                                    }
                                } else if (currentCall == 100 && Parameter.pUseCrossFileTrimOpt && Parameter.pCrossFilePct > 1.0f) {
                                    AlertDialogPane aPane = new AlertDialogPane(1, "Cross file trim percentage should be less than or equal to 1.0 ");
                                    b = false;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            ++step;
        }
        return b;
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup = new JPopupMenu();

        PopupListener() {
            this.popup.setBackground(new Color(255, 200, 200));
            JMenuItem menuItem = new JMenuItem("Delete");
            menuItem.setFont(Constant.font);
            menuItem.setBackground(new Color(255, 200, 200));
            this.popup.add(menuItem);
            this.popup.add(menuItem);
        }

        public void mousePressed(MouseEvent e) {
            this.popup.setVisible(true);
            if (e.getButton() == 3) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.popup.setVisible(false);
        }

        private void showPopup(MouseEvent e) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class EventListener
    implements ActionListener,
    ItemListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == IconBar.blankButton || source == MenuBar.newProjItem) {
                ActionManager.this.blankButtonAction();
            } else if (source == IconBar.saveProjButton || source == MenuBar.saveProjItem) {
                ActionManager.this.saveButtonAction();
            } else if (source == IconBar.openProjButton || source == MenuBar.openProjItem) {
                ActionManager.this.openButtonAction();
            } else if (source != IconBar.stopButton) {
                if (source == MenuBar.exitItem) {
                    Midas.frame.dispose();
                } else if (source == IconBar.readFileButton || source == MenuBar.readFileItem) {
                    ActionManager.this.readFileButtonAction();
                } else if (source == IconBar.readPairButton || source == MenuBar.readPairItem) {
                    ActionManager.this.readPairButtonAction();
                } else if (source == IconBar.readFolderButton || source == MenuBar.readFolderItem) {
                    ActionManager.this.readFolderButtonAction();
                } else if (source == IconBar.totintButton || source == MenuBar.totIntItem) {
                    ActionManager.this.totintButtonAction();
                } else if (source == IconBar.locfitButton || source == MenuBar.locFitItem) {
                    ActionManager.this.locfitButtonAction();
                } else if (source == IconBar.iterLinRegButton || source == MenuBar.iterLinRegItem) {
                    ActionManager.this.iterLinRegButtonAction();
                } else if (source == IconBar.iterLogMeanButton || source == MenuBar.iterLogMeanItem) {
                    ActionManager.this.iterLogMeanButtonAction();
                } else if (source == IconBar.sdRegButton || source == MenuBar.sdRegItem) {
                    ActionManager.this.sdRegButtonAction();
                } else if (source == IconBar.filterButton || source == MenuBar.intFilterItem) {
                    ActionManager.this.filterButtonAction();
                } else if (source == IconBar.ratioStatsButton || source == MenuBar.ratioStatsItem) {
                    ActionManager.this.ratioStatsButtonAction();
                } else if (source == IconBar.sliceAnalysisButton || source == MenuBar.saItem) {
                    ActionManager.this.sliceAnalysisButtonAction();
                } else if (source == IconBar.inSlideReplicaButton || source == MenuBar.inSlideRAItem) {
                    ActionManager.this.inSlideRAButtonAction();
                } else if (source != IconBar.crossSlideReplicaButton && source != MenuBar.crossSlideRAItem) {
                    if (source == IconBar.crossSlideTtestButton || source == MenuBar.crossSlideTtestItem) {
                        ActionManager.this.crossSlideTtestButtonAction();
                    } else if (source == IconBar.crossSlideSAMButton || source == MenuBar.crossSlideSAMItem) {
                        ActionManager.this.crossSlideSAMButtonAction();
                    } else if (source == IconBar.flipDyeButton || source == MenuBar.flipDyeItem) {
                        ActionManager.this.flipDyeButtonAction();
                    } else if (source == IconBar.maanovaButton || source == MenuBar.maanovaItem) {
                        ActionManager.this.maanovaButtonAction();
                    } else if (source == IconBar.writeButton || source == MenuBar.writeItem) {
                        ActionManager.this.writeButtonAction();
                    } else if (source == IconBar.exeButton) {
                        ActionManager.this.exeButtonAction();
                    } else if (source == ToolPane.setParamButton || source == MenuBar.setAllParamItem) {
                        ActionManager.this.setParamButtonAction();
                    } else if (source != MenuBar.pdfReportItem) {
                        if (source == MenuBar.aboutItem) {
                            if (!ProfaceProjector.faceOn) {
                                Midas.showAbout(false);
                            } else {
                                Midas.projector.showFace();
                            }
                        } else if (source == MenuBar.sysInfoItem) {
                            int width = 640;
                            int height = 550;
                            InformationPane infoPane = new InformationPane();
                            JFrame frame = new JFrame("System Information");
                            frame.getContentPane().add(infoPane);
                            frame.setSize(width, height);
                            Dimension screenSize = frame.getToolkit().getScreenSize();
                            frame.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
                            frame.setResizable(false);
                            frame.setVisible(true);
                            infoPane.Start();
                        } else if (source == MenuBar.acknowlegeItem) {
                            AcknowlegementDialog d = new AcknowlegementDialog((Frame)Midas.frame, AcknowlegementDialog.createAcknowlegementText());
                        } else {
                            PopupListener popupListener = new PopupListener();
                            int i = 0;
                            while (i < ActionManager.this.procID) {
                                if (source == ActionManager.this.flowImagePane.getAddedButtonAt(i)) {
                                    Midas.paramHolderPane.pasteParameterPane((ParameterPane)ActionManager.this.paramPageVec.elementAt(i));
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent event) {
            Object source = event.getSource();
            if (source == MenuBar.pdfReportItem) {
                ActionManager.this.ifBuildPdfReport = event.getStateChange() == 1;
            } else if (source == MenuBar.txtReportItem) {
                ActionManager.this.ifBuildTxtReport = event.getStateChange() == 1;
            }
        }
    }
}

