/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.midas.Constant;
import org.tigr.midas.display.FileBrowserPane;
import org.tigr.midas.display.IconData;

class FileNode {
    protected File m_file;

    public FileNode(File file) {
        this.m_file = file;
    }

    public File getFile() {
        return this.m_file;
    }

    public String toString() {
        return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
    }

    public boolean expand(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
        if (flag == null) {
            return false;
        }
        Object obj = flag.getUserObject();
        if (!(obj instanceof Boolean)) {
            return false;
        }
        parent.removeAllChildren();
        File[] files = this.listFiles();
        if (files == null) {
            return true;
        }
        Vector<FileNode> u = new Vector<FileNode>();
        Vector<FileNode> v = new Vector<FileNode>();
        int k = 0;
        while (k < files.length) {
            File f = files[k];
            FileNode newNode = new FileNode(f);
            boolean isAdded = false;
            if (!f.isDirectory()) {
                String[] exts = new String[]{"ity", "lty", "dis", "prc", "rrc", "box", "dis"};
                int j = 0;
                while (j < exts.length) {
                    if (f.getAbsolutePath().endsWith(exts[j])) {
                        u.addElement(newNode);
                        break;
                    }
                    ++j;
                }
            } else {
                int i = 0;
                while (i < v.size()) {
                    FileNode nd = (FileNode)v.elementAt(i);
                    if (newNode.compareTo(nd) < 0) {
                        v.insertElementAt(newNode, i);
                        isAdded = true;
                        break;
                    }
                    ++i;
                }
                if (!isAdded) {
                    v.addElement(newNode);
                }
            }
            ++k;
        }
        int i = 0;
        while (i < u.size()) {
            FileNode nd = (FileNode)u.elementAt(i);
            IconData idata = new IconData(Constant.ICON_GRAPHFILE, Constant.ICON_EXPANDEDFOLDER, nd);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
            parent.add(node);
            ++i;
        }
        int i2 = 0;
        while (i2 < v.size()) {
            FileNode nd = (FileNode)v.elementAt(i2);
            IconData idata = new IconData(Constant.ICON_FOLDER, Constant.ICON_EXPANDEDFOLDER, nd);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
            parent.add(node);
            node.add(new DefaultMutableTreeNode(new Boolean(true)));
            ++i2;
        }
        return true;
    }

    public boolean hasSubDirs() {
        File[] files = this.listFiles();
        if (files == null) {
            return false;
        }
        int k = 0;
        while (k < files.length) {
            if (files[k].isDirectory()) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public int compareTo(FileNode toCompare) {
        return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
    }

    protected File[] listFiles() {
        if (!this.m_file.isDirectory()) {
            return null;
        }
        try {
            return this.m_file.listFiles();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
            return null;
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("FileBroswerPane Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        FileBrowserPane rPane = new FileBrowserPane();
        frame.getContentPane().add(rPane);
        frame.pack();
        frame.setVisible(true);
    }
}

