/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.display;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.tigr.midas.display.MidasDesignFrame;

public class MidasDesktop
extends JFrame
implements ActionListener {
    public static final String version = "2.19";
    JDesktopPane desktop;

    public MidasDesktop() {
        super("TIGR MIDAS version 2.19");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.desktop = new JDesktopPane();
        this.createDesignFrame();
        this.setContentPane(this.desktop);
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu anaMenu = new JMenu("Design");
        anaMenu.setMnemonic(65);
        menuBar.add(anaMenu);
        JMenuItem designMenuItem = new JMenuItem("New Design");
        designMenuItem.setMnemonic(78);
        designMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        designMenuItem.setActionCommand("new design");
        designMenuItem.addActionListener(this);
        anaMenu.add(designMenuItem);
        designMenuItem = new JMenuItem("Quit");
        designMenuItem.setMnemonic(81);
        designMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        designMenuItem.setActionCommand("quit");
        designMenuItem.addActionListener(this);
        anaMenu.add(designMenuItem);
        JMenu invMenu = new JMenu("Investigation");
        invMenu.setMnemonic(73);
        menuBar.add(invMenu);
        JMenuItem invMenuItem = new JMenuItem("New Investigation");
        invMenuItem.setMnemonic(78);
        invMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        invMenuItem.setActionCommand("new investigation");
        invMenuItem.addActionListener(this);
        invMenu.add(invMenuItem);
        JMenu aboutMenu = new JMenu("About");
        aboutMenu.setMnemonic(66);
        menuBar.add(aboutMenu);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        if ("new design".equals(e.getActionCommand())) {
            this.createDesignFrame();
        } else if (!"new investigation".equals(e.getActionCommand())) {
            this.quit();
        }
    }

    protected void createDesignFrame() {
        MidasDesignFrame frame = new MidasDesignFrame();
        frame.setVisible(true);
        this.desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {}
    }

    protected void quit() {
        System.exit(0);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        MidasDesktop frame = new MidasDesktop();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MidasDesktop.createAndShowGUI();
            }
        });
    }
}

