/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.exception.BkgdInfoMissingException;
import org.tigr.midas.exception.EmptyPairListException;
import org.tigr.midas.exception.UnevenSizePairException;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class FileOpener
extends Module {
    private ColumnWorker fileCW;
    private ColumnWorker[][] pairsCW;
    private ColumnWorker[] folderCW;
    public static String badFileName = "";

    public FileOpener(int type) throws NumberFormatException, FileNotFoundException, BkgdInfoMissingException, EmptyPairListException, UnevenSizePairException, OutOfMemoryError, Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String f = projFolderFB.createSubDir("raw");
        switch (type) {
            case 0: {
                this.fileCW = new ColumnWorker(Parameter.pSingleFileStr);
                try {
                    this.fileCW.setColumnsForUID();
                    this.fileCW.setColumnsForMeta(2, 3);
                }
                catch (FileNotFoundException nfex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw nfex;
                }
                catch (NumberFormatException nex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw nex;
                }
                catch (OutOfMemoryError memex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw memex;
                }
                catch (Exception ex) {
                    throw ex;
                }
                if (Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                    try {
                        this.fileCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1, Parameter.pUseCh2FlagCol - 1);
                        if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                            this.fileCW.allowOneBadChannel();
                        } else {
                            this.fileCW.KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        this.fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
                    }
                    catch (FileNotFoundException nfex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nfex;
                    }
                    catch (NumberFormatException nex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nex;
                    }
                    catch (OutOfMemoryError memex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw memex;
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                }
                if (Parameter.pUseCh1FlagOpt && !Parameter.pUseCh2FlagOpt) {
                    try {
                        this.fileCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1);
                        if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                            this.fileCW.allowOneBadChannel();
                        } else {
                            this.fileCW.KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        this.fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
                    }
                    catch (FileNotFoundException nfex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nfex;
                    }
                    catch (NumberFormatException nex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nex;
                    }
                    catch (OutOfMemoryError memex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw memex;
                    }
                    catch (Exception ex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw ex;
                    }
                }
                if (!Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                    try {
                        this.fileCW.setColumns(6, 7, Parameter.pUseCh2FlagCol - 1);
                        if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                            this.fileCW.allowOneBadChannel();
                        } else {
                            this.fileCW.KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        this.fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
                    }
                    catch (FileNotFoundException nfex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nfex;
                    }
                    catch (NumberFormatException nex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nex;
                    }
                    catch (OutOfMemoryError memex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw memex;
                    }
                    catch (Exception ex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw ex;
                    }
                }
                try {
                    this.fileCW.setColumns(6, 7);
                    if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                        this.fileCW.allowOneBadChannel();
                    } else {
                        this.fileCW.KeepTwoColumnsAddFlags(1L, 1L);
                    }
                    this.fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
                }
                catch (FileNotFoundException nfex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw nfex;
                }
                catch (NumberFormatException nex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw nex;
                }
                catch (OutOfMemoryError memex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw memex;
                }
                catch (Exception ex) {
                    badFileName = Parameter.pSingleFileStr;
                    throw ex;
                }
                if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                    try {
                        this.fileCW.setColumnsForTwoBkgd(Parameter.pCh1BkgdCol - 1, Parameter.pCh2BkgdCol - 1, Parameter.pBkgdSNRatioVal);
                    }
                    catch (FileNotFoundException nfex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nfex;
                    }
                    catch (NumberFormatException nex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw nex;
                    }
                    catch (Exception ex) {
                        badFileName = Parameter.pSingleFileStr;
                        throw ex;
                    }
                } else {
                    if (!Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                        throw new BkgdInfoMissingException();
                    }
                    if (Parameter.pCh1BkgdOpt && !Parameter.pCh2BkgdOpt) {
                        throw new BkgdInfoMissingException();
                    }
                }
                String ityName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.fileCW.getFileName() + "_raw.ity";
                String ltyName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.fileCW.getFileName() + "_raw.lty";
                String prcName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.fileCW.getFileName() + "_raw.prc";
                String hisName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.fileCW.getFileName() + "_raw.his";
                String boxName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.fileCW.getFileName() + "_raw_block.box";
                DataPrep dataPrep = new DataPrep(this.fileCW);
                DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
                dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
                dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("identity", new Integer(0));
                hash.put(CodeBook.lookup(99901), ityName);
                hash.put(CodeBook.lookup(99902), ltyName);
                hash.put(CodeBook.lookup(99903), prcName);
                hash.put(CodeBook.lookup(99904), hisName);
                hash.put(CodeBook.lookup(99905), boxName);
                hash.put("experiment data file:                  ", this.fileCW.getFileNameWithExtension());
                hash.put("total data count:                      ", new Integer(this.fileCW.getRowCounts()));
                hash.put("post-preliminary filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
                String[] moduleNotes = new String[]{"experiment data file:                  ", "total data count:                      ", "post-preliminary filtering data count: "};
                hash.put("module_notes", moduleNotes);
                Module.proj.insertReportItem("raw_for_" + this.fileCW.getFileName(), hash);
                break;
            }
            case 1: {
                this.pairsCW = new ColumnWorker[Parameter.pFilePairVec.size()][2];
                if (this.pairsCW.length == 0) {
                    throw new EmptyPairListException();
                }
                int pairIndex = 0;
                while (pairIndex < Parameter.pFilePairVec.size()) {
                    Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairIndex);
                    String fileName1 = eachPairVec.elementAt(0).toString();
                    String fileName2 = eachPairVec.elementAt(1).toString();
                    System.out.println("    fileName1 = " + fileName1 + "\n    fileName2 = " + fileName2);
                    ColumnWorker fileOneCW = new ColumnWorker(fileName1);
                    ColumnWorker fileTwoCW = new ColumnWorker(fileName2);
                    if (Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                        try {
                            fileOneCW.setColumnsForUID();
                            fileTwoCW.setColumnsForUID();
                            fileOneCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1, Parameter.pUseCh2FlagCol - 1);
                            fileTwoCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1, Parameter.pUseCh2FlagCol - 1);
                            fileOneCW.setColumnsForMeta(2, 3);
                            fileTwoCW.setColumnsForMeta(2, 3);
                            fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                            fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                fileOneCW.allowOneBadChannel();
                                fileTwoCW.allowOneBadChannel();
                            } else {
                                fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                                fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            }
                            fileOneCW.computeGoodRatiosAndLogRatios(1L, 1L);
                            fileTwoCW.computeGoodRatiosAndLogRatios(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw ex;
                        }
                    }
                    if (Parameter.pUseCh1FlagOpt && !Parameter.pUseCh2FlagOpt) {
                        try {
                            fileOneCW.setColumnsForUID();
                            fileTwoCW.setColumnsForUID();
                            fileOneCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1);
                            fileTwoCW.setColumns(6, 7, Parameter.pUseCh1FlagCol - 1);
                            fileOneCW.setColumnsForMeta(2, 3);
                            fileTwoCW.setColumnsForMeta(2, 3);
                            fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                            fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                fileOneCW.allowOneBadChannel();
                                fileTwoCW.allowOneBadChannel();
                            } else {
                                fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                                fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            }
                            fileOneCW.computeGoodRatiosAndLogRatios(1L, 1L);
                            fileTwoCW.computeGoodRatiosAndLogRatios(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw ex;
                        }
                    }
                    if (!Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                        try {
                            fileOneCW.setColumnsForUID();
                            fileTwoCW.setColumnsForUID();
                            fileOneCW.setColumns(6, 7, Parameter.pUseCh2FlagCol - 1);
                            fileTwoCW.setColumns(6, 7, Parameter.pUseCh2FlagCol - 1);
                            fileOneCW.setColumnsForMeta(2, 3);
                            fileTwoCW.setColumnsForMeta(2, 3);
                            fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                            fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                fileOneCW.allowOneBadChannel();
                                fileTwoCW.allowOneBadChannel();
                            } else {
                                fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                                fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                            }
                            fileOneCW.computeGoodRatiosAndLogRatios(1L, 1L);
                            fileTwoCW.computeGoodRatiosAndLogRatios(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw ex;
                        }
                    }
                    try {
                        fileOneCW.setColumnsForUID();
                        fileTwoCW.setColumnsForUID();
                        fileOneCW.setColumns(6, 7);
                        fileTwoCW.setColumns(6, 7);
                        fileOneCW.setColumnsForMeta(2, 3);
                        fileTwoCW.setColumnsForMeta(2, 3);
                        fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                        fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                        if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                            fileOneCW.allowOneBadChannel();
                            fileTwoCW.allowOneBadChannel();
                        } else {
                            fileOneCW.KeepTwoColumnsAddFlags(1L, 1L);
                            fileTwoCW.KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        fileOneCW.computeGoodRatiosAndLogRatios(1L, 1L);
                        fileTwoCW.computeGoodRatiosAndLogRatios(1L, 1L);
                    }
                    catch (FileNotFoundException nfex) {
                        badFileName = fileName1 + " or " + fileName2;
                        throw nfex;
                    }
                    catch (NumberFormatException nex) {
                        badFileName = fileName1 + " or " + fileName2;
                        throw nex;
                    }
                    catch (OutOfMemoryError memex) {
                        badFileName = fileName1 + " or " + fileName2;
                        throw memex;
                    }
                    catch (Exception ex) {
                        badFileName = fileName1 + " or " + fileName2;
                        throw ex;
                    }
                    if (fileOneCW.getRowCounts() != fileTwoCW.getRowCounts()) {
                        badFileName = fileName1 + " and " + fileName2;
                        throw new UnevenSizePairException();
                    }
                    if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                        try {
                            fileOneCW.setColumnsForTwoBkgd(Parameter.pCh1BkgdCol - 1, Parameter.pCh2BkgdCol - 1, Parameter.pBkgdSNRatioVal);
                            fileTwoCW.setColumnsForTwoBkgd(Parameter.pCh1BkgdCol - 1, Parameter.pCh2BkgdCol - 1, Parameter.pBkgdSNRatioVal);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw nex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName1 + " or " + fileName2;
                            throw ex;
                        }
                    } else {
                        if (!Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            throw new BkgdInfoMissingException();
                        }
                        if (Parameter.pCh1BkgdOpt && !Parameter.pCh2BkgdOpt) {
                            throw new BkgdInfoMissingException();
                        }
                    }
                    this.pairsCW[pairIndex][0] = fileOneCW;
                    this.pairsCW[pairIndex][1] = fileTwoCW;
                    String ityName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileOneCW.getFileName() + "_raw.ity";
                    String ltyName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileOneCW.getFileName() + "_raw.lty";
                    String prcName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileOneCW.getFileName() + "_raw.prc";
                    String hisName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileOneCW.getFileName() + "_raw.his";
                    String boxName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileOneCW.getFileName() + "_raw_block.box";
                    DataPrep dataPrep = new DataPrep(fileOneCW);
                    DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
                    dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
                    dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    hash.put("identity", new Integer(1));
                    hash.put(CodeBook.lookup(99901), ityName);
                    hash.put(CodeBook.lookup(99902), ltyName);
                    hash.put(CodeBook.lookup(99903), prcName);
                    hash.put(CodeBook.lookup(99904), hisName);
                    hash.put(CodeBook.lookup(99905), boxName);
                    hash.put("experiment data file:                  ", fileOneCW.getFileNameWithExtension());
                    hash.put("total data count:                      ", new Integer(fileOneCW.getRowCounts()));
                    hash.put("post-preliminary filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
                    String[] moduleNotesOne = new String[]{"experiment data file:                  ", "total data count:                      ", "post-preliminary filtering data count: "};
                    hash.put("module_notes", moduleNotesOne);
                    Module.proj.insertReportItem("raw_for_" + fileOneCW.getFileName(), hash);
                    ityName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileTwoCW.getFileName() + "_raw.ity";
                    ltyName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileTwoCW.getFileName() + "_raw.lty";
                    prcName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileTwoCW.getFileName() + "_raw.prc";
                    hisName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileTwoCW.getFileName() + "_raw.his";
                    boxName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + fileTwoCW.getFileName() + "_raw_block.box";
                    dataPrep = new DataPrep(fileTwoCW);
                    dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
                    dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
                    dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
                    hash = new Hashtable();
                    hash.put("identity", new Integer(1));
                    hash.put(CodeBook.lookup(99901), ityName);
                    hash.put(CodeBook.lookup(99902), ltyName);
                    hash.put(CodeBook.lookup(99903), prcName);
                    hash.put(CodeBook.lookup(99904), hisName);
                    hash.put(CodeBook.lookup(99905), boxName);
                    hash.put("experiment data file:                  ", fileTwoCW.getFileNameWithExtension());
                    hash.put("total data count:                      ", new Integer(fileTwoCW.getRowCounts()));
                    hash.put("post-preliminary filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
                    String[] moduleNotesTwo = new String[]{"experiment data file:                  ", "total data count:                      ", "post-preliminary filtering data count: "};
                    hash.put("module_notes", moduleNotesTwo);
                    Module.proj.insertReportItem("raw_for_" + fileTwoCW.getFileName(), hash);
                    ++pairIndex;
                }
                break;
            }
            case 2: {
                Vector<String> inputFilesNameVec;
                if (Parameter.pGroupFilesVec.size() > 0) {
                    inputFilesNameVec = Parameter.pGroupFilesVec;
                } else if (MaAnovaParameter.elistSize > 0) {
                    Vector<String> vec = new Vector<String>();
                    int selectNdx = 0;
                    while (selectNdx < MaAnovaParameter.elistSize) {
                        vec.addElement(Parameter.pFolderStr + FileBrowser.fsep + MaAnovaParameter.GetFile(selectNdx));
                        ++selectNdx;
                    }
                    Parameter.pFolderFilesVec = inputFilesNameVec = vec;
                } else {
                    inputFilesNameVec = Parameter.pFolderFilesVec;
                }
                this.folderCW = new ColumnWorker[inputFilesNameVec.size()];
                int fileIndex = 0;
                while (fileIndex < inputFilesNameVec.size()) {
                    String fileName = inputFilesNameVec.elementAt(fileIndex).toString();
                    System.out.println("    fileName = " + fileName);
                    this.folderCW[fileIndex] = new ColumnWorker(fileName);
                    if (Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                        try {
                            this.folderCW[fileIndex].setColumnsForUID();
                            this.folderCW[fileIndex].setColumnsForMeta(2, 3);
                            this.folderCW[fileIndex].setColumns(6, 7, Parameter.pUseCh1FlagCol - 1, Parameter.pUseCh2FlagCol - 1);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                this.folderCW[fileIndex].allowOneBadChannel();
                            }
                            this.folderCW[fileIndex].KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName;
                            throw ex;
                        }
                    } else if (Parameter.pUseCh1FlagOpt && !Parameter.pUseCh2FlagOpt) {
                        try {
                            this.folderCW[fileIndex].setColumnsForUID();
                            this.folderCW[fileIndex].setColumnsForMeta(2, 3);
                            this.folderCW[fileIndex].setColumns(6, 7, Parameter.pUseCh1FlagCol - 1);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                this.folderCW[fileIndex].allowOneBadChannel();
                            }
                            this.folderCW[fileIndex].KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName;
                            throw ex;
                        }
                    } else if (!Parameter.pUseCh1FlagOpt && Parameter.pUseCh2FlagOpt) {
                        try {
                            this.folderCW[fileIndex].setColumnsForUID();
                            this.folderCW[fileIndex].setColumnsForMeta(2, 3);
                            this.folderCW[fileIndex].setColumns(6, 7, Parameter.pUseCh2FlagCol - 1);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                this.folderCW[fileIndex].allowOneBadChannel();
                            }
                            this.folderCW[fileIndex].KeepTwoColumnsAddFlags(1L, 1L);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName;
                            throw ex;
                        }
                    } else {
                        try {
                            this.folderCW[fileIndex].setColumnsForUID();
                            this.folderCW[fileIndex].setColumnsForMeta(2, 3);
                            this.folderCW[fileIndex].setColumns(6, 7);
                            if (Parameter.pOneBadChannelPolicyStr.equalsIgnoreCase("Generous")) {
                                this.folderCW[fileIndex].allowOneBadChannel();
                            } else {
                                this.folderCW[fileIndex].KeepTwoColumnsAddFlags(1L, 1L);
                            }
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName;
                            throw nex;
                        }
                        catch (OutOfMemoryError memex) {
                            badFileName = fileName;
                            throw memex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName;
                            throw ex;
                        }
                    }
                    if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                        try {
                            this.folderCW[fileIndex].setColumnsForTwoBkgd(Parameter.pCh1BkgdCol - 1, Parameter.pCh2BkgdCol - 1, Parameter.pBkgdSNRatioVal);
                        }
                        catch (FileNotFoundException nfex) {
                            badFileName = fileName;
                            throw nfex;
                        }
                        catch (NumberFormatException nex) {
                            badFileName = fileName;
                            throw nex;
                        }
                        catch (Exception ex) {
                            badFileName = fileName;
                            throw ex;
                        }
                    } else {
                        if (!Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
                            throw new BkgdInfoMissingException();
                        }
                        if (Parameter.pCh1BkgdOpt && !Parameter.pCh2BkgdOpt) {
                            throw new BkgdInfoMissingException();
                        }
                    }
                    String ityName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.folderCW[fileIndex].getFileName() + "_raw.ity";
                    String ltyName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.folderCW[fileIndex].getFileName() + "_raw.lty";
                    String prcName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.folderCW[fileIndex].getFileName() + "_raw.prc";
                    String hisName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.folderCW[fileIndex].getFileName() + "_raw.his";
                    String boxName = Module.proj.getProjPath() + "raw" + FileBrowser.fsep + this.folderCW[fileIndex].getFileName() + "_raw_block.box";
                    DataPrep dataPrep = new DataPrep(this.folderCW[fileIndex]);
                    DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
                    dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
                    dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    hash.put("identity", new Integer(2));
                    hash.put(CodeBook.lookup(99901), ityName);
                    hash.put(CodeBook.lookup(99902), ltyName);
                    hash.put(CodeBook.lookup(99903), prcName);
                    hash.put(CodeBook.lookup(99904), hisName);
                    hash.put(CodeBook.lookup(99905), boxName);
                    hash.put("experiment data file:                  ", this.folderCW[fileIndex].getFileNameWithExtension());
                    hash.put("total data count:                      ", new Integer(this.folderCW[fileIndex].getRowCounts()));
                    hash.put("post-preliminary filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
                    String[] moduleNotess = new String[]{"experiment data file:                  ", "total data count:                      ", "post-preliminary filtering data count: "};
                    hash.put("module_notes", moduleNotess);
                    Module.proj.insertReportItem("raw_for_" + this.folderCW[fileIndex].getFileName(), hash);
                    ++fileIndex;
                }
                break;
            }
        }
    }

    public final ColumnWorker getFileCW() {
        return this.fileCW;
    }

    public final ColumnWorker[][] getPairsCW() {
        return this.pairsCW;
    }

    public final ColumnWorker[] getFolderCW() {
        return this.folderCW;
    }
}

