/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.BlockFiller;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.NegateFlags;

public class IterativeLinReg
extends Module {
    private ColumnWorker fCW;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] logCy3;
    private float[] logCy5;
    private boolean[] inputFlag;
    private float slope;
    private float intercept;
    private String linearEquation;
    private String[] linearEquations;
    private float r2;
    private float[] r2s;
    private int m;
    private int[] ms;

    /*
     * Unable to fully structure code
     */
    public IterativeLinReg(ColumnWorker fileCW, float nSD, String processMode, String ref) throws Exception {
        block30: {
            block29: {
                super();
                this.m = 0;
                projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
                iterLinRegFB = projFolderFB.createSubDir("iter_linear_regression");
                this.fCW = fileCW;
                this.cy3Column = this.fCW.getColumnOneArray();
                this.cy5Column = this.fCW.getColumnTwoArray();
                totalRowCount = this.fCW.getRowCounts();
                tempFlag = this.fCW.getRowFlagArray();
                this.inputFlag = new boolean[tempFlag.length];
                System.arraycopy(tempFlag, 0, this.inputFlag, 0, tempFlag.length);
                iterLogFlag = new boolean[fileCW.getRowCounts()];
                iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
                iterLogFlag = new AndFlags(iterLogFlag, this.inputFlag).getAndFlag();
                s = new StatsTools();
                if (!processMode.equalsIgnoreCase("block")) break block29;
                blockFiller = new BlockFiller(fileCW);
                totalRowCount = this.fCW.getRowCounts();
                blockNumber = blockFiller.getBlockNumber();
                this.linearEquations = new String[blockNumber];
                this.r2s = new float[blockNumber];
                this.ms = new int[blockNumber];
                blockCount = 0;
                while (blockCount < blockNumber) {
                    blockCy3Column = blockFiller.getBlockCy3(blockCount);
                    blockCy5Column = blockFiller.getBlockCy5(blockCount);
                    blockRawNdx = blockFiller.getOrigIndex(blockCount);
                    blockSize = blockFiller.getBlockSize(blockCount);
                    System.out.println("    ============================");
                    System.out.println("              Block " + blockCount);
                    System.out.println("    ============================");
                    residue = new float[blockSize];
                    lastR2 = 1.0f;
                    this.r2 = 0.0f;
                    this.slope = 0.0f;
                    this.intercept = 0.0f;
                    residueCount = 0;
                    this.m = 0;
                    block3: while (true) {
                        if ((double)Math.abs(lastR2 - this.r2) <= 0.001) {
                            System.out.println("    *********************************");
                            this.linearEquations[blockCount] = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                            this.r2s[blockCount] = this.r2;
                            this.ms[blockCount] = this.m;
                            System.out.println("    Block final linear equation: " + this.linearEquations[blockCount]);
                            break;
                        }
                        if (this.m > 100) {
                            System.out.println("    *********************************");
                            System.out.println("    Maximum iteration number 100 reached! ");
                            this.linearEquations[blockCount] = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                            this.r2s[blockCount] = this.r2;
                            this.ms[blockCount] = this.m;
                            System.out.println("    Block final linear equation: " + this.linearEquations[blockCount]);
                            break;
                        }
                        if (this.m > 0) {
                            System.out.println("    residueCount        = " + residueCount);
                        }
                        lastR2 = this.r2;
                        ++this.m;
                        cyTran = new CyToLogProdRatio(blockCy3Column, blockCy5Column, blockRawNdx, iterLogFlag);
                        logCy3 = cyTran.getLogX();
                        logCy5 = cyTran.getLogY();
                        s.linearRegression(logCy3, logCy5);
                        this.slope = s.getSlope();
                        this.intercept = s.getIntercept();
                        this.r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                        System.out.println("    ------ iteration " + this.m + " ------");
                        System.out.println("    Datasize            = " + s.getDataSize());
                        System.out.println("    Slope               = " + this.slope);
                        System.out.println("    Intercept           = " + this.intercept);
                        System.out.println("    Corr.Coeff^2        = " + this.r2);
                        ndx = 0;
                        while (ndx < blockSize) {
                            residue[ndx] = blockCy3Column[ndx] > 1.0f && blockCy5Column[ndx] > 1.0f && iterLogFlag[blockRawNdx[ndx]] != false ? Math.abs(MathTools.log10(blockCy5Column[ndx]) - (MathTools.log10(blockCy3Column[ndx]) * this.slope + this.intercept)) : 0.0f;
                            ++ndx;
                        }
                        s.computeMeanSDforNonZero(residue);
                        residueCount = 0;
                        ndx = 0;
                        while (true) {
                            if (ndx >= blockSize) continue block3;
                            if (iterLogFlag[blockRawNdx[ndx]] & Math.abs(residue[ndx]) < s.getXSD() * nSD) {
                                iterLogFlag[blockRawNdx[ndx]] = true;
                                ++residueCount;
                            } else {
                                iterLogFlag[blockRawNdx[ndx]] = false;
                            }
                            ++ndx;
                        }
                        break;
                    }
                    if (ref.equalsIgnoreCase("Cy3")) {
                        ndx = 0;
                        while (ndx < blockSize) {
                            if (blockCy3Column[ndx] != 0.0f && blockCy5Column[ndx] != 0.0f && this.inputFlag[blockRawNdx[ndx]]) {
                                this.cy5Column[blockRawNdx[ndx]] = (float)Math.pow(10.0, (MathTools.log10(this.cy5Column[blockRawNdx[ndx]]) - this.intercept) / this.slope);
                            }
                            ++ndx;
                        }
                    } else {
                        ndx = 0;
                        while (ndx < blockSize) {
                            if (blockCy3Column[ndx] != 0.0f && blockCy5Column[ndx] != 0.0f && this.inputFlag[blockRawNdx[ndx]]) {
                                blockCy3Column[ndx] = (float)Math.pow(10.0, MathTools.log10(blockCy3Column[ndx]) * this.slope + this.intercept);
                                this.cy3Column[blockRawNdx[ndx]] = (float)Math.pow(10.0, MathTools.log10(this.cy3Column[blockRawNdx[ndx]]) * this.slope + this.intercept);
                            }
                            ++ndx;
                        }
                    }
                    ++blockCount;
                }
                break block30;
            }
            residue = new float[totalRowCount];
            lastR2 = 1.0f;
            this.r2 = 0.0f;
            this.slope = 0.0f;
            this.intercept = 0.0f;
            residueCount = 0;
            block8: while (true) lbl-1000:
            // 3 sources

            {
                block31: {
                    if ((double)Math.abs(lastR2 - this.r2) <= 0.001) {
                        this.linearEquation = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                        System.out.println("    *********************************");
                        System.out.println("    Final linear equation: " + this.linearEquation);
                        break;
                    }
                    if (this.m > 100) {
                        this.linearEquation = "log(cy5) = log(cy3) * " + this.slope + " + " + this.intercept;
                        System.out.println("    *********************************");
                        System.out.println("    Maximum iteration number 100 reached! ");
                        System.out.println("    Final linear equation: " + this.linearEquation);
                        break;
                    }
                    if (this.m > 0) {
                        System.out.println("    residueCount        = " + residueCount);
                    }
                    lastR2 = this.r2;
                    ++this.m;
                    cyTran = new CyToLogProdRatio(this.cy3Column, this.cy5Column, iterLogFlag);
                    logCy3 = cyTran.getLogX();
                    logCy5 = cyTran.getLogY();
                    s.linearRegression(logCy3, logCy5);
                    this.slope = s.getSlope();
                    this.intercept = s.getIntercept();
                    this.r2 = s.getCorrelationCoeff() * s.getCorrelationCoeff();
                    System.out.println("    ------ iteration " + this.m + " ------");
                    System.out.println("    Datasize            = " + s.getDataSize());
                    System.out.println("    Slope               = " + this.slope);
                    System.out.println("    Intercept           = " + this.intercept);
                    System.out.println("    Corr.Coeff^2        = " + this.r2);
                    rawNdx = 0;
                    while (rawNdx < totalRowCount) {
                        residue[rawNdx] = this.cy3Column[rawNdx] > 1.0f && this.cy5Column[rawNdx] > 1.0f && iterLogFlag[rawNdx] != false ? Math.abs(MathTools.log10(this.cy5Column[rawNdx]) - (MathTools.log10(this.cy3Column[rawNdx]) * this.slope + this.intercept)) : 0.0f;
                        ++rawNdx;
                    }
                    s.computeMeanSDforNonZero(residue);
                    residueCount = 0;
                    rawNdx = 0;
                    while (rawNdx < totalRowCount) {
                        if (iterLogFlag[rawNdx] & Math.abs(residue[rawNdx]) < s.getXSD() * nSD) {
                            iterLogFlag[rawNdx] = true;
                            ++residueCount;
                        } else {
                            iterLogFlag[rawNdx] = false;
                        }
                        ++rawNdx;
                    }
                    if (!Parameter.pRefStr.equalsIgnoreCase("Cy3")) break block31;
                    rawNdx = 0;
                    while (true) {
                        if (rawNdx >= totalRowCount) ** GOTO lbl-1000
                        if (this.cy3Column[rawNdx] != 0.0f && this.cy5Column[rawNdx] != 0.0f && this.inputFlag[rawNdx]) {
                            this.cy5Column[rawNdx] = (float)Math.pow(10.0, (MathTools.log10(this.cy5Column[rawNdx]) - this.intercept) / this.slope);
                        }
                        ++rawNdx;
                    }
                }
                rawNdx = 0;
                while (true) {
                    if (rawNdx >= totalRowCount) continue block8;
                    if (this.cy3Column[rawNdx] != 0.0f && this.cy5Column[rawNdx] != 0.0f && this.inputFlag[rawNdx]) {
                        this.cy3Column[rawNdx] = (float)Math.pow(10.0, MathTools.log10(this.cy3Column[rawNdx]) * this.slope + this.intercept);
                    }
                    ++rawNdx;
                }
                break;
            }
        }
        this.fCW.setColOneArray(this.cy3Column);
        this.fCW.setColTwoArray(this.cy5Column);
        ityName = Module.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_iterLinReg.ity";
        ltyName = Module.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_iterLinReg.lty";
        prcName = Module.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_iterLinReg.prc";
        hisName = Module.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_iterLinReg.his";
        boxName = Module.proj.getProjPath() + "iter_linear_regression" + FileBrowser.fsep + fileCW.getFileName() + "_iterLinReg_block.box";
        dataPrep = new DataPrep(fileCW);
        dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
        dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
        dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
        hash = new Hashtable<String, Object>();
        hash.put("identity", new Integer(15));
        hash.put(CodeBook.lookup(99901), ityName);
        hash.put(CodeBook.lookup(99902), ltyName);
        hash.put(CodeBook.lookup(99903), prcName);
        hash.put(CodeBook.lookup(99904), hisName);
        hash.put(CodeBook.lookup(99905), boxName);
        hash.put("experiment data file: ", fileCW.getFileNameWithExtension());
        hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
        moduleNotes = new String[]{"experiment data file: ", "processed data count: "};
        hash.put("module_notes", moduleNotes);
        Module.proj.insertReportItem("iterLinReg_for_" + fileCW.getFileName(), hash);
    }

    public final ColumnWorker getIterLinRegColumnWorker() {
        return this.fCW;
    }

    public final String getLinearEquation() {
        return this.linearEquation;
    }

    public final String[] getLinearEquations() {
        return this.linearEquations;
    }

    public final float getCorrCoeff() {
        return this.r2;
    }

    public final float[] getCorrCoeffs() {
        return this.r2s;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            IterativeLinReg iterLinReg = new IterativeLinReg(fileCW, 2.0f, "block", "Cy3");
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

