/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Lowess;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.ArrayResizer;
import org.tigr.midas.util.BlockFiller;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;

public class Locfit
extends Module {
    private boolean PRINT_PRC = true;
    private int nonZeroCount;
    private int zeroCount;
    private float[] cy3Column;
    private float[] cy5Column;
    private float[] wholeLogRatio;
    private float[] wholeLogProd;
    private float[] nonZeroLogRatio;
    private float[] nonZeroLogProd;
    private float[] newNonZeroLogRatio;
    private float[] sortedLogProd;
    private float[] locfittedLogRatio;
    private float[] scaledLogRatio;
    private float[] blockLogRatioMean;
    private float[] blockLogRatioSD;
    private float[] blockLogRatioFactor;
    private int[] blockRawNdx;
    private int[] nonZeroRawIdx;
    private int[] zeroRawIdx;
    private int[] newNonZeroRawIdx;
    private float[] assembledLogProd;
    private float[] assembledRawLogRatio;
    private float[] assembledLogRatio;
    private float[] assembledLocfit;
    private int[] assembledRawNdx;
    private String[] blockSummary;
    private float[] sortedAssembledLogProd;
    private float[] sortedAssembledRawLogRatio;
    private float[] sortedAssembledLogRatio;
    private float[] sortedAssembledLocfit;
    private int[] sortedAssembledRawNdx;
    private ColumnWorker fCW;

    public Locfit(ColumnWorker fileCW, float smoothParam, String processMode, String ref) throws Exception {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String locfitFB = projFolderFB.createSubDir("lowess");
        this.fCW = fileCW;
        boolean[] tempFlag = fileCW.getRowFlagArray();
        boolean[] inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);
        boolean[] locfitFlag = new boolean[fileCW.getRowCounts()];
        if (processMode.equalsIgnoreCase("block")) {
            BlockFiller blockFiller = new BlockFiller(fileCW);
            int totalRowCount = this.fCW.getRowCounts();
            this.assembledLogProd = new float[totalRowCount];
            this.assembledRawLogRatio = new float[totalRowCount];
            this.assembledLogRatio = new float[totalRowCount];
            this.assembledLocfit = new float[totalRowCount];
            this.assembledRawNdx = new int[totalRowCount];
            this.blockSummary = new String[totalRowCount];
            this.blockLogRatioMean = new float[blockFiller.getBlockNumber()];
            this.blockLogRatioSD = new float[blockFiller.getBlockNumber()];
            this.blockLogRatioFactor = new float[blockFiller.getBlockNumber()];
            int assembleCount = 0;
            int blockCount = 0;
            while (blockCount < blockFiller.getBlockNumber()) {
                this.cy3Column = blockFiller.getBlockCy3(blockCount);
                this.cy5Column = blockFiller.getBlockCy5(blockCount);
                int[] rawNdx = blockFiller.getOrigIndex(blockCount);
                System.out.println("    ============================");
                System.out.println("              Block " + blockCount);
                System.out.println("    ============================");
                System.out.println("    PreLocfitting ...");
                this.preLocfit();
                System.out.println("    Sorting ...");
                QSort sort = new QSort(this.nonZeroLogProd);
                this.sortedLogProd = sort.getSorted();
                int[] bb = sort.getOrigIndx();
                this.newNonZeroLogRatio = new float[this.sortedLogProd.length];
                this.newNonZeroRawIdx = new int[this.sortedLogProd.length];
                int i = 0;
                while (i < this.sortedLogProd.length) {
                    this.newNonZeroLogRatio[i] = this.nonZeroLogRatio[bb[i]];
                    this.newNonZeroRawIdx[i] = this.nonZeroRawIdx[bb[i]];
                    ++i;
                }
                System.out.println("    Locfitting ...");
                Lowess lowess = new Lowess(this.sortedLogProd, this.newNonZeroLogRatio, smoothParam);
                this.locfittedLogRatio = lowess.getYEst();
                System.out.println("    Outputing ... ");
                this.scaledLogRatio = new float[this.sortedLogProd.length];
                this.blockRawNdx = new int[this.sortedLogProd.length];
                int i2 = 0;
                while (i2 < this.sortedLogProd.length) {
                    this.scaledLogRatio[i2] = this.newNonZeroLogRatio[i2] - this.locfittedLogRatio[i2];
                    this.blockRawNdx[i2] = rawNdx[this.nonZeroRawIdx[bb[i2]]];
                    this.assembledLogProd[assembleCount] = this.sortedLogProd[i2];
                    this.assembledRawLogRatio[assembleCount] = this.newNonZeroLogRatio[i2];
                    this.assembledLogRatio[assembleCount] = this.scaledLogRatio[i2];
                    this.assembledLocfit[assembleCount] = this.locfittedLogRatio[i2];
                    this.assembledRawNdx[assembleCount] = rawNdx[this.nonZeroRawIdx[bb[i2]]];
                    ++assembleCount;
                    ++i2;
                }
                StatsTools s = new StatsTools();
                s.computeMeanSD(this.scaledLogRatio);
                this.blockLogRatioMean[blockCount] = s.getXMean();
                this.blockLogRatioSD[blockCount] = s.getXSD();
                this.blockSummary[blockCount] = "    ----> Block#:           " + blockCount + "\n    ----> Total Spot#:      " + blockFiller.getBlockSize(blockCount) + "\n    ----> Processed Spot#:  " + this.sortedLogProd.length + "\n    ----> log-ratio-mean = " + this.blockLogRatioMean[blockCount] + "\n    ----> log-ratio-SD = " + this.blockLogRatioSD[blockCount];
                System.out.println("    Block Summary:");
                System.out.println(this.blockSummary[blockCount]);
                ++blockCount;
            }
            float blockSDProd = 1.0f;
            int blockCount2 = 0;
            while (blockCount2 < blockFiller.getBlockNumber()) {
                blockSDProd *= this.blockLogRatioSD[blockCount2];
                ++blockCount2;
            }
            System.out.println("    ============================");
            System.out.println("          Assembling blocks     ");
            System.out.println("    ============================");
            System.out.println("    assembleCount = " + assembleCount);
            this.assembledLogProd = new ArrayResizer(this.assembledLogProd, assembleCount).getFArray();
            this.assembledRawLogRatio = new ArrayResizer(this.assembledRawLogRatio, assembleCount).getFArray();
            this.assembledLogRatio = new ArrayResizer(this.assembledLogRatio, assembleCount).getFArray();
            this.assembledLocfit = new ArrayResizer(this.assembledLocfit, assembleCount).getFArray();
            this.assembledRawNdx = new ArrayResizer(this.assembledRawNdx, assembleCount).getIArray();
            QSort sortAssemble = new QSort(this.assembledLogProd);
            this.sortedAssembledLogProd = sortAssemble.getSorted();
            int[] cc = sortAssemble.getOrigIndx();
            this.sortedAssembledRawLogRatio = new float[this.sortedAssembledLogProd.length];
            this.sortedAssembledLogRatio = new float[this.sortedAssembledLogProd.length];
            this.sortedAssembledLocfit = new float[this.sortedAssembledLogProd.length];
            this.sortedAssembledRawNdx = new int[this.sortedAssembledLogProd.length];
            int sac = 0;
            while (sac < this.sortedAssembledLogProd.length) {
                this.sortedAssembledRawLogRatio[sac] = this.assembledRawLogRatio[cc[sac]];
                this.sortedAssembledLogRatio[sac] = this.assembledLogRatio[cc[sac]];
                this.sortedAssembledLocfit[sac] = this.assembledLocfit[cc[sac]];
                this.sortedAssembledRawNdx[sac] = this.assembledRawNdx[cc[sac]];
                ++sac;
            }
            StatsTools sTools = new StatsTools();
            sTools.computeMeanSD(this.sortedAssembledLogRatio);
            float sliceLogRatioMean = sTools.getXMean();
            float slideLogRatioSD = sTools.getXSD();
            System.out.println("    sliceLogRatioMean = " + sliceLogRatioMean);
            System.out.println("    sliceLogRatioSD = " + slideLogRatioSD);
            System.out.println("    Prepare insert columns ...");
            float[] rawCy3Column = fileCW.getColumnOneArray();
            float[] rawCy5Column = fileCW.getColumnTwoArray();
            int rawRowIndex = 0;
            while (rawRowIndex < fileCW.getRowCounts()) {
                int i = 0;
                while (i < this.sortedAssembledRawNdx.length) {
                    float expValue = 1.0f;
                    if (this.sortedAssembledRawNdx[i] == rawRowIndex) {
                        if (ref.equalsIgnoreCase("Cy3")) {
                            expValue = (float)(1.0 / Math.pow(2.0, this.sortedAssembledLocfit[i]));
                            rawCy5Column[rawRowIndex] = new Double(rawCy5Column[rawRowIndex] * expValue).longValue();
                            locfitFlag[rawRowIndex] = true;
                            break;
                        }
                        expValue = (float)Math.pow(2.0, this.sortedAssembledLocfit[i]);
                        rawCy3Column[rawRowIndex] = new Double(rawCy3Column[rawRowIndex] * expValue).longValue();
                        locfitFlag[rawRowIndex] = true;
                        break;
                    }
                    ++i;
                }
                ++rawRowIndex;
            }
            this.fCW.setColOneArray(rawCy3Column);
            this.fCW.setColTwoArray(rawCy5Column);
            boolean[] outputFlag = new AndFlags(inputFlag, locfitFlag).getAndFlag();
            this.fCW.setRowFlag(outputFlag);
        } else {
            this.cy3Column = this.fCW.getColumnOneArray();
            this.cy5Column = this.fCW.getColumnTwoArray();
            System.out.println("    ================================");
            System.out.println("              Global Locfit         ");
            System.out.println("    ================================");
            System.out.println("    Global PreLocfitting ...");
            this.preLocfit();
            System.out.println("    Global Sorting ...");
            QSort sort = new QSort(this.nonZeroLogProd);
            this.sortedLogProd = sort.getSorted();
            int[] bb = sort.getOrigIndx();
            this.newNonZeroLogRatio = new float[this.sortedLogProd.length];
            this.newNonZeroRawIdx = new int[this.sortedLogProd.length];
            int i = 0;
            while (i < this.sortedLogProd.length) {
                this.newNonZeroLogRatio[i] = this.nonZeroLogRatio[bb[i]];
                this.newNonZeroRawIdx[i] = this.nonZeroRawIdx[bb[i]];
                ++i;
            }
            System.out.println("    Global Locfitting ...");
            Lowess lowess = new Lowess(this.sortedLogProd, this.newNonZeroLogRatio, smoothParam);
            this.locfittedLogRatio = lowess.getYEst();
            this.scaledLogRatio = new float[this.sortedLogProd.length];
            int i3 = 0;
            while (i3 < this.sortedLogProd.length) {
                this.scaledLogRatio[i3] = this.newNonZeroLogRatio[i3] - this.locfittedLogRatio[i3];
                ++i3;
            }
            System.out.println("    Prepare insert columns ...");
            int rawRowIndex = 0;
            while (rawRowIndex < fileCW.getRowCounts()) {
                int i4 = 0;
                while (i4 < this.newNonZeroRawIdx.length) {
                    float expValue = 1.0f;
                    if (this.newNonZeroRawIdx[i4] == rawRowIndex) {
                        if (ref.equalsIgnoreCase("Cy3")) {
                            expValue = (float)(1.0 / Math.pow(2.0, this.locfittedLogRatio[i4]));
                            this.cy5Column[rawRowIndex] = new Double(this.cy5Column[rawRowIndex] * expValue).longValue();
                            locfitFlag[rawRowIndex] = true;
                            break;
                        }
                        expValue = (float)Math.pow(2.0, this.locfittedLogRatio[i4]);
                        this.cy3Column[rawRowIndex] = new Double(this.cy3Column[rawRowIndex] * expValue).longValue();
                        locfitFlag[rawRowIndex] = true;
                        break;
                    }
                    ++i4;
                }
                ++rawRowIndex;
            }
            this.fCW.setColOneArray(this.cy3Column);
            this.fCW.setColTwoArray(this.cy5Column);
            boolean[] outputFlag = new AndFlags(inputFlag, locfitFlag).getAndFlag();
            this.fCW.setRowFlag(outputFlag);
        }
        String ityName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess.ity";
        String ltyName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess.lty";
        String prcName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess.prc";
        String hisName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess.his";
        String boxName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess_block.box";
        String locName = Module.proj.getProjPath() + "lowess" + FileBrowser.fsep + fileCW.getFileName() + "_lowess_loc.prc";
        DataPrep dataPrep = new DataPrep(fileCW);
        DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
        dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
        dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
        dr = new DataReporter(locName, this.sortedLogProd, this.locfittedLogRatio, new IndexAdjuster().addOne(this.newNonZeroRawIdx));
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("identity", new Integer(11));
        hash.put(CodeBook.lookup(99901), ityName);
        hash.put(CodeBook.lookup(99902), ltyName);
        hash.put(CodeBook.lookup(99903), prcName);
        hash.put(CodeBook.lookup(99904), hisName);
        hash.put(CodeBook.lookup(99905), boxName);
        hash.put("experiment data file: ", fileCW.getFileNameWithExtension());
        hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
        String[] moduleNotes = new String[]{"experiment data file: ", "processed data count: "};
        hash.put("module_notes", moduleNotes);
        Module.proj.insertReportItem("lowess_for_" + fileCW.getFileName(), hash);
    }

    public void preLocfit() {
        int dataNumber = this.cy3Column.length;
        this.wholeLogRatio = new float[dataNumber];
        this.nonZeroLogRatio = new float[dataNumber];
        this.wholeLogProd = new float[dataNumber];
        this.nonZeroLogProd = new float[dataNumber];
        this.nonZeroRawIdx = new int[dataNumber];
        this.zeroRawIdx = new int[dataNumber];
        this.nonZeroCount = 0;
        this.zeroCount = 0;
        int rowIndex = 0;
        while (rowIndex < dataNumber) {
            if (this.cy3Column[rowIndex] <= 1.0f || this.cy5Column[rowIndex] <= 1.0f) {
                this.cy3Column[rowIndex] = 0.0f;
                this.cy5Column[rowIndex] = 0.0f;
                this.wholeLogRatio[rowIndex] = 0.0f;
                this.wholeLogProd[rowIndex] = 0.0f;
                this.zeroRawIdx[this.zeroCount] = rowIndex;
                ++this.zeroCount;
            } else {
                this.wholeLogRatio[rowIndex] = MathTools.log2(this.cy5Column[rowIndex] / this.cy3Column[rowIndex]);
                this.wholeLogProd[rowIndex] = MathTools.log10(this.cy5Column[rowIndex] * this.cy3Column[rowIndex]);
                this.nonZeroLogRatio[this.nonZeroCount] = this.wholeLogRatio[rowIndex];
                this.nonZeroLogProd[this.nonZeroCount] = this.wholeLogProd[rowIndex];
                this.nonZeroRawIdx[this.nonZeroCount] = rowIndex;
                ++this.nonZeroCount;
            }
            ++rowIndex;
        }
        System.out.println("    ---- dataNumber = " + dataNumber);
        System.out.println("    ---- nonZeroCount = " + this.nonZeroCount);
        System.out.println("    ---- zeroCount = " + this.zeroCount);
        this.nonZeroLogProd = new ArrayResizer(this.nonZeroLogProd, this.nonZeroCount).getFArray();
        this.nonZeroLogRatio = new ArrayResizer(this.nonZeroLogRatio, this.nonZeroCount).getFArray();
        this.nonZeroRawIdx = new ArrayResizer(this.nonZeroRawIdx, this.nonZeroCount).getIArray();
        this.zeroRawIdx = new ArrayResizer(this.zeroRawIdx, this.zeroCount).getIArray();
    }

    public final float[] getLogRatioColumn() {
        return this.nonZeroLogRatio;
    }

    public final float[] getLogProdColumn() {
        return this.nonZeroLogProd;
    }

    public final float[] getSortedLogProd() {
        return this.sortedLogProd;
    }

    public final float[] getScaledLogRatio() {
        return this.scaledLogRatio;
    }

    public final float[] getLocfittedLogRatio() {
        return this.locfittedLogRatio;
    }

    public final int[] getNewNonZeroRawIdx() {
        return this.newNonZeroRawIdx;
    }

    public final int[] getZeroRawIdx() {
        return this.zeroRawIdx;
    }

    public final String[] getBlockSummary() {
        return this.blockSummary;
    }

    public final float[] getAssembledLogProd() {
        return this.assembledLogProd;
    }

    public final float[] getAssembledLogRatio() {
        return this.assembledLogRatio;
    }

    public final int[] getAssembledRawIndex() {
        return this.assembledRawNdx;
    }

    public final float[] getSortedAssembledLogProd() {
        return this.sortedAssembledLogProd;
    }

    public final float[] getSortedAssembledLogRatio() {
        return this.sortedAssembledLogRatio;
    }

    public final float[] getSortedAssembledLocfit() {
        return this.sortedAssembledLocfit;
    }

    public final int[] getSortedAssembledRawNdx() {
        return this.sortedAssembledRawNdx;
    }

    public final ColumnWorker getFileLocfitColumnWorker() {
        return this.fCW;
    }
}

