/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import Jama.Matrix;

public class Lowess {
    private static float[] xArray;
    private static float[] yArray;
    private static float[] yEst;
    private float[] xSub;
    private float[] ySub;
    private int subQueryPointIndex;
    private float[] weights;

    public Lowess(float[] xInput, float[] yInput, float bandwidthPct) {
        xArray = xInput;
        yArray = yInput;
        int totalDataCount = xArray.length;
        yEst = new float[totalDataCount];
        int windowSize = new Double(bandwidthPct * (float)totalDataCount).intValue();
        if (windowSize > 1) {
            this.xSub = new float[windowSize];
            this.ySub = new float[windowSize];
            this.weights = new float[windowSize];
            System.out.println("    ---- Bandwidth = " + windowSize);
            System.out.println("    ---- Please be patient, I am working hard, you know it's not an easy computation ...");
            Matrix X = new Matrix(windowSize, 2);
            Matrix WX = new Matrix(windowSize, 2);
            Matrix WY = new Matrix(windowSize, 1);
            int q = 0;
            while (q < totalDataCount) {
                this.getEstWindowSubArrayAndWeights(q, windowSize);
                int row = 0;
                while (row < windowSize) {
                    WX.set(row, 0, Math.sqrt(this.weights[row]));
                    WX.set(row, 1, Math.sqrt(this.weights[row]) * (double)this.xSub[row]);
                    WY.set(row, 0, Math.sqrt(this.weights[row]) * (double)this.ySub[row]);
                    ++row;
                }
                Matrix WXT = WX.transpose();
                Matrix B = WXT.times(WX).inverse().times(WXT.times(WY));
                float B0 = (float)B.get(0, 0);
                float B1 = (float)B.get(1, 0);
                Lowess.yEst[q] = B0 + B1 * this.xSub[this.subQueryPointIndex];
                ++q;
            }
        } else {
            int q = 0;
            while (q < totalDataCount) {
                Lowess.yEst[q] = 0.0f;
                ++q;
            }
        }
    }

    public float[] getXarray() {
        return xArray;
    }

    public float[] getYEst() {
        return yEst;
    }

    private void getEstWindowSubArrayAndWeights(int queryPointIndex, int window) {
        int i;
        int fullLength = xArray.length;
        int subStartIndex = 0;
        int windowSize = window;
        float maxDistance = 0.0f;
        if (queryPointIndex >= windowSize && queryPointIndex < fullLength - windowSize) {
            i = 0;
            while (i < windowSize) {
                if (xArray[queryPointIndex] - xArray[queryPointIndex - windowSize + 1 + i] <= xArray[queryPointIndex + 1 + i] - xArray[queryPointIndex]) {
                    subStartIndex = queryPointIndex - windowSize + 1 + i;
                    this.subQueryPointIndex = queryPointIndex - subStartIndex;
                    maxDistance = xArray[queryPointIndex] - xArray[subStartIndex] > xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex] ? xArray[queryPointIndex] - xArray[subStartIndex] : xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex];
                    break;
                }
                ++i;
            }
        } else if (queryPointIndex < windowSize) {
            i = 0;
            while (i < windowSize) {
                if (xArray[queryPointIndex] - xArray[i] <= xArray[windowSize + i] - xArray[queryPointIndex]) {
                    subStartIndex = i;
                    this.subQueryPointIndex = queryPointIndex - subStartIndex;
                    maxDistance = xArray[queryPointIndex] - xArray[subStartIndex] > xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex] ? xArray[queryPointIndex] - xArray[subStartIndex] : xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex];
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < windowSize) {
                if (xArray[fullLength - 1 - i] - xArray[queryPointIndex] <= xArray[queryPointIndex] - xArray[fullLength - windowSize - 1 - i]) {
                    subStartIndex = fullLength - windowSize - i;
                    this.subQueryPointIndex = queryPointIndex - subStartIndex;
                    maxDistance = xArray[queryPointIndex] - xArray[subStartIndex] > xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex] ? xArray[queryPointIndex] - xArray[subStartIndex] : xArray[subStartIndex + windowSize - 1] - xArray[queryPointIndex];
                    break;
                }
                ++i;
            }
        }
        System.arraycopy(xArray, subStartIndex, this.xSub, 0, windowSize);
        System.arraycopy(yArray, subStartIndex, this.ySub, 0, windowSize);
        int j = 0;
        while (j < windowSize) {
            float distance = Math.abs(this.xSub[this.subQueryPointIndex] - this.xSub[j]);
            this.weights[j] = (float)Math.pow(1.0 - Math.pow(distance / maxDistance, 3.0), 3.0);
            ++j;
        }
    }
}

