/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import ExpDesigner.ExpDesigner;
import java.util.Hashtable;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.StringSplitter;

public class MaAnova
extends Module {
    private ExpDesigner ED;

    public MaAnova(ColumnWorker[] groupCW) {
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String maanovaFB = projFolderFB.createSubDir("maanova");
        this.ED = new ExpDesigner(groupCW);
        this.RunMaAnova(groupCW);
    }

    public void RunMaAnova(ColumnWorker[] groupCW) {
        String str = MaAnovaParameter.pFolderStr;
        str = MaAnovaParameter.pExpListStr;
        this.ED.RunMaAnovaFixedModel();
        int fileNdx = 0;
        while (fileNdx < groupCW.length) {
            int selectNdx = 0;
            while (selectNdx < MaAnovaParameter.elistSize) {
                String s = MaAnovaParameter.GetFile(selectNdx);
                s = s.substring(0, s.lastIndexOf(46));
                if (groupCW[fileNdx].getFileName().equalsIgnoreCase(s)) {
                    String[][] anovaTable = new String[MaAnovaParameter.AnovaTableStringArray.length][4];
                    int i = 0;
                    while (i < MaAnovaParameter.AnovaTableStringArray.length) {
                        StringSplitter st = new StringSplitter(MaAnovaParameter.AnovaTableStringArray[i], '\t');
                        anovaTable[i][0] = st.nextToken();
                        anovaTable[i][1] = st.nextToken();
                        anovaTable[i][2] = st.nextToken();
                        anovaTable[i][3] = st.nextToken();
                        ++i;
                    }
                    String ityName = Module.proj.getProjPath() + "maanova" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_maanova.ity";
                    String ltyName = Module.proj.getProjPath() + "maanova" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_maanova.lty";
                    String prcName = Module.proj.getProjPath() + "maanova" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_maanova.prc";
                    String hisName = Module.proj.getProjPath() + "maanova" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_maanova.his";
                    String boxName = Module.proj.getProjPath() + "maanova" + FileBrowser.fsep + groupCW[fileNdx].getFileName() + "_maanova_block.box";
                    DataPrep dataPrep = new DataPrep(groupCW[fileNdx]);
                    DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
                    dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
                    dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
                    dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                    hash.put("identity", new Integer(41));
                    hash.put(CodeBook.lookup(99901), ityName);
                    hash.put(CodeBook.lookup(99902), ltyName);
                    hash.put(CodeBook.lookup(99903), prcName);
                    hash.put(CodeBook.lookup(99904), hisName);
                    hash.put(CodeBook.lookup(99905), boxName);
                    hash.put("experiment data file: ", groupCW[fileNdx].getFileNameWithExtension());
                    hash.put("maanova table       : ", anovaTable);
                    hash.put("processed data count: ", new Integer(dataPrep.getNonZeroCount()));
                    String[] moduleNotes = new String[]{"experiment data file: ", "maanova table       : ", "processed data count: "};
                    hash.put("module_notes", moduleNotes);
                    Module.proj.insertReportItem("maanova_for_" + groupCW[fileNdx].getFileName(), hash);
                }
                ++selectNdx;
            }
            ++fileNdx;
        }
    }

    public String getExpList() {
        return this.ED.getExpList();
    }
}

