/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.midas.Constant;
import org.tigr.midas.graph.ActionInfoDialog;
import org.tigr.midas.util.GBA;

public class SAMGraph
extends ActionInfoDialog {
    private double[] observedYArray;
    private double[] expectedXArray;
    private double delta;
    private double maxDelta;
    private double minDelta;
    boolean infiniteDeltaEncountered;
    double[] deltaGrid;
    int[] numSigGenesByDelta;
    double[] medNumFalse;
    double[] false90th;
    double[] FDRMedian;
    double[] FDR90th;
    GraphPanel gPanel;
    BottomPanel bPanel;
    GBA gba = new GBA();
    private String pubNumSig;
    private String pubNumFalseSigMed;
    private String pubNumFalseSig90th;
    private String pubFDRMed;
    private String pubFDR90th;

    public SAMGraph(JFrame parentFrame, double[] expectedXArray, double[] observedYArray, double delta, double[] deltaGrid, int[] numSigGenesByDelta, double[] medNumFalse, double[] false90th, double[] FDRMedian, double[] FDR90th, boolean modality) {
        super(parentFrame, "SAM Graph", modality);
        this.observedYArray = observedYArray;
        this.expectedXArray = expectedXArray;
        this.delta = delta;
        this.deltaGrid = deltaGrid;
        this.numSigGenesByDelta = numSigGenesByDelta;
        this.medNumFalse = medNumFalse;
        this.false90th = false90th;
        this.FDRMedian = FDRMedian;
        this.FDR90th = FDR90th;
        this.infiniteDeltaEncountered = false;
        this.setBounds(0, 0, 800, 600);
        this.setDefaultCloseOperation(2);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        this.gPanel = new GraphPanel(expectedXArray, observedYArray);
        this.bPanel = new BottomPanel();
        this.gba.add(pane, this.gPanel, 0, 0, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
        this.gba.add(pane, this.bPanel, 0, 1, 1, 1, 1, 0, 1, 10, 0, 0, 0, 0);
        this.setContentPane(pane);
    }

    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private float getMax(float[] array) {
        float max = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    private float getMin(float[] array) {
        float min = Float.POSITIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (min > array[i]) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    private double getMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (max < array[i]) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    private double getMin(double[] array) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < array.length) {
            if (min > array[i]) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    private String getNumSig(double currDel) {
        String numSig = "";
        int finalIndex = 0;
        if (currDel >= this.maxDelta) {
            numSig = "0";
        } else if (currDel <= this.minDelta) {
            numSig = String.valueOf(this.observedYArray.length);
        } else {
            int currentIndex = 0;
            int i = 0;
            while (i < this.deltaGrid.length) {
                if (this.deltaGrid[i] > currDel) {
                    currentIndex = i;
                    break;
                }
                ++i;
            }
            finalIndex = this.deltaGrid[currentIndex] - currDel > currDel - this.deltaGrid[currentIndex - 1] ? currentIndex - 1 : currentIndex;
            numSig = String.valueOf(this.numSigGenesByDelta[finalIndex]);
        }
        this.pubNumSig = numSig;
        return numSig;
    }

    private String getNumFalseSig(double currDel) {
        String numFalse = "";
        String numFalse90th = "";
        int finalIndex = 0;
        if (currDel >= this.maxDelta || currDel <= this.minDelta) {
            this.pubNumFalseSigMed = numFalse = "N/A        ";
            this.pubNumFalseSig90th = numFalse;
            this.pubFDRMed = numFalse;
            this.pubFDR90th = numFalse;
            return numFalse;
        }
        int currentIndex = 0;
        int i = 0;
        while (i < this.deltaGrid.length) {
            if (this.deltaGrid[i] > currDel) {
                currentIndex = i;
                break;
            }
            ++i;
        }
        finalIndex = this.deltaGrid[currentIndex] - currDel > currDel - this.deltaGrid[currentIndex - 1] ? currentIndex - 1 : currentIndex;
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        numFalse = nf.format(this.medNumFalse[finalIndex]);
        this.pubNumFalseSig90th = nf.format(this.false90th[finalIndex]);
        this.pubFDRMed = nf.format(this.FDRMedian[finalIndex]);
        this.pubFDR90th = nf.format(this.FDR90th[finalIndex]);
        this.pubNumFalseSigMed = numFalse;
        return numFalse;
    }

    public String getNumSig() {
        return this.pubNumSig;
    }

    public String getNumFalseSigMed() {
        return this.pubNumFalseSigMed;
    }

    public String getNumFalseSig90th() {
        return this.pubNumFalseSig90th;
    }

    public String getFDRMedian() {
        return this.pubFDRMed;
    }

    public String getFDR90th() {
        return this.pubFDR90th;
    }

    public double getDelta() {
        String s = this.bPanel.deltaTextField.getText();
        if (this.infiniteDeltaEncountered) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(s);
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ double access$602(SAMGraph x0, double x1) {
        x0.delta = x1;
        return x0.delta;
    }

    private class GraphPanel
    extends JPanel {
        private double[] xArray;
        private double[] yArray;
        int originX;
        int originY;

        GraphPanel(double[] xArray, double[] yArray) {
            this.setBorder(new LineBorder(Color.black));
            this.setBackground(Color.white);
            this.xArray = xArray;
            this.yArray = yArray;
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.paint1(g);
        }

        private void paint1(Graphics g) {
            int i;
            int i2;
            Graphics2D g2D = (Graphics2D)g;
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            this.originX = (int)Math.round((double)(this.getWidth() / 2));
            this.originY = (int)Math.round((double)(this.getHeight() / 2));
            double origMaxXValue = SAMGraph.this.getMax(this.xArray);
            double origMaxYValue = SAMGraph.this.getMax(this.yArray);
            double origMinXValue = SAMGraph.this.getMin(this.xArray);
            double origMinYValue = SAMGraph.this.getMin(this.yArray);
            double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
            double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
            float[] dash1 = new float[]{10.0f};
            g2D.setStroke(new BasicStroke(1.2f));
            g2D.setColor(Color.black);
            g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
            g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
            double[] xIntervalArray = new double[6];
            double[] yIntervalArray = new double[6];
            double xIncrement = 0.0;
            double yIncrement = 0.0;
            xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
            yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
            double xCounter = 0.0;
            double yCounter = 0.0;
            int i3 = 0;
            while (i3 < xIntervalArray.length) {
                xIntervalArray[i3] = xCounter;
                xCounter += xIncrement;
                yIntervalArray[i3] = yCounter;
                yCounter += yIncrement;
                ++i3;
            }
            g2D.setStroke(new BasicStroke(1.2f));
            g2D.setColor(Color.black);
            int i4 = 1;
            while (i4 < xIntervalArray.length) {
                g2D.drawLine((int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i4] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
                ++i4;
            }
            int i5 = 1;
            while (i5 < xIntervalArray.length) {
                g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i5] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i5] * xScalingFactor), this.getHeight() / 2 + 5);
                ++i5;
            }
            g2D.setStroke(new BasicStroke(1.2f));
            g2D.setColor(Constant.dark_blue_1);
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor), this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor));
            g2D.setStroke(new BasicStroke(0.7f));
            g2D.setColor(Color.gray);
            int i6 = 1;
            while (i6 < yIntervalArray.length) {
                g2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i6] * yScalingFactor), this.getWidth(), this.getHeight() / 2 + (int)Math.round(yIntervalArray[i6] * yScalingFactor));
                ++i6;
            }
            int i7 = 1;
            while (i7 < yIntervalArray.length) {
                g2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i7] * yScalingFactor), this.getWidth(), this.getHeight() / 2 - (int)Math.round(yIntervalArray[i7] * yScalingFactor));
                ++i7;
            }
            g2D.setStroke(new BasicStroke(1.2f));
            g2D.setColor(Color.black);
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            int i8 = 1;
            while (i8 < xIntervalArray.length) {
                g2D.drawString(nf.format(xIntervalArray[i8]), (int)Math.round(xIntervalArray[i8] * xScalingFactor) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
                ++i8;
            }
            int i9 = 1;
            while (i9 < xIntervalArray.length) {
                g2D.drawString("-" + nf.format(xIntervalArray[i9]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i9] * xScalingFactor) - 10, this.getHeight() / 2 + 20);
                ++i9;
            }
            int i10 = 1;
            while (i10 < yIntervalArray.length) {
                g2D.drawString(" " + nf.format(yIntervalArray[i10]), this.getWidth() / 2 - 37, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i10] * yScalingFactor) - 5);
                ++i10;
            }
            int i11 = 1;
            while (i11 < yIntervalArray.length) {
                g2D.drawString("-" + nf.format(yIntervalArray[i11]), this.getWidth() / 2 - 37, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i11] * yScalingFactor) - 5);
                ++i11;
            }
            int deltaOffset = (int)Math.round(SAMGraph.this.delta * yScalingFactor);
            BasicStroke dashed = new BasicStroke(1.2f, 0, 0, 10.0f, dash1, 0.0f);
            g2D.setColor(Constant.dark_blue_1);
            g2D.setStroke(dashed);
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) - deltaOffset);
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 + (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset, this.getWidth() / 2 + (int)Math.round(xIntervalArray[5] * xScalingFactor), this.getHeight() / 2 - (int)Math.round(xIntervalArray[5] * yScalingFactor) + deltaOffset);
            g2D.setStroke(new BasicStroke(1.2f));
            boolean posSigEncountered = false;
            boolean negSigEncountered = false;
            int lowestPosSigIndex = 0;
            int highestNegSigIndex = 0;
            int i12 = 0;
            while (i12 < this.xArray.length) {
                if (this.xArray[i12] > 0.0 && this.yArray[i12] - this.xArray[i12] > SAMGraph.this.delta) {
                    lowestPosSigIndex = i12;
                    posSigEncountered = true;
                    break;
                }
                ++i12;
            }
            int i13 = 0;
            while (i13 < this.xArray.length) {
                if (this.xArray[i13] < 0.0 && this.xArray[i13] - this.yArray[i13] > SAMGraph.this.delta) {
                    highestNegSigIndex = i13;
                    negSigEncountered = true;
                }
                ++i13;
            }
            Color[] pointColor = new Color[this.xArray.length];
            if (posSigEncountered && negSigEncountered) {
                i2 = 0;
                while (i2 < highestNegSigIndex + 1) {
                    pointColor[i2] = Color.green.darker();
                    ++i2;
                }
                i = highestNegSigIndex + 1;
                while (i < lowestPosSigIndex) {
                    pointColor[i] = Color.black;
                    ++i;
                }
                int i14 = lowestPosSigIndex;
                while (i14 < this.xArray.length) {
                    pointColor[i14] = Color.red;
                    ++i14;
                }
            } else if (posSigEncountered && !negSigEncountered) {
                i2 = 0;
                while (i2 < lowestPosSigIndex) {
                    pointColor[i2] = Color.black;
                    ++i2;
                }
                i = lowestPosSigIndex;
                while (i < this.xArray.length) {
                    pointColor[i] = Color.red;
                    ++i;
                }
            } else if (!posSigEncountered && negSigEncountered) {
                i2 = 0;
                while (i2 < highestNegSigIndex + 1) {
                    pointColor[i2] = Color.green.darker();
                    ++i2;
                }
                i = highestNegSigIndex + 1;
                while (i < this.xArray.length) {
                    pointColor[i] = Color.black;
                    ++i;
                }
            } else if (!posSigEncountered && !negSigEncountered) {
                i2 = 0;
                while (i2 < this.xArray.length) {
                    pointColor[i2] = Color.black;
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < SAMGraph.this.expectedXArray.length) {
                g2D.setColor(pointColor[i2]);
                this.drawPoint(g2D, this.xArray[i2], this.yArray[i2], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 3);
                g2D.setColor(Color.black);
                ++i2;
            }
            g2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
        }

        private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
            int xRaw = (int)Math.round(xValue * xScale);
            int yRaw = (int)Math.round(yValue * yScale);
            int xCoord = 0;
            int yCoord = 0;
            xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
            yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
            g2D.fillOval(xCoord, yCoord, diameter, diameter);
        }

        private double getXScalingFactor(double maxValue, double minValue) {
            double largest = 1.0;
            if (maxValue > 0.0 && minValue > 0.0) {
                largest = maxValue;
            } else if (maxValue > 0.0 && minValue < 0.0) {
                largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
            } else if (maxValue <= 0.0) {
                largest = Math.abs(minValue);
            } else if (minValue == 0.0) {
                largest = maxValue;
            }
            double scalingFactor = 0.0;
            scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
            return scalingFactor;
        }

        private double getYScalingFactor(double maxValue, double minValue) {
            double largest = 1.0;
            if (maxValue > 0.0 && minValue > 0.0) {
                largest = maxValue;
            } else if (maxValue > 0.0 && minValue < 0.0) {
                largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
            } else if (maxValue <= 0.0) {
                largest = Math.abs(minValue);
            } else if (minValue == 0.0) {
                largest = maxValue;
            }
            double scalingFactor = 0.0;
            scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
            return scalingFactor;
        }
    }

    private class BottomPanel
    extends JPanel {
        JSlider deltaSlider;
        JTextField deltaTextField;
        JLabel sigLabel;
        JLabel falseSigLabel;
        double maxValue;
        double initDelta;
        JButton okButton;

        BottomPanel() {
            this.setBorder(new EtchedBorder());
            double[] diffValues = new double[SAMGraph.this.observedYArray.length];
            int i = 0;
            while (i < diffValues.length) {
                diffValues[i] = Math.abs(SAMGraph.this.observedYArray[i] - SAMGraph.this.expectedXArray[i]);
                ++i;
            }
            SAMGraph.this.maxDelta = SAMGraph.this.getMax(diffValues);
            SAMGraph.this.minDelta = SAMGraph.this.getMin(diffValues);
            this.maxValue = 0.0;
            double initMax = SAMGraph.this.getMax(SAMGraph.this.observedYArray);
            double initMin = SAMGraph.this.getMin(SAMGraph.this.observedYArray);
            this.maxValue = Math.abs(initMax) > Math.abs(initMin) ? Math.abs(initMax) : Math.abs(initMin);
            this.initDelta = SAMGraph.this.delta;
            this.deltaSlider = new JSlider(0, 1000, (int)Math.round(this.initDelta * 1000.0 / this.maxValue));
            this.deltaSlider.setBackground(new Color(220, 220, 220));
            this.deltaTextField = new JTextField("" + this.initDelta, 7);
            this.deltaTextField.addActionListener(new ActionListener(this){
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = this.this$1.deltaTextField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 1000.0 / this.this$1.maxValue);
                        if (sliderValue >= 1000) {
                            this.this$1.deltaSlider.setValue(1000);
                            this.this$1.deltaTextField.setText("" + (float)this.this$1.maxValue);
                        } else if (sliderValue <= 0) {
                            this.this$1.deltaSlider.setValue(0);
                            this.this$1.deltaTextField.setText("0.0");
                        } else {
                            this.this$1.deltaSlider.setValue(sliderValue);
                            this.this$1.deltaTextField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        this.this$1.deltaSlider.setValue(250);
                        this.this$1.deltaTextField.setText("" + (float)this.this$1.initDelta);
                    }
                    String dString = this.this$1.deltaTextField.getText();
                    SAMGraph.access$602(BottomPanel.access$700(this.this$1), Double.parseDouble(dString));
                    this.this$1.sigLabel.setText(" Number of Significant Genes: " + SAMGraph.access$800(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    this.this$1.falseSigLabel.setText(" Median number of false significant genes" + SAMGraph.access$900(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    BottomPanel.access$700((BottomPanel)this.this$1).gPanel.repaint();
                }
            });
            this.deltaTextField.addFocusListener(new FocusListener(this){
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusLost(FocusEvent e) {
                    try {
                        String s = this.this$1.deltaTextField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 1000.0 / this.this$1.maxValue);
                        if (sliderValue >= 1000) {
                            this.this$1.deltaSlider.setValue(1000);
                            this.this$1.deltaTextField.setText("" + (float)this.this$1.maxValue);
                        } else if (sliderValue <= 0) {
                            this.this$1.deltaSlider.setValue(0);
                            this.this$1.deltaTextField.setText("0.0");
                        } else {
                            this.this$1.deltaSlider.setValue(sliderValue);
                            this.this$1.deltaTextField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        this.this$1.deltaSlider.setValue(250);
                        this.this$1.deltaTextField.setText("" + (float)this.this$1.initDelta);
                    }
                    String dString = this.this$1.deltaTextField.getText();
                    SAMGraph.access$602(BottomPanel.access$700(this.this$1), Double.parseDouble(dString));
                    this.this$1.sigLabel.setText(" Number of Significant Genes: " + SAMGraph.access$800(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    this.this$1.falseSigLabel.setText(" Median number of false significant genes: " + SAMGraph.access$900(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    BottomPanel.access$700((BottomPanel)this.this$1).gPanel.repaint();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.deltaSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    int value = source.getValue();
                    double displayValue = (double)value * this.this$1.maxValue / 1000.0;
                    if (value == 0) {
                        displayValue = 0.0;
                    }
                    this.this$1.deltaTextField.setText("" + (float)displayValue);
                    String dString = this.this$1.deltaTextField.getText();
                    if (!Double.isInfinite(displayValue)) {
                        SAMGraph.access$602(BottomPanel.access$700(this.this$1), Double.parseDouble(dString));
                    } else {
                        BottomPanel.access$700((BottomPanel)this.this$1).infiniteDeltaEncountered = true;
                        SAMGraph.access$602(BottomPanel.access$700(this.this$1), Double.POSITIVE_INFINITY);
                    }
                    this.this$1.sigLabel.setText(" Number of Significant Genes: " + SAMGraph.access$800(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    this.this$1.falseSigLabel.setText(" Median number of false significant genes: " + SAMGraph.access$900(BottomPanel.access$700(this.this$1), SAMGraph.access$600(BottomPanel.access$700(this.this$1))));
                    BottomPanel.access$700((BottomPanel)this.this$1).gPanel.repaint();
                }
            });
            this.okButton = new JButton("OK");
            this.okButton.setBackground(new Color(220, 220, 220));
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BottomPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    BottomPanel.access$700(this.this$1).dispose();
                }
            });
            this.sigLabel = new JLabel("  Number of significant genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
            this.sigLabel.setFont(new Font("dialog.plain", 2, 12));
            this.sigLabel.setForeground(Constant.dark_blue_1);
            this.falseSigLabel = new JLabel("  Median number of falsely significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
            this.falseSigLabel.setFont(new Font("dialog.plain", 2, 12));
            this.falseSigLabel.setForeground(Constant.dark_blue_1);
            JPanel sliderPane = new JPanel();
            sliderPane.setBackground(new Color(220, 220, 220));
            sliderPane.setLayout(new GridBagLayout());
            JLabel sliderLabel = new JLabel("  Use slider to set \u0394 value: ");
            sliderLabel.setFont(Constant.font);
            SAMGraph.this.gba.add(sliderPane, sliderLabel, 0, 0, 1, 1, 0, 1, 1, 10, 0, 0, 0, 0);
            SAMGraph.this.gba.add(sliderPane, this.deltaSlider, 1, 0, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
            JPanel deltaPane = new JPanel();
            deltaPane.setBackground(new Color(220, 220, 220));
            deltaPane.setLayout(new GridBagLayout());
            JLabel deltaLabel = new JLabel("  Or enter \u0394 value here: ");
            deltaLabel.setFont(Constant.font);
            SAMGraph.this.gba.add(deltaPane, deltaLabel, 0, 0, 1, 1, 0, 1, 1, 10, 0, 0, 0, 0);
            SAMGraph.this.gba.add(deltaPane, this.deltaTextField, 1, 0, 1, 1, 1, 1, 1, 10, 0, 0, 0, 0);
            JPanel okPane = new JPanel();
            okPane.setBackground(new Color(220, 220, 220));
            okPane.add(this.okButton);
            this.setLayout(new GridBagLayout());
            this.setBackground(new Color(220, 220, 220));
            SAMGraph.this.gba.add(this, this.sigLabel, 0, 0, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
            SAMGraph.this.gba.add(this, this.falseSigLabel, 1, 0, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
            SAMGraph.this.gba.add(this, sliderPane, 0, 1, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
            SAMGraph.this.gba.add(this, deltaPane, 1, 1, 1, 1, 1, 1, 1, 10, 5, 5, 5, 5);
            SAMGraph.this.gba.add(this, okPane, 0, 2, 2, 1, 1, 1, 1, 10, 5, 5, 5, 5);
        }

        static /* synthetic */ SAMGraph access$700(BottomPanel x0) {
            return x0.SAMGraph.this;
        }
    }
}

