/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.tigr.midas.exception.SA_CantComputeSliceMeanSD;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.math.statistics.TDistribution;

public class SliceAnalyzer {
    float[] wholeX;
    float[] wholeY;
    int[] wholeZ;
    float[] sliceX;
    float[] sliceY;
    int winPop;
    float[] queryX;
    float[] sliceMeanVal;
    float[] sliceStdVal;
    float[] beyondRangeLogProd;
    float[] beyondRangeLogRatio;
    int[] beyondRangeRawNdx;
    float[] withinRangeLogProd;
    float[] withinRangeLogRatio;
    int[] withinRangeRawNdx;
    float[] logRatioMean;
    float[] logRatioStd;
    int beyondRangeCount;
    int withinRangeCount;
    float[] zScoreVal;
    float zMean;
    float zSD;
    float[] pVal;
    float[] logPval;

    public SliceAnalyzer(float[] x, float[] y, int[] z, int windowPopulation) {
        this.wholeX = x;
        this.wholeY = y;
        this.wholeZ = z;
        this.winPop = windowPopulation;
    }

    protected void findMeanStdCurve(int curvePointNbr) {
        this.queryX = new float[curvePointNbr];
        this.sliceMeanVal = new float[curvePointNbr];
        this.sliceStdVal = new float[curvePointNbr];
        float xMin = this.wholeX[0];
        float xMax = this.wholeX[this.wholeX.length - 1];
        int cp = 0;
        while (cp < curvePointNbr) {
            this.queryX[cp] = xMin + (float)cp * (xMax - xMin) / (float)curvePointNbr;
            float[] ms = this.cutSliceData(cp);
            this.sliceMeanVal[cp] = ms[0];
            this.sliceStdVal[cp] = ms[1];
            ++cp;
        }
    }

    public void findDataPointsInStdRange(float lowStdFolds, float highStdFolds) throws SA_CantComputeSliceMeanSD {
        this.logRatioMean = new float[this.wholeY.length];
        this.logRatioStd = new float[this.wholeY.length];
        this.beyondRangeLogProd = new float[this.wholeX.length];
        this.beyondRangeLogRatio = new float[this.wholeY.length];
        this.beyondRangeRawNdx = new int[this.wholeZ.length];
        this.withinRangeLogProd = new float[this.wholeX.length];
        this.withinRangeLogRatio = new float[this.wholeY.length];
        this.withinRangeRawNdx = new int[this.wholeZ.length];
        this.zScoreVal = new float[this.wholeY.length];
        this.pVal = new float[this.wholeY.length];
        this.logPval = new float[this.wholeY.length];
        int beyondRangeIdx = 0;
        int withinRangeIdx = 0;
        int dp = 0;
        while (dp < this.wholeX.length) {
            float[] fms = this.cutSliceData(dp);
            if (fms == null) {
                throw new SA_CantComputeSliceMeanSD();
            }
            this.logRatioMean[dp] = fms[0];
            this.logRatioStd[dp] = fms[1];
            this.zScoreVal[dp] = (this.wholeY[dp] - this.logRatioMean[dp]) / this.logRatioStd[dp];
            if (lowStdFolds == Float.NEGATIVE_INFINITY && highStdFolds != Float.POSITIVE_INFINITY) {
                if (Math.abs(this.wholeY[dp] - this.logRatioMean[dp]) <= fms[1] * highStdFolds) {
                    this.withinRangeLogProd[withinRangeIdx] = this.wholeX[dp];
                    this.withinRangeLogRatio[withinRangeIdx] = this.wholeY[dp];
                    this.withinRangeRawNdx[withinRangeIdx] = this.wholeZ[dp];
                    ++withinRangeIdx;
                } else {
                    this.beyondRangeLogProd[beyondRangeIdx] = this.wholeX[dp];
                    this.beyondRangeLogRatio[beyondRangeIdx] = this.wholeY[dp];
                    this.beyondRangeRawNdx[beyondRangeIdx] = this.wholeZ[dp];
                    ++beyondRangeIdx;
                }
            } else if (lowStdFolds != Float.NEGATIVE_INFINITY && highStdFolds == Float.POSITIVE_INFINITY) {
                if (Math.abs(this.wholeY[dp] - this.logRatioMean[dp]) >= fms[1] * lowStdFolds) {
                    this.withinRangeLogProd[withinRangeIdx] = this.wholeX[dp];
                    this.withinRangeLogRatio[withinRangeIdx] = this.wholeY[dp];
                    this.withinRangeRawNdx[withinRangeIdx] = this.wholeZ[dp];
                    ++withinRangeIdx;
                } else {
                    this.beyondRangeLogProd[beyondRangeIdx] = this.wholeX[dp];
                    this.beyondRangeLogRatio[beyondRangeIdx] = this.wholeY[dp];
                    this.beyondRangeRawNdx[beyondRangeIdx] = this.wholeZ[dp];
                    ++beyondRangeIdx;
                }
            } else if (lowStdFolds != Float.NEGATIVE_INFINITY && highStdFolds != Float.POSITIVE_INFINITY) {
                if (Math.abs(this.wholeY[dp] - this.logRatioMean[dp]) >= fms[1] * lowStdFolds && Math.abs(this.wholeY[dp] - this.logRatioMean[dp]) <= fms[1] * highStdFolds) {
                    this.withinRangeLogProd[withinRangeIdx] = this.wholeX[dp];
                    this.withinRangeLogRatio[withinRangeIdx] = this.wholeY[dp];
                    this.withinRangeRawNdx[withinRangeIdx] = this.wholeZ[dp];
                    ++withinRangeIdx;
                } else {
                    this.beyondRangeLogProd[beyondRangeIdx] = this.wholeX[dp];
                    this.beyondRangeLogRatio[beyondRangeIdx] = this.wholeY[dp];
                    this.beyondRangeRawNdx[beyondRangeIdx] = this.wholeZ[dp];
                    ++beyondRangeIdx;
                }
            } else {
                this.withinRangeLogProd[withinRangeIdx] = this.wholeX[dp];
                this.withinRangeLogRatio[withinRangeIdx] = this.wholeY[dp];
                this.withinRangeRawNdx[withinRangeIdx] = this.wholeZ[dp];
                ++withinRangeIdx;
            }
            ++dp;
        }
        StatsTools st = new StatsTools();
        st.computeMeanSD(this.zScoreVal);
        this.zMean = st.getXMean();
        this.zSD = st.getXSD();
        System.out.println("    ---- zMean = " + this.zMean);
        System.out.println("    ---- zSD = " + this.zSD);
        int dp2 = 0;
        while (dp2 < this.zScoreVal.length) {
            this.pVal[dp2] = (float)(1.0 - new TDistribution(this.zScoreVal.length).prob(-1.0f * Math.abs(this.zScoreVal[dp2]), Math.abs(this.zScoreVal[dp2])));
            this.logPval[dp2] = this.pVal[dp2] > 0.0f ? -1.0f * MathTools.log10(this.pVal[dp2]) : 10.0f;
            ++dp2;
        }
        System.out.println("    ---- beyondRangeIdx = " + beyondRangeIdx);
        System.out.println("    ---- withinRangeIdx = " + withinRangeIdx);
        this.beyondRangeCount = beyondRangeIdx;
        this.withinRangeCount = withinRangeIdx;
        float[] tmp = new float[this.beyondRangeLogProd.length];
        System.arraycopy(this.beyondRangeLogProd, 0, tmp, 0, this.beyondRangeLogProd.length);
        this.beyondRangeLogProd = new float[beyondRangeIdx];
        System.arraycopy(tmp, 0, this.beyondRangeLogProd, 0, beyondRangeIdx);
        tmp = new float[this.beyondRangeLogRatio.length];
        System.arraycopy(this.beyondRangeLogRatio, 0, tmp, 0, this.beyondRangeLogRatio.length);
        this.beyondRangeLogRatio = new float[beyondRangeIdx];
        System.arraycopy(tmp, 0, this.beyondRangeLogRatio, 0, beyondRangeIdx);
        int[] tmp2 = new int[this.beyondRangeRawNdx.length];
        System.arraycopy(this.beyondRangeRawNdx, 0, tmp2, 0, this.beyondRangeRawNdx.length);
        this.beyondRangeRawNdx = new int[beyondRangeIdx];
        System.arraycopy(tmp2, 0, this.beyondRangeRawNdx, 0, beyondRangeIdx);
        tmp = new float[this.withinRangeLogProd.length];
        System.arraycopy(this.withinRangeLogProd, 0, tmp, 0, this.withinRangeLogProd.length);
        this.withinRangeLogProd = new float[withinRangeIdx];
        System.arraycopy(tmp, 0, this.withinRangeLogProd, 0, withinRangeIdx);
        tmp = new float[this.withinRangeLogRatio.length];
        System.arraycopy(this.withinRangeLogRatio, 0, tmp, 0, this.withinRangeLogRatio.length);
        this.withinRangeLogRatio = new float[withinRangeIdx];
        System.arraycopy(tmp, 0, this.withinRangeLogRatio, 0, withinRangeIdx);
        tmp2 = new int[this.withinRangeRawNdx.length];
        System.arraycopy(this.withinRangeRawNdx, 0, tmp2, 0, this.withinRangeRawNdx.length);
        this.withinRangeRawNdx = new int[withinRangeIdx];
        System.arraycopy(tmp2, 0, this.withinRangeRawNdx, 0, withinRangeIdx);
    }

    public void outputMeanStd(String meanFile, String stdFile) {
        try {
            System.out.println("Generating " + meanFile + " and " + stdFile + "...");
            PrintStream meanOut = new PrintStream(new FileOutputStream(new File(meanFile)));
            PrintStream stdOut = new PrintStream(new FileOutputStream(new File(stdFile)));
            meanOut.print("sortedAsmLogProd logRatioMean\n");
            stdOut.print("sortedAsmLogProd logRatioStd\n");
            int i = 0;
            while (i <= this.wholeX.length - 1) {
                meanOut.print(Double.toString(this.wholeX[i]) + " " + Double.toString(this.logRatioMean[i]) + "\n");
                stdOut.print(Double.toString(this.wholeX[i]) + " " + Double.toString(this.logRatioStd[i]) + "\n");
                ++i;
            }
            meanOut.close();
            stdOut.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private float[] cutSliceData(int queryNdx) {
        float[] returnVal = new float[2];
        this.sliceX = new float[this.winPop];
        this.sliceY = new float[this.winPop];
        int sliceStartNdx = queryNdx - this.winPop / 2 <= 0 ? 0 : (queryNdx + this.winPop / 2 >= this.wholeX.length ? this.wholeX.length - this.winPop : queryNdx - this.winPop / 2);
        int i = 0;
        while (i < this.winPop) {
            this.sliceX[i] = this.wholeX[sliceStartNdx + i];
            this.sliceY[i] = this.wholeY[sliceStartNdx + i];
            ++i;
        }
        StatsTools s = new StatsTools();
        s.computeMeanSD(this.sliceY);
        returnVal[0] = s.getXMean();
        returnVal[1] = s.getXSD();
        if (Float.isNaN(returnVal[0]) || Float.isNaN(returnVal[1])) {
            return null;
        }
        return returnVal;
    }

    public final int getBeyondRangeCount() {
        return this.beyondRangeCount;
    }

    public final float[] getBeyondRangeLogProd() {
        return this.beyondRangeLogProd;
    }

    public final float[] getBeyondRangeLogRatio() {
        return this.beyondRangeLogRatio;
    }

    public final int[] getBeyondRangeRawNdx() {
        return this.beyondRangeRawNdx;
    }

    public final int getWithinRangeCount() {
        return this.withinRangeCount;
    }

    public final float[] getWithinRangeLogProd() {
        return this.withinRangeLogProd;
    }

    public final float[] getWithinRangeLogRatio() {
        return this.withinRangeLogRatio;
    }

    public final int[] getWithinRangeRawNdx() {
        return this.withinRangeRawNdx;
    }

    public final float[] getQueryX() {
        return this.queryX;
    }

    public final float[] getlogRatioMean() {
        return this.logRatioMean;
    }

    public final float[] getlogRatioStd() {
        return this.logRatioStd;
    }

    public final float[] getZscoreVal() {
        return this.zScoreVal;
    }

    public final float getZMean() {
        return this.zMean;
    }

    public final float getZSD() {
        return this.zSD;
    }

    public final float[] getPVal() {
        return this.pVal;
    }

    public final float[] getLogPVal() {
        return this.logPval;
    }

    public final float[] getWholeX() {
        return this.wholeX;
    }

    public final float[] getWholeY() {
        return this.wholeY;
    }

    public final int[] getWholeZ() {
        return this.wholeZ;
    }
}

