/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.tigr.midas.engine.DataPrep;
import org.tigr.midas.engine.DataReporter;
import org.tigr.midas.engine.Module;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.statistics.TDistribution;
import org.tigr.midas.util.AndFlags;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.CyToLogProdRatio;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.IndexAdjuster;
import org.tigr.midas.util.MemObserver;

public class Ttest
extends Module {
    public static final int ONE_CLASS = 321;
    public static final int TWO_CLASS = 322;
    public static final int P_VAL_BASED_ON_TDISTRIBUTION = -323;
    public static final int P_VAL_BASED_ON_ALL_PERMUT_COMBS = 320;
    public static final int ALL_PERMUT_COMBS = 323;
    public static final int JUST_ALPHA = 324;
    public static final int STANDARD_BONFERRONI = 325;
    public static final int ADJUSTED_BONFERRONI = 326;
    private float hypoMean;
    private int pValBase;
    private float alpha;
    private int sigMethod;
    private int numExps;
    private int numGenes;
    private float[][] folderLogRatio;
    private Vector tValuesVector;
    private Vector pValuesVector;
    private Vector sigGenes;
    private Vector nonSigGenes;
    private ColumnWorker[] groupCW;
    private boolean[] sigFlag;

    public Ttest(ColumnWorker[] groupCW, float hypoMean, int pValBase, float alpha, int sigMethod) {
        float[] cy5Column;
        float[] cy3Column;
        FileBrowser projFolderFB = new FileBrowser(Module.proj.getProjPath(), 11199);
        String crossSlideTtestFB = projFolderFB.createSubDir("cross_slide_ttest");
        this.groupCW = groupCW;
        this.hypoMean = hypoMean;
        this.pValBase = pValBase;
        this.alpha = alpha;
        this.sigMethod = sigMethod;
        this.numExps = groupCW.length;
        this.numGenes = groupCW[0].getRowCounts();
        float[][] cy3Exps = new float[this.numGenes][this.numExps];
        float[][] cy5Exps = new float[this.numGenes][this.numExps];
        this.folderLogRatio = new float[this.numExps][];
        this.sigFlag = new boolean[this.numGenes];
        int fileNdx = 0;
        while (fileNdx < this.numExps) {
            float[] cy3Column2 = groupCW[fileNdx].getColumnOneArray();
            float[] cy5Column2 = groupCW[fileNdx].getColumnTwoArray();
            this.folderLogRatio[fileNdx] = new CyToLogProdRatio(cy3Column2, cy5Column2).getLogRatio();
            ++fileNdx;
        }
        int geneNdx = 0;
        while (geneNdx < this.numGenes) {
            int fileNdx2 = 0;
            while (fileNdx2 < this.numExps) {
                String[] uidColumn = groupCW[fileNdx2].getUID();
                cy3Column = groupCW[fileNdx2].getColumnOneArray();
                cy5Column = groupCW[fileNdx2].getColumnTwoArray();
                cy3Exps[geneNdx][fileNdx2] = cy3Column[geneNdx];
                cy5Exps[geneNdx][fileNdx2] = cy5Column[geneNdx];
                ++fileNdx2;
            }
            ++geneNdx;
        }
        Vector clusterVector = this.sortGenesForOneClassDesign();
        int fileNdx3 = 0;
        while (fileNdx3 < this.numExps) {
            cy3Column = groupCW[fileNdx3].getColumnOneArray();
            cy5Column = groupCW[fileNdx3].getColumnTwoArray();
            DataPrep dataPrep = new DataPrep(groupCW[fileNdx3]);
            int inCount = dataPrep.getNonZeroCount();
            int geneNdx2 = 0;
            while (geneNdx2 < this.numGenes) {
                if (!this.sigFlag[geneNdx2]) {
                    cy3Column[geneNdx2] = 0.0f;
                    cy5Column[geneNdx2] = 0.0f;
                }
                ++geneNdx2;
            }
            this.groupCW[fileNdx3].setRowFlag(new AndFlags(this.sigFlag, groupCW[fileNdx3].getRowFlagArray()).getAndFlag());
            this.groupCW[fileNdx3].setColOneArray(cy3Column);
            this.groupCW[fileNdx3].setColTwoArray(cy5Column);
            String ityName = Module.proj.getProjPath() + "cross_slide_ttest" + FileBrowser.fsep + groupCW[fileNdx3].getFileName() + "_ttest.ity";
            String ltyName = Module.proj.getProjPath() + "cross_slide_ttest" + FileBrowser.fsep + groupCW[fileNdx3].getFileName() + "_ttest.lty";
            String prcName = Module.proj.getProjPath() + "cross_slide_ttest" + FileBrowser.fsep + groupCW[fileNdx3].getFileName() + "_ttest.prc";
            String hisName = Module.proj.getProjPath() + "cross_slide_ttest" + FileBrowser.fsep + groupCW[fileNdx3].getFileName() + "_ttest.his";
            String boxName = Module.proj.getProjPath() + "cross_slide_ttest" + FileBrowser.fsep + groupCW[fileNdx3].getFileName() + "_ttest_block.box";
            dataPrep = new DataPrep(groupCW[fileNdx3]);
            DataReporter dr = new DataReporter(ityName, dataPrep.getX(), dataPrep.getY());
            dr = new DataReporter(ltyName, dataPrep.getLogX(), dataPrep.getLogY());
            dr = new DataReporter(prcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(hisName, dataPrep.getZscore(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            dr = new DataReporter(boxName, dataPrep.getBlockLogRatio());
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            hash.put("identity", new Integer(32));
            hash.put(CodeBook.lookup(99901), ityName);
            hash.put(CodeBook.lookup(99902), ltyName);
            hash.put(CodeBook.lookup(99903), prcName);
            hash.put(CodeBook.lookup(99904), hisName);
            hash.put(CodeBook.lookup(99905), boxName);
            hash.put("experiment data file:      ", groupCW[fileNdx3].getFileNameWithExtension());
            hash.put("post-filtering data count: ", new Integer(dataPrep.getNonZeroCount()));
            String[] moduleNotes = new String[]{"experiment data file:      ", "post-filtering data count: "};
            hash.put("module_notes", moduleNotes);
            Module.proj.insertReportItem("ttest_for_" + groupCW[fileNdx3].getFileName(), hash);
            ++fileNdx3;
        }
    }

    private float[] getLogRatiosForGene(int geneNdx) {
        float[] currGeneArray = new float[this.numExps];
        int i = 0;
        while (i < this.numExps) {
            currGeneArray[i] = this.folderLogRatio[i][geneNdx];
            ++i;
        }
        return currGeneArray;
    }

    private Vector sortGenesForOneClassDesign() {
        block51: {
            Vector<Integer> nonSigGenes;
            Vector<Integer> sigGenes;
            block52: {
                block53: {
                    block49: {
                        block50: {
                            sigGenes = new Vector<Integer>();
                            nonSigGenes = new Vector<Integer>();
                            this.pValuesVector = new Vector();
                            if (this.pValBase != -323) break block49;
                            if (this.sigMethod != 324 && this.sigMethod != 325) break block50;
                            int i = 0;
                            while (i < this.numGenes) {
                                this.checkFreeMem();
                                this.sigFlag[i] = this.isSigOneClass(i);
                                if (this.isSigOneClass(i)) {
                                    sigGenes.add(new Integer(i));
                                } else {
                                    nonSigGenes.add(new Integer(i));
                                }
                                ++i;
                            }
                            break block51;
                        }
                        if (this.sigMethod != 326) break block51;
                        float[] pValues = new float[this.numGenes];
                        int i = 0;
                        while (i < this.numGenes) {
                            float currentOneClassProb;
                            float[] currentGeneValues = this.getOneClassGeneValues(i);
                            float currentOneClassT = (float)this.getOneClassTValue(currentGeneValues);
                            float currentOneClassDF = this.getOneClassDFValue(currentGeneValues);
                            pValues[i] = currentOneClassProb = this.getProb(currentOneClassT, (int)currentOneClassDF);
                            ++i;
                        }
                        int i2 = 0;
                        while (i2 < pValues.length) {
                            this.pValuesVector.add(new Float(pValues[i2]));
                            ++i2;
                        }
                        int denomAlpha = this.numGenes;
                        double adjAlpha = (double)this.alpha / (double)denomAlpha;
                        QSort sortPVals = new QSort(pValues);
                        float[] sortedPValues = sortPVals.getSorted();
                        int[] sortedIndices = sortPVals.getOrigIndx();
                        int i3 = sortedPValues.length - 1;
                        while (i3 >= 0) {
                            if ((double)sortedPValues[i3] <= adjAlpha) {
                                this.sigFlag[i3] = true;
                                sigGenes.add(new Integer(sortedIndices[i3]));
                            } else {
                                this.sigFlag[i3] = false;
                                nonSigGenes.add(new Integer(sortedIndices[i3]));
                            }
                            if (i3 < sortedPValues.length - 1) {
                                if (sortedPValues[i3] < sortedPValues[i3 + 1] && --denomAlpha < 1) {
                                    System.out.println("Warning: denomAlpha = " + denomAlpha);
                                }
                            } else if (denomAlpha < 1) {
                                System.out.println("Warning: denomAlpha = " + denomAlpha);
                            }
                            adjAlpha = this.alpha / (float)denomAlpha;
                            --i3;
                        }
                        break block51;
                    }
                    if (this.pValBase != 320) break block52;
                    if (this.sigMethod != 324 && this.sigMethod != 325) break block53;
                    int i = 0;
                    while (i < this.numGenes) {
                        float currentProb;
                        if (this.sigMethod == 324) {
                            currentProb = this.getAllCombsOneClassProb(i);
                            this.pValuesVector.add(new Float(currentProb));
                            if (currentProb <= this.alpha) {
                                this.sigFlag[i] = true;
                                sigGenes.add(new Integer(i));
                            } else {
                                this.sigFlag[i] = false;
                                nonSigGenes.add(new Integer(i));
                            }
                        } else if (this.sigMethod == 325) {
                            currentProb = this.getAllCombsOneClassProb(i);
                            this.pValuesVector.add(new Float(currentProb));
                            float thresh = (float)((double)this.alpha / (double)this.numGenes);
                            if (currentProb <= thresh) {
                                this.sigFlag[i] = true;
                                sigGenes.add(new Integer(i));
                            } else {
                                this.sigFlag[i] = false;
                                nonSigGenes.add(new Integer(i));
                            }
                        }
                        ++i;
                    }
                    break block51;
                }
                if (this.sigMethod != 326) break block51;
                float[] pValues = new float[this.numGenes];
                int i = 0;
                while (i < this.numGenes) {
                    pValues[i] = this.getAllCombsOneClassProb(i);
                    ++i;
                }
                int i4 = 0;
                while (i4 < pValues.length) {
                    this.pValuesVector.add(new Float(pValues[i4]));
                    ++i4;
                }
                int denomAlpha = this.numGenes;
                double adjAlpha = (double)this.alpha / (double)denomAlpha;
                QSort sortPVals = new QSort(pValues);
                float[] sortedPValues = sortPVals.getSorted();
                int[] sortedIndices = sortPVals.getOrigIndx();
                int i5 = sortedPValues.length - 1;
                while (i5 >= 0) {
                    if ((double)sortedPValues[i5] <= adjAlpha) {
                        this.sigFlag[i5] = true;
                        sigGenes.add(new Integer(sortedIndices[i5]));
                    } else {
                        this.sigFlag[i5] = false;
                        nonSigGenes.add(new Integer(sortedIndices[i5]));
                    }
                    if (i5 < sortedPValues.length - 1) {
                        if (sortedPValues[i5] < sortedPValues[i5 + 1] && --denomAlpha < 1) {
                            System.out.println("Warning: denomAlpha = " + denomAlpha);
                        }
                    } else if (denomAlpha < 1) {
                        System.out.println("Warning: denomAlpha = " + denomAlpha);
                    }
                    adjAlpha = this.alpha / (float)denomAlpha;
                    --i5;
                }
                break block51;
            }
            if (this.sigMethod == 324 || this.sigMethod == 325) {
                int i = 0;
                while (i < this.numGenes) {
                    float currentProb = this.getSomeCombsOneClassProb(i);
                    this.pValuesVector.add(new Float(currentProb));
                    if (this.sigMethod == 324) {
                        if (currentProb <= this.alpha) {
                            this.sigFlag[i] = true;
                            sigGenes.add(new Integer(i));
                        } else {
                            this.sigFlag[i] = false;
                            nonSigGenes.add(new Integer(i));
                        }
                    } else if (this.sigMethod == 325) {
                        float thresh = (float)((double)this.alpha / (double)this.numGenes);
                        if (currentProb <= thresh) {
                            this.sigFlag[i] = true;
                            sigGenes.add(new Integer(i));
                        } else {
                            this.sigFlag[i] = false;
                            nonSigGenes.add(new Integer(i));
                        }
                    }
                    ++i;
                }
            } else if (this.sigMethod == 326) {
                float[] pValues = new float[this.numGenes];
                int i = 0;
                while (i < this.numGenes) {
                    pValues[i] = this.getSomeCombsOneClassProb(i);
                    ++i;
                }
                int i6 = 0;
                while (i6 < pValues.length) {
                    this.pValuesVector.add(new Float(pValues[i6]));
                    ++i6;
                }
                int denomAlpha = this.numGenes;
                double adjAlpha = (double)this.alpha / (double)denomAlpha;
                QSort sortPVals = new QSort(pValues);
                float[] sortedPValues = sortPVals.getSorted();
                int[] sortedIndices = sortPVals.getOrigIndx();
                int i7 = sortedPValues.length - 1;
                while (i7 >= 0) {
                    if ((double)sortedPValues[i7] <= adjAlpha) {
                        this.sigFlag[i7] = true;
                        sigGenes.add(new Integer(sortedIndices[i7]));
                    } else {
                        this.sigFlag[i7] = false;
                        nonSigGenes.add(new Integer(sortedIndices[i7]));
                    }
                    if (i7 < sortedPValues.length - 1) {
                        if (sortedPValues[i7] < sortedPValues[i7 + 1] && --denomAlpha < 1) {
                            System.out.println("Warning: denomAlpha = " + denomAlpha);
                        }
                    } else if (denomAlpha < 1) {
                        System.out.println("Warning: denomAlpha = " + denomAlpha);
                    }
                    adjAlpha = this.alpha / (float)denomAlpha;
                    --i7;
                }
            }
        }
        return null;
    }

    private boolean isSigOneClass(int gene) {
        boolean isSig = false;
        float[] currGeneArray = this.getLogRatiosForGene(gene);
        double tValue = this.getOneClassTValue(currGeneArray);
        if (Double.isNaN(tValue)) {
            this.pValuesVector.add(new Float(Float.NaN));
            return false;
        }
        int validNum = 0;
        int i = 0;
        while (i < currGeneArray.length) {
            if (!Float.isNaN(currGeneArray[i])) {
                ++validNum;
            }
            ++i;
        }
        int df = validNum - 1;
        TDistribution tDist = new TDistribution(df);
        double prob = 1.0 - tDist.prob(-1.0 * Math.abs(tValue), Math.abs(tValue));
        if (prob > 1.0) {
            prob = 1.0;
        }
        this.pValuesVector.add(new Float((float)prob));
        if (this.sigMethod == 324) {
            if (prob <= (double)this.alpha) {
                isSig = true;
                return true;
            }
            isSig = false;
            return false;
        }
        if (this.sigMethod == 325) {
            double thresh = (double)this.alpha / (double)this.numGenes;
            if (prob <= thresh) {
                isSig = true;
                return true;
            }
            isSig = false;
            return false;
        }
        return isSig;
    }

    private float getProb(float tValue, int df) {
        TDistribution tDist = new TDistribution(df);
        double prob = 1.0 - tDist.prob(-1.0f * Math.abs(tValue), Math.abs(tValue));
        if (prob > 1.0) {
            prob = 1.0;
        }
        return (float)prob;
    }

    private float getMean(float[] group) {
        float sum = 0.0f;
        int n = 0;
        int i = 0;
        while (i < group.length) {
            if (!Float.isNaN(group[i])) {
                sum += group[i];
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = sum / (float)n;
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getGeoMean(float[] group) {
        float prod = 1.0f;
        int n = 0;
        int i = 0;
        while (i < group.length) {
            if (!Float.isNaN(group[i])) {
                prod *= group[i];
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float mean = MathTools.nthRoot(prod, n);
        if (Float.isInfinite(mean)) {
            return Float.NaN;
        }
        return mean;
    }

    private float getSomeCombsOneClassProb(int gene) {
        float[] currentGene = this.getLogRatiosForGene(gene);
        float[] origGeneValues = this.getOneClassGeneValues(gene);
        float origOneClassT = (float)Math.abs(this.getOneClassTValue(origGeneValues));
        if (Float.isNaN(origOneClassT)) {
            return Float.NaN;
        }
        Random rand = new Random();
        long[] randomSeeds = new long[this.pValBase];
        int i = 0;
        while (i < this.pValBase) {
            randomSeeds[i] = rand.nextLong();
            ++i;
        }
        int exceedCount = 0;
        int i2 = 0;
        while (i2 < this.pValBase) {
            boolean[] changeSign = this.getSomeCombsPermutArray(randomSeeds[i2]);
            float[] randomizedGene = new float[origGeneValues.length];
            int l = 0;
            while (l < changeSign.length) {
                randomizedGene[l] = changeSign[l] ? origGeneValues[l] - 2.0f * (origGeneValues[l] - this.hypoMean) : origGeneValues[l];
                ++l;
            }
            double randTValue = Math.abs(this.getOneClassTValue(randomizedGene));
            if (randTValue > (double)origOneClassT) {
                ++exceedCount;
            }
            ++i2;
        }
        double prob = (double)exceedCount / (double)this.pValBase;
        return (float)prob;
    }

    private boolean[] getSomeCombsPermutArray(long seed) {
        boolean[] boolArray = new boolean[this.numExps];
        int i = 0;
        while (i < boolArray.length) {
            boolArray[i] = false;
            ++i;
        }
        Random generator2 = new Random(seed);
        int i2 = 0;
        while (i2 < boolArray.length) {
            boolArray[i2] = generator2.nextBoolean();
            ++i2;
        }
        return boolArray;
    }

    private float getAllCombsOneClassProb(int gene) {
        int numAllPossOneClassPerms = (int)Math.pow(2.0, this.numExps);
        float[] currentGene = this.getLogRatiosForGene(gene);
        float[] origGeneValues = this.getOneClassGeneValues(gene);
        float origOneClassT = (float)Math.abs(this.getOneClassTValue(origGeneValues));
        if (Float.isNaN(origOneClassT)) {
            return Float.NaN;
        }
        int exceedCount = 0;
        int j = 0;
        while (j < numAllPossOneClassPerms) {
            boolean[] changeSign = this.getOneClassPermutArray(j);
            float[] randomizedGene = new float[currentGene.length];
            int l = 0;
            while (l < changeSign.length) {
                randomizedGene[l] = changeSign[l] ? currentGene[l] - 2.0f * (currentGene[l] - this.hypoMean) : currentGene[l];
                ++l;
            }
            double randTValue = Math.abs(this.getOneClassTValue(randomizedGene));
            if (randTValue > (double)origOneClassT) {
                ++exceedCount;
            }
            ++j;
        }
        double prob = (double)exceedCount / (double)numAllPossOneClassPerms;
        return (float)prob;
    }

    boolean[] getOneClassPermutArray(int num) {
        boolean[] oneClassPermutArray = new boolean[this.numExps];
        int i = 0;
        while (i < oneClassPermutArray.length) {
            oneClassPermutArray[i] = false;
            ++i;
        }
        String binaryString = Integer.toBinaryString(num);
        char[] binArray = binaryString.toCharArray();
        int i2 = 0;
        while (i2 < oneClassPermutArray.length) {
            oneClassPermutArray[i2] = binArray[i2] == '1';
            ++i2;
        }
        return oneClassPermutArray;
    }

    private float[] getOneClassGeneValues(int geneNdx) {
        float[] currGeneArray = new float[this.numExps];
        int i = 0;
        while (i < this.numExps) {
            currGeneArray[i] = this.folderLogRatio[i][geneNdx];
            ++i;
        }
        return currGeneArray;
    }

    private double getOneClassTValue(float[] geneArray) {
        float mean = this.getMean(geneArray);
        double stdDev = Math.sqrt(this.getVar(geneArray));
        int validNum = 0;
        int i = 0;
        while (i < geneArray.length) {
            if (!Float.isNaN(geneArray[i])) {
                ++validNum;
            }
            ++i;
        }
        double stdErr = stdDev / Math.sqrt(validNum);
        double tValue = (double)(mean - this.hypoMean) / stdErr;
        return tValue;
    }

    private int getOneClassDFValue(float[] geneArray) {
        int validNum = 0;
        int i = 0;
        while (i < geneArray.length) {
            if (!Float.isNaN(geneArray[i])) {
                ++validNum;
            }
            ++i;
        }
        int df = validNum - 1;
        return df;
    }

    private float getVar(float[] group) {
        float mean = this.getMean(group);
        int n = 0;
        float sumSquares = 0.0f;
        int i = 0;
        while (i < group.length) {
            if (!Float.isNaN(group[i])) {
                sumSquares = (float)((double)sumSquares + Math.pow(group[i] - mean, 2.0));
                ++n;
            }
            ++i;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float var = sumSquares / (float)(n - 1);
        if (Float.isInfinite(var)) {
            return Float.NaN;
        }
        return var;
    }

    public ColumnWorker[] getOneClassTtestColumnWorker() {
        return this.groupCW;
    }

    private void checkFreeMem() {
        long fm = Runtime.getRuntime().freeMemory();
        if (fm < 10000L) {
            System.out.println("--------------------------");
            System.out.println("    Free Mem: " + fm + ", perform GC");
            System.gc();
            MemObserver.mem("    After GC");
        }
    }

    public static void main(String[] args) {
        ColumnWorker[] folderCW = new ColumnWorker[6];
        String path = "C:\\DataFiles0\\mev files\\BryanData\\";
        String[] f = new String[]{"NFE005d0001.mev", "NFE005d0002.mev", "NFE005d0003.mev", "NFE005d0004.mev", "NFE005d0005.mev", "NFE005d0006.mev", "NFE005d0007.mev", "NFE005d0008.mev"};
        try {
            int fileNdx = 0;
            while (fileNdx < 6) {
                folderCW[fileNdx] = new ColumnWorker(path + f[fileNdx]);
                folderCW[fileNdx].setColumnsForUID();
                folderCW[fileNdx].setColumnsForMeta(2, 3);
                folderCW[fileNdx].setColumns(6, 7);
                System.out.println("------ > Done with reading " + path + f[fileNdx]);
                ++fileNdx;
            }
            Ttest ttest = new Ttest(folderCW, 0.0f, -323, 0.05f, 324);
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

