/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.graph.plot;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlotFileParser {
    private String fName;
    private int dataCount;
    private String[] params;

    public PlotFileParser(String fName) {
        this.fName = fName;
        this.dataCount = this.getCnt();
    }

    protected String getFileName() {
        return this.fName;
    }

    protected int getDataCount() {
        return this.dataCount;
    }

    private int getCnt() {
        int cnt = 0;
        String ln = "";
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fName));
            do {
                ln = inFile.readLine();
                ++cnt;
            } while (ln.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cnt;
    }

    protected float[][] getColArrays(int[] col) throws FileNotFoundException, NumberFormatException, Exception {
        float[][] colArray = new float[col.length][this.dataCount];
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fName));
            do {
                line = inFile.readLine();
                StringTokenizer st = new StringTokenizer(line, "\t");
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                int i = 0;
                while (i < col.length) {
                    colArray[i][rowCount] = Float.parseFloat(inputRowVec.elementAt(col[i]).toString());
                    ++i;
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return colArray;
    }

    protected double[][] getColArraysWithParams(int numParams, int[] col) throws FileNotFoundException, NumberFormatException, Exception {
        double[][] colArray = new double[col.length][this.dataCount - numParams];
        this.params = new String[numParams];
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fName));
            do {
                line = inFile.readLine();
                if (rowCount < numParams) {
                    this.params[rowCount] = line;
                } else {
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    int i = 0;
                    while (i < col.length) {
                        colArray[i][rowCount - numParams] = Double.parseDouble(inputRowVec.elementAt(col[i]).toString());
                        ++i;
                    }
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return colArray;
    }

    protected String[] getParams() {
        return this.params;
    }
}

