/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.math;

import java.text.DecimalFormat;
import java.util.BitSet;

public class MathTools {
    public static final double LN10 = Math.log(10.0);
    public static final double LN2 = Math.log(2.0);

    public static final boolean even(long n) {
        return (n & 1L) == 0L;
    }

    public static final boolean odd(long n) {
        return (n & 1L) != 0L;
    }

    public static final float sqr(float x) {
        if (x == 0.0f) {
            return 0.0f;
        }
        return x * x;
    }

    public static final float cubeRoot(float x) {
        float value = 0.0f;
        value = (double)x < 0.0 ? -((float)Math.exp(Math.log(-x) / 3.0)) : (float)Math.exp(Math.log(x) / 3.0);
        return value;
    }

    public static final float nthRoot(float x, long n) {
        float value = 0.0f;
        if (MathTools.even(n)) {
            if ((double)x > 0.0) {
                value = (float)Math.exp(Math.log(x) / (double)n);
            } else if (x == 0.0f) {
                value = 0.0f;
            } else {
                System.out.print("Invalid number!");
                value = 0.0f;
            }
        } else {
            value = (double)x > 0.0 ? (float)Math.exp(Math.log(x) / (double)n) : (x == 0.0f ? 0.0f : -((float)Math.exp(Math.log(-x) / (double)n)));
        }
        return value;
    }

    public static final long lpow(long a, long b) throws ArithmeticException {
        if (b < 0L) {
            throw new ArithmeticException("Exponent must be positive.");
        }
        long r = 1L;
        while (b != 0L) {
            if (MathTools.odd(b)) {
                r *= a;
            }
            b >>>= 1;
            a *= a;
        }
        return r;
    }

    public static final long pow2(long x) {
        long value = 1L;
        long i = 0L;
        while (i < x) {
            value *= 2L;
            ++i;
        }
        return value;
    }

    public static final float pow10(int x) {
        float pow10 = 10.0f;
        if (x != 0) {
            boolean neg = false;
            if (x < 0) {
                x *= -1;
                neg = true;
            }
            int i = 1;
            while (i < x) {
                pow10 *= 10.0f;
                ++i;
            }
            if (neg) {
                pow10 = 1.0f / pow10;
            }
        } else {
            pow10 = 1.0f;
        }
        return pow10;
    }

    public static final float log10(float x) {
        return (float)(Math.log(x) / LN10);
    }

    public static final float log2(float x) {
        return (float)(Math.log(x) / LN2);
    }

    public static final float roundUpToPlace(float value, int place) {
        if (place > 0) {
            float pow10 = MathTools.pow10(place);
            if (value >= 0.0f) {
                float holdvalue = value * pow10;
                if ((double)((value = (float)Math.ceil(holdvalue)) - holdvalue) > 0.5) {
                    value = (float)Math.floor(holdvalue);
                }
                value /= pow10;
            } else {
                float holdvalue = -1.0f * value * pow10;
                if ((double)((value = (float)Math.ceil(holdvalue)) - holdvalue) > 0.5) {
                    value = (float)Math.floor(holdvalue);
                }
                value /= pow10;
                value *= -1.0f;
            }
        } else if (place < 0) {
            float pow10 = MathTools.pow10(place *= -1);
            if (value >= 0.0f) {
                float holdvalue = value / pow10;
                if ((double)((value = (float)Math.ceil(holdvalue)) - holdvalue) > 0.5) {
                    value = (float)Math.floor(holdvalue);
                }
                value *= pow10;
            } else {
                float holdvalue = -1.0f * value / pow10;
                if ((double)((value = (float)Math.ceil(holdvalue)) - holdvalue) > 0.5) {
                    value = (float)Math.floor(holdvalue);
                }
                value *= pow10;
                value *= -1.0f;
            }
        } else {
            value = value >= 0.0f ? (float)Math.ceil(value) : (float)Math.floor(value);
        }
        return value;
    }

    public static final long greatestCommonDivisor(long xval, long yval) {
        long value = 0L;
        while (value != xval) {
            if (xval < yval) {
                yval -= xval;
                continue;
            }
            if (xval > yval) {
                xval -= yval;
                continue;
            }
            value = xval;
        }
        return value;
    }

    public static final float frac(float x) {
        if ((double)(x -= (float)((long)x)) < 0.0) {
            x += 1.0f;
        }
        return x;
    }

    public static final float lineInterp(float x1, float y1, float x2, float y2, float x) {
        return (y2 - y1) / (x2 - x1) * (x - x1) + y1;
    }

    public static final void dec2bin(int decimal, BitSet bits) {
        if (decimal < 0) {
            throw new IllegalArgumentException("Cannot convert a negative number to binary.");
        }
        int i = 0;
        int value = decimal;
        while (value > 0) {
            if (value % 2 > 0) {
                bits.set(i);
            } else {
                bits.clear(i);
            }
            value /= 2;
            ++i;
        }
        while (i < bits.size()) {
            bits.clear(i);
            ++i;
        }
    }

    public static final long bin2dec(BitSet bits) {
        long value = 0L;
        int length = bits.size();
        int i = 0;
        while (i < length) {
            if (bits.get(i)) {
                value += MathTools.pow2(i);
            }
            ++i;
        }
        return value;
    }

    public static float hypot(float a, float b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = (float)((double)Math.abs(a) * Math.sqrt(1.0 + r * r));
        } else if (b != 0.0f) {
            r = a / b;
            r = (float)((double)Math.abs(b) * Math.sqrt(1.0 + r * r));
        } else {
            r = 0.0;
        }
        return (float)r;
    }

    private static String sciNote(float a, int place) {
        DecimalFormat format = new DecimalFormat("0.#E0");
        String s = format.format(123456.789);
        System.out.println(s);
        return "";
    }

    public static void main(String[] args) {
        System.out.println(MathTools.sciNote(0.0f, 1));
        System.out.println("  1346.466745676 rounded up to the nearest -1 is " + MathTools.roundUpToPlace(1346.4668f, -1));
        System.out.println("  1346.466745676 rounded up to the nearest 1 is " + MathTools.roundUpToPlace(1346.4668f, 1));
        System.out.println("  1346.466745676 rounded up to the nearest 0 is " + MathTools.roundUpToPlace(1346.4668f, 0));
        System.out.println("  -1346.466745676 rounded up to the nearest -1 is " + MathTools.roundUpToPlace(-1346.4668f, -1));
        System.out.println("  -1346.466745676 rounded up to the nearest 1 is " + MathTools.roundUpToPlace(-1346.4668f, 1));
        System.out.println("  -1346.466745676 rounded up to the nearest 0 is " + MathTools.roundUpToPlace(-1346.4668f, 0));
    }
}

