/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.math;

import java.util.Vector;

public class QSort {
    private int[] origIndx;
    private float[] sorted;
    private double[] sortedDouble;
    private int[] NaNIndices;
    private int[] negInfinityIndices;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private boolean ascending;

    public QSort(float[] origA) {
        float[] copyA = new float[origA.length];
        this.ascending = true;
        Vector<Integer> NaNIndicesVector = new Vector<Integer>();
        Vector<Integer> negInfinityIndicesVector = new Vector<Integer>();
        int i = 0;
        while (i < copyA.length) {
            copyA[i] = origA[i];
            if (Float.isNaN(origA[i])) {
                NaNIndicesVector.add(new Integer(i));
                copyA[i] = Float.NEGATIVE_INFINITY;
            }
            if (Float.isInfinite(origA[i]) && origA[i] < 0.0f) {
                negInfinityIndicesVector.add(new Integer(i));
            }
            ++i;
        }
        this.NaNIndices = new int[NaNIndicesVector.size()];
        int i2 = 0;
        while (i2 < this.NaNIndices.length) {
            this.NaNIndices[i2] = (Integer)NaNIndicesVector.get(i2);
            ++i2;
        }
        this.negInfinityIndices = new int[negInfinityIndicesVector.size()];
        int i3 = 0;
        while (i3 < this.negInfinityIndices.length) {
            this.negInfinityIndices[i3] = (Integer)negInfinityIndicesVector.get(i3);
            ++i3;
        }
        this.sort(copyA);
    }

    public QSort(double[] origA) {
        double[] copyA = new double[origA.length];
        this.ascending = true;
        Vector<Integer> NaNIndicesVector = new Vector<Integer>();
        Vector<Integer> negInfinityIndicesVector = new Vector<Integer>();
        int i = 0;
        while (i < copyA.length) {
            copyA[i] = origA[i];
            if (Double.isNaN(origA[i])) {
                NaNIndicesVector.add(new Integer(i));
                copyA[i] = Double.NEGATIVE_INFINITY;
            }
            if (Double.isInfinite(origA[i]) && origA[i] < 0.0) {
                negInfinityIndicesVector.add(new Integer(i));
            }
            ++i;
        }
        this.NaNIndices = new int[NaNIndicesVector.size()];
        int i2 = 0;
        while (i2 < this.NaNIndices.length) {
            this.NaNIndices[i2] = (Integer)NaNIndicesVector.get(i2);
            ++i2;
        }
        this.negInfinityIndices = new int[negInfinityIndicesVector.size()];
        int i3 = 0;
        while (i3 < this.negInfinityIndices.length) {
            this.negInfinityIndices[i3] = (Integer)negInfinityIndicesVector.get(i3);
            ++i3;
        }
        this.sort(copyA);
    }

    public QSort(float[] origA, int ascOrDesc) {
        this(origA);
        if (ascOrDesc == 1) {
            this.ascending = true;
        } else if (ascOrDesc == 2) {
            this.ascending = false;
        }
    }

    public QSort(double[] origA, int ascOrDesc) {
        this(origA);
        if (ascOrDesc == 1) {
            this.ascending = true;
        } else if (ascOrDesc == 2) {
            this.ascending = false;
        }
    }

    public void sort(float[] a) {
        this.origIndx = new int[a.length];
        int i = 0;
        while (i <= this.origIndx.length - 1) {
            this.origIndx[i] = i;
            ++i;
        }
        this.quickSort(a, 0, a.length - 1);
    }

    public void sort(double[] a) {
        this.origIndx = new int[a.length];
        int i = 0;
        while (i <= this.origIndx.length - 1) {
            this.origIndx[i] = i;
            ++i;
        }
        this.quickSort(a, 0, a.length - 1);
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(float[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo] < mid) continue block0;
                    while (hi > lo0 && a[hi] > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
        this.sorted = a;
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(double[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && a[lo] < mid) continue block0;
                    while (hi > lo0 && a[hi] > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
        this.sortedDouble = a;
    }

    private void swap(float[] a, int i, int j) {
        float T = a[i];
        a[i] = a[j];
        a[j] = T;
        int TT = this.origIndx[i];
        this.origIndx[i] = this.origIndx[j];
        this.origIndx[j] = TT;
    }

    private void swap(double[] a, int i, int j) {
        double T = a[i];
        a[i] = a[j];
        a[j] = T;
        int TT = this.origIndx[i];
        this.origIndx[i] = this.origIndx[j];
        this.origIndx[j] = TT;
    }

    public float[] getSorted() {
        int i = 0;
        while (i < this.NaNIndices.length) {
            this.sorted[i] = Float.NaN;
            ++i;
        }
        if (!this.ascending) {
            float[] revSorted = this.reverse(this.sorted);
            return revSorted;
        }
        return this.sorted;
    }

    public double[] getSortedDouble() {
        int i = 0;
        while (i < this.NaNIndices.length) {
            this.sortedDouble[i] = Double.NaN;
            ++i;
        }
        if (!this.ascending) {
            double[] revSortedDouble = this.reverse(this.sortedDouble);
            return revSortedDouble;
        }
        return this.sortedDouble;
    }

    public int[] getOrigIndx() {
        int i = 0;
        while (i < this.NaNIndices.length) {
            this.origIndx[i] = this.NaNIndices[i];
            ++i;
        }
        int i2 = this.NaNIndices.length;
        while (i2 < this.NaNIndices.length + this.negInfinityIndices.length) {
            this.origIndx[i2] = this.negInfinityIndices[i2 - this.NaNIndices.length];
            ++i2;
        }
        if (!this.ascending) {
            return this.reverse(this.origIndx);
        }
        return this.origIndx;
    }

    private boolean isNaNIndex(int index) {
        int i = 0;
        while (i < this.NaNIndices.length) {
            if (index == this.NaNIndices[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        int i = 0;
        while (i < arr.length) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
            ++i;
        }
        return revArr;
    }

    private float[] reverse(float[] arr) {
        float[] revArr = new float[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        int i = 0;
        while (i < arr.length) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
            ++i;
        }
        return revArr;
    }

    private double[] reverse(double[] arr) {
        double[] revArr = new double[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        int i = 0;
        while (i < arr.length) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
            ++i;
        }
        return revArr;
    }

    public static void main(String[] args) {
        double[] arr = new double[]{120.0, 0.01, -4.5, Double.NaN, 7.6, -65.0, Double.NEGATIVE_INFINITY, 3.5, -0.95, Double.POSITIVE_INFINITY, 600.0, Double.NaN, 65.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE};
        QSort sortArr = new QSort(arr, 1);
        double[] sortedArr = sortArr.getSortedDouble();
        int[] sortedArrIndices = sortArr.getOrigIndx();
        int i = 0;
        while (i < sortedArr.length) {
            System.out.println("arr[" + i + "] = " + arr[i] + ", sortedArr[" + i + "] = " + sortedArr[i] + ",  sortedArrIndices[" + i + "] = " + sortedArrIndices[i]);
            ++i;
        }
    }
}

