/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mev.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import org.tigr.midas.math.MathTools;

public class FloatMatrix
implements Cloneable,
Serializable {
    public float[][] A;
    public int m;
    public int n;

    public FloatMatrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new float[m][n];
    }

    public FloatMatrix(int m, int n, float s) {
        this.m = m;
        this.n = n;
        this.A = new float[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                this.A[i][j] = s;
                ++j;
            }
            ++i;
        }
    }

    public FloatMatrix(float[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        int i = 0;
        while (i < this.m) {
            if (A[i].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
        this.A = A;
    }

    public FloatMatrix(float[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public FloatMatrix(float[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new float[m][this.n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = vals[i + j * m];
                ++j;
            }
            ++i;
        }
    }

    public static FloatMatrix constructWithCopy(float[][] A) {
        int m = A.length;
        int n = A[0].length;
        FloatMatrix X = new FloatMatrix(m, n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < m) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            int j = 0;
            while (j < n) {
                C[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix copy() {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Object clone() {
        return this.copy();
    }

    public float[][] getArray() {
        return this.A;
    }

    public float[][] getArrayCopy() {
        float[][] C = new float[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return C;
    }

    public float[] getColumnPackedCopy() {
        float[] vals = new float[this.m * this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                vals[i + j * this.m] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public float[] getRowPackedCopy() {
        float[] vals = new float[this.m * this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                vals[i * this.n + j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public float get(int i, int j) {
        return this.A[i][j];
    }

    public FloatMatrix getMatrix(int i0, int i1, int j0, int j1) {
        FloatMatrix X = new FloatMatrix(i1 - i0 + 1, j1 - j0 + 1);
        float[][] B = X.getArray();
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    B[i - i0][j - j0] = this.A[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int[] r, int[] c) {
        FloatMatrix X = new FloatMatrix(r.length, c.length);
        float[][] B = X.getArray();
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    B[i][j] = this.A[r[i]][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int i0, int i1, int[] c) {
        FloatMatrix X = new FloatMatrix(i1 - i0 + 1, c.length);
        float[][] B = X.getArray();
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    B[i - i0][j] = this.A[i][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int[] r, int j0, int j1) {
        FloatMatrix X = new FloatMatrix(r.length, j1 - j0 + 1);
        float[][] B = X.getArray();
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    B[i][j - j0] = this.A[r[i]][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public void set(int i, int j, float s) {
        this.A[i][j] = s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, FloatMatrix X) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    this.A[i][j] = X.get(i - i0, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, FloatMatrix X) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    this.A[r[i]][c[j]] = X.get(i, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, FloatMatrix X) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    this.A[r[i]][j] = X.get(i, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, FloatMatrix X) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    this.A[i][c[j]] = X.get(i - i0, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public FloatMatrix transpose() {
        FloatMatrix X = new FloatMatrix(this.n, this.m);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[j][i] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public float norm1() {
        float f = 0.0f;
        int j = 0;
        while (j < this.n) {
            float s = 0.0f;
            int i = 0;
            while (i < this.m) {
                s += Math.abs(this.A[i][j]);
                ++i;
            }
            f = Math.max(f, s);
            ++j;
        }
        return f;
    }

    public float normInf() {
        float f = 0.0f;
        int i = 0;
        while (i < this.m) {
            float s = 0.0f;
            int j = 0;
            while (j < this.n) {
                s += Math.abs(this.A[i][j]);
                ++j;
            }
            f = Math.max(f, s);
            ++i;
        }
        return f;
    }

    public float normF() {
        float f = 0.0f;
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                f = MathTools.hypot(f, this.A[i][j]);
                ++j;
            }
            ++i;
        }
        return f;
    }

    public FloatMatrix uminus() {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = -this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix plus(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] + B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix plusEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] + B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix minus(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix minusEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix arrayTimes(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] * B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix arrayTimesEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] * B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix arrayRightDivide(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] / B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix arrayRightDivideEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] / B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix arrayLeftDivide(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = B.A[i][j] / this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix arrayLeftDivideEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = B.A[i][j] / this.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix times(float s) {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = s * this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public FloatMatrix timesEquals(float s) {
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = s * this.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public FloatMatrix times(FloatMatrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        FloatMatrix X = new FloatMatrix(this.m, B.n);
        float[][] C = X.getArray();
        float[] Bcolj = new float[this.n];
        int j = 0;
        while (j < B.n) {
            int k = 0;
            while (k < this.n) {
                Bcolj[k] = B.A[k][j];
                ++k;
            }
            int i = 0;
            while (i < this.m) {
                float[] Arowi = this.A[i];
                float s = 0.0f;
                int k2 = 0;
                while (k2 < this.n) {
                    s += Arowi[k2] * Bcolj[k2];
                    ++k2;
                }
                C[i][j] = s;
                ++i;
            }
            ++j;
        }
        return X;
    }

    public float trace() {
        float t = 0.0f;
        int i = 0;
        while (i < Math.min(this.m, this.n)) {
            t += this.A[i][i];
            ++i;
        }
        return t;
    }

    public static FloatMatrix random(int m, int n) {
        FloatMatrix A = new FloatMatrix(m, n);
        float[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = (float)Math.random();
                ++j;
            }
            ++i;
        }
        return A;
    }

    public static FloatMatrix identity(int m, int n) {
        FloatMatrix A = new FloatMatrix(m, n);
        float[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = (float)(i == j ? 1.0 : 0.0);
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                String s = format.format(this.A[i][j]);
                int padding = Math.max(1, width - s.length());
                int k = 0;
                while (k < padding) {
                    output.print(' ');
                    ++k;
                }
                output.print(s);
                ++j;
            }
            output.println();
            ++i;
        }
        output.println();
    }

    public static FloatMatrix read(BufferedReader input) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Object> v = new Vector<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.addElement(Float.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        float[] row = new float[n];
        int j = 0;
        while (j < n) {
            row[j] = ((Float)v.elementAt(j)).floatValue();
            ++j;
        }
        v.removeAllElements();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new float[n];
            v.addElement(row);
            int j2 = 0;
            do {
                if (j2 >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j2++] = Float.valueOf(tokenizer.sval).floatValue();
            } while (tokenizer.nextToken() == -3);
            if (j2 >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        float[][] A = new float[m][];
        v.copyInto((Object[])A);
        return new FloatMatrix(A);
    }

    private void checkMatrixDimensions(FloatMatrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

