/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.report;

import java.util.Hashtable;
import java.util.Vector;
import org.tigr.midas.engine.MaAnovaParameter;
import org.tigr.midas.engine.Parameter;
import org.tigr.midas.engine.Project;
import org.tigr.midas.exception.ReportException;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.report.TxtReport;
import org.tigr.midas.util.CodeBook;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.StringSplitter;

public class PrepareTXTReport {
    private Project proj;
    private Vector flowVec;
    private Hashtable resultHash;
    private TxtReport rpt;
    private String[] moduleNotes;
    int fpd = 9999;
    boolean hasPairMerged = false;
    int padSpaces = 40;

    public PrepareTXTReport(Project proj) throws ReportException {
        this.proj = proj;
        this.resultHash = proj.getReportItemHash();
        StringSplitter st = new StringSplitter(proj.getFlow(), '>');
        this.flowVec = new Vector();
        while (st.hasMoreTokens()) {
            this.flowVec.add(st.nextToken());
        }
        String rptName = proj.getProjFullName().substring(0, proj.getProjFullName().length() - 4) + ".rpt";
        try {
            this.rpt = new TxtReport(rptName);
            this.reportHeader();
            this.reportGeneral();
            this.reportFlow();
            this.reportParameter();
            this.reportResult();
            this.reportTrailer();
            this.rpt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.rpt.close();
        }
    }

    public final void reportHeader() {
        this.rpt.appendLine("************************************************************************");
        this.rpt.appendLine("*                       TIGR MIDAS Analysis Report                     *");
        this.rpt.appendLine("************************************************************************");
        this.rpt.appendLine("");
    }

    public void reportGeneral() {
        System.out.println("    ---- Reporting general information ...");
        this.rpt.appendCaption("MIDAS Version: 2.19");
        this.rpt.appendStartTime(this.proj.getStartDate());
        this.rpt.appendStopTime(this.proj.getStopDate());
        this.rpt.appendCaption("Project file: " + this.proj.getProjName());
        this.rpt.appendCaption("Java Runtime Environment version: " + System.getProperty("java.version"));
        this.rpt.appendCaption("Java Runtime Environment vendor: " + System.getProperty("java.vendor"));
        this.rpt.appendCaption("Java Virtual Machine name: " + System.getProperty("java.vm.name"));
        this.rpt.appendCaption("Java Virtual Machine version: " + System.getProperty("java.vm.version"));
        this.rpt.appendCaption("Java Virtual Machine vendor: " + System.getProperty("java.vm.vendor"));
        this.rpt.appendCaption("Operating System name: " + System.getProperty("os.name"));
        this.rpt.appendCaption("Operating System version: " + System.getProperty("os.version"));
        this.rpt.appendCaption("Operating System architecture: " + System.getProperty("os.arch"));
        this.rpt.appendCaption("System MAX Memory: " + Long.toString(Runtime.getRuntime().maxMemory()));
        this.rpt.appendLine("");
    }

    public void reportFlow() {
        this.rpt.appendCaption("Process Flow:");
        int i = 0;
        while (i < this.flowVec.size()) {
            int currentCall = Integer.parseInt(this.flowVec.elementAt(i).toString());
            if (currentCall == 0) {
                this.rpt.appendText("    Read Single File");
            } else if (currentCall == 1) {
                this.rpt.appendText("    Read File Pair(s)");
            } else if (currentCall == 2) {
                this.rpt.appendText("    Read Folder Files");
            } else if (currentCall == 12) {
                this.rpt.appendText(" => Total Intensity Normalization");
            } else if (currentCall == 11) {
                this.rpt.appendText(" => Locfit Normalization");
            } else if (currentCall == 15) {
                this.rpt.appendText(" => Iterative Linear Regression Normalization");
            } else if (currentCall == 14) {
                this.rpt.appendText(" => Iterative Log Mean Centering Normalization");
            } else if (currentCall == 16) {
                this.rpt.appendText(" => Ratio Statistics Normalization & Trim");
            } else if (currentCall == 13) {
                this.rpt.appendText(" => SD Regularization");
            } else if (currentCall == 10) {
                this.rpt.appendText(" => Intensity Filter");
            } else if (currentCall == 20) {
                this.rpt.appendText(" => Slice Analysis");
            } else if (currentCall == 30) {
                this.rpt.appendText(" => In-slide Replicates Analysis");
            } else if (currentCall == 32) {
                this.rpt.appendText(" => Cross-slide Replicates Ttest");
            } else if (currentCall == 33) {
                this.rpt.appendText(" => Cross-slide One-Class SAM");
            } else if (currentCall == 40) {
                this.rpt.appendText(" => Flip-Dye Consistency Trim");
            } else if (currentCall == 41) {
                this.rpt.appendText(" => Maanova");
            } else if (currentCall == 100) {
                this.rpt.appendText(" => Write Outputs");
                this.rpt.appendLineIndentOne("");
                this.rpt.appendLineIndentOne("");
            }
            ++i;
        }
    }

    public final void reportTrailer() {
        this.rpt.appendLine("");
        this.rpt.appendLine("************************************************************************");
        this.rpt.appendLine("*                             End of Report                            *");
        this.rpt.appendLine("************************************************************************");
        this.rpt.close();
    }

    public void reportStop() {
        this.rpt.appendCaption("Process stopped for user request.\n");
        this.reportTrailer();
    }

    public void reportParameter() {
        System.out.println("    ---- Reporting parameter settings ...");
        this.rpt.appendCaption("Parameter Settings:");
        int i = 0;
        while (i < this.flowVec.size()) {
            int currentCall = Integer.parseInt(this.flowVec.elementAt(i).toString());
            if (currentCall == 0) {
                this.fpd = currentCall;
                this.readSingleParam();
            } else if (currentCall == 1) {
                this.fpd = currentCall;
                this.readPairParam();
            } else if (currentCall == 2) {
                this.fpd = currentCall;
                this.readFolderParam();
            } else if (currentCall == 12) {
                this.totalIntensityParam();
            } else if (currentCall == 11) {
                this.locfitParam();
            } else if (currentCall == 15) {
                this.iterLinRegParam();
            } else if (currentCall == 14) {
                this.iterLogMeanCenteringParam();
            } else if (currentCall == 16) {
                this.ratioStatsParam();
            } else if (currentCall == 13) {
                this.sdRegParam(this.fpd);
            } else if (currentCall == 10) {
                this.intensityFilterParam();
            } else if (currentCall == 20) {
                this.sliceAnalysisParam();
            } else if (currentCall == 30) {
                this.inSlideReplicatesAnalysisParam();
            } else if (currentCall == 32) {
                this.crossSlideTtestParam();
            } else if (currentCall == 33) {
                this.crossSlideSAMParam();
            } else if (currentCall == 40) {
                this.flipDyeParam();
            } else if (currentCall == 41) {
                this.maanovaParam();
            } else if (currentCall == 100) {
                if (this.fpd != 2) {
                    this.writeSingleParam();
                } else {
                    this.writeFolderParam();
                }
            }
            ++i;
        }
    }

    public void reportResult() {
        System.out.println("    ---- Reporting process results ...");
        this.rpt.appendLine("");
        this.rpt.appendCaption("Processing Results:");
        this.resultHash = this.proj.getReportItemHash();
        int i = 0;
        while (i < this.flowVec.size()) {
            int currentCall = Integer.parseInt(this.flowVec.elementAt(i).toString());
            if (currentCall == 0) {
                System.out.println("         Reporting raw data ...");
                this.fpd = 0;
                this.readSingleResult();
            } else if (currentCall == 1) {
                System.out.println("         Reporting raw data ...");
                this.fpd = 1;
                this.readPairResult();
            } else if (currentCall == 2) {
                System.out.println("         Reporting raw data ...");
                this.fpd = 2;
                this.readFolderResult();
            } else if (currentCall == 12) {
                System.out.println("         Reporting total intensity normalization results ...");
                this.totalIntensityResult(this.fpd);
            } else if (currentCall == 11) {
                System.out.println("         Reporting lowess normalization results ...");
                this.locfitResult(this.fpd);
            } else if (currentCall == 15) {
                System.out.println("         Reporting iterative linear regression normalization results ...");
                this.iterLinRegResult(this.fpd);
            } else if (currentCall == 14) {
                System.out.println("         Reporting iterative log mean centering normalization results ...");
                this.iterLogMeanCenteringResult(this.fpd);
            } else if (currentCall == 16) {
                System.out.println("         Reporting total intensity normalization results ...");
                this.ratioStatsResult(this.fpd);
            } else if (currentCall == 13) {
                System.out.println("         Reporting standard deviation regularization results ...");
                this.sdRegResult(this.fpd);
            } else if (currentCall == 10) {
                System.out.println("         Reporting low intensity filtering results ...");
                this.intensityFilterResult(this.fpd);
            } else if (currentCall == 20) {
                System.out.println("         Reporting slice analysis results ...");
                this.sliceAnalysisResult(this.fpd);
            } else if (currentCall == 30) {
                System.out.println("         Reporting in-slide replicates analysis results ...");
                this.inSlideReplicatesAnalysisResult(this.fpd);
            } else if (currentCall == 32) {
                System.out.println("         Reporting cross-slide replicates t-test results ...");
                this.crossSlideTtestResult();
            } else if (currentCall == 33) {
                System.out.println("         Reporting cross-slide one-class SAM results ...");
                this.crossSlideSAMResult();
            } else if (currentCall == 40) {
                System.out.println("         Reporting flip-dye consistency checking results ...");
                this.flipDyeResult();
            } else if (currentCall == 41) {
                System.out.println("         Reporting maanova results ...");
                this.maanovaResult();
            } else if (currentCall == 100) {
                System.out.println("         Reporting final results ...");
                this.writeResult(this.fpd);
            }
            ++i;
        }
        Object var2_3 = null;
    }

    public void readSingleParam() {
        this.rpt.appendLineIndentOne("Read Single File");
        this.rpt.appendLineIndentTwo(this.paddings("- Input file name :", this.padSpaces) + Parameter.pSingleFileStr);
        this.rpt.appendLineIndentTwo(this.paddings("- One Bad Channel Tolerance Policy :", this.padSpaces) + Parameter.pOneBadChannelPolicyStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 1 Flag :", this.padSpaces) + Parameter.pUseCh1FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 2 Flag :", this.padSpaces) + Parameter.pUseCh2FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 1 Background Checking :", this.padSpaces) + Parameter.pCh1BkgdOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 2 Background Checking :", this.padSpaces) + Parameter.pCh2BkgdOpt);
        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
            this.rpt.appendLineIndentTwo(this.paddings("- Background Checking S/N Threshold :", this.padSpaces) + Parameter.pBkgdSNRatioVal);
        }
    }

    public void readSingleResult() {
        Hashtable readSingleResultHash = (Hashtable)this.resultHash.get("raw_for_" + this.getFileName(Parameter.pSingleFileStr));
        this.rpt.appendLineIndentOne("Read Single File");
        this.moduleNotes = (String[])readSingleResultHash.get("module_notes");
        int i = 0;
        while (i < this.moduleNotes.length) {
            this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + readSingleResultHash.get(this.moduleNotes[i]).toString());
            ++i;
        }
        Object var1_1 = null;
    }

    public void readPairParam() {
        this.rpt.appendLineIndentOne("Read File Pair(s)");
        this.rpt.appendLineIndentTwo(this.paddings("- Input file pair(s) :", this.padSpaces) + Parameter.pFilePairVec.toString());
        this.rpt.appendLineIndentTwo(this.paddings("- One Bad Channel Tolerance Policy :", this.padSpaces) + Parameter.pOneBadChannelPolicyStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 1 Flag :", this.padSpaces) + Parameter.pUseCh1FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 2 Flag :", this.padSpaces) + Parameter.pUseCh2FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 1 Background Checking :", this.padSpaces) + Parameter.pCh1BkgdOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 2 Background Checking :", this.padSpaces) + Parameter.pCh2BkgdOpt);
        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
            this.rpt.appendLineIndentTwo(this.paddings("- Background Checking S/N Threshold :", this.padSpaces) + Parameter.pBkgdSNRatioVal);
        }
    }

    public void readPairResult() {
        Hashtable readPairResultHash = null;
        this.rpt.appendLineIndentOne("Read File Pair(s)");
        int pairNdx = 0;
        while (pairNdx < Parameter.pFilePairVec.size()) {
            Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
            String fileName1 = eachPairVec.elementAt(0).toString();
            String fileName2 = eachPairVec.elementAt(1).toString();
            readPairResultHash = (Hashtable)this.resultHash.get("raw_for_" + this.getFileName(fileName1));
            this.moduleNotes = (String[])readPairResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + readPairResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
            readPairResultHash = (Hashtable)this.resultHash.get("raw_for_" + this.getFileName(fileName2));
            this.moduleNotes = (String[])readPairResultHash.get("module_notes");
            int i2 = 0;
            while (i2 < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("  - " + this.moduleNotes[i2] + readPairResultHash.get(this.moduleNotes[i2]).toString());
                ++i2;
            }
            ++pairNdx;
        }
        Object var1_1 = null;
    }

    public void readFolderParam() {
        this.rpt.appendLineIndentOne("Read Folder Files");
        this.rpt.appendLineIndentTwo(this.paddings("- Input folder name :", this.padSpaces) + Parameter.pFolderStr);
        this.rpt.appendLineIndentTwo(this.paddings("- One Bad Channel Tolerance Policy :", this.padSpaces) + Parameter.pOneBadChannelPolicyStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 1 Flag :", this.padSpaces) + Parameter.pUseCh1FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Use Channel 2 Flag :", this.padSpaces) + Parameter.pUseCh2FlagOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 1 Background Checking :", this.padSpaces) + Parameter.pCh1BkgdOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Channel 2 Background Checking :", this.padSpaces) + Parameter.pCh2BkgdOpt);
        if (Parameter.pCh1BkgdOpt && Parameter.pCh2BkgdOpt) {
            this.rpt.appendLineIndentTwo(this.paddings("- Background Checking S/N Threshold :", this.padSpaces) + Parameter.pBkgdSNRatioVal);
        }
    }

    public void readFolderResult() {
        Hashtable readFolderResultHash = null;
        Vector fileVec = Parameter.pFolderFilesVec;
        this.rpt.appendLineIndentOne("- Read Folder Files");
        int fileNdx = 0;
        while (fileNdx < fileVec.size()) {
            String inFileName = fileVec.elementAt(fileNdx).toString();
            readFolderResultHash = (Hashtable)this.resultHash.get("raw_for_" + this.getFileName(inFileName));
            this.moduleNotes = (String[])readFolderResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + readFolderResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
            ++fileNdx;
        }
        Object var1_1 = null;
    }

    public void totalIntensityParam() {
        this.rpt.appendLineIndentOne("Total Intensity Normalization");
        this.rpt.appendLineIndentTwo(this.paddings("- Reference", this.padSpaces) + Parameter.pRefStr);
    }

    public void totalIntensityResult(int fpd) {
        Hashtable totintResultHash = null;
        this.rpt.appendLineIndentOne("Total Intensity Normalization");
        if (fpd == 0) {
            totintResultHash = (Hashtable)this.resultHash.get("totint_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])totintResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + totintResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    totintResultHash = (Hashtable)this.resultHash.get("totint_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])totintResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + totintResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    totintResultHash = (Hashtable)this.resultHash.get("totint_for_" + this.getFileName(fileName1));
                    String s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])totintResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + totintResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    totintResultHash = (Hashtable)this.resultHash.get("totint_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])totintResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + totintResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                totintResultHash = (Hashtable)this.resultHash.get("totint_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])totintResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + totintResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void locfitParam() {
        this.rpt.appendLineIndentOne("Lowess Normalization");
        this.rpt.appendLineIndentTwo(this.paddings("- Mode :", this.padSpaces) + Parameter.pLocfitModeStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Smooth Parameter :", this.padSpaces) + Parameter.pSmoothParaVal);
        this.rpt.appendLineIndentTwo(this.paddings("- Reference :", this.padSpaces) + Parameter.pRefStr);
    }

    public void locfitResult(int fpd) {
        Hashtable locfitResultHash = null;
        this.rpt.appendLineIndentOne("Lowess Normalization");
        if (fpd == 0) {
            locfitResultHash = (Hashtable)this.resultHash.get("lowess_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])locfitResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + locfitResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    locfitResultHash = (Hashtable)this.resultHash.get("lowess_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])locfitResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + locfitResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    locfitResultHash = (Hashtable)this.resultHash.get("lowess_for_" + this.getFileName(fileName1));
                    String s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])locfitResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + locfitResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    locfitResultHash = (Hashtable)this.resultHash.get("lowess_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])locfitResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + locfitResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                locfitResultHash = (Hashtable)this.resultHash.get("lowess_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])locfitResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + locfitResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void iterLinRegParam() {
        this.rpt.appendLineIndentOne("Iterative Linear Regression Normalization");
        this.rpt.appendLineIndentTwo(this.paddings("- Mode :", this.padSpaces) + Parameter.pIterLinRegModeStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Outlier Range :", this.padSpaces) + Parameter.pIterLinRegSDRangeVal);
        this.rpt.appendLineIndentTwo(this.paddings("- Reference :", this.padSpaces) + Parameter.pRefStr);
    }

    public void iterLinRegResult(int fpd) {
        Hashtable iterLinRegResultHash = null;
        this.rpt.appendLineIndentOne("Iterative Linear Regression Normalization");
        if (fpd == 0) {
            iterLinRegResultHash = (Hashtable)this.resultHash.get("iterLinReg_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])iterLinRegResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + iterLinRegResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    iterLinRegResultHash = (Hashtable)this.resultHash.get("iterLinReg_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])iterLinRegResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLinRegResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    iterLinRegResultHash = (Hashtable)this.resultHash.get("iterLinReg_for_" + this.getFileName(fileName1));
                    String s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])iterLinRegResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLinRegResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    iterLinRegResultHash = (Hashtable)this.resultHash.get("iterLinReg_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])iterLinRegResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + iterLinRegResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                iterLinRegResultHash = (Hashtable)this.resultHash.get("iterLinReg_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])iterLinRegResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLinRegResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void iterLogMeanCenteringParam() {
        this.rpt.appendLineIndentOne("Iterative Log Mean Centering");
        this.rpt.appendLineIndentTwo(this.paddings("- Data Range For Mean Centering :", this.padSpaces) + Parameter.pIterLogMeanSDRangeVal + " SD");
        this.rpt.appendLineIndentTwo(this.paddings("- Reference :", this.padSpaces) + Parameter.pRefStr);
    }

    public void iterLogMeanCenteringResult(int fpd) {
        Hashtable iterLogMeanResultHash = null;
        this.rpt.appendLineIndentOne("Iterative Log Mean Centering");
        if (fpd == 0) {
            iterLogMeanResultHash = (Hashtable)this.resultHash.get("iterLogMean_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])iterLogMeanResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + iterLogMeanResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    iterLogMeanResultHash = (Hashtable)this.resultHash.get("iterLogMean_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])iterLogMeanResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLogMeanResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    iterLogMeanResultHash = (Hashtable)this.resultHash.get("iterLogMean_for_" + this.getFileName(fileName1));
                    String s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])iterLogMeanResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLogMeanResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    iterLogMeanResultHash = (Hashtable)this.resultHash.get("iterLogMean_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])iterLogMeanResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + iterLogMeanResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                iterLogMeanResultHash = (Hashtable)this.resultHash.get("iterLogMean_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])iterLogMeanResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + iterLogMeanResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void ratioStatsParam() {
        this.rpt.appendLineIndentOne("Ratio Statistics");
        this.rpt.appendLineIndentTwo(this.paddings("- Confidence Interval Check :", this.padSpaces) + Parameter.pRatioStatsCIChkOpt);
        if (Parameter.pRatioStatsCIChkOpt) {
            this.rpt.appendLineIndentTwo(this.paddings("- Confidence Interval Range :", this.padSpaces) + Parameter.pRatioStatsCIVal + "%");
        }
        this.rpt.appendLineIndentTwo(this.paddings("- Reference :", this.padSpaces) + Parameter.pRefStr);
    }

    public void ratioStatsResult(int fpd) {
        Hashtable ratioStatsResultHash = null;
        this.rpt.appendLineIndentOne("Ratio Statistics");
        if (fpd == 0) {
            ratioStatsResultHash = (Hashtable)this.resultHash.get("ratiostats_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])ratioStatsResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + ratioStatsResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                String s;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    ratioStatsResultHash = (Hashtable)this.resultHash.get("ratiostats_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    s = this.getFileName(fileName1) + "_" + this.getFileName(fileName2);
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])ratioStatsResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + ratioStatsResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    ratioStatsResultHash = (Hashtable)this.resultHash.get("ratiostats_for_" + this.getFileName(fileName1));
                    s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])ratioStatsResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + ratioStatsResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    ratioStatsResultHash = (Hashtable)this.resultHash.get("ratiostats_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])ratioStatsResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + ratioStatsResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                ratioStatsResultHash = (Hashtable)this.resultHash.get("ratiostats_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])ratioStatsResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + ratioStatsResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void sdRegParam(int fpd) {
        this.rpt.appendLineIndentOne("SD Regularization");
        this.rpt.appendLineIndentTwo(this.paddings("- Block SD Regularization Option :", this.padSpaces) + Parameter.pBlockSDRegOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Slide SD Regularization Option :", this.padSpaces) + Parameter.pSlideSDRegOpt);
        this.rpt.appendLineIndentTwo(this.paddings("- Reference :", this.padSpaces) + Parameter.pRefStr);
    }

    public void sdRegResult(int fpd) {
        Hashtable sdRegResultHash = null;
        this.rpt.appendLineIndentOne("SD Regularization");
        if (fpd == 0) {
            sdRegResultHash = (Hashtable)this.resultHash.get("sdreg_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])sdRegResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + sdRegResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                String s;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    sdRegResultHash = (Hashtable)this.resultHash.get("sdreg_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    s = this.getFileName(fileName1) + "_" + this.getFileName(fileName2);
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])sdRegResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sdRegResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    sdRegResultHash = (Hashtable)this.resultHash.get("sdreg_for_" + this.getFileName(fileName1));
                    s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])sdRegResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sdRegResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    sdRegResultHash = (Hashtable)this.resultHash.get("sdreg_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])sdRegResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + sdRegResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                sdRegResultHash = (Hashtable)this.resultHash.get("sdreg_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])sdRegResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sdRegResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
            if (Parameter.pSlideSDRegOpt) {
                Hashtable slide_sdRegResultHash = (Hashtable)this.resultHash.get("slide_sdreg");
                this.rpt.appendLineIndentThree("- Averaged slide log-ratio SD: " + slide_sdRegResultHash.get("slide_log_ratio_sd_geo_mean").toString());
            }
        }
        Object var2_2 = null;
    }

    public void intensityFilterParam() {
        this.rpt.appendLineIndentOne("Low Intensity Filter");
        this.rpt.appendLineIndentTwo(this.paddings("- Cy3 Threshold :", this.padSpaces) + Parameter.pCy3CutoffVal);
        this.rpt.appendLineIndentTwo(this.paddings("- Cy5 Threshold :", this.padSpaces) + Parameter.pCy5CutoffVal);
    }

    public void intensityFilterResult(int fpd) {
        Hashtable intensityFilterResultHash = null;
        this.rpt.appendLineIndentOne("Low Intensity Filter");
        if (fpd == 0) {
            intensityFilterResultHash = (Hashtable)this.resultHash.get("lowFilter_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])intensityFilterResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + intensityFilterResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                String s;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    intensityFilterResultHash = (Hashtable)this.resultHash.get("lowFilter_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    s = this.getFileName(fileName1) + "_" + this.getFileName(fileName2);
                    this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])intensityFilterResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + intensityFilterResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    intensityFilterResultHash = (Hashtable)this.resultHash.get("lowFilter_for_" + this.getFileName(fileName1));
                    s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])intensityFilterResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + intensityFilterResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    intensityFilterResultHash = (Hashtable)this.resultHash.get("lowFilter_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])intensityFilterResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + intensityFilterResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                intensityFilterResultHash = (Hashtable)this.resultHash.get("lowFilter_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])intensityFilterResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + intensityFilterResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void sliceAnalysisParam() {
        this.rpt.appendLineIndentOne("Slice Analysis");
        this.rpt.appendLineIndentTwo(this.paddings("- Slice Data Point Population :", this.padSpaces) + Parameter.pSliceDataPopVal);
        if ((double)Parameter.pSliceDataRangeGtVal >= 0.0) {
            this.rpt.appendLineIndentTwo(this.paddings("- Data Keep Range > :", this.padSpaces) + Parameter.pSliceDataRangeGtVal);
        }
        if ((double)Parameter.pSliceDataRangeLtVal >= 0.0) {
            this.rpt.appendLineIndentTwo(this.paddings("- Data Keep Range < :", this.padSpaces) + Parameter.pSliceDataRangeLtVal);
        }
    }

    public void sliceAnalysisResult(int fpd) {
        Hashtable sliceAnalysisResultHash = null;
        this.rpt.appendLineIndentOne("Slice Analysis");
        if (fpd == 0) {
            sliceAnalysisResultHash = (Hashtable)this.resultHash.get("slice_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])sliceAnalysisResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + sliceAnalysisResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                int i;
                String s;
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                if (this.hasPairMerged) {
                    sliceAnalysisResultHash = (Hashtable)this.resultHash.get("slice_for_" + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    s = this.getFileName(fileName1) + "_" + this.getFileName(fileName2);
                    this.rpt.appendLineIndentTwo("- Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                    this.moduleNotes = (String[])sliceAnalysisResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sliceAnalysisResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                } else {
                    sliceAnalysisResultHash = (Hashtable)this.resultHash.get("slice_for_" + this.getFileName(fileName1));
                    s = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])sliceAnalysisResultHash.get("module_notes");
                    i = 0;
                    while (i < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sliceAnalysisResultHash.get(this.moduleNotes[i]).toString());
                        ++i;
                    }
                    sliceAnalysisResultHash = (Hashtable)this.resultHash.get("slice_for_" + this.getFileName(fileName2));
                    s = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                    this.rpt.appendLineIndentTwo("File name : " + s);
                    this.moduleNotes = (String[])sliceAnalysisResultHash.get("module_notes");
                    int i2 = 0;
                    while (i2 < this.moduleNotes.length) {
                        this.rpt.appendLineIndentThree("- " + this.moduleNotes[i2] + sliceAnalysisResultHash.get(this.moduleNotes[i2]).toString());
                        ++i2;
                    }
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                sliceAnalysisResultHash = (Hashtable)this.resultHash.get("slice_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])sliceAnalysisResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + sliceAnalysisResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void inSlideReplicatesAnalysisParam() {
        this.rpt.appendLineIndentOne("In-slide Replicates Analysis");
        this.rpt.appendLineIndentTwo(this.paddings("- Replicates Identifier :", this.padSpaces) + Parameter.pIdentifierCol.toString());
    }

    public void inSlideReplicatesAnalysisResult(int fpd) {
        Hashtable inSlideRAResultHash = null;
        this.rpt.appendLineIndentOne("In-slide Replicates Analysis");
        if (fpd == 0) {
            inSlideRAResultHash = (Hashtable)this.resultHash.get("inSliceRep_for_" + this.getFileName(Parameter.pSingleFileStr));
            this.moduleNotes = (String[])inSlideRAResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + inSlideRAResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd != 1 && fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                inSlideRAResultHash = (Hashtable)this.resultHash.get("inSliceRep_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])inSlideRAResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + inSlideRAResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    public void crossSlideTtestParam() {
        this.rpt.appendLineIndentOne("Cross-slide Ttest");
        this.rpt.appendLineIndentTwo(this.paddings("- Hypothetical Mean :", this.padSpaces) + Parameter.pTtestHypoMean);
        if (Parameter.pTtestPValBase == -323) {
            this.rpt.appendLineIndentTwo(this.paddings("- p-Value Base :", this.padSpaces) + "T-distribution");
        } else if (Parameter.pTtestPValBase == 320) {
            this.rpt.appendLineIndentTwo(this.paddings("- p-Value Base :", this.padSpaces) + "All possible permutation");
        } else {
            this.rpt.appendLineIndentTwo(this.paddings("- p-Value Base :", this.padSpaces) + Parameter.pTtestPValBase + " random permutations");
        }
        this.rpt.appendLineIndentTwo(this.paddings("- alpha :", this.padSpaces) + Parameter.pTtestAlpha);
        if (Parameter.pTtestSigMethod == 324) {
            this.rpt.appendLineIndentTwo(this.paddings("- Significence Criteria :", this.padSpaces) + "Just Alpha");
        } else if (Parameter.pTtestSigMethod == 325) {
            this.rpt.appendLineIndentTwo(this.paddings("- Significence Criteria :", this.padSpaces) + "Standard Bonferroni");
        } else if (Parameter.pTtestSigMethod == 326) {
            this.rpt.appendLineIndentTwo(this.paddings("- Significence Criteria :", this.padSpaces) + "Adjusted Bonferroni");
        }
    }

    public void crossSlideTtestResult() {
        Hashtable crossSlideTtestResultHash = null;
        this.rpt.appendLineIndentOne("Cross-slide One-class Ttest");
        if (this.fpd != 0 && this.fpd != 1 && this.fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                crossSlideTtestResultHash = (Hashtable)this.resultHash.get("ttest_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])crossSlideTtestResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + crossSlideTtestResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var1_1 = null;
    }

    public void crossSlideSAMParam() {
        this.rpt.appendLineIndentOne("Cross-slide One-class SAM");
        this.rpt.appendLineIndentTwo(this.paddings("- Hypothetical Mean :", this.padSpaces) + Parameter.pSAMHypoMean);
        this.rpt.appendLineIndentTwo(this.paddings("- Number of Permutations :", this.padSpaces) + new Integer(Parameter.pSAMPermutationsNumber).toString() + (Parameter.pSAMAllUniquePerm ? " unique" : "random"));
        this.rpt.appendLineIndentTwo(this.paddings("- S0 Calculation Method :", this.padSpaces) + CodeBook.lookup(Parameter.pSAMS0Method));
        this.rpt.appendLineIndentTwo(this.paddings("- Missing Data Imputation Method :", this.padSpaces) + (Parameter.pSAMImputationEngine == 3306 ? new Integer(Parameter.pSAMNearestNeighborsNumber).toString() : "") + CodeBook.lookup(Parameter.pSAMImputationEngine));
    }

    public void crossSlideSAMResult() {
        Hashtable crossSlideSAMResultHash = null;
        this.rpt.appendLineIndentOne("Cross-slide One-class SAM");
        if (this.fpd != 0 && this.fpd != 1 && this.fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                crossSlideSAMResultHash = (Hashtable)this.resultHash.get("sam_for_" + this.getFileName(fileName));
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])crossSlideSAMResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + crossSlideSAMResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var1_1 = null;
    }

    public void flipDyeParam() {
        String tail = "";
        if (Parameter.pFlipdyeCutOptionStr.equalsIgnoreCase("SD Cut")) {
            tail = " SD";
        }
        this.rpt.appendLineIndentOne("Flip Dye Consistency Checking");
        this.rpt.appendLineIndentTwo(this.paddings("- Data Trim Option :", this.padSpaces) + Parameter.pFlipdyeCutOptionStr);
        this.rpt.appendLineIndentTwo(this.paddings("- Cross Log Ratio Data Keep range :", this.padSpaces) + "+/-" + Parameter.pFlipdyeDataKeepRangeVal + tail);
    }

    public void flipDyeResult() {
        Hashtable flipDyeHash = null;
        this.rpt.appendLineIndentOne("Flip Dye Consistency Checking");
        int pairNdx = 0;
        while (pairNdx < Parameter.pFilePairVec.size()) {
            flipDyeHash = (Hashtable)this.resultHash.get("flip_dye_for_pair" + pairNdx);
            Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
            String fileName1 = eachPairVec.elementAt(0).toString();
            String fileName2 = eachPairVec.elementAt(1).toString();
            fileName1 = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
            fileName2 = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
            this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
            this.moduleNotes = (String[])flipDyeHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + flipDyeHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
            ++pairNdx;
        }
        this.hasPairMerged = true;
        Object var1_1 = null;
    }

    public void maanovaParam() {
        this.rpt.appendLineIndentOne("MAANOVA");
        this.rpt.appendLineIndentTwo(this.paddings("- Design :", this.padSpaces));
        String[] s_array = MaAnovaParameter.GetExpStringArray();
        int i = 0;
        while (i < MaAnovaParameter.elistSize) {
            this.rpt.appendLineIndentThree(s_array[i] + '\t' + MaAnovaParameter.GetFile(i));
            ++i;
        }
        this.rpt.appendLineIndentTwo(this.paddings("- Variety Gene Effects :", this.padSpaces) + (MaAnovaParameter.anova_model[0] == 0 ? "No" : "Yes"));
        this.rpt.appendLineIndentTwo(this.paddings("- Dye Gene Effects :", this.padSpaces) + (MaAnovaParameter.anova_model[1] == 0 ? "No" : "Yes"));
        this.rpt.appendLineIndentTwo(this.paddings("- Array Gene Effects :", this.padSpaces) + (MaAnovaParameter.anova_model[2] == 0 ? "No" : "Yes"));
    }

    public void maanovaResult() {
        Hashtable maanovaResultHash = null;
        this.rpt.appendLineIndentOne("MAANOVA");
        if (this.fpd != 0 && this.fpd != 1 && this.fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < MaAnovaParameter.elistSize) {
                String fileName = MaAnovaParameter.GetFile(fileNdx);
                maanovaResultHash = (Hashtable)this.resultHash.get("maanova_for_" + this.getFileName(fileName));
                this.moduleNotes = (String[])maanovaResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + maanovaResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var1_1 = null;
    }

    public void writeSingleParam() {
        this.rpt.appendLineIndentOne("Write Outputs");
        this.rpt.appendLineIndentTwo(this.paddings("- Virtual Trim Option :", this.padSpaces) + (Parameter.pVtrimOpt ? "Yes" : "No"));
        this.rpt.appendLineIndentTwo(this.paddings("- Output Trimmed Data Option :", this.padSpaces) + (Parameter.pUseCrossFileTrimOpt ? "Yes" : "No"));
    }

    public void writeFolderParam() {
        this.rpt.appendLineIndentOne("Write Outputs");
        this.rpt.appendLineIndentTwo(this.paddings("- Virtual Trim Option :", this.padSpaces) + (Parameter.pOutputTrimmedDataOpt ? "Yes" : "No"));
        this.rpt.appendLineIndentTwo(this.paddings("- Output Trimmed Data Option :", this.padSpaces) + (Parameter.pUseCrossFileTrimOpt ? "Yes" : "No"));
        this.rpt.appendLineIndentTwo(this.paddings("- Apply Cross File Trim Option :", this.padSpaces) + (Parameter.pUseCrossFileTrimOpt ? "Yes" : "No"));
        if (Parameter.pUseCrossFileTrimOpt) {
            String s = Float.toString(MathTools.roundUpToPlace(new Float(Parameter.pCrossFilePct).floatValue() * 100.0f, 2));
            this.rpt.appendLineIndentTwo(this.paddings("- Cross File Trim Percentage :", this.padSpaces) + s + "%");
        }
    }

    public void writeResult(int fpd) {
        Hashtable writeResultHash = null;
        this.rpt.appendLineIndentOne("Write Outputs");
        if (fpd == 0) {
            writeResultHash = (Hashtable)this.resultHash.get("write");
            this.moduleNotes = (String[])writeResultHash.get("module_notes");
            int i = 0;
            while (i < this.moduleNotes.length) {
                this.rpt.appendLineIndentTwo("- " + this.moduleNotes[i] + writeResultHash.get(this.moduleNotes[i]).toString());
                ++i;
            }
        } else if (fpd == 1) {
            int pairNdx = 0;
            while (pairNdx < Parameter.pFilePairVec.size()) {
                writeResultHash = (Hashtable)this.resultHash.get("write_for_pair_" + pairNdx);
                Vector eachPairVec = (Vector)Parameter.pFilePairVec.elementAt(pairNdx);
                String fileName1 = eachPairVec.elementAt(0).toString();
                String fileName2 = eachPairVec.elementAt(1).toString();
                fileName1 = fileName1.substring(fileName1.lastIndexOf(FileBrowser.fsep) + 1, fileName1.length());
                fileName2 = fileName2.substring(fileName2.lastIndexOf(FileBrowser.fsep) + 1, fileName2.length());
                this.rpt.appendLineIndentTwo("Pair #" + (pairNdx + 1) + " : " + this.getFileName(fileName1) + "_" + this.getFileName(fileName2));
                this.moduleNotes = (String[])writeResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + writeResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++pairNdx;
            }
        } else if (fpd == 2) {
            int fileNdx = 0;
            while (fileNdx < Parameter.pFolderFilesVec.size()) {
                String fileName = Parameter.pFolderFilesVec.elementAt(fileNdx).toString();
                writeResultHash = (Hashtable)this.resultHash.get("write_for_file_" + fileNdx);
                String s = fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.length());
                this.rpt.appendLineIndentTwo("File name : " + s);
                this.moduleNotes = (String[])writeResultHash.get("module_notes");
                int i = 0;
                while (i < this.moduleNotes.length) {
                    this.rpt.appendLineIndentThree("- " + this.moduleNotes[i] + writeResultHash.get(this.moduleNotes[i]).toString());
                    ++i;
                }
                ++fileNdx;
            }
        }
        Object var2_2 = null;
    }

    private String getFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(FileBrowser.fsep) + 1, fileName.lastIndexOf(46));
    }

    private String StringSizeMask(String s, int size) {
        String space = "";
        int i = 0;
        while (i < size - s.length()) {
            space = space + " ";
            ++i;
        }
        return s.toUpperCase() + space;
    }

    protected String paddings(String s, int upto) {
        String sp = "";
        int i = 0;
        while (i < upto - s.length()) {
            sp = sp + " ";
            ++i;
        }
        return s + sp;
    }
}

