/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Vector;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.math.QSort;
import org.tigr.midas.math.StatsTools;
import org.tigr.midas.util.ArrayResizer;
import org.tigr.midas.util.FileBrowser;
import org.tigr.midas.util.StringSplitter;
import org.tigr.midas.util.VecToArray;
import org.tigr.midas.util.mevFileParser.FieldNotFoundException;
import org.tigr.midas.util.mevFileParser.MevFileParser;

public class ColumnWorker {
    private String fileName;
    private int count;
    private int nonZeroCount;
    private int[] metaRow;
    private int[] metaCol;
    private String[] metaCombo;
    private long colOneTotal;
    private long colTwoTotal;
    private float col12Ratio;
    private float[] colOneArrayRaw;
    private float[] colTwoArrayRaw;
    private float[] colOneArray;
    private float[] colTwoArray;
    private float[] plainRatioArray;
    private float[] logProdArray;
    private float[] logRatioArray;
    private float[] colOneBkgdArray;
    private float[] colTwoBkgdArray;
    private float[] snRatioOne;
    private float[] snRatioTwo;
    private boolean[] rowFlag;
    private boolean[] channelFlag1;
    private boolean[] channelFlag2;
    private int[] colThreeArray;
    private String[] colThreeArrayStr;
    private String[] colFourArrayStr;
    private String[] featNameArray;
    private int[] ndxArray;
    private String[] uidArrayStr;
    private MevFileParser mfp;
    public int file_type;
    public boolean repNotCombined;

    public ColumnWorker(String fName) throws Exception {
        block9: {
            this.repNotCombined = true;
            if (fName.endsWith(".mev")) {
                this.file_type = 11100;
                this.fileName = fName;
                this.mfp = new MevFileParser();
                File thisFile = new File(fName);
                try {
                    if (MevFileParser.validate(thisFile) == 1) {
                        this.mfp.loadFile(thisFile);
                        Vector uidVec = this.mfp.getColumnNamed("UID");
                        this.initializeArrays(uidVec.size());
                        break block9;
                    }
                    System.out.println("Invalid MEV file: " + fName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.file_type = 11102;
                this.fileName = fName;
                int cnt = 0;
                String ln = "";
                try {
                    BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                    do {
                        ln = inFile.readLine();
                        ++cnt;
                    } while (ln.length() != 0);
                }
                catch (NullPointerException e) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                this.initializeArrays(cnt - 1);
            }
        }
    }

    public ColumnWorker(int size) {
        this.repNotCombined = true;
        this.metaRow = new int[size];
        this.metaCol = new int[size];
        this.metaCombo = new String[size];
        this.colOneArray = new float[size];
        this.colTwoArray = new float[size];
        this.colOneArrayRaw = new float[size];
        this.colTwoArrayRaw = new float[size];
        this.colOneBkgdArray = new float[size];
        this.colTwoBkgdArray = new float[size];
        this.snRatioOne = new float[size];
        this.snRatioTwo = new float[size];
        this.rowFlag = new boolean[size];
        this.channelFlag1 = new boolean[size];
        this.channelFlag2 = new boolean[size];
        this.colThreeArray = new int[size];
        this.colThreeArrayStr = new String[size];
        this.colFourArrayStr = new String[size];
        this.featNameArray = new String[size];
        this.ndxArray = new int[size];
        this.uidArrayStr = new String[size];
        this.count = 0;
        this.colOneTotal = 0L;
        this.colTwoTotal = 0L;
        this.col12Ratio = 0.0f;
    }

    public void initializeArrays(int size) {
        this.metaRow = new int[size];
        this.metaCol = new int[size];
        this.metaCombo = new String[size];
        this.colOneArray = new float[size];
        this.colTwoArray = new float[size];
        this.colOneArrayRaw = new float[size];
        this.colTwoArrayRaw = new float[size];
        this.colOneBkgdArray = new float[size];
        this.colTwoBkgdArray = new float[size];
        this.snRatioOne = new float[size];
        this.snRatioTwo = new float[size];
        this.rowFlag = new boolean[size];
        this.channelFlag1 = new boolean[size];
        this.channelFlag2 = new boolean[size];
        this.colThreeArray = new int[size];
        this.colThreeArrayStr = new String[size];
        this.colFourArrayStr = new String[size];
        this.featNameArray = new String[size];
        this.ndxArray = new int[size];
        this.uidArrayStr = new String[size];
        this.count = 0;
        this.colOneTotal = 0L;
        this.colTwoTotal = 0L;
        this.col12Ratio = 0.0f;
    }

    public void setColumnsForMeta() {
        try {
            Vector v1 = this.mfp.getColumnNamed("MR");
            Vector v2 = this.mfp.getColumnNamed("MC");
            int rowCount = 0;
            while (rowCount < v1.size()) {
                this.metaCombo[rowCount] = v1.elementAt(rowCount).toString() + v2.elementAt(rowCount).toString();
                ++rowCount;
            }
            this.count = v1.size();
        }
        catch (FieldNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void setColumnsForMeta(int col1, int col2) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            this.setColumnsForMeta();
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.metaCombo[rowCount] = inputRowVec.elementAt(col1).toString() + "_" + inputRowVec.elementAt(col2).toString();
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.metaCombo = new ArrayResizer(this.metaCombo, rowCount).getSArray();
            this.metaRow = new ArrayResizer(this.metaRow, rowCount).getIArray();
            this.metaCol = new ArrayResizer(this.metaCol, rowCount).getIArray();
            this.count = rowCount;
        }
    }

    public void setColumnsForUID() {
        if (this.file_type == 11100) {
            try {
                Vector v1 = this.mfp.getColumnNamed("UID");
                this.uidArrayStr = VecToArray.toString(v1);
                this.count = v1.size();
            }
            catch (FieldNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.uidArrayStr = null;
        }
    }

    public void setColumnForIdentifier(Object colId) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            try {
                Vector v1 = this.mfp.getColumnNamed(colId.toString());
                this.featNameArray = VecToArray.toString(v1);
                this.count = v1.size();
            }
            catch (FieldNotFoundException ex) {
                ex.printStackTrace();
            }
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            int nn = (Integer)colId;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.featNameArray[rowCount] = inputRowVec.elementAt(nn - 1).toString();
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.featNameArray = new ArrayResizer(this.featNameArray, rowCount).getSArray();
            this.count = rowCount;
        }
    }

    public void setOneColumn(int col) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col).toString());
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.colOneArray = new ArrayResizer(this.colOneArray, rowCount).getFArray();
        this.count = rowCount;
    }

    public void setColumnsForIAIB() {
        try {
            Vector aVec = this.mfp.getColumnNamed("IA");
            Vector bVec = this.mfp.getColumnNamed("IB");
            this.colOneArray = VecToArray.toFloat(aVec);
            this.colTwoArray = VecToArray.toFloat(bVec);
            int rowCount = 0;
            while (rowCount < this.colOneArray.length) {
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                this.channelFlag1[rowCount] = true;
                this.channelFlag2[rowCount] = true;
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = aVec.size();
        }
        catch (FieldNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void setColumns(int col1, int col2) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            this.setColumnsForIAIB();
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.colOneArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col1).toString());
                    this.colTwoArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col2).toString());
                    this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                    this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                    this.channelFlag1[rowCount] = true;
                    this.channelFlag2[rowCount] = true;
                    boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                    if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                        this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                        this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                    }
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = rowCount;
            this.colOneArray = new ArrayResizer(this.colOneArray, rowCount).getFArray();
            this.colTwoArray = new ArrayResizer(this.colTwoArray, rowCount).getFArray();
            this.colOneArrayRaw = new ArrayResizer(this.colOneArrayRaw, rowCount).getFArray();
            this.colTwoArrayRaw = new ArrayResizer(this.colTwoArrayRaw, rowCount).getFArray();
            this.channelFlag1 = new ArrayResizer(this.channelFlag1, rowCount).getBArray();
            this.channelFlag2 = new ArrayResizer(this.channelFlag2, rowCount).getBArray();
            this.rowFlag = new ArrayResizer(this.rowFlag, rowCount).getBArray();
        }
    }

    public void setColumnsForIAIBwithOneFlag() {
        try {
            Vector aVec = this.mfp.getColumnNamed("IA");
            Vector bVec = this.mfp.getColumnNamed("IB");
            Vector f1Vec = this.mfp.getColumnNamed("Flag");
            this.colOneArray = VecToArray.toFloat(aVec);
            this.colTwoArray = VecToArray.toFloat(bVec);
            this.colThreeArrayStr = VecToArray.toString(f1Vec);
            int rowCount = 0;
            while (rowCount < this.colOneArray.length) {
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                if (this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C")) {
                    this.channelFlag1[rowCount] = true;
                    this.channelFlag2[rowCount] = true;
                } else {
                    this.channelFlag1[rowCount] = false;
                    this.channelFlag2[rowCount] = false;
                }
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0f;
                    this.colTwoArray[rowCount] = 0.0f;
                }
                if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = aVec.size();
        }
        catch (FieldNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void setColumns(int col1, int col2, int col3) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            this.setColumnsForIAIBwithOneFlag();
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.colOneArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col1).toString());
                    this.colTwoArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col2).toString());
                    this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                    this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                    this.colThreeArrayStr[rowCount] = inputRowVec.elementAt(col3).toString();
                    if (this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C")) {
                        this.channelFlag1[rowCount] = true;
                        this.channelFlag2[rowCount] = true;
                    } else {
                        this.channelFlag1[rowCount] = false;
                        this.channelFlag2[rowCount] = false;
                    }
                    boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                    if (!this.rowFlag[rowCount]) {
                        this.colOneArray[rowCount] = 0.0f;
                        this.colTwoArray[rowCount] = 0.0f;
                    }
                    if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                        this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                        this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                    }
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = rowCount;
            this.colOneArray = new ArrayResizer(this.colOneArray, rowCount).getFArray();
            this.colTwoArray = new ArrayResizer(this.colTwoArray, rowCount).getFArray();
            this.colOneArrayRaw = new ArrayResizer(this.colOneArrayRaw, rowCount).getFArray();
            this.colTwoArrayRaw = new ArrayResizer(this.colTwoArrayRaw, rowCount).getFArray();
            this.colThreeArrayStr = new ArrayResizer(this.colThreeArrayStr, rowCount).getSArray();
            this.channelFlag1 = new ArrayResizer(this.channelFlag1, rowCount).getBArray();
            this.channelFlag2 = new ArrayResizer(this.channelFlag2, rowCount).getBArray();
            this.rowFlag = new ArrayResizer(this.rowFlag, rowCount).getBArray();
        }
    }

    public void setColumnsForIAIBwithTwoFlags() {
        try {
            Vector aVec = this.mfp.getColumnNamed("IA");
            Vector bVec = this.mfp.getColumnNamed("IB");
            Vector f1Vec = this.mfp.getColumnNamed("FlagA");
            Vector f2Vec = this.mfp.getColumnNamed("FlagB");
            this.colOneArray = VecToArray.toFloat(aVec);
            this.colTwoArray = VecToArray.toFloat(bVec);
            this.colThreeArrayStr = VecToArray.toString(f1Vec);
            this.colFourArrayStr = VecToArray.toString(f2Vec);
            int rowCount = 0;
            while (rowCount < this.colOneArray.length) {
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                this.channelFlag1[rowCount] = this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C");
                this.channelFlag2[rowCount] = this.colFourArrayStr[rowCount].equalsIgnoreCase("B") || this.colFourArrayStr[rowCount].equalsIgnoreCase("C");
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0f;
                    this.colTwoArray[rowCount] = 0.0f;
                }
                if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = aVec.size();
        }
        catch (FieldNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void setColumns(int col1, int col2, int col3, int col4) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            this.setColumnsForIAIBwithTwoFlags();
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.colOneArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col1).toString());
                    this.colTwoArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col2).toString());
                    this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                    this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                    this.colThreeArrayStr[rowCount] = inputRowVec.elementAt(col3).toString();
                    this.colFourArrayStr[rowCount] = inputRowVec.elementAt(col4).toString();
                    this.channelFlag1[rowCount] = this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C");
                    this.channelFlag2[rowCount] = this.colFourArrayStr[rowCount].equalsIgnoreCase("B") || this.colFourArrayStr[rowCount].equalsIgnoreCase("C");
                    boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                    if (!this.rowFlag[rowCount]) {
                        this.colOneArray[rowCount] = 0.0f;
                        this.colTwoArray[rowCount] = 0.0f;
                    }
                    if (this.colOneArray[rowCount] > 1.0f && this.colTwoArray[rowCount] > 1.0f && this.rowFlag[rowCount]) {
                        this.colOneTotal = (long)((float)this.colOneTotal + this.colOneArray[rowCount]);
                        this.colTwoTotal = (long)((float)this.colTwoTotal + this.colTwoArray[rowCount]);
                    }
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.col12Ratio = (float)this.colOneTotal / (float)this.colTwoTotal;
            this.count = rowCount;
            this.colOneArray = new ArrayResizer(this.colOneArray, rowCount).getFArray();
            this.colTwoArray = new ArrayResizer(this.colTwoArray, rowCount).getFArray();
            this.colOneArrayRaw = new ArrayResizer(this.colOneArrayRaw, rowCount).getFArray();
            this.colTwoArrayRaw = new ArrayResizer(this.colTwoArrayRaw, rowCount).getFArray();
            this.colThreeArrayStr = new ArrayResizer(this.colThreeArrayStr, rowCount).getSArray();
            this.colFourArrayStr = new ArrayResizer(this.colFourArrayStr, rowCount).getSArray();
            this.channelFlag1 = new ArrayResizer(this.channelFlag1, rowCount).getBArray();
            this.channelFlag2 = new ArrayResizer(this.channelFlag2, rowCount).getBArray();
            this.rowFlag = new ArrayResizer(this.rowFlag, rowCount).getBArray();
        }
    }

    public void setColumnsForTwoBkgd(float snRatioCutoff) {
        try {
            Vector aVec = this.mfp.getColumnNamed("IA");
            this.colOneArray = VecToArray.toFloat(aVec);
            Vector bVec = this.mfp.getColumnNamed("IB");
            this.colTwoArray = VecToArray.toFloat(bVec);
            Vector v1 = this.mfp.getColumnNamed("BkgA");
            this.colOneBkgdArray = VecToArray.toFloat(v1);
            Vector v2 = this.mfp.getColumnNamed("BkgB");
            this.colTwoBkgdArray = VecToArray.toFloat(v2);
            int rowCount = 0;
            while (rowCount < this.colOneArray.length) {
                this.snRatioOne[rowCount] = (this.colOneArray[rowCount] + this.colOneBkgdArray[rowCount]) / this.colOneBkgdArray[rowCount];
                this.snRatioTwo[rowCount] = (this.colTwoArray[rowCount] + this.colTwoBkgdArray[rowCount]) / this.colTwoBkgdArray[rowCount];
                this.rowFlag[rowCount] = this.rowFlag[rowCount] && this.snRatioOne[rowCount] >= snRatioCutoff && this.snRatioTwo[rowCount] >= snRatioCutoff;
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0f;
                    this.colTwoArray[rowCount] = 0.0f;
                }
                ++rowCount;
            }
            this.count = v1.size();
        }
        catch (FieldNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void setColumnsForTwoBkgd(int col1, int col2, float snRatioCutoff) throws FileNotFoundException, NumberFormatException, Exception {
        if (this.file_type == 11100) {
            this.setColumnsForTwoBkgd(snRatioCutoff);
        } else {
            Vector<String> inputRowVec = new Vector<String>();
            String line = "";
            int rowCount = 0;
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
                do {
                    line = inFile.readLine();
                    StringSplitter st = new StringSplitter(line, '\t');
                    inputRowVec = new Vector();
                    while (st.hasMoreTokens()) {
                        inputRowVec.add(st.nextToken());
                    }
                    this.colOneBkgdArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col1).toString());
                    this.colTwoBkgdArray[rowCount] = Float.parseFloat(inputRowVec.elementAt(col2).toString());
                    this.snRatioOne[rowCount] = (this.colOneArray[rowCount] + this.colOneBkgdArray[rowCount]) / this.colOneBkgdArray[rowCount];
                    this.snRatioTwo[rowCount] = (this.colTwoArray[rowCount] + this.colTwoBkgdArray[rowCount]) / this.colTwoBkgdArray[rowCount];
                    this.rowFlag[rowCount] = this.rowFlag[rowCount] && this.snRatioOne[rowCount] >= snRatioCutoff && this.snRatioTwo[rowCount] >= snRatioCutoff;
                    if (!this.rowFlag[rowCount]) {
                        this.colOneArray[rowCount] = 0.0f;
                        this.colTwoArray[rowCount] = 0.0f;
                    }
                    ++rowCount;
                } while (line.length() != 0);
            }
            catch (NullPointerException e) {
            }
            catch (FileNotFoundException nfex) {
                throw nfex;
            }
            catch (NumberFormatException nex) {
                throw nex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            this.colOneBkgdArray = new ArrayResizer(this.colOneBkgdArray, rowCount).getFArray();
            this.colTwoBkgdArray = new ArrayResizer(this.colTwoBkgdArray, rowCount).getFArray();
            this.snRatioOne = new ArrayResizer(this.snRatioOne, rowCount).getFArray();
            this.snRatioTwo = new ArrayResizer(this.snRatioTwo, rowCount).getFArray();
        }
    }

    public void setRowCount(int cnt) {
        this.count = cnt;
    }

    public void KeepTwoColumnsAddFlags(long cutOff1, long cutOff2) {
        this.nonZeroCount = 0;
        int i = 0;
        while (i < this.count) {
            if (this.colTwoArray[i] <= 1.0f || this.colOneArray[i] <= 1.0f) {
                this.colOneArray[i] = 0.0f;
                this.colTwoArray[i] = 0.0f;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            }
            if (this.colOneArray[i] > (float)cutOff1 && this.colTwoArray[i] > (float)cutOff2) {
                this.rowFlag[i] = true;
                ++this.nonZeroCount;
            } else {
                this.rowFlag[i] = false;
            }
            ++i;
        }
    }

    public void resetTwoColumnsAddFlagsRefColOne(long cutOff1, long cutOff2) {
        this.nonZeroCount = 0;
        int i = 0;
        while (i < this.count) {
            if (this.colTwoArray[i] <= 1.0f || this.colOneArray[i] <= 1.0f) {
                this.colOneArray[i] = 0.0f;
                this.colTwoArray[i] = 0.0f;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            } else {
                int n = i;
                this.colTwoArray[n] = this.colTwoArray[n] * this.col12Ratio;
            }
            if (this.colOneArray[i] > (float)cutOff1 && this.colTwoArray[i] > (float)cutOff2) {
                this.rowFlag[i] = true;
                ++this.nonZeroCount;
            } else {
                this.rowFlag[i] = false;
            }
            ++i;
        }
    }

    public void resetTwoColumnsAddFlagsRefColTwo(long cutOff1, long cutOff2) {
        this.nonZeroCount = 0;
        int i = 0;
        while (i < this.count) {
            if (this.colOneArray[i] <= 1.0f || this.colTwoArray[i] <= 1.0f) {
                this.colOneArray[i] = 0.0f;
                this.colTwoArray[i] = 0.0f;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            } else {
                int n = i;
                this.colOneArray[n] = this.colOneArray[n] / this.col12Ratio;
            }
            if (this.colOneArray[i] > (float)cutOff1 && this.colTwoArray[i] > (float)cutOff2) {
                this.rowFlag[i] = true;
                ++this.nonZeroCount;
            } else {
                this.rowFlag[i] = false;
            }
            ++i;
        }
    }

    public void allowOneBadChannel() {
        int colOneNdx = 0;
        int colTwoNdx = 0;
        float[] sortedColOne = new QSort(this.colOneArray).getSorted();
        float[] sortedColTwo = new QSort(this.colTwoArray).getSorted();
        while (!(sortedColOne[colOneNdx] > 1.0f) && colOneNdx < sortedColOne.length) {
            ++colOneNdx;
        }
        while (!(sortedColTwo[colTwoNdx] > 1.0f) && colTwoNdx < sortedColTwo.length) {
            ++colTwoNdx;
        }
        int colOneLower10pctCount = new Float((float)(sortedColOne.length - colOneNdx) * 0.1f).intValue();
        int colTwoLower10pctCount = new Float((float)(sortedColTwo.length - colTwoNdx) * 0.1f).intValue();
        float[] colOneLower10pct = new float[colOneLower10pctCount];
        float[] colTwoLower10pct = new float[colTwoLower10pctCount];
        System.arraycopy(sortedColOne, colOneNdx, colOneLower10pct, 0, colOneLower10pctCount);
        System.arraycopy(sortedColTwo, colTwoNdx, colTwoLower10pct, 0, colTwoLower10pctCount);
        StatsTools s = new StatsTools();
        s.computeMeanSD(colOneLower10pct);
        float colOneLower10pctMean = s.getXMean();
        s.computeMeanSD(colTwoLower10pct);
        float colTwoLower10pctMean = s.getXMean();
        int i = 0;
        while (i < this.count) {
            if (!(this.colOneArrayRaw[i] > 1.0f) && this.colTwoArrayRaw[i] > 1.0f) {
                this.colOneArray[i] = colOneLower10pctMean;
                this.colTwoArray[i] = this.colTwoArrayRaw[i];
                this.rowFlag[i] = true;
            } else if (this.colOneArrayRaw[i] > 1.0f && !(this.colTwoArrayRaw[i] > 1.0f)) {
                this.colOneArray[i] = this.colOneArrayRaw[i];
                this.colTwoArray[i] = colTwoLower10pctMean;
                this.rowFlag[i] = true;
            } else if (!(this.colOneArrayRaw[i] > 1.0f) && !(this.colTwoArrayRaw[i] > 1.0f)) {
                this.colOneArray[i] = 0.0f;
                this.colTwoArray[i] = 0.0f;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            } else if (this.colOneArrayRaw[i] > 1.0f && this.colTwoArrayRaw[i] > 1.0f) {
                this.colOneArray[i] = this.colOneArrayRaw[i];
                this.colTwoArray[i] = this.colTwoArrayRaw[i];
                this.rowFlag[i] = true;
            }
            ++i;
        }
    }

    public void computeGoodRatiosAndLogRatios(long cutOff1, long cutOff2) {
        this.plainRatioArray = new float[this.colOneArray.length];
        this.logProdArray = new float[this.colOneArray.length];
        this.logRatioArray = new float[this.colOneArray.length];
        int i = 0;
        while (i < this.count) {
            if (this.colOneArray[i] > (float)cutOff1 && this.colTwoArray[i] > (float)cutOff2 && this.rowFlag[i]) {
                this.plainRatioArray[i] = this.colTwoArray[i] / this.colOneArray[i];
                this.logProdArray[i] = MathTools.log10(this.colOneArray[i] * this.colTwoArray[i]);
                this.logRatioArray[i] = MathTools.log2(this.colTwoArray[i] / this.colOneArray[i]);
            } else {
                this.plainRatioArray[i] = Float.NaN;
                this.logProdArray[i] = Float.NaN;
                this.logRatioArray[i] = Float.NaN;
            }
            ++i;
        }
    }

    public String getFileName() {
        if (this.fileName.lastIndexOf(FileBrowser.fsep) > 0) {
            return this.fileName.substring(this.fileName.lastIndexOf(FileBrowser.fsep) + 1, this.fileName.lastIndexOf(46));
        }
        return this.fileName;
    }

    public String getFileNameWithExtension() {
        if (this.fileName.lastIndexOf(FileBrowser.fsep) > 0) {
            return this.fileName.substring(this.fileName.lastIndexOf(FileBrowser.fsep) + 1, this.fileName.length());
        }
        return this.fileName;
    }

    public String getFileNameExtension() {
        if (this.fileName.lastIndexOf(FileBrowser.fsep) > 0) {
            return this.fileName.substring(this.fileName.lastIndexOf(46), this.fileName.length());
        }
        return "";
    }

    public final String[] getMetaCombo() {
        return this.metaCombo;
    }

    public final int[] getMetaRow() {
        return this.metaRow;
    }

    public final int[] getMetaCol() {
        return this.metaCol;
    }

    public final String[] getFeatNameArray() {
        return this.featNameArray;
    }

    public final float[] getColumnOneArrayRaw() {
        return this.colOneArrayRaw;
    }

    public final float[] getColumnTwoArrayRaw() {
        return this.colTwoArrayRaw;
    }

    public final float[] getColumnOneArray() {
        return this.colOneArray;
    }

    public final float[] getColumnTwoArray() {
        return this.colTwoArray;
    }

    public final int[] getColumnThreeArray() {
        return this.colThreeArray;
    }

    public final String[] getColumnThreeArrayStr() {
        return this.colThreeArrayStr;
    }

    public final float getColumn12Ratio() {
        return this.col12Ratio;
    }

    public final float[] getPlainRatioArray() {
        return this.plainRatioArray;
    }

    public final float[] getLogProdArray() {
        return this.logProdArray;
    }

    public final float[] getLogRatioArray() {
        return this.logRatioArray;
    }

    public final float[] getFlipLogRatioArray() {
        int i = 0;
        while (i < this.logRatioArray.length) {
            int n = i++;
            this.logRatioArray[n] = this.logRatioArray[n] * -1.0f;
        }
        return this.logRatioArray;
    }

    public final boolean[] getRowFlagArray() {
        return this.rowFlag;
    }

    public final int getRowCounts() {
        return this.count;
    }

    public final int getNonZeroCounts() {
        return this.nonZeroCount;
    }

    public final boolean[] getChannelFlagOne() {
        return this.channelFlag1;
    }

    public final boolean[] getChannelFlagTwo() {
        return this.channelFlag2;
    }

    public final String[] getUID() {
        return this.uidArrayStr;
    }

    public final void setFileName(String f) {
        this.fileName = f;
    }

    public final void setColOneArray(float[] a) {
        this.colOneArray = a;
    }

    public final void setColTwoArray(float[] b) {
        this.colTwoArray = b;
    }

    public final void setRowFlag(boolean[] c) {
        this.rowFlag = c;
    }

    public final void setColumnOneArrayRaw(int size) {
        this.colOneArrayRaw = new float[size];
    }

    public final void setColumnTwoArrayRaw(int size) {
        this.colTwoArrayRaw = new float[size];
    }

    public final void setNdxArray(int[] d) {
        this.ndxArray = d;
    }

    public final void setUIDArray(String[] uid) {
        this.repNotCombined = false;
        this.uidArrayStr = uid;
    }
}

