/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.tables;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.tables.CSVFile;

public class TableCanvas
extends JScrollPane
implements DataCanvas {
    DefaultTableModel tableModel = new DefaultTableModel();
    JTable tablePane = new JTable(this.tableModel);

    public TableCanvas() {
        super(22, 32);
        this.setViewportView(this.tablePane);
        this.tablePane.setCellSelectionEnabled(true);
        this.tablePane.setColumnSelectionAllowed(true);
        this.tablePane.setRowSelectionAllowed(true);
        BLMain.addMenuItem((int)0, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Open..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(false);
                openDialog.setMultiSelectionEnabled(true);
                openDialog.addChoosableFileFilter(new CSVFile());
                if (openDialog.showOpenDialog(BLMain.getJFrame()) == 0) {
                    if (openDialog.getSelectedFiles() != null) {
                        File[] openFiles;
                        for (File ofile : openFiles = openDialog.getSelectedFiles()) {
                            if (!ofile.exists() || !ofile.isFile()) continue;
                            try {
                                TableCanvas.this.readFile("csv", ofile);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (openDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        BLMain.addMenuItem((int)1, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Save As..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(83));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser saveDialog = new JFileChooser();
                saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                saveDialog.setAcceptAllFileFilterUsed(false);
                saveDialog.addChoosableFileFilter(new CSVFile());
                if (!(saveDialog.showSaveDialog(BLMain.getJFrame()) != 0 || saveDialog.getSelectedFile() == null || saveDialog.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwrite", 2, 3) == 2)) {
                    try {
                        TableCanvas.this.writeFile("", saveDialog.getSelectedFile());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (saveDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)saveDialog.getCurrentDirectory());
                    }
                }
            }
        }));
    }

    public String[][] getData() {
        int[] rows = this.tablePane.getSelectedRows();
        int[] columns = this.tablePane.getSelectedColumns();
        String[][] result = new String[rows.length][];
        if (rows != null && columns != null) {
            for (int y : rows) {
                result[y] = new String[columns.length];
                for (int x : columns) {
                    result[y][x] = (String)this.tableModel.getValueAt(y, x);
                }
            }
        }
        return result;
    }

    public String getTabName() {
        return "Table";
    }

    public void stateChanged(ChangeEvent event) {
    }

    public void readFile(String format, File currentFile) {
        try {
            String[][] dataIn;
            for (Object[] objectArray : dataIn = CSVFile.readFile(currentFile)) {
                while (this.tableModel.getColumnCount() < objectArray.length) {
                    this.tableModel.addColumn("" + this.tableModel.getColumnCount());
                }
                this.tableModel.addRow(objectArray);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void writeFile(String format, File currentFile) {
        try {
            CSVFile.writeFile(currentFile, this.getData());
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

