/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.main;

import org.biolegato.main.BLMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginWrapper {
    private String pluginName;
    private Class<?> pluginClass;

    public PluginWrapper(String pluginName, Class<?> pluginClass) {
        this.pluginName = pluginName;
        this.pluginClass = pluginClass;
    }

    public Object create() {
        return this.create(new Class[0], new Object[0]);
    }

    public Object create(Class[] classes, Object[] data) {
        Object result = null;
        try {
            result = this.pluginClass.getConstructor(classes).newInstance(data);
        }
        catch (Throwable cex) {
            try {
                BLMain.error("Constructor error: " + this.pluginClass.getConstructor(classes), this.pluginName + ".create()");
            }
            catch (Throwable pex) {
                BLMain.error("Invalid plugin", this.pluginName + ".create()");
            }
            cex.printStackTrace(System.err);
        }
        return result;
    }

    public Object smethod(String name) {
        return this.smethod(name, new Class[0], new Object[0]);
    }

    public Object smethod(String name, Class[] classes, Object[] parameters) {
        Object result = null;
        try {
            result = this.pluginClass.getMethod(name, classes).invoke(null, parameters);
        }
        catch (Throwable th) {
            BLMain.error("Invalid static method: " + name, this.pluginName);
            th.printStackTrace(System.err);
        }
        return result;
    }

    public boolean isA(Class<?> test) {
        return test.isAssignableFrom(this.pluginClass);
    }

    public String getName() {
        return this.pluginName;
    }
}

