/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedHash<K, V>
extends Hashtable<K, V> {
    List<K> keyList = new ArrayList<K>();

    public OrderedHash() {
    }

    public OrderedHash(Map importMap) {
        this.putAll(importMap);
    }

    @Override
    public void clear() {
        super.clear();
        this.keyList.clear();
    }

    @Override
    public Enumeration<V> elements() {
        return new EnumeratingItterator<V>(this.values().iterator());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ArrayList entries = new ArrayList();
        for (K key : this.keyList) {
            entries.add(new MapEntry(key, this.get(key)));
        }
        return new LinkedHashSet<Map.Entry<K, V>>(entries);
    }

    @Override
    public Enumeration<K> keys() {
        return new EnumeratingItterator<K>(this.keyList.listIterator());
    }

    @Override
    public Set<K> keySet() {
        return new LinkedHashSet<K>(this.keyList);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (K key : this.keyList) {
            values.add(this.get(key));
        }
        return values;
    }

    public K getKey(int number) {
        return this.keyList.get(number);
    }

    public int getKeyCount() {
        return this.keyList.size();
    }

    @Override
    public V put(K key, V value) {
        if (!this.containsKey(key)) {
            this.keyList.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.keyList.addAll(map.keySet());
        super.putAll(map);
    }

    @Override
    public V remove(Object key) {
        this.keyList.remove(key);
        return super.remove(key);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        this.toString(b, 1);
        return b.toString();
    }

    private final void toString(StringBuffer b, int scope) {
        boolean comma = false;
        Object current = null;
        b.append("{");
        b.append("\n");
        for (K key : this.keySet()) {
            if (comma) {
                b.append(",\n");
            }
            for (int count = 0; count < scope; ++count) {
                b.append("    ");
            }
            b.append(key).append("=");
            current = this.get(key);
            if (current instanceof OrderedHash) {
                ((OrderedHash)current).toString(b, scope + 1);
            } else {
                b.append((Object)current);
            }
            comma = true;
        }
        b.append("\n");
        for (int count = 0; count < scope - 1; ++count) {
            b.append("    ");
        }
        b.append("}");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapEntry<H, I>
    implements Map.Entry<H, I> {
        private H key;
        private I value;

        public MapEntry(H key, I value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public H getKey() {
            return this.key;
        }

        @Override
        public I getValue() {
            return this.value;
        }

        @Override
        public I setValue(I newValue) {
            I oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumeratingItterator<T>
    implements Enumeration<T> {
        private Iterator<T> itt;

        public EnumeratingItterator(Iterator<T> i) {
            this.itt = i;
        }

        @Override
        public boolean hasMoreElements() {
            return this.itt.hasNext();
        }

        @Override
        public T nextElement() {
            return this.itt.next();
        }
    }
}

