/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.pcdmenu.widgets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.biolegato.core.pcdmenu.widgets.ListWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chooser
extends ListWidget
implements ActionListener {
    private static final long serialVersionUID = 7526472295622776152L;

    public Chooser(String label, Map<String, String> choices, String value) {
        super(label, choices, value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.value = e.getActionCommand();
    }

    public static String getType() {
        return "chooser";
    }

    public Object getNewDefault() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.choices != null ? (String)this.choices.get(this.value) : "";
    }

    @Override
    public Component display() {
        Box result = new Box(2);
        Object entries = null;
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        if (this.label != null) {
            result.add(new JLabel(this.label));
        }
        for (String entry : this.choices.keySet()) {
            JRadioButton radio = new JRadioButton(entry);
            panel.add(radio);
            radio.setActionCommand(entry);
            radio.addActionListener(this);
            if (entry.equalsIgnoreCase(this.value)) {
                radio.setSelected(true);
            }
            group.add(radio);
        }
        result.add(panel);
        return result;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

