/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataListener;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.canvas.SelectByNameWindow;
import org.biolegato.gdesupport.data.ClipboardWrapper;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.GDESequenceWindow;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;
import org.biolegato.main.BLMain;

public class GDEList
extends JList
implements MouseListener,
GDECanvasObject {
    private long lastClickTime = -1000L;
    private int lastClickEntry = -1;
    private final GDEList list = this;
    protected JPopupMenu popup = new JPopupMenu();
    protected Dataset datamodel;
    private List<ListDataListener> listListeners = new ArrayList<ListDataListener>();
    public final AbstractAction selectGroupAction = new AbstractAction("Select group"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            int[] group = null;
            for (int index : GDEList.this.getSelectedIndices()) {
                group = GDEList.this.datamodel.getgroup(GDEList.this.datamodel.getLine(index).getGroupID());
                if (group == null) continue;
                GDEList.this.setSelectedIndices(group);
            }
        }
    };
    public final AbstractAction getInfoAction = new AbstractAction("Get info..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent evt) {
            if (!GDEList.this.isSelectionEmpty()) {
                new GDESequenceWindow(GDEList.this.datamodel, BLMain.getJFrame(), GDEList.this.getSelectedIndices());
            }
        }
    };
    private final JMenuItem deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.deleteSelection();
        }
    });
    public final AbstractAction selectAllAction = new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.list.setSelectionInterval(0, GDEList.this.list.getModel().getSize() - 1);
            GDEList.this.list.requestFocus();
        }
    };
    public final AbstractAction selectByNameAction = new AbstractAction("Select sequence by name"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.list.requestFocus();
            GDEList.this.list.requestFocusInWindow();
            new SelectByNameWindow(BLMain.getJFrame(), GDEList.this.list);
        }
    };
    public final AbstractAction groupAction = new AbstractAction("Group"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDEList.this.datamodel.group((Seq[])GDEList.this.list.getSelectedValues());
        }
    };
    public final AbstractAction ungroupAction = new AbstractAction("Ungroup"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDEList.this.datamodel.ungroup((Seq[])GDEList.this.list.getSelectedValues());
        }
    };
    private static final long serialVersionUID = 7526472295622777009L;

    public GDEList(GDECanvas canvas, Dataset datamodel) {
        super(datamodel);
        this.datamodel = datamodel;
        this.popup.add(new JMenuItem(canvas.cutAction));
        this.popup.add(new JMenuItem(canvas.copyAction));
        this.popup.add(new JMenuItem(canvas.pasteAction));
        this.popup.add(this.deleteMenuItem);
        this.popup.add(new JMenuItem(this.groupAction));
        this.popup.add(new JMenuItem(this.ungroupAction));
        this.popup.add(new JMenuItem(this.selectAllAction));
        this.popup.add(new JMenuItem(this.selectGroupAction));
        this.popup.add(new JMenuItem(this.selectByNameAction));
        this.popup.add(new JMenuItem(this.getInfoAction));
        this.addMouseListener(this.list);
        this.setForeground(Color.BLACK);
        this.setBackground(new Color(255, 255, 240));
        this.setSize(this.getPreferredSize());
        this.setFont(canvas.currentFont);
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 2 || this.getSelectedIndex() == this.lastClickEntry && event.getWhen() - this.lastClickTime < 300L) {
            this.selectGroupAction.actionPerformed(null);
        }
        this.lastClickTime = event.getWhen();
        this.lastClickEntry = this.getSelectedIndex();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void paste() {
        int row = this.datamodel.getSize();
        Seq[] clipboard = ClipboardWrapper.getClipboard();
        if (clipboard != null) {
            if (this.getSelectedIndex() >= 0) {
                row = this.getSelectedIndex() + 1;
            }
            for (Seq seq : clipboard) {
                this.datamodel.addSequence(row, seq);
                ++row;
            }
        }
    }

    public void changeCase() {
        String data = null;
        for (int sequenceNumber : this.getSelectedIndices()) {
            data = this.datamodel.getLine(sequenceNumber).getSequence().toString();
            if (data.length() > 0) {
                if (Character.isUpperCase(data.charAt(0))) {
                    data.toLowerCase();
                } else {
                    data.toUpperCase();
                }
            }
            this.datamodel.getLine(sequenceNumber).getSequence().replace(0, data.length(), data);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFixedCellHeight(this.getFontMetrics(font).getHeight());
        this.repaint();
    }

    public void deleteSelection() {
        int[] deletionZone = this.getSelectedIndices();
        this.datamodel.removeSequences(deletionZone);
    }

    public void copyClipboard() {
        Seq seqAdd = null;
        int count = 0;
        int countseq = 0;
        int[] indexlist = this.getSelectedIndices();
        Seq[] sequencelist = new Seq[indexlist.length];
        for (count = 0; count < indexlist.length; ++count) {
            seqAdd = this.datamodel.getLine(indexlist[count]);
            if (seqAdd == null) continue;
            sequencelist[countseq] = seqAdd;
            ++countseq;
        }
        if (countseq < indexlist.length) {
            Seq[] temp = new Seq[countseq];
            System.arraycopy(sequencelist, 0, temp, 0, countseq);
            sequencelist = temp;
        }
        ClipboardWrapper.setClipboard(sequencelist);
    }

    public void writeOut(DataFormat format, Appendable dest) throws IOException {
        for (int lineNumber : this.getSelectedIndices()) {
            Seq line = this.datamodel.getLine(lineNumber);
            format.translateTo(dest, line, 0, line.getSequence().length());
        }
    }
}

