/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.filechooser.FileFilter;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.FastAFile;
import org.biolegato.gdesupport.files.GDEFile;
import org.biolegato.gdesupport.files.GDEFlatfile;
import org.biolegato.gdesupport.files.GenBankFile2008;

public abstract class DataFormat
extends FileFilter {
    public static final DataFormat GENBANK = new GenBankFile2008();
    public static final DataFormat GDEFILE = new GDEFile();
    public static final DataFormat GDEFLAT = new GDEFlatfile();
    public static final DataFormat FASTA = new FastAFile();
    public static final DataFormat[] FORMAT_LIST = new DataFormat[]{GENBANK, GDEFILE, GDEFLAT, FASTA};

    public String getName() {
        return "";
    }

    public abstract void translateTo(Appendable var1, Seq var2, int var3, int var4) throws IOException;

    public abstract void translateFrom(Dataset var1, BufferedReader var2) throws IOException;

    public abstract boolean isFormat(Reader var1);

    public static DataFormat autodetect(BufferedReader data) {
        DataFormat result = null;
        if (data != null) {
            int count;
            for (count = 0; count < FORMAT_LIST.length && !FORMAT_LIST[count].isFormat(data); ++count) {
            }
            if (count < FORMAT_LIST.length) {
                result = FORMAT_LIST[count];
            }
        }
        return result;
    }

    public static DataFormat getFormat(String hashname) {
        DataFormat found = GDEFLAT;
        if ("genbank".equals(hashname)) {
            found = GENBANK;
        } else if ("gde".equals(hashname)) {
            found = GDEFILE;
        } else if ("fasta".equals(hashname)) {
            found = FASTA;
        }
        return found;
    }

    public static void readFile(Dataset datamodel, File file) throws IOException {
        Object stream = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
        DataFormat format = DataFormat.autodetect(reader);
        if (format != null && file != null && file.exists() && file.isFile() && file.length() > 0L) {
            DataFormat.readFile(datamodel, format, reader);
        }
    }

    public static void readFile(Dataset datamodel, DataFormat format, File file) {
        Object stream = null;
        BufferedReader reader = null;
        if (format != null && file != null && file.exists() && file.isFile() && file.length() > 0L) {
            try {
                reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
                DataFormat.readFile(datamodel, format, reader);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
    }

    private static void readFile(Dataset datamodel, DataFormat format, BufferedReader buffer) throws IOException {
        format.translateFrom(datamodel, buffer);
    }

    public static void writeAll(Dataset datamodel, DataFormat format, File file) throws IOException {
        int maxlines = datamodel.getSize();
        FileWriter writer = new FileWriter(file);
        for (int count = 0; count < maxlines; ++count) {
            Seq current = datamodel.getLine(count);
            format.translateTo(writer, current, 0, current.getSequence().length());
        }
        writer.flush();
        writer.close();
    }
}

