/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class CSVFile
extends FileFilter {
    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".csv");
    }

    public String getDescription() {
        return "CSV - Comma Separated Values - file (*.csv)";
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check != 10 && check != 13 && check != 44) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 44;
    }

    public static String[][] readFile(File currentFile) {
        LinkedList row = new LinkedList();
        LinkedList<String[]> dataIn = new LinkedList<String[]>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(currentFile));
            while ((line = reader.readLine()) != null) {
                dataIn.add(line.split("\t"));
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        for (int y = 0; y < dataIn.size(); ++y) {
            for (int x = 0; x < ((String[])dataIn.get(y)).length; ++x) {
                if (x > 0) {
                    System.out.print(',');
                }
                System.out.print(((String[])dataIn.get(y))[x]);
            }
            System.out.print('\n');
        }
        return (String[][])dataIn.toArray((T[])new String[0][]);
    }

    public static void writeFile(File currentFile, String[][] data) {
        try {
            FileWriter writer = new FileWriter(currentFile);
            for (int y = 0; y < data.length; ++y) {
                if (data[y].length > 0) {
                    writer.append('\"');
                    writer.append(data[y][0].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                for (int x = 1; x < data[y].length; ++x) {
                    writer.append(',');
                    writer.append('\"');
                    writer.append(data[y][x].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                writer.append('\n');
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

