/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.PDBCanvas;
import MCview.PDBfile;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.UserDefinedColours;
import jalview.io.AppletFormatAdapter;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.UserColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.util.ImageMaker;
import jalview.ws.ebi.EBIFetchClient;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class PDBViewer
extends JInternalFrame
implements Runnable {
    PDBCanvas pdbcanvas;
    PDBEntry pdbentry;
    SequenceI[] seq;
    String[] chains;
    AlignmentPanel ap;
    String protocol;
    String tmpPDBFile;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenu coloursMenu = new JMenu();
    JMenu saveMenu = new JMenu();
    JMenuItem png = new JMenuItem();
    JMenuItem eps = new JMenuItem();
    JMenuItem mapping = new JMenuItem();
    JCheckBoxMenuItem wire = new JCheckBoxMenuItem();
    JCheckBoxMenuItem depth = new JCheckBoxMenuItem();
    JCheckBoxMenuItem zbuffer = new JCheckBoxMenuItem();
    JCheckBoxMenuItem allchains = new JCheckBoxMenuItem();
    JRadioButtonMenuItem charge = new JRadioButtonMenuItem();
    JRadioButtonMenuItem chain = new JRadioButtonMenuItem();
    JRadioButtonMenuItem seqButton = new JRadioButtonMenuItem();
    JRadioButtonMenuItem hydro = new JRadioButtonMenuItem();
    JRadioButtonMenuItem taylor = new JRadioButtonMenuItem();
    JRadioButtonMenuItem zappo = new JRadioButtonMenuItem();
    JRadioButtonMenuItem user = new JRadioButtonMenuItem();
    JRadioButtonMenuItem buried = new JRadioButtonMenuItem();
    JRadioButtonMenuItem turn = new JRadioButtonMenuItem();
    JRadioButtonMenuItem strand = new JRadioButtonMenuItem();
    JRadioButtonMenuItem helix = new JRadioButtonMenuItem();
    JMenu viewMenu = new JMenu();
    JMenuItem background = new JMenuItem();
    JMenuItem savePDB = new JMenuItem();

    public PDBViewer(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap, String protocol) {
        this.pdbentry = pdbentry;
        this.seq = seq;
        this.chains = chains;
        this.ap = ap;
        this.protocol = protocol;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StringBuffer title = new StringBuffer(seq[0].getName() + ":" + pdbentry.getFile());
        this.pdbcanvas = new PDBCanvas();
        this.setContentPane(this.pdbcanvas);
        if (pdbentry.getFile() != null) {
            try {
                this.tmpPDBFile = pdbentry.getFile();
                PDBfile pdbfile = new PDBfile(this.tmpPDBFile, AppletFormatAdapter.FILE);
                this.pdbcanvas.init(pdbentry, seq, chains, ap, protocol);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            Thread worker = new Thread(this);
            worker.start();
        }
        if (pdbentry.getProperty() != null) {
            if (pdbentry.getProperty().get("method") != null) {
                title.append(" Method: ");
                title.append(pdbentry.getProperty().get("method"));
            }
            if (pdbentry.getProperty().get("chains") != null) {
                title.append(" Chain:");
                title.append(pdbentry.getProperty().get("chains"));
            }
        }
        Desktop.addInternalFrame(this, title.toString(), 400, 400);
    }

    public void run() {
        try {
            EBIFetchClient ebi = new EBIFetchClient();
            String query = "pdb:" + this.pdbentry.getId();
            this.pdbentry.setFile(ebi.fetchDataAsFile(query, "default", "raw").getAbsolutePath());
            if (this.pdbentry.getFile() != null) {
                this.pdbcanvas.init(this.pdbentry, this.seq, this.chains, this.ap, this.protocol);
            }
        }
        catch (Exception ex) {
            this.pdbcanvas.errorMessage = "Error retrieving file: " + this.pdbentry.getId();
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                PDBViewer.this.pdbcanvas.keyPressed(evt);
            }
        });
        this.setJMenuBar(this.jMenuBar1);
        this.fileMenu.setText("File");
        this.coloursMenu.setText("Colours");
        this.saveMenu.setActionCommand("Save Image");
        this.saveMenu.setText("Save As");
        this.png.setText("PNG");
        this.png.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.png_actionPerformed(e);
            }
        });
        this.eps.setText("EPS");
        this.eps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.eps_actionPerformed(e);
            }
        });
        this.mapping.setText("View Mapping");
        this.mapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.mapping_actionPerformed(e);
            }
        });
        this.wire.setText("Wireframe");
        this.wire.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.wire_actionPerformed(e);
            }
        });
        this.depth.setSelected(true);
        this.depth.setText("Depthcue");
        this.depth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.depth_actionPerformed(e);
            }
        });
        this.zbuffer.setSelected(true);
        this.zbuffer.setText("Z Buffering");
        this.zbuffer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.zbuffer_actionPerformed(e);
            }
        });
        this.charge.setText("Charge & Cysteine");
        this.charge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.charge_actionPerformed(e);
            }
        });
        this.chain.setText("By Chain");
        this.chain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.chain_actionPerformed(e);
            }
        });
        this.seqButton.setSelected(true);
        this.seqButton.setText("By Sequence");
        this.seqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.seqButton_actionPerformed(e);
            }
        });
        this.allchains.setSelected(true);
        this.allchains.setText("Show All Chains");
        this.allchains.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PDBViewer.this.allchains_itemStateChanged(e);
            }
        });
        this.zappo.setText("Zappo");
        this.zappo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.zappo_actionPerformed(e);
            }
        });
        this.taylor.setText("Taylor");
        this.taylor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.taylor_actionPerformed(e);
            }
        });
        this.hydro.setText("Hydro");
        this.hydro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.hydro_actionPerformed(e);
            }
        });
        this.helix.setText("Helix");
        this.helix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.helix_actionPerformed(e);
            }
        });
        this.strand.setText("Strand");
        this.strand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.strand_actionPerformed(e);
            }
        });
        this.turn.setText("Turn");
        this.turn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.turn_actionPerformed(e);
            }
        });
        this.buried.setText("Buried");
        this.buried.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.buried_actionPerformed(e);
            }
        });
        this.user.setText("User Defined...");
        this.user.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.user_actionPerformed(e);
            }
        });
        this.viewMenu.setText("View");
        this.background.setText("Background Colour...");
        this.background.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.background_actionPerformed(e);
            }
        });
        this.savePDB.setText("PDB File");
        this.savePDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PDBViewer.this.savePDB_actionPerformed(e);
            }
        });
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.coloursMenu);
        this.jMenuBar1.add(this.viewMenu);
        this.fileMenu.add(this.saveMenu);
        this.fileMenu.add(this.mapping);
        this.saveMenu.add(this.savePDB);
        this.saveMenu.add(this.png);
        this.saveMenu.add(this.eps);
        this.coloursMenu.add(this.seqButton);
        this.coloursMenu.add(this.chain);
        this.coloursMenu.add(this.charge);
        this.coloursMenu.add(this.zappo);
        this.coloursMenu.add(this.taylor);
        this.coloursMenu.add(this.hydro);
        this.coloursMenu.add(this.helix);
        this.coloursMenu.add(this.strand);
        this.coloursMenu.add(this.turn);
        this.coloursMenu.add(this.buried);
        this.coloursMenu.add(this.user);
        this.coloursMenu.add(this.background);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.seqButton);
        bg.add(this.chain);
        bg.add(this.charge);
        bg.add(this.zappo);
        bg.add(this.taylor);
        bg.add(this.hydro);
        bg.add(this.helix);
        bg.add(this.strand);
        bg.add(this.turn);
        bg.add(this.buried);
        bg.add(this.user);
        if (UserDefinedColours.getUserColourSchemes() != null) {
            Enumeration userColours = UserDefinedColours.getUserColourSchemes().keys();
            while (userColours.hasMoreElements()) {
                final JRadioButtonMenuItem radioItem = new JRadioButtonMenuItem(userColours.nextElement().toString());
                radioItem.setName("USER_DEFINED");
                radioItem.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        if (evt.isControlDown() || SwingUtilities.isRightMouseButton(evt)) {
                            radioItem.removeActionListener(radioItem.getActionListeners()[0]);
                            int option = JOptionPane.showInternalConfirmDialog(Desktop.desktop, "Remove from default list?", "Remove user defined colour", 0);
                            if (option == 0) {
                                UserDefinedColours.removeColourFromDefaults(radioItem.getText());
                                PDBViewer.this.coloursMenu.remove(radioItem);
                            } else {
                                radioItem.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent evt) {
                                        PDBViewer.this.user_actionPerformed(evt);
                                    }
                                });
                            }
                        }
                    }
                });
                radioItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PDBViewer.this.user_actionPerformed(evt);
                    }
                });
                this.coloursMenu.add(radioItem);
                bg.add(radioItem);
            }
        }
        this.viewMenu.add(this.wire);
        this.viewMenu.add(this.depth);
        this.viewMenu.add(this.zbuffer);
        this.viewMenu.add(this.allchains);
    }

    public void eps_actionPerformed(ActionEvent e) {
        this.makePDBImage(0);
    }

    public void png_actionPerformed(ActionEvent e) {
        this.makePDBImage(1);
    }

    void makePDBImage(int type) {
        int width = this.pdbcanvas.getWidth();
        int height = this.pdbcanvas.getHeight();
        ImageMaker im = type == 1 ? new ImageMaker(this, 1, "Make PNG image from view", width, height, null, null) : new ImageMaker(this, 0, "Make EPS file from view", width, height, null, this.getTitle());
        if (im.getGraphics() != null) {
            this.pdbcanvas.drawAll(im.getGraphics(), width, height);
            im.writeImage();
        }
    }

    public void charge_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setChargeColours();
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void hydro_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new HydrophobicColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void chain_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setChainColours();
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void zbuffer_actionPerformed(ActionEvent e) {
        this.pdbcanvas.zbuffer = !this.pdbcanvas.zbuffer;
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void molecule_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bymolecule = !this.pdbcanvas.bymolecule;
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void depth_actionPerformed(ActionEvent e) {
        this.pdbcanvas.depthcue = !this.pdbcanvas.depthcue;
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void wire_actionPerformed(ActionEvent e) {
        this.pdbcanvas.wire = !this.pdbcanvas.wire;
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void seqButton_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = true;
        this.pdbcanvas.updateSeqColours();
    }

    public void mapping_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        Desktop.addInternalFrame(cap, "PDB - Sequence Mapping", 550, 600);
        cap.setText(this.pdbcanvas.mappingDetails.toString());
    }

    public void allchains_itemStateChanged(ItemEvent e) {
        this.pdbcanvas.setAllchainsVisible(this.allchains.getState());
    }

    public void zappo_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new ZappoColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void taylor_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new TaylorColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void helix_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new HelixColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void strand_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new StrandColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void turn_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new TurnColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void buried_actionPerformed(ActionEvent e) {
        this.pdbcanvas.bysequence = false;
        this.pdbcanvas.pdb.setColours(new BuriedColourScheme());
        this.pdbcanvas.redrawneeded = true;
        this.pdbcanvas.repaint();
    }

    public void user_actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("User Defined...")) {
            UserColourScheme udc = (UserColourScheme)UserDefinedColours.getUserColourSchemes().get(e.getActionCommand());
            this.pdbcanvas.pdb.setColours(udc);
            this.pdbcanvas.redrawneeded = true;
            this.pdbcanvas.repaint();
        }
    }

    public void background_actionPerformed(ActionEvent e) {
        Color col = JColorChooser.showDialog(this, "Select Background Colour", this.pdbcanvas.backgroundColour);
        if (col != null) {
            this.pdbcanvas.backgroundColour = col;
            this.pdbcanvas.redrawneeded = true;
            this.pdbcanvas.repaint();
        }
    }

    public void savePDB_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle("Save PDB File");
        chooser.setToolTipText("Save");
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            try {
                String data;
                BufferedReader in = new BufferedReader(new FileReader(this.tmpPDBFile));
                File outFile = chooser.getSelectedFile();
                PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
                while ((data = in.readLine()) != null) {
                    if (data.indexOf("<PRE>") > -1 || data.indexOf("</PRE>") > -1) continue;
                    out.println(data);
                }
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

