/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.Pattern;
import com.stevesoft.pat.Pthings;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.RegSyntaxError;
import com.stevesoft.pat.oneChar;
import com.stevesoft.pat.patInt;
import java.util.Hashtable;

class Range
extends Pattern {
    char lo;
    char hi;
    char altlo;
    char althi;
    boolean printBrackets = false;

    public String toString() {
        String s = Range.protect("" + this.lo, "[]{}(),$,-\"^.", '\\') + "-" + Range.protect("" + this.hi, "[]{}(),$,-\"^.", '\\');
        if (!this.printBrackets) {
            return s;
        }
        return "[" + s + "]";
    }

    Range(char loi, char hii) throws RegSyntax {
        this.lo = loi;
        this.hi = hii;
        oneChar o = null;
        if (this.lo >= this.hi) {
            RegSyntaxError.endItAll("Badly formed []'s : " + this.lo + " >= " + this.hi);
        }
        o = new oneChar(this.lo);
        this.altlo = o.altc;
        o = new oneChar(this.hi);
        this.althi = o.altc;
    }

    public int matchInternal(int pos, Pthings pt) {
        if (pos >= pt.src.length()) {
            return -1;
        }
        if (this.Masked(pos, pt)) {
            return -1;
        }
        char c = pt.src.charAt(pos);
        if (this.lo <= c && c <= this.hi || pt.ignoreCase && this.altlo <= c && c <= this.althi) {
            return this.nextMatch(pos + 1, pt);
        }
        return -1;
    }

    public patInt minChars() {
        return new patInt(1);
    }

    public patInt maxChars() {
        return new patInt(1);
    }

    public Pattern clone1(Hashtable h) {
        try {
            Range r = new Range(this.lo, this.hi);
            r.printBrackets = this.printBrackets;
            return r;
        }
        catch (RegSyntax rs) {
            return null;
        }
    }
}

