/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.ws.SequenceFetcher;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CrossRef {
    public static DBRefEntry[] findXDbRefs(boolean dna, DBRefEntry[] rfs) {
        rfs = dna ? DBRefUtils.selectRefs(rfs, DBRefSource.PROTEINDBS) : DBRefUtils.selectRefs(rfs, DBRefSource.DNACODINGDBS);
        return rfs;
    }

    public static Hashtable classifyDbRefs(DBRefEntry[] rfs) {
        Hashtable<String[], DBRefEntry[]> classes = new Hashtable<String[], DBRefEntry[]>();
        classes.put(DBRefSource.PROTEINDBS, DBRefUtils.selectRefs(rfs, DBRefSource.PROTEINDBS));
        classes.put(DBRefSource.DNACODINGDBS, DBRefUtils.selectRefs(rfs, DBRefSource.DNACODINGDBS));
        classes.put(DBRefSource.DOMAINDBS, DBRefUtils.selectRefs(rfs, DBRefSource.DOMAINDBS));
        return classes;
    }

    public static String[] findSequenceXrefTypes(boolean dna, SequenceI[] seqs) {
        return CrossRef.findSequenceXrefTypes(dna, seqs, null);
    }

    public static String[] findSequenceXrefTypes(boolean dna, SequenceI[] seqs, AlignmentI dataset) {
        Object[] dbrefs = null;
        Vector<String> refs = new Vector<String>();
        for (int s = 0; s < seqs.length; ++s) {
            SequenceI dss = seqs[s];
            while (dss.getDatasetSequence() != null) {
                dss = dss.getDatasetSequence();
            }
            DBRefEntry[] rfs = CrossRef.findXDbRefs(dna, dss.getDBRef());
            for (int r = 0; rfs != null && r < rfs.length; ++r) {
                if (refs.contains(rfs[r].getSource())) continue;
                refs.addElement(rfs[r].getSource());
            }
            if (dataset == null) continue;
            DBRefEntry[] lrfs = CrossRef.findXDbRefs(!dna, seqs[s].getDBRef());
            Vector rseqs = new Vector();
            CrossRef.searchDatasetXrefs(seqs[s], !dna, lrfs, dataset, rseqs, null);
            Enumeration lr = rseqs.elements();
            while (lr.hasMoreElements()) {
                SequenceI rs = (SequenceI)lr.nextElement();
                DBRefEntry[] xrs = CrossRef.findXDbRefs(dna, rs.getDBRef());
                for (int r = 0; rfs != null && r < rfs.length; ++r) {
                    if (refs.contains(rfs[r].getSource())) continue;
                    refs.addElement(rfs[r].getSource());
                }
            }
        }
        if (refs.size() > 0) {
            dbrefs = new String[refs.size()];
            refs.copyInto(dbrefs);
        }
        return dbrefs;
    }

    public static boolean hasCdnaMap(SequenceI[] seqs) {
        String[] reftypes = CrossRef.findSequenceXrefTypes(false, seqs);
        for (int s = 0; s < reftypes.length; ++s) {
            if (!reftypes.equals(DBRefSource.EMBLCDS)) continue;
            return true;
        }
        return false;
    }

    public static SequenceI[] getCdnaMap(SequenceI[] seqs) {
        Vector cseqs = new Vector();
        for (int s = 0; s < seqs.length; ++s) {
            DBRefEntry[] cdna = CrossRef.findXDbRefs(true, seqs[s].getDBRef());
            for (int c = 0; c < cdna.length; ++c) {
                if (!cdna[c].getSource().equals(DBRefSource.EMBLCDS)) continue;
                System.err.println("TODO: unimplemented sequence retrieval for coding region sequence.");
            }
        }
        if (cseqs.size() > 0) {
            Object[] rsqs = new SequenceI[cseqs.size()];
            cseqs.copyInto(rsqs);
            return rsqs;
        }
        return null;
    }

    public static Alignment findXrefSequences(SequenceI[] seqs, boolean dna, String source) {
        return CrossRef.findXrefSequences(seqs, dna, source, null);
    }

    public static Alignment findXrefSequences(SequenceI[] seqs, boolean dna, String source, AlignmentI dataset) {
        Vector<SequenceI> rseqs = new Vector<SequenceI>();
        Alignment ral = null;
        AlignedCodonFrame cf = new AlignedCodonFrame(0);
        for (int s = 0; s < seqs.length; ++s) {
            SequenceI dss = seqs[s];
            while (dss.getDatasetSequence() != null) {
                dss = dss.getDatasetSequence();
            }
            boolean found = false;
            DBRefEntry[] xrfs = CrossRef.findXDbRefs(dna, dss.getDBRef());
            if ((xrfs == null || xrfs.length == 0) && dataset != null) {
                System.out.println("Attempting to find ds Xrefs refs.");
                DBRefEntry[] lrfs = CrossRef.findXDbRefs(!dna, seqs[s].getDBRef());
                found = CrossRef.searchDatasetXrefs(dss, !dna, lrfs, dataset, rseqs, cf);
            }
            for (int r = 0; xrfs != null && r < xrfs.length; ++r) {
                if (source != null && !source.equals(xrfs[r].getSource())) continue;
                if (xrfs[r].hasMap() && xrfs[r].getMap().getTo() != null) {
                    Sequence rsq = new Sequence(xrfs[r].getMap().getTo());
                    rseqs.addElement(rsq);
                    if (xrfs[r].getMap().getMap().getFromRatio() != xrfs[r].getMap().getMap().getToRatio()) {
                        if (dna) {
                            cf.addMap(dss, rsq, xrfs[r].getMap().getMap());
                        } else {
                            cf.addMap(rsq, dss, xrfs[r].getMap().getMap().getInverse());
                        }
                    }
                    found = true;
                }
                if (found || dataset == null || !(found |= CrossRef.searchDataset(dss, xrfs[r], dataset, rseqs, cf))) continue;
                xrfs[r] = null;
            }
            if (found || xrfs == null || xrfs.length <= 0) continue;
            SequenceFetcher sftch = new SequenceFetcher();
            SequenceI[] retrieved = null;
            int l = xrfs.length;
            for (int r = 0; r < xrfs.length; ++r) {
                if (xrfs[r] != null && (source == null || source.equals(xrfs[r].getSource())) && sftch.isFetchable(xrfs[r].getSource())) continue;
                --l;
                xrfs[r] = null;
            }
            if (l <= 0) continue;
            System.out.println("Attempting to retrieve cross referenced sequences.");
            DBRefEntry[] t = new DBRefEntry[l];
            l = 0;
            for (int r = 0; r < xrfs.length; ++r) {
                if (xrfs[r] == null) continue;
                t[l++] = xrfs[r];
            }
            xrfs = t;
            try {
                retrieved = sftch.getSequences(xrfs);
            }
            catch (Exception e) {
                System.err.println("Problem whilst retrieving cross references for Sequence : " + seqs[s].getName());
                e.printStackTrace();
            }
            if (retrieved == null) continue;
            for (int rs = 0; rs < retrieved.length; ++rs) {
                DBRefEntry[] dbr = retrieved[rs].getDBRef();
                if (dbr != null && dbr.length > 0) {
                    for (int di = 0; di < dbr.length; ++di) {
                        Mapping map = dbr[di].getMap();
                        if (map == null || map.getTo() == null || map.getMap() == null) continue;
                        try {
                            SequenceI ms = map.getTo();
                            int sf = map.getMap().getToLowest();
                            int st = map.getMap().getToHighest();
                            SequenceI mappedrg = ms.getSubSequence(sf, st);
                            SequenceI loc = dss.getSubSequence(sf, st);
                            if (mappedrg.getLength() <= 0 || !mappedrg.getSequenceAsString().equals(loc.getSequenceAsString())) continue;
                            System.err.println("Mapping updated for retrieved crossreference");
                            map.setTo(dss);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("Exception when consolidating Mapped sequence set...");
                            e.printStackTrace(System.err);
                        }
                    }
                }
                retrieved[rs].updatePDBIds();
                rseqs.addElement(retrieved[rs]);
            }
        }
        if (rseqs.size() > 0) {
            Object[] rsqs = new SequenceI[rseqs.size()];
            rseqs.copyInto(rsqs);
            ral = new Alignment((SequenceI[])rsqs);
            if (cf != null && cf.getProtMappings() != null) {
                ral.addCodonFrame(cf);
            }
        }
        return ral;
    }

    private static boolean searchDatasetXrefs(SequenceI sequenceI, boolean dna, DBRefEntry[] lrfs, AlignmentI dataset, Vector rseqs, AlignedCodonFrame cf) {
        boolean found = false;
        if (lrfs == null) {
            return false;
        }
        for (int i = 0; i < lrfs.length; ++i) {
            DBRefEntry xref = new DBRefEntry(lrfs[i]);
            xref.setVersion(null);
            xref.setMap(null);
            found = CrossRef.searchDataset(sequenceI, xref, dataset, rseqs, cf, false, dna);
        }
        return found;
    }

    public static boolean searchDataset(SequenceI sequenceI, DBRefEntry xrf, AlignmentI dataset, Vector rseqs, AlignedCodonFrame cf) {
        return CrossRef.searchDataset(sequenceI, xrf, dataset, rseqs, cf, true, false);
    }

    public static boolean searchDataset(SequenceI sequenceI, DBRefEntry xrf, AlignmentI dataset, Vector rseqs, AlignedCodonFrame cf, boolean direct, boolean dna) {
        boolean found = false;
        SequenceI[] typer = new SequenceI[1];
        if (dataset == null) {
            return false;
        }
        if (dataset.getSequences() == null) {
            System.err.println("Empty dataset sequence set - NO VECTOR");
            return false;
        }
        Enumeration e = dataset.getSequences().elements();
        while (e.hasMoreElements()) {
            SequenceI nxt = (SequenceI)e.nextElement();
            if (nxt == null) continue;
            if (nxt.getDatasetSequence() != null) {
                System.err.println("Implementation warning: getProducts passed a dataset alignment without dataset sequences in it!");
            }
            if (nxt == sequenceI || nxt == sequenceI.getDatasetSequence()) continue;
            typer[0] = nxt;
            boolean isDna = Comparison.isNucleotide(typer);
            if (direct && isDna == dna || !direct && isDna != dna) continue;
            DBRefEntry[] poss = null;
            DBRefEntry[] cands = null;
            if (direct) {
                poss = nxt.getDBRef();
                cands = DBRefUtils.searchRefs(poss, xrf);
            } else {
                poss = CrossRef.findXDbRefs(dna, nxt.getDBRef());
                cands = DBRefUtils.searchRefs(poss, xrf);
            }
            if (cands == null || rseqs.contains(nxt)) continue;
            rseqs.addElement(nxt);
            boolean foundmap = cf != null;
            for (int r = 0; foundmap && r < cands.length; ++r) {
                if (!cands[r].hasMap() || cands[r].getMap().getTo() == null || cands[r].getMap().getMap().getFromRatio() == cands[r].getMap().getMap().getToRatio()) continue;
                foundmap = true;
                if (dna) {
                    cf.addMap(sequenceI, nxt, cands[r].getMap().getMap());
                    continue;
                }
                cf.addMap(nxt, sequenceI, cands[r].getMap().getMap().getInverse());
            }
            found = true;
        }
        return found;
    }
}

