/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import com.stevesoft.pat.Regex;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;

public class ParseProperties {
    private AlignmentI al = null;

    public ParseProperties(AlignmentI al) {
        this.al = al;
    }

    public int getScoresFromDescription(String ScoreName, String ScoreDescriptions, String regex, boolean repeat) {
        return this.getScoresFromDescription(new String[]{ScoreName}, new String[]{ScoreDescriptions}, regex, repeat);
    }

    public int getScoresFromDescription(String[] ScoreNames, String[] ScoreDescriptions, String regex, boolean repeat) {
        return this.getScoresFromDescription(this.al.getSequencesArray(), ScoreNames, ScoreDescriptions, regex, repeat);
    }

    public int getScoresFromDescription(SequenceI[] seqs, String[] ScoreNames, String[] ScoreDescriptions, String regex, boolean repeat) {
        int count = 0;
        Regex pattern = new Regex(regex);
        if (pattern.numSubs() > ScoreNames.length) {
            int onamelen = ScoreNames.length;
            String[] tnames = new String[pattern.numSubs() + 1];
            System.arraycopy(ScoreNames, 0, tnames, 0, ScoreNames.length);
            String base = tnames[ScoreNames.length - 1];
            ScoreNames = tnames;
            String descrbase = ScoreDescriptions[onamelen - 1];
            if (descrbase == null) {
                descrbase = "Score parsed from (" + regex + ")";
            }
            tnames = new String[pattern.numSubs() + 1];
            System.arraycopy(ScoreDescriptions, 0, tnames, 0, ScoreDescriptions.length);
            ScoreDescriptions = tnames;
            for (int i = onamelen; i < ScoreNames.length; ++i) {
                ScoreNames[i] = base + "_" + i;
                ScoreDescriptions[i] = descrbase + " (column " + i + ")";
            }
        }
        for (int i = 0; i < seqs.length; ++i) {
            String descr = seqs[i].getDescription();
            if (descr == null) continue;
            int pos = 0;
            boolean added = false;
            int reps = 0;
            while ((repeat || pos == 0) && pattern.searchFrom(descr, pos)) {
                pos = pattern.matchedTo();
                for (int cols = 0; cols < pattern.numSubs(); ++cols) {
                    String sstring = pattern.stringMatched(cols + 1);
                    double score = Double.NaN;
                    try {
                        score = new Double(sstring);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    AlignmentAnnotation an = new AlignmentAnnotation(ScoreNames[cols] + (reps > 0 ? "_" + reps : ""), ScoreDescriptions[cols], null);
                    an.setScore(score);
                    System.out.println("Score: " + ScoreNames[cols] + "=" + score);
                    an.setSequenceRef(seqs[i]);
                    seqs[i].addAlignmentAnnotation(an);
                    this.al.addAnnotation(an);
                    added = true;
                }
                ++reps;
            }
            if (!added) continue;
            ++count;
        }
        return count;
    }

    public static void main(String[] argv) {
        SequenceI[] seqs = new SequenceI[]{new Sequence("sq1", "THISISAPLACEHOLDER"), new Sequence("sq2", "THISISAPLACEHOLDER"), new Sequence("sq3", "THISISAPLACEHOLDER"), new Sequence("sq4", "THISISAPLACEHOLDER")};
        seqs[0].setDescription("1 mydescription1");
        seqs[1].setDescription("mydescription2");
        seqs[2].setDescription("2. 0.1 mydescription3");
        seqs[3].setDescription("3 0.01 mydescription4");
        Alignment al = new Alignment(seqs);
        ParseProperties pp = new ParseProperties(al);
        String regex = ".*([-0-9.+]+)";
        System.out.println("Matched " + pp.getScoresFromDescription("my Score", "my Score Description", regex, true) + " for " + regex);
        regex = ".*([-0-9.+]+).+([-0-9.+]+).*";
        System.out.println("Matched " + pp.getScoresFromDescription("my Score", "my Score Description", regex, true) + " for " + regex);
        System.out.println("Finished.");
    }
}

