/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.gui.UserDefinedColours;
import jalview.io.PIRFile;
import jalview.jbgui.GDesktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class Cache {
    public static final String CASTORLOGLEVEL = "logs.Castor.level";
    public static final String AXISLOGLEVEL = "logs.Axis.level";
    public static final String JALVIEWLOGLEVEL = "logs.Jalview.level";
    public static final String DAS_LOCAL_SOURCE = "DAS_LOCAL_SOURCE";
    public static Logger log;
    public static Properties applicationProperties;
    static String propertiesFile;
    private static int vamsasJarsArePresent;
    private static int groovyJarsArePresent;
    protected static Object tracker;
    protected static Class trackerfocus;
    protected static Class jgoogleanalyticstracker;

    public static void initLogger() {
        try {
            ConsoleAppender ap = new ConsoleAppender((Layout)new SimpleLayout(), "System.err");
            ap.setName("JalviewLogger");
            Logger.getRootLogger().addAppender((Appender)ap);
            Logger laxis = Logger.getLogger((String)"org.apache.axis");
            Logger lcastor = Logger.getLogger((String)"org.exolab.castor");
            log = Logger.getLogger((String)"jalview.bin.Jalview");
            laxis.setLevel(Level.toLevel((String)Cache.getDefault("logs.Axis.Level", Level.INFO.toString())));
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            lcastor = Logger.getLogger((String)"org.exolab.castor.xml");
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            log.setLevel(Level.toLevel((String)Cache.getDefault(JALVIEWLOGLEVEL, Level.INFO.toString())));
            log.debug((Object)"Jalview Debugging Output Follows.");
        }
        catch (Exception ex) {
            System.err.println("Problems initializing the log4j system\n");
            ex.printStackTrace(System.err);
        }
    }

    public static void loadProperties(String propsFile) {
        propertiesFile = propsFile;
        if (propsFile == null) {
            propertiesFile = System.getProperty("user.home") + File.separatorChar + ".jalview_properties";
        }
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            applicationProperties.load(fis);
            applicationProperties.remove("LATEST_VERSION");
            applicationProperties.remove("VERSION");
            fis.close();
        }
        catch (Exception ex) {
            System.out.println("Error reading properties file: " + ex);
        }
        if (Cache.getDefault("USE_PROXY", false)) {
            System.out.println("Using proxyServer: " + Cache.getDefault("PROXY_SERVER", null) + " proxyPort: " + Cache.getDefault("PROXY_PORT", null));
            System.setProperty("http.proxyHost", Cache.getDefault("PROXY_SERVER", null));
            System.setProperty("http.proxyPort", Cache.getDefault("PROXY_PORT", null));
        }
        try {
            String buildDetails = "jar:".concat(Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!/.build_properties"));
            URL localJarFileURL = new URL(buildDetails);
            InputStream in = localJarFileURL.openStream();
            applicationProperties.load(in);
            in.close();
        }
        catch (Exception ex) {
            System.out.println("Error reading build details: " + ex);
            applicationProperties.remove("VERSION");
        }
        String jnlpVersion = System.getProperty("jalview.version");
        String codeVersion = Cache.getProperty("VERSION");
        if (codeVersion == null) {
            codeVersion = "Test";
            jnlpVersion = "Test";
        }
        System.out.println("Jalview Version: " + codeVersion);
        if (jnlpVersion == null && Cache.getDefault("VERSION_CHECK", true) && (System.getProperty("java.awt.headless") == null || System.getProperty("java.awt.headless").equals("false"))) {
            class VersionChecker
            extends Thread {
                VersionChecker() {
                }

                public void run() {
                    String orgtimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
                    if (orgtimeout == null) {
                        orgtimeout = "30";
                        System.out.println("# INFO: Setting default net timeout to " + orgtimeout + " seconds.");
                    }
                    String jnlpVersion = null;
                    try {
                        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
                        URL url = new URL("http://www.jalview.org/webstart/jalview.jnlp");
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if (line.indexOf("jalview.version") == -1) continue;
                            line = line.substring(line.indexOf("value=") + 7);
                            jnlpVersion = line = line.substring(0, line.lastIndexOf("\""));
                            break;
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Non-fatal exceptions when checking version at www.jalview.org :");
                        System.out.println(ex);
                        jnlpVersion = Cache.getProperty("VERSION");
                    }
                    System.setProperty("sun.net.client.defaultConnectTimeout", orgtimeout);
                    Cache.setProperty("LATEST_VERSION", jnlpVersion);
                }
            }
            VersionChecker vc = new VersionChecker();
            vc.start();
        } else if (jnlpVersion != null) {
            Cache.setProperty("LATEST_VERSION", jnlpVersion);
        } else {
            applicationProperties.remove("LATEST_VERSION");
        }
        Cache.setProperty("VERSION", codeVersion);
        UserDefinedColours.initUserColourSchemes(Cache.getProperty("USER_DEFINED_COLOURS"));
        PIRFile.useModellerOutput = Cache.getDefault("PIR_MODELLER", false);
    }

    public static String getProperty(String key) {
        return applicationProperties.getProperty(key);
    }

    public static boolean getDefault(String property, boolean def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            def = Boolean.valueOf(string);
        }
        return def;
    }

    public static String getDefault(String property, String def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            return string;
        }
        return def;
    }

    public static String setProperty(String key, String obj) {
        try {
            FileOutputStream out = new FileOutputStream(propertiesFile);
            applicationProperties.setProperty(key, obj);
            applicationProperties.store(out, "---JalviewX Properties File---");
            out.close();
        }
        catch (Exception ex) {
            System.out.println("Error setting property: " + key + " " + obj + "\n" + ex);
        }
        return obj;
    }

    public static void removeProperty(String string) {
        applicationProperties.remove(string);
        Cache.saveProperties();
    }

    public static void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(propertiesFile);
            applicationProperties.store(out, "---JalviewX Properties File---");
            out.close();
        }
        catch (Exception ex) {
            System.out.println("Error saving properties: " + ex);
        }
    }

    public static boolean vamsasJarsPresent() {
        if (vamsasJarsArePresent == -1) {
            try {
                if (GDesktop.class.getClassLoader().loadClass("uk.ac.vamsas.client.VorbaId") != null) {
                    log.debug((Object)"Found Vamsas Classes (uk.ac..vamsas.client.VorbaId can be loaded)");
                    vamsasJarsArePresent = 1;
                    Logger lvclient = Logger.getLogger((String)"uk.ac.vamsas");
                    lvclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Vamsas.Level", Level.INFO.toString())));
                    lvclient.addAppender(log.getAppender("JalviewLogger"));
                    lvclient.debug((Object)"Jalview Vamsas Client Debugging Output Follows.");
                }
            }
            catch (Exception e) {
                vamsasJarsArePresent = 0;
                log.debug((Object)"Vamsas Classes are not present");
            }
        }
        return vamsasJarsArePresent > 0;
    }

    public static boolean groovyJarsPresent() {
        if (groovyJarsArePresent == -1) {
            try {
                if (Cache.class.getClassLoader().loadClass("groovy.lang.GroovyObject") != null) {
                    log.debug((Object)"Found Groovy (groovy.lang.GroovyObject can be loaded)");
                    groovyJarsArePresent = 1;
                    Logger lgclient = Logger.getLogger((String)"groovy");
                    lgclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Groovy.Level", Level.INFO.toString())));
                    lgclient.addAppender(log.getAppender("JalviewLogger"));
                    lgclient.debug((Object)"Jalview Groovy Client Debugging Output Follows.");
                }
            }
            catch (Error e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present", (Throwable)e);
            }
            catch (Exception e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present");
            }
        }
        return groovyJarsArePresent > 0;
    }

    public static void initGoogleTracker() {
        if (tracker == null) {
            if (jgoogleanalyticstracker == null) {
                try {
                    jgoogleanalyticstracker = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.JGoogleAnalyticsTracker");
                    trackerfocus = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.FocusPoint");
                }
                catch (Exception e) {
                    log.debug((Object)"com.boxysystems.jgoogleanalytics package is not present - tracking not enabled.");
                    tracker = null;
                    jgoogleanalyticstracker = null;
                    trackerfocus = null;
                    return;
                }
            }
            RuntimeException re = null;
            Exception ex = null;
            Error err = null;
            String vrs = "No Version Accessible";
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = "Jalview Desktop";
                vrs = Cache.getProperty("VERSION") + "_" + Cache.getDefault("BUILD_DATE", "unknown");
                objectArray[1] = vrs;
                objectArray[2] = "UA-9060947-1";
                tracker = jgoogleanalyticstracker.getConstructor(String.class, String.class, String.class).newInstance(objectArray);
                jgoogleanalyticstracker.getMethod("trackAsynchronously", trackerfocus).invoke(tracker, trackerfocus.getConstructor(String.class).newInstance("Application Started."));
            }
            catch (RuntimeException e) {
                re = e;
            }
            catch (Exception e) {
                ex = e;
            }
            catch (Error e) {
                err = e;
            }
            if (re != null || ex != null || err != null) {
                if (log != null) {
                    if (re != null) {
                        log.debug((Object)"Caught runtime exception in googletracker init:", (Throwable)re);
                    }
                    if (ex != null) {
                        log.warn((Object)("Failed to initialise GoogleTracker for Jalview Desktop with version " + vrs), (Throwable)ex);
                    }
                    if (err != null) {
                        log.error((Object)("Whilst initing GoogleTracker for Jalview Desktop version " + vrs), (Throwable)err);
                    }
                } else {
                    if (re != null) {
                        System.err.println("Debug: Caught runtime exception in googletracker init:" + vrs);
                        re.printStackTrace();
                    }
                    if (ex != null) {
                        System.err.println("Warning:  Failed to initialise GoogleTracker for Jalview Desktop with version " + vrs);
                        ex.printStackTrace();
                    }
                    if (err != null) {
                        System.err.println("ERROR: Whilst initing GoogleTracker for Jalview Desktop version " + vrs);
                        err.printStackTrace();
                    }
                }
            } else {
                log.debug((Object)"Successfully initialised tracker.");
            }
        }
    }

    static {
        applicationProperties = new Properties();
        vamsasJarsArePresent = -1;
        groovyJarsArePresent = -1;
        tracker = null;
        trackerfocus = null;
        jgoogleanalyticstracker = null;
    }
}

