/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import [Ljava.net.URL;;
import jalview.bin.ArgsParser;
import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.PromptUserConfig;
import jalview.io.FileLoader;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.UserColourScheme;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Jalview {
    public static void main(String[] args) {
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println(System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        ArgsParser aparser = new ArgsParser(args);
        boolean headless = false;
        if (aparser.contains("help") || aparser.contains("h")) {
            System.out.println("Usage: jalview -open [FILE] [OUTPUT_FORMAT] [OUTPUT_FILE]\n\n-nodisplay\tRun Jalview without User Interface.\n-props FILE\tUse the given Jalview properties file instead of users default.\n-annotations FILE\tAdd precalculated annotations to the alignment.\n-tree FILE\tLoad the given newick format tree file onto the alignment\n-features FILE\tUse the given file to mark features on the alignment.\n-fasta FILE\tCreate alignment file FILE in Fasta format.\n-clustal FILE\tCreate alignment file FILE in Clustal format.\n-pfam FILE\tCreate alignment file FILE in PFAM format.\n-msf FILE\tCreate alignment file FILE in MSF format.\n-pileup FILE\tCreate alignment file FILE in Pileup format\n-pir FILE\tCreate alignment file FILE in PIR format.\n-blc FILE\tCreate alignment file FILE in BLC format.\n-jalview FILE\tCreate alignment file FILE in Jalview format.\n-png FILE\tCreate PNG image FILE from alignment.\n-imgMap FILE\tCreate HTML file FILE with image map of PNG image.\n-eps FILE\tCreate EPS file FILE from alignment.\n-questionnaire URL\tQueries the given URL for information about any Jalview user questionnaires.\n-noquestionnaire\tTurn off questionnaire check.\n-nousagestats\tTurn off google analytics tracking for this session.\n-dasserver nickname=URL\tAdd and enable a das server with given nickname \n\t\t\t(alphanumeric or underscores only) for retrieval of features for all alignments.\n-fetchfrom nickname\tQuery nickname for features for the alignments and display them.\n-groovy FILE\tExecute groovy script in FILE, after all other arguments have been processed\n\t\t(if FILE is the text 'STDIN' then the file will be read from STDIN)\n\n\n~Read documentation in Application or visit http://www.jalview.org for description of Features and Annotations file~\n\n");
            System.exit(0);
        }
        Cache.loadProperties(aparser.getValue("props"));
        if (aparser.contains("nodisplay")) {
            System.setProperty("java.awt.headless", "true");
        }
        if (System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            headless = true;
        }
        try {
            Cache.initLogger();
        }
        catch (NoClassDefFoundError error) {
            error.printStackTrace();
            System.out.println("\nEssential logging libraries not found.\nUse: java -Djava.ext.dirs=$PATH_TO_LIB$ jalview.bin.Jalview");
            System.exit(0);
        }
        Desktop desktop = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!headless) {
            desktop = new Desktop();
            desktop.setVisible(true);
            Desktop.discoverer.start();
            if (!aparser.contains("nousagestats")) {
                Jalview.startUsageStats(desktop);
            }
            if (!aparser.contains("noquestionnaire")) {
                String url = aparser.getValue("questionnaire");
                if (url != null) {
                    Cache.log.debug((Object)("Starting questionnaire url at " + url));
                    desktop.checkForQuestionnaire(url);
                } else if (Cache.getProperty("NOQUESTIONNAIRES") == null) {
                    String defurl = "http://www.jalview.org/cgi-bin/questionnaire.pl";
                    Cache.log.debug((Object)("Starting questionnaire with default url: " + defurl));
                    desktop.checkForQuestionnaire(defurl);
                }
            }
        }
        String file = null;
        String protocol = null;
        String format = null;
        String data = null;
        FileLoader fileLoader = new FileLoader();
        Vector getFeatures = null;
        String groovyscript = null;
        groovyscript = aparser.getValue("groovy");
        file = aparser.getValue("open");
        if (file == null && desktop == null) {
            System.out.println("No files to open!");
            System.exit(1);
        }
        if (file != null) {
            AlignFrame af;
            System.out.println("Opening file: " + file);
            if (!file.startsWith("http://") && !new File(file).exists()) {
                System.out.println("Can't find " + file);
                if (headless) {
                    System.exit(1);
                }
            }
            if ((af = fileLoader.LoadFileWaitTillLoaded(file, protocol = Jalview.checkProtocol(file), format = new IdentifyFile().Identify(file, protocol))) == null) {
                System.out.println("error");
                return;
            }
            data = aparser.getValue("colour");
            if (data != null) {
                data.replaceAll("%20", " ");
                ColourSchemeI cs = ColourSchemeProperty.getColour(af.getViewport().getAlignment(), data);
                if (cs == null) {
                    UserColourScheme ucs = new UserColourScheme("white");
                    ucs.parseAppletParameter(data);
                    cs = ucs;
                }
                System.out.println("colour is " + data);
                af.changeColour(cs);
            }
            if ((data = aparser.getValue("groups")) != null) {
                af.parseFeaturesFile(data, Jalview.checkProtocol(data));
                System.out.println("Added " + data);
            }
            if ((data = aparser.getValue("features")) != null) {
                af.parseFeaturesFile(data, Jalview.checkProtocol(data));
                System.out.println("Added " + data);
            }
            if ((data = aparser.getValue("annotations")) != null) {
                af.loadJalviewDataFile(data);
                System.out.println("Added " + data);
            }
            if ((data = aparser.getValue("tree")) != null) {
                NewickFile fin = null;
                try {
                    fin = new NewickFile(data, Jalview.checkProtocol(data));
                    if (fin != null) {
                        af.getViewport().setCurrentTree(af.ShowNewickTree(fin, data).getTree());
                        System.out.println("Added tree " + data);
                    }
                }
                catch (IOException ex) {
                    System.err.println("Couldn't add tree " + data);
                    ex.printStackTrace(System.err);
                }
            }
            getFeatures = Jalview.checkDasArguments(aparser);
            if (af != null && getFeatures != null) {
                Jalview.startFeatureFetching(getFeatures);
                while (af.operationInProgress()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {}
                }
            }
            if (groovyscript != null) {
                if (Cache.groovyJarsPresent()) {
                    System.out.println("Executing script " + groovyscript);
                    Jalview.executeGroovyScript(groovyscript, desktop);
                } else {
                    System.err.println("Sorry. Groovy Support is not available, so ignoring the provided groovy script " + groovyscript);
                }
                groovyscript = null;
            }
            String imageName = "unnamed.png";
            while (aparser.getSize() > 1) {
                format = aparser.nextValue();
                file = aparser.nextValue();
                if (format.equalsIgnoreCase("png")) {
                    af.createPNG(new File(file));
                    imageName = new File(file).getName();
                    System.out.println("Creating PNG image: " + file);
                    continue;
                }
                if (format.equalsIgnoreCase("imgMap")) {
                    af.createImageMap(new File(file), imageName);
                    System.out.println("Creating image map: " + file);
                    continue;
                }
                if (format.equalsIgnoreCase("eps")) {
                    System.out.println("Creating EPS file: " + file);
                    af.createEPS(new File(file));
                    continue;
                }
                if (af.saveAlignment(file, format)) {
                    System.out.println("Written alignment in " + format + " format to " + file);
                    continue;
                }
                System.out.println("Error writing file " + file + " in " + format + " format!!");
            }
            while (aparser.getSize() > 0) {
                System.out.println("Unknown arg: " + aparser.nextValue());
            }
        }
        AlignFrame startUpAlframe = null;
        if (!headless && file == null && Cache.getDefault("SHOW_STARTUP_FILE", true)) {
            file = Cache.getDefault("STARTUP_FILE", "http://www.jalview.org/examples/exampleFile_2_3.jar");
            protocol = "File";
            if (file.indexOf("http:") > -1) {
                protocol = "URL";
            }
            format = file.endsWith(".jar") ? "Jalview" : new IdentifyFile().Identify(file, protocol);
            startUpAlframe = fileLoader.LoadFileWaitTillLoaded(file, protocol, format);
            getFeatures = Jalview.checkDasArguments(aparser);
        }
        if (getFeatures != null && startUpAlframe != null) {
            Jalview.startFeatureFetching(getFeatures);
        }
        if (groovyscript != null) {
            if (Cache.groovyJarsPresent()) {
                System.out.println("Executing script " + groovyscript);
                Jalview.executeGroovyScript(groovyscript, desktop);
            } else {
                System.err.println("Sorry. Groovy Support is not available, so ignoring the provided groovy script " + groovyscript);
            }
        }
    }

    private static void startUsageStats(Desktop desktop) {
        PromptUserConfig prompter = new PromptUserConfig(Desktop.desktop, "USAGESTATS", "Jalview Usage Statistics", "Do you want to help make Jalview better by enabling the collection of usage statistics with Google Analytics ?\n\n(you can enable or disable usage tracking in the preferences)", new Runnable(){

            public void run() {
                Cache.log.info((Object)"Initialising googletracker for usage stats.");
                Cache.initGoogleTracker();
                Cache.log.debug((Object)"Tracking enabled.");
            }
        }, new Runnable(){

            public void run() {
                Cache.log.info((Object)"Not enabling Google Tracking.");
            }
        }, null, true);
        SwingUtilities.invokeLater(prompter);
    }

    private static void executeGroovyScript(String groovyscript, Object jalviewContext) {
        if (jalviewContext == null) {
            System.err.println("Sorry. Groovy support is currently only available when running with the Jalview GUI enabled.");
        }
        File sfile = null;
        if (groovyscript.trim().equals("STDIN")) {
            try {
                sfile = File.createTempFile("jalview", "groovy");
                PrintWriter outfile = new PrintWriter(new OutputStreamWriter(new FileOutputStream(sfile)));
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    outfile.write(line + "\n");
                }
                br.close();
                outfile.flush();
                outfile.close();
            }
            catch (Exception ex) {
                System.err.println("Failed to read from STDIN into tempfile " + (sfile == null ? "(tempfile wasn't created)" : sfile.toString()));
                ex.printStackTrace();
                return;
            }
        } else {
            sfile = new File(groovyscript);
        }
        if (!sfile.exists()) {
            System.err.println("File '" + groovyscript + "' does not exist.");
            return;
        }
        if (!sfile.canRead()) {
            System.err.println("File '" + groovyscript + "' cannot be read.");
            return;
        }
        if (sfile.length() < 1L) {
            System.err.println("File '" + groovyscript + "' is empty.");
            return;
        }
        boolean success = false;
        try {
            ClassLoader cl = jalviewContext.getClass().getClassLoader();
            Class<?> gbindingc = cl.loadClass("groovy.lang.Binding");
            Constructor<?> gbcons = gbindingc.getConstructor(null);
            Object gbinding = gbcons.newInstance(null);
            Method setvar = gbindingc.getMethod("setVariable", String.class, Object.class);
            setvar.invoke(gbinding, "Jalview", jalviewContext);
            Class<?> gsec = cl.loadClass("groovy.util.GroovyScriptEngine");
            Constructor<?> gseccons = gsec.getConstructor(URL;.class);
            Object gse = gseccons.newInstance(new Object[]{new URL[]{sfile.toURL()}});
            Method run = gsec.getMethod("run", String.class, gbindingc);
            run.invoke(gse, sfile.getName(), gbinding);
            success = true;
        }
        catch (Exception e) {
            System.err.println("Exception Whilst trying to execute file " + sfile + " as a groovy script.");
            e.printStackTrace(System.err);
        }
        if (success && groovyscript.equals("STDIN")) {
            sfile.delete();
        }
    }

    private static Vector checkDasArguments(ArgsParser aparser) {
        String data;
        Vector<String> source = null;
        String locsources = Cache.getProperty("DAS_LOCAL_SOURCE");
        while ((data = aparser.getValue("dasserver")) != null) {
            String nickname = null;
            String url = null;
            int pos = data.indexOf(61);
            if (pos > 0) {
                nickname = data.substring(0, pos);
            }
            if ((url = data.substring(pos + 1)) == null || !url.startsWith("http:")) continue;
            if (nickname == null) {
                nickname = url;
            }
            locsources = locsources == null ? "" : locsources + "\t";
            locsources = locsources + nickname + "|" + url;
            System.err.println("NOTE! dasserver parameter not yet really supported (got args of " + nickname + "|" + url);
            if (source == null) {
                source = new Vector();
            }
            source.addElement(nickname);
        }
        if (locsources != null && locsources.indexOf(124) > -1) {
            Cache.log.debug((Object)("Setting local source list in properties file to:\n" + locsources));
            Cache.setProperty("DAS_LOCAL_SOURCE", locsources);
        }
        while ((data = aparser.getValue("fetchfrom")) != null) {
            System.out.println("adding source '" + data + "'");
            if (source == null) {
                source = new Vector<String>();
            }
            source.addElement(data);
        }
        return source;
    }

    private static void startFeatureFetching(final Vector dasSources) {
        AlignFrame[] afs = Desktop.getAlignframes();
        if (afs == null || afs.length == 0) {
            return;
        }
        for (int i = 0; i < afs.length; ++i) {
            final AlignFrame af = afs[i];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    af.featureSettings_actionPerformed(null);
                    af.featureSettings.fetchDasFeatures(dasSources);
                }
            });
        }
    }

    private static String checkProtocol(String file) {
        String protocol = FormatAdapter.FILE;
        if (file.indexOf("http:") > -1 || file.indexOf("file:") > -1) {
            protocol = FormatAdapter.URL;
        }
        return protocol;
    }
}

