/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import MCview.AppletPDBViewer;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FeatureSettings;
import jalview.datamodel.Alignment;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.io.NewickFile;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class JalviewLite
extends Applet {
    static int lastFrameX = 200;
    static int lastFrameY = 200;
    boolean fileFound = true;
    String file = "No file";
    Button launcher = new Button("Start Jalview");
    public static AlignFrame currentAlignFrame;
    AlignFrame initialAlignFrame;
    boolean embedded = false;
    private boolean checkForJmol = true;
    public boolean jmolAvailable = false;
    public static boolean debug;
    protected String separator = "|";

    public String getSelectedSequences() {
        return this.getSelectedSequencesFrom(this.getDefaultTargetFrame());
    }

    public String getSelectedSequences(String sep) {
        return this.getSelectedSequencesFrom(this.getDefaultTargetFrame(), sep);
    }

    public String getSelectedSequencesFrom(AlignFrame alf) {
        return this.getSelectedSequencesFrom(alf, "\ufffd");
    }

    public String getSelectedSequencesFrom(AlignFrame alf, String sep) {
        StringBuffer result = new StringBuffer("");
        if (sep == null || sep.length() == 0) {
            sep = "\ufffd";
        }
        if (alf.viewport.getSelectionGroup() != null) {
            SequenceI[] seqs = alf.viewport.getSelectionGroup().getSequencesInOrder(alf.viewport.getAlignment());
            for (int i = 0; i < seqs.length; ++i) {
                result.append(seqs[i].getName());
                result.append(sep);
            }
        }
        return result.toString();
    }

    public String getSelectedSequencesAsAlignment(String format, String suffix) {
        return this.getSelectedSequencesAsAlignmentFrom(currentAlignFrame, format, suffix);
    }

    public String getSelectedSequencesAsAlignmentFrom(AlignFrame alf, String format, String suffix) {
        try {
            boolean seqlimits = suffix.equalsIgnoreCase("true");
            if (alf.viewport.getSelectionGroup() != null) {
                String reply = new AppletFormatAdapter().formatSequences(format, new Alignment(alf.viewport.getSelectionAsNewSequence()), seqlimits);
                return reply;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error retrieving alignment in " + format + " format. ";
        }
        return "";
    }

    public String getAlignment(String format) {
        return this.getAlignmentFrom(this.getDefaultTargetFrame(), format, "true");
    }

    public String getAlignmentFrom(AlignFrame alf, String format) {
        return this.getAlignmentFrom(alf, format, "true");
    }

    public String getAlignment(String format, String suffix) {
        return this.getAlignmentFrom(this.getDefaultTargetFrame(), format, suffix);
    }

    public String getAlignmentFrom(AlignFrame alf, String format, String suffix) {
        try {
            boolean seqlimits = suffix.equalsIgnoreCase("true");
            String reply = new AppletFormatAdapter().formatSequences(format, alf.viewport.getAlignment(), seqlimits);
            return reply;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error retrieving alignment in " + format + " format. ";
        }
    }

    public void loadAnnotation(String annotation) {
        this.loadAnnotationFrom(this.getDefaultTargetFrame(), annotation);
    }

    public void loadAnnotationFrom(AlignFrame alf, String annotation) {
        if (new AnnotationFile().readAnnotationFile(alf.getAlignViewport().getAlignment(), annotation, AppletFormatAdapter.PASTE)) {
            alf.alignPanel.fontChanged();
            alf.alignPanel.setScrollValues(0, 0);
        } else {
            alf.parseFeaturesFile(annotation, AppletFormatAdapter.PASTE);
        }
    }

    public String getFeatures(String format) {
        return this.getFeaturesFrom(this.getDefaultTargetFrame(), format);
    }

    public String getFeaturesFrom(AlignFrame alf, String format) {
        return alf.outputFeatures(false, format);
    }

    public String getAnnotation() {
        return this.getAnnotationFrom(this.getDefaultTargetFrame());
    }

    public String getAnnotationFrom(AlignFrame alf) {
        return alf.outputAnnotations(false);
    }

    public AlignFrame newView() {
        return this.newViewFrom(this.getDefaultTargetFrame());
    }

    public AlignFrame newView(String name) {
        return this.newViewFrom(this.getDefaultTargetFrame(), name);
    }

    public AlignFrame newViewFrom(AlignFrame alf) {
        return alf.newView(null);
    }

    public AlignFrame newViewFrom(AlignFrame alf, String name) {
        return alf.newView(name);
    }

    public AlignFrame loadAlignment(String text, String title) {
        Alignment al = null;
        String format = new IdentifyFile().Identify(text, AppletFormatAdapter.PASTE);
        try {
            al = new AppletFormatAdapter().readFile(text, AppletFormatAdapter.PASTE, format);
            if (al.getHeight() > 0) {
                return new AlignFrame(al, this, title, false);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void init() {
        String sep;
        String chkforJmol;
        String dbg = this.getParameter("debug");
        if (dbg != null) {
            debug = dbg.toLowerCase().equals("true");
        }
        if ((chkforJmol = this.getParameter("nojmol")) != null) {
            boolean bl = this.checkForJmol = !chkforJmol.equals("true");
        }
        if ((sep = this.getParameter("separator")) != null) {
            if (sep.length() > 0) {
                this.separator = sep;
                if (debug) {
                    System.err.println("Separator set to '" + this.separator + "'");
                }
            } else {
                throw new Error("Invalid separator parameter - must be non-zero length");
            }
        }
        int r = 255;
        int g = 255;
        int b = 255;
        String param = this.getParameter("RGB");
        if (param != null) {
            try {
                r = Integer.parseInt(param.substring(0, 2), 16);
                g = Integer.parseInt(param.substring(2, 4), 16);
                b = Integer.parseInt(param.substring(4, 6), 16);
            }
            catch (Exception ex) {
                r = 255;
                g = 255;
                b = 255;
            }
        }
        if ((param = this.getParameter("label")) != null) {
            this.launcher.setLabel(param);
        }
        this.setBackground(new Color(r, g, b));
        this.file = this.getParameter("file");
        if (this.file == null) {
            StringBuffer data = new StringBuffer("PASTE");
            int i = 1;
            while ((this.file = this.getParameter("sequence" + i)) != null) {
                data.append(this.file.toString() + "\n");
                ++i;
            }
            if (data.length() > 5) {
                this.file = data.toString();
            }
        }
        LoadJmolThread jmolAvailable = new LoadJmolThread();
        jmolAvailable.start();
        final JalviewLite applet = this;
        if (this.getParameter("embedded") != null && this.getParameter("embedded").equalsIgnoreCase("true")) {
            this.embedded = true;
            LoadingThread loader = new LoadingThread(this.file, applet);
            loader.start();
        } else if (this.file != null) {
            if (this.getParameter("showbutton") == null || !this.getParameter("showbutton").equalsIgnoreCase("false")) {
                this.add(this.launcher);
                this.launcher.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LoadingThread loader = new LoadingThread(JalviewLite.this.file, applet);
                        loader.start();
                    }
                });
            } else {
                LoadingThread loader = new LoadingThread(this.file, applet);
                loader.start();
            }
        } else {
            this.file = "NO FILE";
            this.fileFound = false;
        }
    }

    public static void addFrame(final Frame frame, String title, int width, int height) {
        frame.setLocation(lastFrameX, lastFrameY);
        lastFrameX += 40;
        lastFrameY += 40;
        frame.setSize(width, height);
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (frame instanceof AlignFrame) {
                    ((AlignFrame)frame).closeMenuItem_actionPerformed();
                }
                if (currentAlignFrame == frame) {
                    currentAlignFrame = null;
                }
                lastFrameX -= 40;
                lastFrameY -= 40;
                if (frame instanceof EmbmenuFrame) {
                    ((EmbmenuFrame)frame).destroyMenus();
                }
                frame.setMenuBar(null);
                frame.dispose();
            }

            public void windowActivated(WindowEvent e) {
                if (frame instanceof AlignFrame) {
                    currentAlignFrame = (AlignFrame)frame;
                    if (debug) {
                        System.err.println("Activated window " + frame);
                    }
                }
                super.windowActivated(e);
            }
        });
        frame.setVisible(true);
    }

    public void paint(Graphics g) {
        if (!this.fileFound) {
            g.setColor(new Color(200, 200, 200));
            g.setColor(Color.cyan);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.red);
            g.drawString("Jalview can't open file", 5, 15);
            g.drawString("\"" + this.file + "\"", 5, 30);
        } else if (this.embedded) {
            g.setColor(Color.black);
            g.setFont(new Font("Arial", 1, 24));
            g.drawString("Jalview Applet", 50, this.getSize().height / 2 - 30);
            g.drawString("Loading Data...", 50, this.getSize().height / 2);
        }
    }

    protected AlignFrame getDefaultTargetFrame() {
        if (currentAlignFrame != null) {
            return currentAlignFrame;
        }
        if (this.initialAlignFrame != null) {
            return this.initialAlignFrame;
        }
        System.err.println("Implementation error: Jalview Applet API cannot work out which AlignFrame to use.");
        return null;
    }

    public String[] separatorListToArray(String list) {
        int pos;
        int seplen = this.separator.length();
        if (list == null || list.equals("")) {
            return null;
        }
        Vector<String> jv = new Vector<String>();
        int cp = 0;
        while ((pos = list.indexOf(this.separator, cp)) > cp) {
            jv.addElement(list.substring(cp, pos));
            cp = pos + seplen;
        }
        if (cp < list.length()) {
            jv.addElement(list.substring(cp));
        }
        if (jv.size() > 0) {
            int i;
            String[] v = new String[jv.size()];
            for (i = 0; i < v.length; ++i) {
                v[i] = (String)jv.elementAt(i);
            }
            jv.removeAllElements();
            if (debug) {
                System.err.println("Array from '" + this.separator + "' separated List:\n" + v.length);
                for (i = 0; i < v.length; ++i) {
                    System.err.println("item " + i + " '" + v[i] + "'");
                }
            }
            return v;
        }
        if (debug) {
            System.err.println("Empty Array from '" + this.separator + "' separated List");
        }
        return null;
    }

    public String arrayToSeparatorList(String[] list) {
        StringBuffer v = new StringBuffer();
        if (list != null) {
            int iSize = list.length - 1;
            for (int i = 0; i < iSize; ++i) {
                if (list[i] != null) {
                    v.append(list[i]);
                }
                v.append(this.separator);
            }
            if (list[list.length - 1] != null) {
                v.append(list[list.length - 1]);
            }
            if (debug) {
                System.err.println("Returning '" + this.separator + "' separated List:\n");
                System.err.println(v);
            }
            return v.toString();
        }
        if (debug) {
            System.err.println("Returning empty '" + this.separator + "' separated List\n");
        }
        return "";
    }

    public String getFeatureGroups() {
        String lst = this.arrayToSeparatorList(this.getDefaultTargetFrame().getFeatureGroups());
        return lst;
    }

    public String getFeatureGroupsOn(AlignFrame alf) {
        String lst = this.arrayToSeparatorList(alf.getFeatureGroups());
        return lst;
    }

    public String getFeatureGroupsOfState(boolean visible) {
        return this.arrayToSeparatorList(this.getDefaultTargetFrame().getFeatureGroupsOfState(visible));
    }

    public String getFeatureGroupsOfStateOn(AlignFrame alf, boolean visible) {
        return this.arrayToSeparatorList(alf.getFeatureGroupsOfState(visible));
    }

    public void setFeatureGroupStateOn(AlignFrame alf, String groups, boolean state) {
        boolean st = state;
        alf.setFeatureGroupState(this.separatorListToArray(groups), st);
    }

    public void setFeatureGroupState(String groups, boolean state) {
        this.setFeatureGroupStateOn(this.getDefaultTargetFrame(), groups, state);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    class LoadingThread
    extends Thread {
        String file;
        String protocol;
        String format;
        JalviewLite applet;

        private void dbgMsg(String msg) {
            if (debug) {
                System.err.println(msg);
            }
        }

        public String setProtocolState(String file) {
            if (file.startsWith("PASTE")) {
                file = file.substring(5);
                this.protocol = AppletFormatAdapter.PASTE;
            } else if (this.inArchive(file)) {
                this.protocol = AppletFormatAdapter.CLASSLOADER;
            } else {
                file = this.addProtocol(file);
                this.protocol = AppletFormatAdapter.URL;
            }
            this.dbgMsg("Protocol identified as '" + this.protocol + "'");
            return file;
        }

        public LoadingThread(String _file, JalviewLite _applet) {
            this.dbgMsg("Loading thread started with:\n>>file\n" + _file + ">>endfile");
            this.file = this.setProtocolState(_file);
            this.format = new IdentifyFile().Identify(this.file, this.protocol);
            this.dbgMsg("File identified as '" + this.format + "'");
            this.applet = _applet;
        }

        public void run() {
            this.startLoading();
        }

        private void startLoading() {
            this.dbgMsg("Loading started.");
            Alignment al = null;
            try {
                al = new AppletFormatAdapter().readFile(this.file, this.protocol, this.format);
            }
            catch (IOException ex) {
                this.dbgMsg("File load exception.");
                ex.printStackTrace();
            }
            if (al != null && al.getHeight() > 0) {
                String param;
                this.dbgMsg("Successfully loaded file.");
                currentAlignFrame = JalviewLite.this.initialAlignFrame = new AlignFrame(al, this.applet, this.file, JalviewLite.this.embedded);
                if (this.protocol == AppletFormatAdapter.PASTE) {
                    currentAlignFrame.setTitle("Sequences from " + JalviewLite.this.getDocumentBase());
                }
                JalviewLite.currentAlignFrame.statusBar.setText("Successfully loaded file " + this.file);
                String treeFile = this.applet.getParameter("tree");
                if (treeFile == null) {
                    treeFile = this.applet.getParameter("treeFile");
                }
                if (treeFile != null) {
                    try {
                        treeFile = this.setProtocolState(treeFile);
                        NewickFile fin = new NewickFile(treeFile, this.protocol);
                        fin.parse();
                        if (fin.getTree() != null) {
                            currentAlignFrame.loadTree(fin, treeFile);
                            this.dbgMsg("Successfuly imported tree.");
                        } else {
                            this.dbgMsg("Tree parameter did not resolve to a valid tree.");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if ((param = JalviewLite.this.getParameter("features")) != null) {
                    param = this.setProtocolState(param);
                    currentAlignFrame.parseFeaturesFile(param, this.protocol);
                }
                if ((param = JalviewLite.this.getParameter("showFeatureSettings")) != null && param.equalsIgnoreCase("true")) {
                    JalviewLite.currentAlignFrame.viewport.showSequenceFeatures(true);
                    new FeatureSettings(JalviewLite.currentAlignFrame.alignPanel);
                }
                if ((param = JalviewLite.this.getParameter("annotations")) != null) {
                    param = this.setProtocolState(param);
                    if (new AnnotationFile().readAnnotationFile(JalviewLite.currentAlignFrame.viewport.getAlignment(), param, this.protocol)) {
                        JalviewLite.currentAlignFrame.alignPanel.fontChanged();
                        JalviewLite.currentAlignFrame.alignPanel.setScrollValues(0, 0);
                    } else {
                        System.err.println("Annotations were not added from annotation file '" + param + "'");
                    }
                }
                if ((param = JalviewLite.this.getParameter("jnetfile")) != null) {
                    try {
                        param = this.setProtocolState(param);
                        JPredFile predictions = new JPredFile(param, this.protocol);
                        JnetAnnotationMaker.add_annotation(predictions, JalviewLite.currentAlignFrame.viewport.getAlignment(), 0, false);
                        JalviewLite.currentAlignFrame.alignPanel.fontChanged();
                        JalviewLite.currentAlignFrame.alignPanel.setScrollValues(0, 0);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                int pdbFileCount = 0;
                do {
                    if ((param = pdbFileCount > 0 ? JalviewLite.this.getParameter("PDBFILE" + pdbFileCount) : JalviewLite.this.getParameter("PDBFILE")) == null) continue;
                    PDBEntry pdb = new PDBEntry();
                    Object[] seqs = null;
                    Object[] chains = null;
                    StringTokenizer st = new StringTokenizer(param, " ");
                    if (st.countTokens() < 2) {
                        String sequence = this.applet.getParameter("PDBSEQ");
                        if (sequence != null) {
                            seqs = new SequenceI[]{(Sequence)currentAlignFrame.getAlignViewport().getAlignment().findName(sequence)};
                        }
                    } else {
                        param = st.nextToken();
                        Vector<Sequence> tmp = new Vector<Sequence>();
                        Vector<String> tmp2 = new Vector<String>();
                        while (st.hasMoreTokens()) {
                            String seqstring = st.nextToken();
                            StringTokenizer st2 = new StringTokenizer(seqstring, "=");
                            if (st2.countTokens() > 1) {
                                tmp2.addElement(st2.nextToken());
                                seqstring = st2.nextToken();
                            }
                            tmp.addElement((Sequence)currentAlignFrame.getAlignViewport().getAlignment().findName(seqstring));
                        }
                        seqs = new SequenceI[tmp.size()];
                        tmp.copyInto(seqs);
                        if (tmp2.size() == tmp.size()) {
                            chains = new String[tmp2.size()];
                            tmp2.copyInto(chains);
                        }
                    }
                    param = this.setProtocolState(param);
                    if (this.protocol == AppletFormatAdapter.CLASSLOADER) {
                        this.protocol = AppletFormatAdapter.URL;
                        param = this.addProtocol(param);
                    }
                    pdb.setFile(param);
                    if (seqs == null) continue;
                    for (int i = 0; i < seqs.length; ++i) {
                        if (seqs[i] != null) {
                            ((Sequence)seqs[i]).addPDBId(pdb);
                            continue;
                        }
                        if (!debug) continue;
                        System.err.println("Warning: Possible input parsing error: Null sequence for attachment of PDB (sequence " + i + ")");
                    }
                    if (JalviewLite.this.jmolAvailable) {
                        new AppletJmol(pdb, (SequenceI[])seqs, (String[])chains, JalviewLite.currentAlignFrame.alignPanel, this.protocol);
                        lastFrameX += 40;
                        lastFrameY += 40;
                        continue;
                    }
                    new AppletPDBViewer(pdb, (SequenceI[])seqs, (String[])chains, JalviewLite.currentAlignFrame.alignPanel, this.protocol);
                } while (++pdbFileCount < 10);
                param = JalviewLite.this.getParameter("hidefeaturegroups");
                if (param != null) {
                    this.applet.setFeatureGroupState(param, false);
                }
                if ((param = JalviewLite.this.getParameter("showfeaturegroups")) != null) {
                    this.applet.setFeatureGroupState(param, true);
                }
            } else {
                JalviewLite.this.fileFound = false;
                JalviewLite.this.remove(JalviewLite.this.launcher);
                JalviewLite.this.repaint();
            }
        }

        boolean inArchive(String file) {
            try {
                boolean rtn;
                boolean bl = rtn = this.getClass().getResourceAsStream("/" + file) != null;
                if (debug) {
                    System.err.println("Resource '" + file + "' was " + (rtn ? "" : "not") + " located by classloader.");
                }
                return rtn;
            }
            catch (Exception ex) {
                System.out.println("Exception checking resources: " + file + " " + ex);
                return false;
            }
        }

        String addProtocol(String file) {
            if (file.indexOf("://") == -1) {
                file = JalviewLite.this.getCodeBase() + file;
                if (debug) {
                    System.err.println("Prepended codebase for resource: '" + file + "'");
                }
            }
            return file;
        }
    }

    class LoadJmolThread
    extends Thread {
        LoadJmolThread() {
        }

        public void run() {
            if (JalviewLite.this.checkForJmol) {
                try {
                    if (!System.getProperty("java.version").startsWith("1.1")) {
                        Class.forName("org.jmol.adapter.smarter.SmarterJmolAdapter");
                        JalviewLite.this.jmolAvailable = true;
                    }
                    if (!JalviewLite.this.jmolAvailable) {
                        System.out.println("Jmol not available - Using MCview for structures");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                JalviewLite.this.jmolAvailable = false;
                if (debug) {
                    System.err.println("Skipping Jmol check. Will use MCView (probably)");
                }
            }
        }
    }
}

