/*
 * Decompiled with CFR 0.152.
 */
package jalview.binding;

import jalview.binding.AnnotationElement;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Annotation
implements Serializable {
    private boolean _graph;
    private boolean _has_graph;
    private int _graphType;
    private boolean _has_graphType;
    private Vector _annotationElementList = new Vector();
    private String _label;
    private String _description;

    public void addAnnotationElement(AnnotationElement vAnnotationElement) throws IndexOutOfBoundsException {
        this._annotationElementList.addElement(vAnnotationElement);
    }

    public void addAnnotationElement(int index, AnnotationElement vAnnotationElement) throws IndexOutOfBoundsException {
        this._annotationElementList.add(index, vAnnotationElement);
    }

    public void deleteGraph() {
        this._has_graph = false;
    }

    public void deleteGraphType() {
        this._has_graphType = false;
    }

    public Enumeration enumerateAnnotationElement() {
        return this._annotationElementList.elements();
    }

    public AnnotationElement getAnnotationElement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._annotationElementList.size()) {
            throw new IndexOutOfBoundsException("getAnnotationElement: Index value '" + index + "' not in range [0.." + (this._annotationElementList.size() - 1) + "]");
        }
        return (AnnotationElement)this._annotationElementList.get(index);
    }

    public AnnotationElement[] getAnnotationElement() {
        AnnotationElement[] array = new AnnotationElement[]{};
        return this._annotationElementList.toArray(array);
    }

    public int getAnnotationElementCount() {
        return this._annotationElementList.size();
    }

    public String getDescription() {
        return this._description;
    }

    public boolean getGraph() {
        return this._graph;
    }

    public int getGraphType() {
        return this._graphType;
    }

    public String getLabel() {
        return this._label;
    }

    public boolean hasGraph() {
        return this._has_graph;
    }

    public boolean hasGraphType() {
        return this._has_graphType;
    }

    public boolean isGraph() {
        return this._graph;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllAnnotationElement() {
        this._annotationElementList.clear();
    }

    public boolean removeAnnotationElement(AnnotationElement vAnnotationElement) {
        boolean removed = this._annotationElementList.remove(vAnnotationElement);
        return removed;
    }

    public AnnotationElement removeAnnotationElementAt(int index) {
        Object obj = this._annotationElementList.remove(index);
        return (AnnotationElement)obj;
    }

    public void setAnnotationElement(int index, AnnotationElement vAnnotationElement) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._annotationElementList.size()) {
            throw new IndexOutOfBoundsException("setAnnotationElement: Index value '" + index + "' not in range [0.." + (this._annotationElementList.size() - 1) + "]");
        }
        this._annotationElementList.set(index, vAnnotationElement);
    }

    public void setAnnotationElement(AnnotationElement[] vAnnotationElementArray) {
        this._annotationElementList.clear();
        for (int i = 0; i < vAnnotationElementArray.length; ++i) {
            this._annotationElementList.add(vAnnotationElementArray[i]);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGraph(boolean graph) {
        this._graph = graph;
        this._has_graph = true;
    }

    public void setGraphType(int graphType) {
        this._graphType = graphType;
        this._has_graphType = true;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public static Annotation unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Annotation)Unmarshaller.unmarshal((Class)Annotation.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

