/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.xdb.embl;

import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.FeatureProperties;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.xdb.embl.EmblFeature;
import jalview.datamodel.xdb.embl.EmblFeatureLocations;
import jalview.datamodel.xdb.embl.EmblSequence;
import jalview.datamodel.xdb.embl.Qualifier;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class EmblEntry {
    String accession;
    String version;
    String taxDivision;
    String desc;
    String rCreated;
    String rLastUpdated;
    String lastUpdated;
    Vector keywords;
    Vector refs;
    Vector dbRefs;
    Vector features;
    EmblSequence sequence;

    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public Vector getDbRefs() {
        return this.dbRefs;
    }

    public void setDbRefs(Vector dbRefs) {
        this.dbRefs = dbRefs;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Vector getFeatures() {
        return this.features;
    }

    public void setFeatures(Vector features) {
        this.features = features;
    }

    public Vector getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Vector keywords) {
        this.keywords = keywords;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Vector getRefs() {
        return this.refs;
    }

    public void setRefs(Vector refs) {
        this.refs = refs;
    }

    public String getRCreated() {
        return this.rCreated;
    }

    public void setRcreated(String releaseCreated) {
        this.rCreated = releaseCreated;
    }

    public String getRLastUpdated() {
        return this.rLastUpdated;
    }

    public void setRLastUpdated(String releaseLastUpdated) {
        this.rLastUpdated = releaseLastUpdated;
    }

    public EmblSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(EmblSequence sequence) {
        this.sequence = sequence;
    }

    public String getTaxDivision() {
        return this.taxDivision;
    }

    public void setTaxDivision(String taxDivision) {
        this.taxDivision = taxDivision;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SequenceI[] getSequences(boolean noNa, boolean noPeptide, String sourceDb) {
        Iterator i;
        Vector<Sequence> seqs = new Vector<Sequence>();
        Sequence dna = null;
        if (!noNa) {
            dna = new Sequence(sourceDb + "|" + this.accession, this.sequence.getSequence());
            dna.setDescription(this.desc);
            dna.addDBRef(new DBRefEntry(sourceDb, this.version, this.accession));
            if (this.dbRefs != null) {
                i = this.dbRefs.iterator();
                while (i.hasNext()) {
                    dna.addDBRef((DBRefEntry)i.next());
                }
            }
        }
        try {
            i = this.features.iterator();
            while (i.hasNext()) {
                Iterator dbr;
                EmblFeature feature = (EmblFeature)i.next();
                if (!noNa && feature.dbRefs != null && feature.dbRefs.size() > 0) {
                    dbr = feature.dbRefs.iterator();
                    while (dbr.hasNext()) {
                        dna.addDBRef((DBRefEntry)dbr.next());
                    }
                }
                if (FeatureProperties.isCodingFeature(sourceDb, feature.getName())) {
                    this.parseCodingFeature(feature, sourceDb, seqs, dna, noPeptide);
                    continue;
                }
                if (noNa || feature.dbRefs == null || feature.dbRefs.size() <= 0) continue;
                dbr = feature.dbRefs.iterator();
                while (dbr.hasNext()) {
                    dna.addDBRef((DBRefEntry)dbr.next());
                }
            }
        }
        catch (Exception e) {
            System.err.println("EMBL Record Features parsing error!");
            System.err.println("Please report the following to help@jalview.org :");
            System.err.println("EMBL Record " + this.accession);
            System.err.println("Resulted in exception: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        if (!noNa && dna != null) {
            seqs.add(dna);
        }
        SequenceI[] sqs = new SequenceI[seqs.size()];
        int j = seqs.size();
        for (int i2 = 0; i2 < j; ++i2) {
            sqs[i2] = (SequenceI)seqs.elementAt(i2);
            seqs.set(i2, null);
        }
        return sqs;
    }

    private void parseCodingFeature(EmblFeature feature, String sourceDb, Vector seqs, Sequence dna, boolean noPeptide) {
        boolean isEmblCdna = sourceDb.equals(DBRefSource.EMBLCDS);
        Mapping map = null;
        int[] exon = null;
        if (feature.locations != null && feature.locations.size() > 0) {
            Enumeration locs = feature.locations.elements();
            while (locs.hasMoreElements()) {
                EmblFeatureLocations loc = (EmblFeatureLocations)locs.nextElement();
                int[] se = loc.getElementRanges(this.accession);
                if (exon == null) {
                    exon = se;
                    continue;
                }
                int[] t = new int[exon.length + se.length];
                System.arraycopy(exon, 0, t, 0, exon.length);
                System.arraycopy(se, 0, t, exon.length, se.length);
                exon = t;
            }
        }
        String prseq = null;
        String prname = new String();
        String prid = null;
        Hashtable<String, String> vals = new Hashtable<String, String>();
        int prstart = 1;
        if (feature.getQualifiers() != null && feature.getQualifiers().size() > 0) {
            Iterator quals = feature.getQualifiers().iterator();
            while (quals.hasNext()) {
                Qualifier q = (Qualifier)quals.next();
                if (q.getName().equals("translation")) {
                    StringBuffer prsq = new StringBuffer(q.getValues()[0]);
                    int p = prsq.indexOf(" ");
                    while (p > -1) {
                        prsq.deleteCharAt(p);
                        p = prsq.indexOf(" ", p);
                    }
                    prseq = prsq.toString();
                    prsq = null;
                    continue;
                }
                if (q.getName().equals("protein_id")) {
                    prid = q.getValues()[0];
                    continue;
                }
                if (q.getName().equals("codon_start")) {
                    prstart = Integer.parseInt(q.getValues()[0]);
                    continue;
                }
                if (q.getName().equals("product")) {
                    prname = q.getValues()[0];
                    continue;
                }
                String[] s = q.getValues();
                StringBuffer sb = new StringBuffer();
                if (s != null) {
                    for (int i = 0; i < s.length; ++i) {
                        sb.append(s[i]);
                        sb.append("\n");
                    }
                }
                vals.put(q.getName(), sb.toString());
            }
        }
        Sequence product = null;
        if (prseq != null && prname != null && prid != null) {
            product = new Sequence(prid, prseq, prstart, prstart + prseq.length() - 1);
            product.setDescription(prname.length() == 0 ? "Protein Product from " + sourceDb : prname);
            if (!noPeptide) {
                seqs.add(product);
            }
            if (exon == null || exon.length == 0) {
                System.err.println("Implementation Notice: EMBLCDS records not properly supported yet - Making up the CDNA region of this sequence... may be incorrect (" + sourceDb + ":" + this.getAccession() + ")");
                if (prseq.length() * 3 == dna.getSequence().length) {
                    exon = new int[]{dna.getStart(), dna.getEnd()};
                    map = new Mapping(product, exon, new int[]{prstart, prstart + prseq.length() - 1}, 3, 1);
                }
                if ((prseq.length() + 1) * 3 == dna.getSequence().length) {
                    exon = new int[]{dna.getStart(), dna.getEnd() - 3};
                    map = new Mapping(product, exon, new int[]{prstart, prstart + prseq.length() - 1}, 3, 1);
                }
            } else if (!isEmblCdna) {
                map = new Mapping(product, exon, new int[]{prstart, prstart + prseq.length() - 1}, 3, 1);
                DBRefEntry pcdnaref = new DBRefEntry();
                pcdnaref.setAccessionId(prid);
                pcdnaref.setSource(DBRefSource.EMBLCDS);
                pcdnaref.setVersion(this.getVersion());
                MapList mp = new MapList(new int[]{1 + (prstart - 1) * 3, 1 + (prstart - 1) * 3 + (prseq.length() - 1) * 3}, new int[]{prstart, prstart + prseq.length() - 1}, 3, 1);
                pcdnaref.setMap(new Mapping(mp));
                if (product != null) {
                    product.addDBRef(pcdnaref);
                }
            }
            for (int xint = 0; exon != null && xint < exon.length; xint += 2) {
                SequenceFeature sf = new SequenceFeature();
                sf.setBegin(exon[xint]);
                sf.setEnd(exon[xint + 1]);
                sf.setType(feature.getName());
                sf.setFeatureGroup(sourceDb);
                sf.setDescription("Exon " + (1 + xint / 2) + " for protein '" + prname + "' EMBLCDS:" + prid);
                sf.setValue("exon number", new Integer(1 + xint));
                sf.setValue("product", prname);
                if (vals != null && vals.size() > 0) {
                    Enumeration kv = vals.elements();
                    while (kv.hasMoreElements()) {
                        Object key = kv.nextElement();
                        if (key == null) continue;
                        sf.setValue(key.toString(), vals.get(key));
                    }
                }
                dna.addSequenceFeature(sf);
            }
        }
        if (feature.dbRefs != null && feature.dbRefs.size() > 0) {
            Iterator dbr = feature.dbRefs.iterator();
            while (dbr.hasNext()) {
                DBRefEntry ref = (DBRefEntry)dbr.next();
                ref.setSource(DBRefUtils.getCanonicalName(ref.getSource()));
                if (ref.getSource().equals(DBRefSource.UNIPROT)) {
                    ref.setMap(map);
                    if (map != null && map.getTo() != null) {
                        map.getTo().addDBRef(new DBRefEntry(ref.getSource(), ref.getVersion(), ref.getAccessionId()));
                        if (map.getTo().getName().indexOf(prid) == 0) {
                            map.getTo().setName(DBRefSource.UNIPROT + "|" + ref.getAccessionId());
                        }
                    }
                }
                if (product != null) {
                    DBRefEntry pref = new DBRefEntry(ref.getSource(), ref.getVersion(), ref.getAccessionId());
                    pref.setMap(null);
                    product.addDBRef(pref);
                    if (map != null) {
                        Mapping pmap = new Mapping(dna, map.getMap().getInverse());
                        pref = new DBRefEntry(sourceDb, this.getVersion(), this.getAccession());
                        pref.setMap(pmap);
                        if (map.getTo() != null) {
                            map.getTo().addDBRef(pref);
                        }
                    }
                }
                dna.addDBRef(ref);
            }
        }
    }
}

