/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.xdb.embl;

import jalview.bin.Cache;
import jalview.datamodel.xdb.embl.BasePosition;
import jalview.datamodel.xdb.embl.EmblFeatureLocElement;
import java.util.Enumeration;
import java.util.Vector;

public class EmblFeatureLocations {
    Vector locElements;
    String locationType;
    boolean locationComplement;

    public boolean isLocationComplement() {
        return this.locationComplement;
    }

    public void setLocationComplement(boolean locationComplement) {
        this.locationComplement = locationComplement;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public Vector getLocElements() {
        return this.locElements;
    }

    public void setLocElements(Vector locElements) {
        this.locElements = locElements;
    }

    public int[] getElementRanges() {
        return this.getElementRanges(null);
    }

    public int[] getElementRanges(String accession) {
        int sepos = 0;
        int[] se = new int[this.locElements.size() * 2];
        if (this.locationType.equalsIgnoreCase("single")) {
            Enumeration le = this.locElements.elements();
            while (le.hasMoreElements()) {
                BasePosition[] bp;
                EmblFeatureLocElement loce = (EmblFeatureLocElement)le.nextElement();
                if (accession != null && (loce.accession == null || !accession.equals(loce.accession)) || (bp = loce.getBasePositions()).length != 2) continue;
                se[sepos++] = Integer.parseInt(bp[0].getPos());
                se[sepos++] = Integer.parseInt(bp[1].getPos());
            }
        } else {
            if (this.locationType.equalsIgnoreCase("join")) {
                Enumeration le = this.locElements.elements();
                while (le.hasMoreElements()) {
                    BasePosition[] bp;
                    EmblFeatureLocElement loce = (EmblFeatureLocElement)le.nextElement();
                    if (accession != null && (loce.accession == null || !accession.equals(loce.accession)) || (bp = loce.getBasePositions()).length != 2) continue;
                    se[sepos++] = Integer.parseInt(bp[0].getPos());
                    se[sepos++] = Integer.parseInt(bp[1].getPos());
                }
                return se;
            }
            if (this.locationType != null) {
                if (Cache.log != null) {
                    Cache.log.error((Object)("EmbleFeatureLocations.getElementRanges cannot deal with locationType=='" + this.locationType + "'"));
                } else {
                    System.err.println("EmbleFeatureLocations.getElementRanges cannot deal with locationType=='" + this.locationType + "'");
                }
            }
        }
        if (se != null && sepos != se.length) {
            int[] trimmed = new int[sepos];
            System.arraycopy(se, 0, trimmed, 0, sepos);
            se = trimmed;
        }
        return se;
    }
}

