/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.xdb.embl;

import jalview.bin.Cache;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;

public class EmblFile {
    Vector entries;
    Vector errors;

    public Vector getEntries() {
        return this.entries;
    }

    public void setEntries(Vector entries) {
        this.entries = entries;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public void setErrors(Vector errors) {
        this.errors = errors;
    }

    public static EmblFile getEmblFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            return EmblFile.getEmblFile(new FileReader(file));
        }
        catch (Exception e) {
            System.err.println("Exception whilst reading EMBLfile from " + file);
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static EmblFile getEmblFile(Reader file) {
        EmblFile record = new EmblFile();
        try {
            Mapping map = new Mapping(record.getClass().getClassLoader());
            URL url = record.getClass().getResource("/embl_mapping.xml");
            map.loadMapping(url);
            Unmarshaller unmar = new Unmarshaller((Object)record);
            try {
                if (Cache.getDefault("logs.Castor.level", "debug").equalsIgnoreCase("DEBUG")) {
                    unmar.setDebug(Cache.log.isDebugEnabled());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            unmar.setIgnoreExtraElements(true);
            unmar.setMapping(map);
            record = (EmblFile)unmar.unmarshal(file);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            record = null;
        }
        return record;
    }

    public static void main(String[] args) {
        EmblFile myfile;
        File mf = null;
        if (args.length == 1) {
            mf = new File(args[0]);
        }
        if (!mf.exists()) {
            mf = new File("C:\\Documents and Settings\\JimP\\workspace-3.2\\Jalview Release\\schemas\\embleRecordV1.1.xml");
        }
        if ((myfile = EmblFile.getEmblFile(mf)) != null && myfile.entries != null && myfile.entries.size() > 0) {
            System.out.println(myfile.entries.size() + " Records read. (" + mf + ")");
        }
    }
}

